/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.suggestion.rules;

import com.ibm.bi.predict.sa.suggestion.domain.parameters.AnnotationParameter;
import com.ibm.bi.predict.sa.suggestion.domain.parameters.AnnotationRestrictionEnumeration;
import com.ibm.bi.predict.sa.suggestion.domain.parameters.AnnotationRestrictionNumber;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleAlgorithm;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleFieldType;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleInsight;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleInsightType;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RulePattern;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RulePatternRole;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleRequiredStatistics;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleSummarization;
import com.ibm.bi.predict.types.Identifiable;
import com.ibm.bi.predict.types.RoleType;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Rules {
    protected static final Map<String, AnnotationParameter> PARAMETERS = Identifiable.asMap((Identifiable[])new AnnotationParameter[]{new AnnotationParameter("FORECAST_PERIODS", "forecastPeriods", "OPTION_AUTOMATIC", new AnnotationRestrictionNumber(Rules.getOptionalNumber("1.0"), Rules.getOptionalNumber("1500.0"))), new AnnotationParameter("FORECAST_IGNORE_PERIODS", "ignoreLastNPeriods", 0.0, new AnnotationRestrictionNumber(Rules.getOptionalNumber("0.0"), Rules.getOptionalNumber("100.0"))), new AnnotationParameter("FORECAST_CONFIDENCE_LEVEL", "confidenceLevel", "95", new AnnotationRestrictionEnumeration("90", "95", "99")), new AnnotationParameter("FORECAST_SEASONALITY", "seasonalityPeriod", "OPTION_AUTOMATIC", new AnnotationRestrictionNumber(Rules.getOptionalNumber("1.0"), Rules.getOptionalNumber("10000.0")))});
    protected static final Map<String, RuleAlgorithm> ALGORITHMS = Identifiable.asMap((Identifiable[])new RuleAlgorithm[]{new RuleAlgorithm("M", "MEAN", "Average summary over categories", RuleInsightType.AVERAGE, Rules.modelParameters(new String[0]), new RuleRequiredStatistics[0]), new RuleAlgorithm("M2", "MODE", "Mode of category frequencies", RuleInsightType.MODE, Rules.modelParameters(new String[0]), new RuleRequiredStatistics[0]), new RuleAlgorithm("W", "WEIGHTED_MEAN", "Overall response mean", RuleInsightType.AVERAGE, Rules.modelParameters(new String[0]), RuleRequiredStatistics.ROW_COUNT), new RuleAlgorithm("A1", "ONE_WAY_CHI_SQUARE", "Equal counts test", RuleInsightType.MEANINGFUL_DIFFERENCES, Rules.modelParameters(new String[0]), new RuleRequiredStatistics[0]), new RuleAlgorithm("A2", "ONE_WAY_CHI_SQUARE", "Equal counts post-hoc test", RuleInsightType.MEANINGFUL_DIFFERENCES, Rules.modelParameters(new String[0]), new RuleRequiredStatistics[0]), new RuleAlgorithm("BA1", "ANOVA", "One-way ANOVA", RuleInsightType.PREDICTIVE_STRENGTH, Rules.modelParameters(new String[0]), RuleRequiredStatistics.ROW_COUNT, RuleRequiredStatistics.SUM_SQR), new RuleAlgorithm("BA2", "MEAN_BASED_UNUSUAL_CELL_DETECTION", "ANOVA post-hoc test", RuleInsightType.MEANINGFUL_DIFFERENCES, Rules.modelParameters(new String[0]), RuleRequiredStatistics.ROW_COUNT, RuleRequiredStatistics.SUM_SQR), new RuleAlgorithm("BB1", "ONE_WAY_CHI_SQUARE", "Equal sums test", RuleInsightType.MEANINGFUL_DIFFERENCES, Rules.modelParameters(new String[0]), RuleRequiredStatistics.ROW_COUNT, RuleRequiredStatistics.SUM_SQR), new RuleAlgorithm("BB2", "ONE_WAY_CHI_SQUARE", "Equal sums post-hoc test", RuleInsightType.MEANINGFUL_DIFFERENCES, Rules.modelParameters(new String[0]), RuleRequiredStatistics.ROW_COUNT, RuleRequiredStatistics.SUM_SQR), new RuleAlgorithm("C1", "CATEGORICAL_TARGET_CHISQUARE", "Frequency chi-square test", RuleInsightType.PREDICTIVE_STRENGTH, Rules.modelParameters(new String[0]), new RuleRequiredStatistics[0]), new RuleAlgorithm("C2", "TWO_WAY_CHI_SQUARE", "Independent sums chi-square test", RuleInsightType.MEANINGFUL_DIFFERENCES, Rules.modelParameters(new String[0]), RuleRequiredStatistics.ROW_COUNT, RuleRequiredStatistics.SUM_SQR), new RuleAlgorithm("C3", "TWO_WAY_CHI_SQUARE", "Independent sums post-hoc test", RuleInsightType.MEANINGFUL_DIFFERENCES, Rules.modelParameters(new String[0]), RuleRequiredStatistics.ROW_COUNT, RuleRequiredStatistics.SUM_SQR), new RuleAlgorithm("CC2", "TWO_WAY_CHI_SQUARE", "Independent counts chi-square test", RuleInsightType.MEANINGFUL_DIFFERENCES, Rules.modelParameters(new String[0]), new RuleRequiredStatistics[0]), new RuleAlgorithm("CC3", "TWO_WAY_CHI_SQUARE", "Independent counts post-hoc test", RuleInsightType.MEANINGFUL_DIFFERENCES, Rules.modelParameters(new String[0]), new RuleRequiredStatistics[0]), new RuleAlgorithm("D1", "FIT_RATIO", "Linear regression model", RuleInsightType.PREDICTIVE_STRENGTH, Rules.modelParameters(new String[0]), RuleRequiredStatistics.ROW_COUNT), new RuleAlgorithm("D2", "FIT_LINE", "Regression model selection", RuleInsightType.FIT_LINE, Rules.modelParameters(new String[0]), RuleRequiredStatistics.ROW_COUNT), new RuleAlgorithm("D3", "STUDENTIZED_RESIDUALS", "Univariate outlier", RuleInsightType.MEANINGFUL_DIFFERENCES, Rules.modelParameters(new String[0]), RuleRequiredStatistics.ROW_COUNT), new RuleAlgorithm("D4", "STUDENTIZED_RESIDUALS", "Regression based outlier", RuleInsightType.MEANINGFUL_DIFFERENCES, Rules.modelParameters(new String[0]), RuleRequiredStatistics.ROW_COUNT), new RuleAlgorithm("E1", "TWO_WAY_ANOVA", "Two-way ANOVA", RuleInsightType.PREDICTIVE_STRENGTH, Rules.modelParameters(new String[0]), RuleRequiredStatistics.ROW_COUNT, RuleRequiredStatistics.SUM_SQR), new RuleAlgorithm("G1", "UNIVARIATE_TIME_SERIES", "Forecasting of future value", RuleInsightType.TIME_SERIES, Rules.modelParameters("FORECAST_PERIODS", "FORECAST_IGNORE_PERIODS", "FORECAST_CONFIDENCE_LEVEL", "FORECAST_SEASONALITY"), new RuleRequiredStatistics[0])});
    protected static final List<RuleInsight> INSIGHTS = Arrays.asList(new RuleInsight("res:con_exp:dat", RuleSummarization.ANY, Rules.algorithms("", "", "", "G1")), new RuleInsight("res:con_exp:dat_gro:cat", RuleSummarization.ANY, Rules.algorithms("", "", "", "G1")), new RuleInsight("res:con_exp:cat", RuleSummarization.COUNT, Rules.algorithms("M", "A1,A2", "", "")), new RuleInsight("res:con_exp:cat", RuleSummarization.SUM, Rules.algorithms("M", "BB1,BB2", "", "")), new RuleInsight("res:con_exp:cat", RuleSummarization.MIN, Rules.algorithms("M", "", "", "")), new RuleInsight("res:con_exp:cat", RuleSummarization.MAX, Rules.algorithms("M", "", "", "")), new RuleInsight("res:con_exp:cat", RuleSummarization.AVERAGE, Rules.algorithms("W", "BA2", "BA1", "")), new RuleInsight("res:con_exp:cat_wei:any", RuleSummarization.AVERAGE, Rules.algorithms("W", "BA2", "BA1", "")), new RuleInsight("res:con_exp:cat_rep:cat", RuleSummarization.COUNT, Rules.algorithms("M2", "CC2,CC3", "C1", "")), new RuleInsight("res:con_exp:cat_2:rep:cat", RuleSummarization.COUNT, Rules.algorithms("M2", "CC2,CC3", "C1", "")), new RuleInsight("res:con_2:exp:cat", RuleSummarization.COUNT, Rules.algorithms("", "CC2,CC3", "C1", "")), new RuleInsight("res:con_2:exp:cat", RuleSummarization.SUM, Rules.algorithms("M", "C2,C3", "", "")), new RuleInsight("res:con_2:exp:cat", RuleSummarization.MIN, Rules.algorithms("M", "", "", "")), new RuleInsight("res:con_2:exp:cat", RuleSummarization.MAX, Rules.algorithms("M", "", "", "")), new RuleInsight("res:con_exp:cat_gro:cat", RuleSummarization.SUM, Rules.algorithms("M", "C2,C3", "", "")), new RuleInsight("res:con_exp:cat_gro:cat", RuleSummarization.MIN, Rules.algorithms("M", "", "", "")), new RuleInsight("res:con_exp:cat_gro:cat", RuleSummarization.MAX, Rules.algorithms("M", "", "", "")), new RuleInsight("res:con_exp:con", RuleSummarization.ANY, Rules.algorithms("D2", "D3,D4", "D1")), new RuleInsight("res:con_exp:con_gro:any", RuleSummarization.ANY, Rules.algorithms("D2", "D3,D4", "D1")), new RuleInsight("res:con_exp:con_wei:con", RuleSummarization.ANY, Rules.algorithms("D2", "D3,D4", "D1")), new RuleInsight("res:con_exp:con_oth:any", RuleSummarization.ANY, Rules.algorithms("D2", "D3,D4", "D1")), new RuleInsight("res:con_exp:con_gro:any_wei:con", RuleSummarization.ANY, Rules.algorithms("D2", "D3,D4", "D1")), new RuleInsight("res:con_exp:con_gro:any_oth:any", RuleSummarization.ANY, Rules.algorithms("D2", "D3,D4", "D1")), new RuleInsight("res:con_exp:con_wei:con_oth:any", RuleSummarization.ANY, Rules.algorithms("D2", "D3,D4", "D1")), new RuleInsight("res:con_exp:con_gro:any_wei:con_oth:any", RuleSummarization.ANY, Rules.algorithms("D2", "D3,D4", "D1")), new RuleInsight("res:con_2:exp:cat", RuleSummarization.AVERAGE, Rules.algorithms("W", "BA2", "E1", "")), new RuleInsight("res:con_2:exp:cat_wei:any", RuleSummarization.AVERAGE, Rules.algorithms("W", "BA2", "E1", "")), new RuleInsight("res:con_exp:cat_gro:cat", RuleSummarization.AVERAGE, Rules.algorithms("W", "BA2", "E1", "")), new RuleInsight("res:con_exp:cat_gro:cat_wei:any", RuleSummarization.AVERAGE, Rules.algorithms("W", "BA2", "E1", "")));
    protected static final Map<String, RulePattern> PATTERNS = Identifiable.asMap((Identifiable[])new RulePattern[]{new RulePattern("res:con_exp:dat", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1, RulePatternRole.oneOrMore), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.DATETIME, 1), new RulePatternRole(RoleType.GROUP, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.OTHER, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REPEAT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_exp:dat_gro:cat", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1, RulePatternRole.oneOrMore), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.DATETIME, 1), new RulePatternRole(RoleType.GROUP, RuleFieldType.CATEGORICAL_NONDATETIME, 1), new RulePatternRole(RoleType.OTHER, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REPEAT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_exp:cat", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.CATEGORICAL, 1), new RulePatternRole(RoleType.GROUP, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.OTHER, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REPEAT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_exp:cat_wei:any", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.CATEGORICAL, 1), new RulePatternRole(RoleType.GROUP, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.OTHER, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REPEAT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.ANY, 1), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_exp:cat_oth:any", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.CATEGORICAL, 1), new RulePatternRole(RoleType.GROUP, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.OTHER, RuleFieldType.ANY, 1), new RulePatternRole(RoleType.REPEAT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_exp:cat_oth:con", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.CATEGORICAL, 1), new RulePatternRole(RoleType.GROUP, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.OTHER, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.REPEAT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_exp:cat_rep:cat", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.CATEGORICAL, 1), new RulePatternRole(RoleType.GROUP, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.OTHER, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REPEAT, RuleFieldType.CATEGORICAL, 1), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_exp:cat_2:rep:cat", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.CATEGORICAL, 1), new RulePatternRole(RoleType.GROUP, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.OTHER, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REPEAT, RuleFieldType.CATEGORICAL, 2), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_2:exp:cat", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.CATEGORICAL, 2), new RulePatternRole(RoleType.GROUP, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.OTHER, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REPEAT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_exp:cat_gro:cat", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.CATEGORICAL, 1), new RulePatternRole(RoleType.GROUP, RuleFieldType.CATEGORICAL, 1), new RulePatternRole(RoleType.OTHER, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REPEAT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_exp:con", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.GROUP, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.OTHER, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REPEAT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_exp:con_gro:any", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.GROUP, RuleFieldType.ANY, 1), new RulePatternRole(RoleType.OTHER, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REPEAT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_exp:con_wei:con", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.GROUP, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.OTHER, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REPEAT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_exp:con_oth:any", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.GROUP, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.OTHER, RuleFieldType.ANY, 1), new RulePatternRole(RoleType.REPEAT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_exp:con_gro:any_wei:con", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.GROUP, RuleFieldType.ANY, 1), new RulePatternRole(RoleType.OTHER, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REPEAT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_exp:con_gro:any_oth:any", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.GROUP, RuleFieldType.ANY, 1), new RulePatternRole(RoleType.OTHER, RuleFieldType.ANY, 1), new RulePatternRole(RoleType.REPEAT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_exp:con_wei:con_oth:any", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.GROUP, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.OTHER, RuleFieldType.ANY, 1), new RulePatternRole(RoleType.REPEAT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_exp:con_gro:any_wei:con_oth:any", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.GROUP, RuleFieldType.ANY, 1), new RulePatternRole(RoleType.OTHER, RuleFieldType.ANY, 1), new RulePatternRole(RoleType.REPEAT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_2:exp:cat_wei:any", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.CATEGORICAL, 2), new RulePatternRole(RoleType.GROUP, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.OTHER, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REPEAT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.ANY, 1), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0)), new RulePattern("res:con_exp:cat_gro:cat_wei:any", new RulePatternRole(RoleType.RESPONSE, RuleFieldType.CONTINUOUS, 1), new RulePatternRole(RoleType.EXPLANATORY, RuleFieldType.CATEGORICAL, 1), new RulePatternRole(RoleType.GROUP, RuleFieldType.CATEGORICAL, 1), new RulePatternRole(RoleType.OTHER, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.REPEAT, RuleFieldType.NOT_ALLOWED, 0), new RulePatternRole(RoleType.WEIGHT, RuleFieldType.ANY, 1), new RulePatternRole(RoleType.REFERENCE, RuleFieldType.NOT_ALLOWED, 0))});

    private Rules() {
    }

    public static RulePattern pattern(String id) {
        return PATTERNS.get(id);
    }

    public static RuleInsight insight(String id) {
        return (RuleInsight)INSIGHTS.stream().collect(Collectors.toMap(Identifiable::id, Function.identity(), (oldVal, newVal) -> oldVal, LinkedHashMap::new)).get(id);
    }

    public static RuleAlgorithm algorithm(String id) {
        return ALGORITHMS.get(id);
    }

    private static Map<RuleInsightType, List<String>> algorithms(String ... algos) {
        return Arrays.stream(algos).filter(StringUtils::isNotBlank).map(Rules::algorithmsToList).flatMap(Collection::stream).collect(Collectors.groupingBy(algoId -> Rules.algorithm(algoId).insightType(), LinkedHashMap::new, Collectors.mapping(Function.identity(), Collectors.toList())));
    }

    private static List<String> algorithmsToList(String allAlgos) {
        return Arrays.asList(allAlgos.split(","));
    }

    private static Optional<Number> getOptionalNumber(String v) {
        try {
            return Optional.of(Double.parseDouble(v));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static List<AnnotationParameter> modelParameters(String ... list) {
        return Arrays.stream(list).map(String::trim).filter(s -> !s.isEmpty()).map(PARAMETERS::get).collect(Collectors.toList());
    }
}

