/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.suggestion.rules;

import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.sa.suggestion.api.request.AnnotationData;
import com.ibm.bi.predict.sa.suggestion.api.request.AnnotationRequest;
import com.ibm.bi.predict.sa.suggestion.rules.Rules;
import com.ibm.bi.predict.sa.suggestion.rules.domain.MatchedInsight;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleInsight;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RulePattern;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleSlot;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleSummarization;
import com.ibm.bi.predict.types.DataItem;
import com.ibm.bi.predict.types.RoleType;
import com.ibm.bi.predict.types.Slot;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RulesMatcher {
    private static final Logger logger = PredictLoggerFactory.getLogger(RulesMatcher.class);

    private RulesMatcher() {
    }

    public static List<MatchedInsight> match(AnnotationRequest request) {
        if (!RulesMatcher.preconditions(request)) {
            return Collections.emptyList();
        }
        return RulesMatcher.doMatch(request);
    }

    private static List<MatchedInsight> doMatch(AnnotationRequest request) {
        List<RuleSlot> slots = RulesMatcher.requestToSlots(request);
        String dataSetId = request.getData().get(0).getId();
        Set<AggregationType> summaryMethods = RulesMatcher.responseAggregationTypes(slots);
        if (summaryMethods.contains(AggregationType.UNKNOWN)) {
            return Collections.emptyList();
        }
        return Rules.INSIGHTS.stream().filter(RulesMatcher.dataItemAggregationsMatchInsight(summaryMethods)).map(insight -> new MatchedInsight(slots, (RuleInsight)insight, dataSetId)).filter(match -> RulesMatcher.slotsMatchPattern(match.matchedPattern(), slots)).filter(RulesMatcher::nonEmptyInsight).distinct().collect(Collectors.toList());
    }

    private static boolean preconditions(AnnotationRequest request) {
        if (!RulesMatcher.onlyOneDataSet(request)) {
            logger.warn("No matching insights. Request contains {} datasets", (Object)request.getData().size());
            return false;
        }
        if (!RulesMatcher.validDataItems(request)) {
            logger.warn("No matching insights. Request contains invalid data items");
            return false;
        }
        return true;
    }

    private static boolean validDataItems(AnnotationRequest request) {
        HashSet<String> dataItemIds = new HashSet<String>();
        HashSet<DataItem> nestedDataItems = new HashSet<DataItem>();
        for (Slot slot : request.getUse()) {
            if (!slot.getDataItems().isEmpty()) continue;
            logger.warn("Found a slot containing no data items - name={}", (Object)slot.getName());
            return false;
        }
        for (DataItem dataItem : request.getData().get(0).getDataItems()) {
            if (!dataItemIds.add(dataItem.getId())) {
                logger.warn("Found duplicate data item ID - id={}", (Object)dataItem.getId());
                return false;
            }
            if (!dataItem.isNestedDataItem()) continue;
            nestedDataItems.add(dataItem);
        }
        for (DataItem nestedDataItem : nestedDataItems) {
            for (String nestedId : nestedDataItem.getNest()) {
                if (dataItemIds.contains(nestedId)) continue;
                logger.warn("Found invalid data item ID - id={}", (Object)nestedId);
                return false;
            }
        }
        return true;
    }

    private static List<RuleSlot> requestToSlots(AnnotationRequest request) {
        AnnotationData data = request.getData().get(0);
        Map<String, DataItem> dataItemsById = RulesMatcher.dataItemsToMap(data.getDataItems());
        ArrayList<RuleSlot> slots = new ArrayList<RuleSlot>();
        boolean seenResponse = false;
        for (Slot slot : request.getUse()) {
            List<DataItem> dataItemsInSlot = RulesMatcher.dataItemsInSlot(slot, dataItemsById);
            if (slot.getRole() == RoleType.RESPONSE) {
                if (seenResponse) continue;
                slots.add(new RuleSlot(slot, dataItemsInSlot));
                seenResponse = true;
                continue;
            }
            if (RulesMatcher.shouldIgnoreField(slot)) continue;
            slots.add(new RuleSlot(slot, dataItemsInSlot));
        }
        return slots;
    }

    private static boolean shouldIgnoreField(Slot slot) {
        return slot.getRole() == RoleType.OTHER && slot.getName().equals("Heat");
    }

    private static List<DataItem> dataItemsInSlot(Slot slot, Map<String, DataItem> dataItemsById) {
        return slot.getDataItems().stream().flatMap(dataItemId -> DataItem.dataItemsById((String)dataItemId, (Map)dataItemsById).stream()).collect(Collectors.toList());
    }

    private static Map<String, DataItem> dataItemsToMap(List<DataItem> dataItems) {
        return dataItems.stream().collect(Collectors.toMap(DataItem::getId, Function.identity(), (di1, di2) -> {
            logger.warn("Encountered duplicate data item ID: {}", (Object)di1.getId());
            return di1;
        }));
    }

    private static Predicate<RuleInsight> dataItemAggregationsMatchInsight(Set<AggregationType> summaryMethods) {
        return insight -> {
            if (insight.summarization() == RuleSummarization.ANY) {
                return true;
            }
            return summaryMethods.stream().allMatch(s -> insight.summarization().matchesAggregationType((AggregationType)s));
        };
    }

    private static boolean slotsMatchPattern(RulePattern pattern, List<RuleSlot> slots) {
        return pattern.matches(slots);
    }

    private static Set<AggregationType> responseAggregationTypes(List<RuleSlot> slots) {
        return slots.stream().filter(slot -> slot.role() == RoleType.RESPONSE).flatMap(slot -> slot.dataItems().stream().map(DataItem::getAggregate)).collect(Collectors.toSet());
    }

    private static boolean onlyOneDataSet(AnnotationRequest request) {
        return request.getData().size() == 1;
    }

    private static boolean nonEmptyInsight(MatchedInsight match) {
        return !match.insight().algorithms().isEmpty();
    }
}

