/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.suggestion.rules.domain;

import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleFieldType;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RulePatternRole;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleSlot;
import com.ibm.bi.predict.types.DataItem;
import com.ibm.bi.predict.types.DataItemType;
import com.ibm.bi.predict.types.Identifiable;
import com.ibm.bi.predict.types.RoleType;
import com.ibm.bi.predict.types.SlotType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class RulePattern
implements Identifiable {
    private String id;
    private List<RulePatternRole> roles;

    public RulePattern(String id, RulePatternRole ... roles) {
        this.id = id;
        this.roles = Arrays.asList(roles);
    }

    public String id() {
        return this.id;
    }

    public boolean matches(List<RuleSlot> slots) {
        Map<RoleType, List<RuleSlot>> slotsByType = slots.stream().collect(Collectors.groupingBy(RuleSlot::role));
        for (RulePatternRole pattern : this.roles) {
            RoleType role;
            List<RuleSlot> slotsByRole;
            if (!this.validateCount(pattern, slotsByRole = slotsByType.getOrDefault(role = pattern.roleType(), Collections.emptyList()))) {
                return false;
            }
            if (pattern.count() == 0 || this.validateType(pattern.fieldType(), slotsByRole)) continue;
            return false;
        }
        return true;
    }

    public List<RulePatternRole> roles() {
        return this.roles;
    }

    private boolean validateType(RuleFieldType expectedType, List<RuleSlot> slotsByRole) {
        switch (expectedType) {
            case CONTINUOUS: {
                return this.allSlotsHaveType(SlotType.CONTINUOUS, slotsByRole);
            }
            case CATEGORICAL: {
                return this.allSlotsHaveType(SlotType.CATEGORICAL, slotsByRole);
            }
            case CATEGORICAL_NONDATETIME: {
                return this.allSlotsHaveType(SlotType.CATEGORICAL, slotsByRole) && this.noDataItemsAreDatetime(slotsByRole);
            }
            case DATETIME: {
                return this.slotsSupportDateTime(slotsByRole);
            }
            case ANY: {
                return true;
            }
            case NOT_ALLOWED: {
                return false;
            }
        }
        return false;
    }

    private boolean allSlotsHaveType(SlotType expectedSlotType, List<RuleSlot> slotsByRole) {
        for (RuleSlot slot : slotsByRole) {
            SlotType slotType = slot.type();
            if (slotType == SlotType.ANY) {
                slotType = this.inferSlotType(slot);
            }
            if (slotType == expectedSlotType) continue;
            return false;
        }
        return true;
    }

    private SlotType inferSlotType(RuleSlot slot) {
        if (slot.type() != SlotType.ANY) {
            return slot.type();
        }
        List dataItemTypes = slot.dataItems().stream().map(DataItem::getType).distinct().collect(Collectors.toList());
        if (dataItemTypes.isEmpty() || dataItemTypes.size() > 1) {
            return SlotType.CATEGORICAL;
        }
        switch ((DataItemType)dataItemTypes.get(0)) {
            case DATETIME: 
            case CATEGORICAL: {
                return SlotType.CATEGORICAL;
            }
            case CONTINUOUS: {
                return SlotType.CONTINUOUS;
            }
        }
        throw new IllegalStateException("Unknown data item type: " + dataItemTypes.get(0));
    }

    private boolean slotsSupportDateTime(List<RuleSlot> slotsByRole) {
        for (RuleSlot slot : slotsByRole) {
            if (slot.type() != SlotType.CATEGORICAL && slot.type() != SlotType.ANY) {
                return false;
            }
            if (slot.dataItems().isEmpty()) {
                return false;
            }
            boolean allDateTime = slot.dataItems().stream().allMatch(di -> di.getType() == DataItemType.DATETIME);
            if (allDateTime) continue;
            return false;
        }
        return true;
    }

    private boolean noDataItemsAreDatetime(List<RuleSlot> slotsByRole) {
        for (RuleSlot slot : slotsByRole) {
            boolean anyDateTime = slot.dataItems().stream().anyMatch(di -> di.getType() == DataItemType.DATETIME);
            if (!anyDateTime) continue;
            return false;
        }
        return true;
    }

    private boolean validateCount(RulePatternRole role, List<RuleSlot> slots) {
        if (role.roleType() == RoleType.RESPONSE) {
            return role.count() == slots.size() && slots.stream().allMatch(slot -> role.validNumDataItems(slot.dataItems().size()));
        }
        return role.count() == slots.size();
    }

    public String toString() {
        return String.format("id: %s, patterns: [%s]", this.id, String.join((CharSequence)", ", this.roles.stream().map(Objects::toString).collect(Collectors.toList())));
    }
}

