/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.suggestion.rules.reader;

import com.ibm.bi.predict.sa.suggestion.domain.parameters.AnnotationParameter;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleAlgorithm;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleInsight;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RulePattern;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleRequiredStatistics;
import com.ibm.bi.predict.sa.suggestion.rules.reader.ExcelReader;
import java.awt.List;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RulesGenerator {
    private static final String PATTERNS_SHEET_NAME = "Patterns";
    private static final int PATTERNS_COLUMNS = 5;
    private static final String INSIGHTS_SHEET_NAME = "Insights";
    private static final int INSIGHTS_COLUMNS = 24;
    private static final String ALGORITHMS_SHEET_NAME = "Algorithms";
    private static final int ALGORITHMS_COLUMNS = 6;
    private static final String OPTIONS_SHEET_NAME = "Options";
    private static final int OPTIONS_COLUMNS = 7;
    private final String wrapper;
    private final ExcelReader reader;
    private final PrintWriter outputWriter;
    private final StringWriter contents;

    public RulesGenerator(String wrapper, ExcelReader reader, Writer outputWriter) {
        this.wrapper = wrapper;
        this.reader = reader;
        this.outputWriter = new PrintWriter(outputWriter);
        this.contents = new StringWriter();
    }

    public void generate() {
        this.buildOptions();
        this.buildAlgorithms();
        this.buildInsights();
        this.buildPatterns();
        this.writeContents();
    }

    private void writeContents() {
        this.outputWriter.write(this.wrapper.replace("##{{GENERATED}}##", this.contents.toString()));
    }

    private void buildPatterns() {
        String[][] table = this.reader.readTable(PATTERNS_SHEET_NAME, 5, true, false);
        this.buildCollection(table, "PATTERNS", RulePattern.class, this::makePatternConstructionParameters, Map.class);
    }

    private void buildInsights() {
        String[] header = this.reader.readRow(INSIGHTS_SHEET_NAME, 0);
        String[][] table = this.reader.readTable(INSIGHTS_SHEET_NAME, 24, true, true);
        this.buildCollection(table, "INSIGHTS", RuleInsight.class, s -> this.makeInsightConstructionParameters((String[])s, header), List.class);
    }

    private void buildAlgorithms() {
        String[][] table = this.reader.readTable(ALGORITHMS_SHEET_NAME, 6, true, true);
        this.buildCollection(table, "ALGORITHMS", RuleAlgorithm.class, this::makeAlgorithmConstructionParameters, Map.class);
    }

    private void buildOptions() {
        String[][] table = this.reader.readTable(OPTIONS_SHEET_NAME, 7, true, true);
        this.buildCollection(table, "PARAMETERS", AnnotationParameter.class, this::makeOptionsConstructionParameters, Map.class);
    }

    public void buildCollection(String[][] table, String collectionName, Class<?> type, Function<String[], String> paramsMakerFunc, Class<?> definedAs) {
        this.javaCollectionWriter(definedAs, type, collectionName, () -> {
            for (int i = 0; i < table.length; ++i) {
                String comma = i == table.length - 1 ? "" : ",";
                String params = (String)paramsMakerFunc.apply(table[i]);
                this.write("    new %s(%s)%s%n", type.getSimpleName(), params, comma);
            }
        });
    }

    private void javaCollectionWriter(Class<?> collectionType, Class<?> containingType, String collectionName, Runnable fn) {
        if (collectionType == Map.class) {
            this.write("  // Generated map of IDs to %s%n", collectionName.toLowerCase());
            this.write("  public static final Map<String, %s> %s = Identifiable.asMap(%n", containingType.getSimpleName(), collectionName);
        } else if (collectionType == List.class) {
            this.write("  // Generated list of %s%n", collectionName.toLowerCase());
            this.write("  public static final List<%s> %s = Arrays.asList(%n", containingType.getSimpleName(), collectionName);
        } else {
            throw new IllegalArgumentException("Unknown collection type - " + collectionType.getSimpleName());
        }
        fn.run();
        this.write("  );%n%n", new Object[0]);
    }

    private String makePatternConstructionParameters(String[] s) {
        StringBuilder b = new StringBuilder();
        b.append(this.q(s[0]));
        String[] roles = s[1].split("[\n\t ]+");
        String[] types = s[2].split("[\n\t ]+");
        String[] counts = s[3].split("[\n\t ]+");
        int n = roles.length;
        if (n != types.length) {
            throw new IllegalStateException("Pattern types length does not match pattern roles");
        }
        if (n != counts.length) {
            throw new IllegalStateException("Pattern counts length does not match pattern roles");
        }
        for (int j = 0; j < n; ++j) {
            String role = roles[j].toUpperCase();
            String type = (types[j].equalsIgnoreCase("N/A") ? "not_allowed" : types[j]).toUpperCase();
            String count = counts[j];
            b.append(String.format(",%n      new RulePatternRole(%s, %s, %s)", role, type, count));
        }
        return b.toString();
    }

    private String makeInsightConstructionParameters(String[] s, String[] header) {
        String map = String.format("algorithms(%s, %s, %s, %s)", this.q(s[2]), this.q(s[3]), this.q(s[4]), this.q(s[5]));
        return String.format("%s, RuleSummarization.%s, %s", this.q(s[0]), s[1].toUpperCase(), map);
    }

    private String makeAlgorithmConstructionParameters(String[] s) {
        String requiredStats = Arrays.stream(this.splitByNewline(s[4])).map(name -> RuleRequiredStatistics.fromString(name).toString()).collect(Collectors.joining(", "));
        String insightDef = s[3].replaceAll(" ", "_");
        String modelParameters = Arrays.stream(this.splitByNewline(s[5])).map(this::q).collect(Collectors.joining(", "));
        if (requiredStats.isEmpty()) {
            return String.format("%s, %s, %s, %s, modelParameters(%s)", this.q(s[0]), this.q(s[1]), this.q(s[2]), insightDef, modelParameters);
        }
        return String.format("%s, %s, %s, %s, modelParameters(%s), %s", this.q(s[0]), this.q(s[1]), this.q(s[2]), insightDef, modelParameters, requiredStats);
    }

    private String makeOptionsConstructionParameters(String[] s) {
        String messageId = s[0];
        String optionId = s[1];
        String value = s[2];
        String type = s[3];
        String min = s[4];
        String max = s[5];
        String[] enumeration = this.splitByNewline(s[6]);
        StringBuilder b = new StringBuilder();
        b.append(this.q(messageId));
        b.append(", ");
        b.append(this.q(optionId));
        b.append(", ");
        if ("number".equals(type) && this.isNumber(value)) {
            b.append(Double.parseDouble(value));
        } else {
            b.append(this.q(value));
        }
        b.append(", ");
        if ("enumeration".equals(type)) {
            b.append("new AnnotationRestrictionEnumeration(");
            b.append(Arrays.stream(enumeration).map(this::q).collect(Collectors.joining(", ")));
            b.append(")");
        } else if ("number".equals(type)) {
            b.append(String.format("new AnnotationRestrictionNumber(getOptionalNumber(%s), getOptionalNumber(%s))", this.q(min), this.q(max)));
        } else {
            throw new IllegalStateException("Unknown type: " + type);
        }
        return b.toString();
    }

    private String q(String s) {
        if (s == null) {
            return "\"\"";
        }
        if (s.contains("\"")) {
            throw new IllegalStateException("Unexpected double quotes in table");
        }
        return "\"" + s.replaceAll("\n", " ") + "\"";
    }

    private void write(String format, Object ... args) {
        this.contents.write(String.format(format, args));
    }

    private String[] splitByNewline(String line) {
        if (line == null || line.isEmpty()) {
            return new String[0];
        }
        return line.split("[\n\t ]+");
    }

    private boolean isNumber(String value) {
        return value != null && value.matches("(\\d+(?:\\.\\d+)?)");
    }
}

