/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.suggestion.service;

import com.ibm.bi.predict.sa.suggestion.api.request.AnnotationData;
import com.ibm.bi.predict.sa.suggestion.api.request.AnnotationRequest;
import com.ibm.bi.predict.sa.suggestion.domain.Annotation;
import com.ibm.bi.predict.sa.suggestion.domain.AnnotationDefinition;
import com.ibm.bi.predict.sa.suggestion.domain.AnnotationDefinitions;
import com.ibm.bi.predict.sa.suggestion.domain.AnnotationStatistic;
import com.ibm.bi.predict.sa.suggestion.domain.MatchingDefinition;
import com.ibm.bi.predict.sa.suggestion.rules.MatchedInsightMapper;
import com.ibm.bi.predict.sa.suggestion.rules.RulesMatcher;
import com.ibm.bi.predict.sa.suggestion.rules.domain.MatchedInsight;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleInsightType;
import com.ibm.bi.predict.sa.suggestion.service.Tag;
import com.ibm.bi.predict.types.DataItem;
import com.ibm.bi.predict.types.Slot;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AnnotationsGenerator {
    private static final Logger logger = PredictLoggerFactory.getLogger(AnnotationsGenerator.class);

    public List<Annotation> generateAnnotations(AnnotationRequest request, AnnotationDefinitions definitions) {
        logger.debug("Preparing to generate annotation suggestions from request");
        if (!this.inputsAreValid(request, definitions)) {
            return Collections.emptyList();
        }
        List<AnnotationRequest> requests = this.isMultipleDataSets(request) ? this.generateMultipleRequests(request) : Collections.singletonList(request);
        return this.generateAnnotations(requests, definitions);
    }

    private List<Annotation> generateAnnotations(List<AnnotationRequest> requests, AnnotationDefinitions definitions) {
        ArrayList<Annotation> suggestions = new ArrayList<Annotation>();
        for (AnnotationRequest childRequest : requests) {
            List<Annotation> annotationsForChildRequest = new ArrayList<Annotation>();
            List<MatchedInsight> matched = RulesMatcher.match(childRequest);
            annotationsForChildRequest.addAll(MatchedInsightMapper.toAnnotations(matched));
            List<MatchingDefinition> matchedDefinitions = definitions.findMatchingDefinitions(childRequest);
            annotationsForChildRequest.addAll(this.generateSuggestionsFromMatchedDefinitions(matchedDefinitions));
            annotationsForChildRequest = this.filterAnnotations(annotationsForChildRequest, childRequest.getTags());
            suggestions.addAll(annotationsForChildRequest);
        }
        return suggestions;
    }

    private List<Annotation> filterAnnotations(List<Annotation> suggestions, List<String> tags) {
        if (CollectionUtils.isEmpty(tags)) {
            return suggestions;
        }
        return suggestions.stream().filter(annotation -> this.includeAnnotationsOnTags((Annotation)annotation, tags)).collect(Collectors.toList());
    }

    private boolean includeAnnotationsOnTags(Annotation annotation, List<String> tags) {
        return this.isAllowedAnnotationType(annotation, tags) && this.isNotExcludedOlapAnnotation(annotation, tags);
    }

    private boolean isAllowedAnnotationType(Annotation annotation, List<String> tags) {
        if (tags.contains(Tag.FORECASTING.toString()) && annotation.getType().equals(RuleInsightType.TIME_SERIES.toString())) {
            return true;
        }
        return tags.contains(Tag.ANNOTATABLE.toString()) && !annotation.getType().equals(RuleInsightType.TIME_SERIES.toString());
    }

    private boolean isNotExcludedOlapAnnotation(Annotation annotation, List<String> tags) {
        if (tags.contains(Tag.OLAP.toString())) {
            if (annotation.getType().equals(RuleInsightType.TIME_SERIES.toString())) {
                return false;
            }
            if (!annotation.getRequirements().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    private List<Annotation> generateSuggestionsFromMatchedDefinitions(List<MatchingDefinition> matchedDefinitions) {
        logger.debug("Generating annotation suggestions for matching definitions");
        return matchedDefinitions.stream().flatMap(this::generateSuggestionsFromMatchedDefinition).collect(Collectors.toList());
    }

    private Stream<Annotation> generateSuggestionsFromMatchedDefinition(MatchingDefinition matchedDefinition) {
        AnnotationDefinition definition = matchedDefinition.getDefinition();
        return definition.getStatistics().stream().map(statistic -> new Annotation(statistic.getName(), this.getPartsForAnnotation((AnnotationStatistic)statistic), new LinkedHashSet<String>(statistic.getRequiredStats()), matchedDefinition.getDataItemsOfMatchedFields(), matchedDefinition.getRolesOfMatchingFields(), matchedDefinition.getDatasetId()));
    }

    private List<AnnotationRequest> generateMultipleRequests(AnnotationRequest request) {
        return request.getData().stream().map(data -> this.generateRequest((AnnotationData)data, request)).collect(Collectors.toList());
    }

    private AnnotationRequest generateRequest(AnnotationData data, AnnotationRequest request) {
        AnnotationRequest ar = new AnnotationRequest();
        ArrayList<AnnotationData> ad = new ArrayList<AnnotationData>(Arrays.asList(data));
        List<Slot> au = this.getUseItems(data.getDataItems(), request.getUse());
        ar.setData(ad);
        ar.setUse(au);
        ar.setTags(request.getTags());
        return ar;
    }

    private List<Slot> getUseItems(List<DataItem> dataItems, List<Slot> useItems) {
        return dataItems.stream().flatMap(dataItem -> this.getUseItem(dataItem.getId(), useItems).stream()).collect(Collectors.toList());
    }

    private List<Slot> getUseItem(String id, List<Slot> useItems) {
        return useItems.stream().filter(useItem -> id.equals(useItem.getDataItems().get(0))).collect(Collectors.toList());
    }

    private boolean isMultipleDataSets(AnnotationRequest request) {
        int numDatasets = request.getData().size();
        if (numDatasets > 1) {
            logger.debug("Multiple data sets found in request");
        }
        return numDatasets > 1;
    }

    private boolean inputsAreValid(AnnotationRequest request, AnnotationDefinitions definitions) {
        if (request == null || definitions == null) {
            logger.warn("Cannot generate annotation suggestions due to invalid inputs");
            return false;
        }
        return true;
    }

    private List<String> getPartsForAnnotation(AnnotationStatistic statistic) {
        String algorithm = statistic.getAlgorithm();
        if (StringUtils.isEmpty((CharSequence)algorithm)) {
            logger.debug("No algorithm found within annotation statistic");
            return Collections.emptyList();
        }
        return Arrays.asList(algorithm);
    }
}

