/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.suggestion.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.bi.predict.sa.suggestion.domain.AnnotationDefinitions;
import com.ibm.bi.predict.sa.suggestion.service.DefinitionLoader;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;

public class JsonFileDefinitionLoader
implements DefinitionLoader {
    private static final Logger logger = PredictLoggerFactory.getLogger(JsonFileDefinitionLoader.class);
    private ObjectMapper mapper;
    private final String DEFINITION_FILE_NAME;

    public JsonFileDefinitionLoader() {
        this("annotations.json", new ObjectMapper());
    }

    public JsonFileDefinitionLoader(String definitionFileName) {
        this(definitionFileName, new ObjectMapper());
    }

    public JsonFileDefinitionLoader(String definitionFileName, ObjectMapper mapper) {
        this.DEFINITION_FILE_NAME = definitionFileName;
        this.mapper = mapper;
    }

    @Override
    public Optional<AnnotationDefinitions> load() {
        String definitionContents;
        logger.debug("Preparing to load annotation definitions");
        try {
            definitionContents = this.getDefinitionContentsAsString(this.DEFINITION_FILE_NAME);
        }
        catch (IOException e) {
            logger.error("Error while loading annotation definitions file - message={}", (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
        try {
            AnnotationDefinitions obj = (AnnotationDefinitions)this.mapper.readValue(definitionContents, AnnotationDefinitions.class);
            logger.debug("Successfully loaded annotation definitions");
            return Optional.of(obj);
        }
        catch (JsonParseException | JsonMappingException e) {
            logger.error("Error while mapping annotation definitions - message={}", (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
        catch (IOException e) {
            logger.error("Error while mapping annotation definitions - message=%s", (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
    }

    private String getDefinitionContentsAsString(String filename) throws IOException {
        try (InputStream annotationStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);){
            String json;
            if (annotationStream == null) {
                throw new FileNotFoundException("Cannot find file");
            }
            String string = json = IOUtils.toString((InputStream)annotationStream);
            return string;
        }
    }
}

