/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.xml;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.xml.XMLFunction;
import com.cognos.xqe.function.xml.xltxej.XQEDynamicContext;
import com.cognos.xqe.runtree.XDataContext;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.exec.BasicStaticContext;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.Preparer;
import com.ibm.xml.xci.exec.StaticContext;
import com.ibm.xml.xci.serializer.SerializeParamValue;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Node;

public class XMLDocument
extends XMLFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{100}, {1, 107}};
    private static final String XQUERY = "declare variable $e external; document {$e}";
    private static SessionContext session = new SessionContext((ClassLoader)null);
    private static StaticContext staticCxt = new BasicStaticContext(session.getTypeRegistry());
    private static QName variableName = new QName("e");
    private static Preparer preparer = session.getPreparer(RequestInfo.XQuery);
    private static Map<String, Object> properties = new HashMap<String, Object>();
    private static Executable qExpr;

    public XMLDocument() {
        super("XMLDocument", ACCEPTED_TYPES, false);
    }

    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        XmlValue input = (XmlValue)pEvaluator.getParameter(context, 0);
        XmlValue output = (XmlValue)outputArg;
        if (input.isNull()) {
            output.setNull();
            return;
        }
        Cursor document = XMLDocument.createDocument(context, input);
        VolatileCData cData = document.serialize(properties);
        output.set(cData.toString());
    }

    public static Cursor createDocument(XDataContext context, XmlValue input) {
        XQEDynamicContext dynamicCxt = new XQEDynamicContext(session, staticCxt, context);
        List nodeList = input.getNodeList();
        Cursor sequence = null;
        for (Node node : nodeList) {
            StreamSource source = new StreamSource(new StringReader(node.asXML()));
            Cursor cursor = session.document((Source)source, RequestInfo.RANDOM_ACCESS);
            if (sequence == null) {
                sequence = cursor;
                continue;
            }
            sequence = sequence.sequenceConcat(cursor, sequence.profile(), sequence.futureProfile(), true, true);
        }
        dynamicCxt.bindVariable(variableName, sequence);
        Cursor result = qExpr.execute(null, (DynamicContext)dynamicCxt, Cursor.RANDOM_ACCESS, null);
        sequence.release();
        return result;
    }

    static {
        staticCxt.setLanguageTypeAndVersion(1);
        staticCxt.setBaseURI(System.getProperty("user.dir"));
        properties.put("omit-xml-declaration", Boolean.TRUE);
        properties.put("method", SerializeParamValue.METHOD_XML);
        properties.put("indent", Boolean.FALSE);
        qExpr = preparer.prepare(XQUERY, staticCxt, -1);
    }
}

