/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.xml;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.XmlType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.xml.XMLFunction;
import com.cognos.xqe.runtree.XDataContext;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;

public class XMLForest
extends XMLFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{107, 1}, DataTypeCode.ALL_TYPES};

    public XMLForest() {
        super("XMLForest", ACCEPTED_TYPES, false, 1);
    }

    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        XmlValue output = (XmlValue)outputArg;
        int nParameters = pEvaluator.getParameterCount();
        IValue nameSpaces = pEvaluator.getParameter(context, 0);
        Document document = DocumentHelper.createDocument();
        ArrayList<Element> nodeList = new ArrayList<Element>();
        for (int i = 1; i < nParameters; i += 2) {
            IValue name = pEvaluator.getParameter(context, i + 1);
            IValue value = pEvaluator.getParameter(context, i);
            if (value.isNull()) continue;
            Element element = DocumentHelper.createElement((String)name.toString());
            if (value.getDataType() == XmlType.XMLTYPE) {
                List nodes = ((XmlValue)value).getNodeList();
                for (int j = 0; j < nodes.size(); ++j) {
                    Node child = (Node)nodes.get(j);
                    if (child.getNodeType() == 9) {
                        child = ((Document)child).getRootElement();
                    }
                    if (child.getParent() != null || child.getDocument() != document) {
                        child = (Node)child.clone();
                    }
                    element.add(child);
                }
            } else {
                element.add(DocumentHelper.createText((String)value.toString()));
            }
            if (!nameSpaces.isNull()) {
                for (Node node : ((XmlValue)nameSpaces).getNodeList()) {
                    element.add((Namespace)node);
                }
            }
            nodeList.add(element);
        }
        output.set(nodeList);
    }
}

