/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.xml;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.function.xml.XMLDocument;
import com.cognos.xqe.runtree.XDataContext;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.serializer.SerializeParamValue;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Node;

public class XMLSerialize
extends ScalarFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{1, 107}, {100}, DataTypeCode.ALL_TYPES, {1, 107}};

    public XMLSerialize() {
        super("XMLSerialize", ACCEPTED_TYPES, false);
    }

    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        List nodeList;
        Value syntax = (Value)pEvaluator.getParameter(context, 0);
        XmlValue input = (XmlValue)pEvaluator.getParameter(context, 1);
        Value declarationOption = (Value)pEvaluator.getParameter(context, 2);
        Value output = (Value)outputArg;
        if (input.isNull()) {
            output.setNull();
            return;
        }
        if (syntax.getString().equals("DOCUMENT") && ((nodeList = input.getNodeList()).size() > 0 || ((Node)nodeList.get(0)).getNodeType() != 9)) {
            throw new XQERuntimeException(XQEMessageKeys.DAT_InvalidDocument);
        }
        boolean omitXmlDeclartion = declarationOption.isNull() || declarationOption.getString().equals("EXCLUDING XMLDECLARATION");
        Cursor document = XMLDocument.createDocument(context, input);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("omit-xml-declaration", omitXmlDeclartion);
        properties.put("method", SerializeParamValue.METHOD_XML);
        properties.put("version", "1.0");
        properties.put("encoding", "UTF-8");
        properties.put("indent", Boolean.FALSE);
        VolatileCData cData = document.serialize(properties);
        output.set(cData.toString());
    }

    public IDataType getResultDataTypeImpl(IDataType[] ins) {
        return ins[2];
    }
}

