/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.xml;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.LongValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.TableFunction;
import com.cognos.xqe.function.xml.XMLErrorHandler;
import com.cognos.xqe.function.xml.XMLURIResolver;
import com.cognos.xqe.function.xml.XMLUtil;
import com.cognos.xqe.function.xml.xltxej.XQEDynamicContext;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.IVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.io.TempFileUtil;
import com.ibm.icu.text.Collator;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.exec.BasicCompilationParameters;
import com.ibm.xml.xci.exec.BasicStaticContext;
import com.ibm.xml.xci.exec.CompilationParameters;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.ErrorHandler;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.Preparer;
import com.ibm.xml.xci.exec.StaticContext;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;
import org.dom4j.Namespace;
import org.dom4j.Node;

public class XMLTable
extends TableFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{100}, {45}, DataTypeCode.ALL_TYPES};
    private static final String XPATH_PREFIX = "XPath_";
    private static final Map<String, Object> SERIALIZER_PARAMETERS = new HashMap<String, Object>();
    private static XQELogger mErrorLogger;

    public XMLTable() {
        super("XMLTable", ACCEPTED_TYPES, true);
    }

    public IHybridResultSet execute(XDataContext context, IParameterEvaluator pEvaluator, IRowsetInfo rowsetInfo) throws XQERuntimeException {
        return new TabularHybridResultSet(context, (ITabularResultSet)new XMLTableResultSet(context, pEvaluator, rowsetInfo));
    }

    public IDataType getResultDataTypeImpl(IDataType[] ins) {
        return DataTypeFactory.getXmlType();
    }

    static {
        SERIALIZER_PARAMETERS.put("omit-xml-declaration", Boolean.TRUE);
        mErrorLogger = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQE, (String)"XQE", (String)"Exception", (LogLevel)LogLevel.ERROR);
    }

    private final class XMLTableResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IParameterEvaluator pEvaluator;
        private SessionContext session;
        private ErrorHandler eHandler;
        private StaticContext staticCxt;
        private String xQuery;
        private Executable qExpr;
        private Executable[] xPathExpr;
        private int nColumns;
        private int baseIndex;
        private boolean useCompiledXPath;
        private List<String> classNames;
        private XVectorContext vContext;

        XMLTableResultSet(XDataContext context, IParameterEvaluator parameterEvaluator, IRowsetInfo theRowsetInfo) {
            super(context, context.getNodeId());
            this.useCompiledXPath = false;
            this.classNames = new ArrayList<String>();
            this.pEvaluator = parameterEvaluator;
            this.rowsetInfo = theRowsetInfo;
            this.nColumns = this.rowsetInfo.getNumColumns();
            this.baseIndex = this.pEvaluator.getParameterCount() - this.nColumns;
            this.session = new SessionContext(((Object)((Object)this)).getClass().getClassLoader());
            this.eHandler = new XMLErrorHandler();
            this.staticCxt = new BasicStaticContext(this.session.getTypeRegistry());
            this.staticCxt.setBaseURI(System.getProperty("user.dir"));
            this.staticCxt.setErrorHandler(this.eHandler);
            this.vContext = ((IVectorContext)this.pEvaluator).getVectorizationContext();
            IValue nameSpaces = this.pEvaluator.getParameter(context, 0);
            if (!nameSpaces.isNull()) {
                for (Node node : ((XmlValue)nameSpaces).getNodeList()) {
                    Namespace ns = (Namespace)node;
                    String prefix = ns.getPrefix();
                    String uri = ns.getURI();
                    if (prefix.isEmpty()) {
                        this.staticCxt.setDefaultElementTypeNamespace(uri);
                        continue;
                    }
                    this.staticCxt.declareNamespace(prefix, uri);
                }
            }
            this.staticCxt.setLanguageTypeAndVersion(3);
            Preparer preparer = this.session.getPreparer(RequestInfo.XPath2);
            try {
                this.xPathExpr = new Executable[this.nColumns];
                for (int i = 0; i < this.nColumns; ++i) {
                    String xPath = this.pEvaluator.getParameter(context, this.baseIndex + i).toString();
                    if (this.useCompiledXPath) {
                        IColumnInfo columnInfo = this.rowsetInfo.getColumnInfo(i);
                        String className = XMLTable.XPATH_PREFIX + columnInfo.getName();
                        this.classNames.add(className);
                        BasicCompilationParameters cp = new BasicCompilationParameters(className);
                        preparer.compile(xPath.toString(), this.staticCxt, (CompilationParameters)cp, -1);
                        this.xPathExpr[i] = preparer.load((CompilationParameters)cp);
                        continue;
                    }
                    this.xPathExpr[i] = preparer.prepare(xPath, this.staticCxt, -1);
                }
            }
            catch (ClassNotFoundException e) {
                throw new XQERuntimeException((Throwable)e);
            }
            this.xQuery = this.pEvaluator.getParameter(context, 1).toString();
            this.xQuery = this.xQuery.replaceAll("&", "&amp;");
            try {
                this.staticCxt.setLanguageTypeAndVersion(4);
                Preparer queryPreparer = this.session.getPreparer(new RequestInfo(Cursor.RANDOM_ACCESS, null, "XPath2StreamingSubset"));
                if (queryPreparer != null) {
                    this.qExpr = queryPreparer.prepare(this.xQuery, this.staticCxt, -1);
                }
            }
            catch (Exception e) {
                mErrorLogger.log((Throwable)e);
            }
            if (this.qExpr == null) {
                this.staticCxt.setLanguageTypeAndVersion(1);
                this.qExpr = this.session.getPreparer(RequestInfo.XQuery).prepare(this.xQuery, this.staticCxt, -1);
            }
        }

        public ITabularIterator getTabularIterator() {
            return new XMLTableIterator(this.getDataContext());
        }

        public void releaseImpl() {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return XMLTableResultSet.this.classNames.contains(name);
                }
            };
            String[] fileList = new File(".").list(filter);
            if (fileList == null) {
                return;
            }
            for (String fileName : fileList) {
                TempFileUtil.deleteTempFile((File)new File("./" + fileName));
            }
        }

        private final class XMLTableIterator
        extends XTabularIterator {
            private RowValue row;
            private XVectorRowBatch batch;
            private Cursor result;
            private boolean eod;
            private DynamicContext dynamicCxt;

            private XMLTableIterator(XDataContext context) {
                super(context, context.getNodeId());
                CursorFactory cursorFactory = XMLTableResultSet.this.session.getSimpleDataFactory();
                this.dynamicCxt = new XQEDynamicContext(XMLTableResultSet.this.session, XMLTableResultSet.this.staticCxt, context);
                this.dynamicCxt.setErrorHandler(XMLTableResultSet.this.eHandler);
                XMLURIResolver myResolver = new XMLURIResolver();
                this.dynamicCxt.setSourceURIResolver((URIResolver)myResolver);
                Cursor contextDoc = null;
                for (int i = 2; i < XMLTableResultSet.this.baseIndex; i += 2) {
                    IValue value = XMLTableResultSet.this.pEvaluator.getParameter(context, i);
                    IValue name = XMLTableResultSet.this.pEvaluator.getParameter(context, i + 1);
                    Cursor cursor = XMLUtil.getXCICursor((CursorFactory)cursorFactory, (IValue)value);
                    if (name.isNull()) {
                        contextDoc = cursor;
                        continue;
                    }
                    QName qName = new QName(name.toString());
                    this.dynamicCxt.bindVariable(qName, cursor);
                }
                try {
                    this.result = XMLTableResultSet.this.qExpr.execute(contextDoc, this.dynamicCxt, Cursor.RANDOM_ACCESS, null);
                    this.row = DataValueFactory.createRowValue((Collator)context.getLocalCollator(), (IRowsetInfo)XMLTableResultSet.this.rowsetInfo);
                    if (XMLTableResultSet.this.vContext != null) {
                        this.batch = XVectorRowBatchUtil.createRowBatch((XVectorContext)XMLTableResultSet.this.vContext, (IRowsetInfo)XMLTableResultSet.this.rowsetInfo, (Collator)context.getLocalCollator());
                    }
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
            }

            public Object nextImpl() {
                if (this.result == null || this.eod) {
                    return null;
                }
                ++this.nRows;
                Cursor xPathCursor = this.result.fork(true);
                if (xPathCursor == null) {
                    this.eod = true;
                    return null;
                }
                xPathCursor.toSelf();
                for (int i = 0; i < XMLTableResultSet.this.xPathExpr.length; ++i) {
                    Value value = (Value)this.row.getColumn(i);
                    Cursor cursor = XMLTableResultSet.this.xPathExpr[i].execute(xPathCursor, this.dynamicCxt, Cursor.RANDOM_ACCESS, null);
                    if (cursor == null) {
                        value.setNull();
                        continue;
                    }
                    VolatileCData cData = cursor.serialize(SERIALIZER_PARAMETERS);
                    if (value instanceof IntegerValue || value instanceof LongValue) {
                        value.set(cData.getDouble(0));
                    } else {
                        value.set(cData.toString());
                    }
                    cursor.release();
                }
                xPathCursor.release();
                this.eod = !this.result.toNext();
                return this.row;
            }

            public Object nextBatch() {
                this.batch.reset();
                if (this.result == null || this.eod) {
                    this.batch.eod = true;
                    return this.batch;
                }
                while (this.batch.size != this.batch.maxBatchSize && !this.eod) {
                    ++this.nRows;
                    Cursor xPathCursor = this.result.fork(true);
                    if (xPathCursor == null) {
                        this.eod = true;
                        return null;
                    }
                    xPathCursor.toSelf();
                    for (int i = 0; i < XMLTableResultSet.this.xPathExpr.length; ++i) {
                        ColumnVector vector = this.batch.columns[i];
                        Cursor cursor = XMLTableResultSet.this.xPathExpr[i].execute(xPathCursor, this.dynamicCxt, Cursor.RANDOM_ACCESS, null);
                        if (cursor == null) {
                            vector.isNull[this.batch.size] = true;
                            continue;
                        }
                        VolatileCData cData = cursor.serialize(SERIALIZER_PARAMETERS);
                        if (vector.getDataType().isInteger()) {
                            vector.assign(this.batch.size, (Object)cData.getDouble(0));
                        } else {
                            vector.assign(this.batch.size, (Object)cData.toString());
                        }
                        cursor.release();
                    }
                    ++this.batch.size;
                    xPathCursor.release();
                    this.eod = !this.result.toNext();
                }
                return this.batch;
            }

            public long getIndex() {
                return this.nRows;
            }

            public void release() {
                if (this.result != null) {
                    try {
                        this.result.release();
                    }
                    catch (Exception e) {
                        mErrorLogger.log((Throwable)e);
                    }
                    finally {
                        this.result = null;
                    }
                }
            }
        }
    }
}

