/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.xml;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.JSONValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.runtree.XDataContext;
import com.ibm.json.xml.XMLToJSONTransformer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.SAXException;

public class XMLToJSON
extends ScalarFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{1, 45, 55, 56}};

    public XMLToJSON() {
        super("XMLToJSON", ACCEPTED_TYPES, true);
    }

    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        Value input = (Value)pEvaluator.getParameter(context, 0);
        JSONValue output = (JSONValue)outputArg;
        output.setNull();
        if (!input.isNull()) {
            ByteArrayInputStream is = new ByteArrayInputStream(input.getByteArray());
            String result = null;
            try {
                result = XMLToJSONTransformer.transform((InputStream)is);
            }
            catch (SAXException e) {
                throw new XQERuntimeException((Throwable)e);
            }
            catch (IOException e) {
                throw new XQERuntimeException((Throwable)e);
            }
            output.set(result);
        }
    }

    protected IDataType getResultDataTypeImpl(IDataType[] fArgumentTypes) {
        return DataTypeFactory.getJSONType();
    }
}

