/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorBW;

import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.resourcePool.MFWDSConnectionSpec;
import com.cognos.mfw4j.resourcePool.MFWDSSelectionCriteria;
import com.cognos.mfw4j.resourcePool.MFWUserPool;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.datasource.DataSourceConnectionSignon;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.providers.SimpleDataSource;
import com.cognos.xqe.olapjapi.IXQEODPSession;
import com.cognos.xqe.olapjapi.XQEODPSessionBuilder;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.security.EncryptedObject;
import com.cognos.xqe.security.IEncryptedObject;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MFWMetadataRequestMethod {
    private ExecutionEnvironment mExecutionEnv = null;
    private XQEODPSessionBuilder mODPSessionBuilder = null;
    private IXQEODPSession mODPSession = null;

    public MFWMetadataRequestMethod(MFWRequestContextUser aContext, MFWMetadataSource aMetadataSrc) {
        this.initXQE(aContext, aMetadataSrc);
    }

    public IXQEODPSession getODPSession() {
        return this.mODPSession;
    }

    public ExecutionEnvironment getExecutionEnv() {
        return this.mExecutionEnv;
    }

    public void terminate() {
        if (this.mODPSession != null) {
            this.mODPSession.release();
        }
    }

    private void initXQE(MFWRequestContextUser aContext, MFWMetadataSource aMetadataSrc) {
        try {
            this.mExecutionEnv = (ExecutionEnvironment)aContext.getXQEExecutionEnvironment();
            this.mODPSessionBuilder = new XQEODPSessionBuilder();
            this.mODPSessionBuilder.setDesignLocale(aContext.getContentLocale());
            HashMap<String, Object> metadataProperties = new HashMap<String, Object>();
            String sCubeName = aMetadataSrc.getScope("cube") != null ? (String)aMetadataSrc.getScope("cube") : (String)aMetadataSrc.getScope("infoquery");
            metadataProperties.put("cube", sCubeName);
            String sCmDataSrc = (String)aMetadataSrc.getConnectionItem("cmDataSource");
            if (this.mExecutionEnv == null) {
                this.setupStandaloneSessionBuilder(sCmDataSrc, aMetadataSrc, aContext, metadataProperties);
            } else {
                this.mODPSessionBuilder.setDataSource(sCmDataSrc, aMetadataSrc.getType(), metadataProperties);
                this.mODPSessionBuilder.setExecutionEnvironment(this.mExecutionEnv);
            }
            this.mODPSession = this.mODPSessionBuilder.createSession();
            MFWException.ASSERT((this.mODPSession != null ? 1 : 0) != 0, (String)"Failed to create an ODP session");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void setupStandaloneSessionBuilder(String sCmDataSrc, MFWMetadataSource aMetadataSrc, MFWRequestContextUser aContext, HashMap<String, Object> mapConnProps) {
        MFWDSSelectionCriteria dsSelection = new MFWDSSelectionCriteria(sCmDataSrc);
        MFWDSConnectionSpec myResolvedSpec = MFWUserPool.getInstance().getConnectionSpec((MFWRequestContext)aContext, dsSelection);
        String signonUID = myResolvedSpec.getSignonUserID();
        String signonPWD = myResolvedSpec.getSignonUserPWD();
        String sRawConnStr = myResolvedSpec.getConnectionString();
        IDataSourceConnectionSignon signon = DataSourceConnectionSignon.createSignon((String)aMetadataSrc.getType(), (String)(sCmDataSrc + "--signon"), (String)(sCmDataSrc + "/connection[0]/signon[0]"), (String)signonUID, (IEncryptedObject)new EncryptedObject((Object)signonPWD), null, null);
        IDataSource testingDS = SimpleDataSource.newInstance((String)sCmDataSrc, (String)aMetadataSrc.getType(), (String)sRawConnStr, mapConnProps, (IDataSourceConnectionSignon)signon);
        this.mODPSessionBuilder.setCustomDataSource(testingDS);
        this.mODPSessionBuilder.setProductLocale(aContext.getProductLocale());
        this.mODPSessionBuilder.setRunLocale(aContext.getContentLocale());
        String sRequestID = "MFWDim:" + Long.toString(System.currentTimeMillis());
        this.mODPSessionBuilder.setRequestId(sRequestID);
        if (aContext.getConnectionSpec() != null) {
            this.mODPSessionBuilder.setConnectionSpec(aContext.getConnectionSpec());
        } else {
            this.mODPSessionBuilder.setConnectionSpec(this.buildElement("<connection/>"));
        }
        if (aContext.getBiBusEnvelope() != null) {
            this.mODPSessionBuilder.setRequestEnvelope(aContext.getBiBusEnvelope());
        } else {
            BIBusEnvelope elmEnvelope = new BIBusEnvelope(this.buildElement("<soapenv:Header xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"/>"));
            this.mODPSessionBuilder.setRequestEnvelope(elmEnvelope);
        }
    }

    private Element buildElement(String strXML) {
        try {
            StringReader myReader = new StringReader(strXML);
            SAXReader myParser = new SAXReader();
            Document document = myParser.read((Reader)myReader);
            return document.getRootElement();
        }
        catch (DocumentException de) {
            throw new RuntimeException(de);
        }
    }
}

