/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorBW;

import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.log.MFWLogDimAdaptorTraceEvent;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfwa4j.adaptorBW.MFWMetadataRequestMethod;
import com.cognos.mfwa4j.adaptorBW.MFWMetadataXQEResponse;
import com.cognos.mfwa4j.adaptorBW.MFWOLAPSchema;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.olapjapi.IXQEODPSession;
import com.cognos.xqe.olapjapi.MetadataQueryArgs;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;

public class MFWMetadataXQERequest {
    private MetadataRestriction restrictions = null;
    private Hashtable constraintsLog = null;
    HashMap sAliasTables = new HashMap();
    private short classType = 0;
    private int m_Start = 0;
    private int m_Count = 0;

    MFWMetadataXQERequest(short classType) {
        this.initialize(classType, 0, 0);
    }

    MFWMetadataXQERequest(short classType, int iDepth, int iStart, int iCount) {
        this.initialize(classType, iStart, iCount);
    }

    private void initialize(short classType, int iStart, int iCount) {
        this.restrictions = new MetadataRestriction();
        this.constraintsLog = new Hashtable();
        this.classType = classType;
        this.m_Start = iStart;
        this.m_Count = iCount;
    }

    void addAliasTable(String sLocale, String tableName) {
        Locale aliasTableLocale = new Locale(sLocale);
        if (tableName != null && tableName.length() > 0) {
            this.sAliasTables.put(aliasTableLocale, tableName);
        } else {
            this.sAliasTables.put(aliasTableLocale, "");
        }
    }

    void addConnectionEntry(String entryName, String entryValue) {
    }

    void addConstraint(int propID, String constValue) {
        this.addConstraint(propID, constValue, false);
    }

    void addConstraint(int propID, String constValue, boolean addToRequestID) {
        this.constraintsLog.put(MFWOLAPSchema.OLAPProperty.getString(propID), constValue);
        switch (propID) {
            case 50: {
                this.restrictions.add(RestrictionType.CATALOG, (Object)constValue);
                break;
            }
            case 52: {
                this.restrictions.add(RestrictionType.SCHEMA, (Object)constValue);
                break;
            }
            case 7: {
                this.restrictions.add(RestrictionType.CUBE, (Object)constValue);
                break;
            }
            case 28: {
                this.restrictions.add(RestrictionType.LEVEL_NUMBER, (Object)Integer.parseInt(constValue));
                break;
            }
            case 59: {
                this.restrictions.add(RestrictionType.FROM, (Object)this.m_Start);
                break;
            }
            case 60: {
                this.restrictions.add(RestrictionType.SIZE, (Object)this.m_Count);
                break;
            }
            case 34: {
                this.restrictions.add(RestrictionType.MEASURE_UNIQUE_NAME, (Object)constValue);
                break;
            }
            case 16: {
                this.restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, (Object)constValue);
                break;
            }
            case 22: {
                this.restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)constValue);
                break;
            }
            case 29: {
                this.restrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, (Object)constValue);
                break;
            }
            case 51: {
                this.restrictions.add(RestrictionType.TREEOP, EnumSet.of(TreeOperatorEnum.CHILDREN));
                break;
            }
            case 53: {
                this.restrictions.add(RestrictionType.ONLY_STRUCTURES, (Object)Boolean.valueOf(constValue));
                break;
            }
            case 57: {
                this.restrictions.add(RestrictionType.KEY_DATE, (Object)constValue);
                break;
            }
        }
    }

    void addProperty(int propID) {
    }

    String getMetadataClass() {
        return null;
    }

    MFWMetadataXQEResponse doMetadataRequest(String contentLocale, MFWMetadataSource aMetadataSrc, MFWMetadataRequestMethod requestMethod) {
        MFWLogDimAdaptorTraceEvent log = new MFWLogDimAdaptorTraceEvent();
        log.logMDRequest(MFWOLAPSchema.getClassStr(this.classType), this.constraintsLog.toString());
        IXQEODPSession session = requestMethod.getODPSession();
        MFWException.ASSERT((session != null ? 1 : 0) != 0, (String)"Failed to create an ODP session");
        List metadataRecords = null;
        try {
            if (!this.sAliasTables.isEmpty()) {
                this.restrictions.add(RestrictionType.ALIASES, (Object)this.sAliasTables);
            }
            MetadataQueryArgs metadataQArgs = new MetadataQueryArgs();
            metadataQArgs.setRestrictions((IRestrictions)this.restrictions);
            switch (this.classType) {
                case 10: {
                    metadataQArgs.setOperation(MetadataOperation.PROPERTIES);
                    break;
                }
                case 20: {
                    metadataQArgs.setOperation(MetadataOperation.CUBES);
                    break;
                }
                case 30: {
                    metadataQArgs.setOperation(MetadataOperation.DIMENSIONS);
                    break;
                }
                case 40: {
                    metadataQArgs.setOperation(MetadataOperation.HIERARCHIES);
                    break;
                }
                case 50: {
                    metadataQArgs.setOperation(MetadataOperation.LEVELS);
                    break;
                }
                case 60: {
                    metadataQArgs.setOperation(MetadataOperation.MACROS);
                    break;
                }
                case 70: {
                    metadataQArgs.setOperation(MetadataOperation.MEASURES);
                    break;
                }
                case 80: {
                    metadataQArgs.setOperation(MetadataOperation.MEMBERS);
                    break;
                }
                case 90: {
                    metadataQArgs.setOperation(MetadataOperation.NAMEDSETS);
                    break;
                }
                case 100: {
                    metadataQArgs.setOperation(MetadataOperation.VARIABLES);
                    break;
                }
            }
            metadataRecords = session.getMetadata(metadataQArgs);
            log.logMDResponse(MFWOLAPSchema.getClassStr(this.classType), this.dumpResponse(metadataRecords));
            return new MFWMetadataXQEResponse(metadataRecords, this.classType);
        }
        catch (Exception e) {
            if (session != null) {
                session.release();
                session = null;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    String queryCubeDefaultMeasure(String sCatalog, String sCube, MFWMetadataRequestMethod requestMethod) {
        MFWLogDimAdaptorTraceEvent log = new MFWLogDimAdaptorTraceEvent();
        log.logMDRequest(MFWOLAPSchema.getClassStr(this.classType), this.constraintsLog.toString());
        IXQEODPSession session = requestMethod.getODPSession();
        try {
            MFWException.ASSERT((session != null ? 1 : 0) != 0, (String)"Failed to create an ODP session");
            log.logMDResponse(MFWOLAPSchema.getClassStr(this.classType), "TODO");
            return "TODO";
        }
        catch (Throwable th) {
            log.logMDResponse(MFWOLAPSchema.getClassStr(this.classType), "****** Failed ******");
            if (session != null) {
                session.release();
                session = null;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new RuntimeException(th);
        }
    }

    private String dumpResponse(List metadataList) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < metadataList.size(); ++i) {
            b.append(metadataList.get(i).toString());
        }
        return b.toString();
    }
}

