/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorBW;

import com.cognos.mfw4j.framework.MFWAdaptor;
import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWConnection;
import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWCrnIDAdvancedLookup;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWMessage;
import com.cognos.mfwa4j.adaptorBW.MFWMetadataRequestMethod;
import com.cognos.mfwa4j.adaptorBW.MFWMetadataXQERequest;
import com.cognos.mfwa4j.adaptorBW.MFWMetadataXQEResponse;
import com.cognos.mfwa4j.adaptorBW.MFWMetadataXQEResponseEntity;
import com.cognos.mfwa4j.adaptorBW.MFWOLAPSchema;
import com.cognos.mfwa4j.adaptorBW.MFWSapBWAdaptor;
import com.cognos.mfwa4j.adaptorBW.MFWSapBWConnectionReuseInfo;
import com.cognos.mfwa4j.adaptorBW.MFWSapBWLocaleHelper;
import com.cognos.mfwa4j.adaptorBW.MFWSapBWObjectLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.Step;

public final class MFWSapBWConnection
extends MFWConnection {
    private MFWNodeObject mDataSourceNode = null;
    private MFWNodeObject mRootNamespace = null;
    private String mRootNamespaceID = null;
    private MFWSapBWLocaleHelper mHlprLocale = null;
    private MFWSapBWObjectLoader mObjLoader = null;
    private MFWMetadataRequestMethod mRequestMethod = null;
    private MFWOLAPSchema mOlapSchema = null;

    MFWSapBWConnection(MFWSapBWConnectionReuseInfo aReuseInfo, MFWSapBWAdaptor anAdaptor) {
        super((MFWConnectionReuseInfo)aReuseInfo, (MFWAdaptor)anAdaptor);
        MFWSapBWAdaptor.debugTrace("----------- Constructing a new connection:", (Object)this);
        this.mHlprLocale = new MFWSapBWLocaleHelper(this.getSource());
        this.mOlapSchema = new MFWOLAPSchema();
    }

    public void destroy() {
        MFWSapBWAdaptor.debugTrace("----------- destroying connection:", (Object)this);
        this.mHlprLocale.destroy();
        this.mObjLoader.destroy();
        this.mOlapSchema = null;
        if (this.mRequestMethod != null) {
            this.mRequestMethod.terminate();
        }
        super.destroy();
    }

    protected void initialSetup(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
        MFWException.ASSERT((aLinkNodeParent == null ? 1 : 0) != 0, (String)"There should be no link node parent");
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        this.mObjLoader = new MFWSapBWObjectLoader(this, this.mHlprLocale);
        MFWNodeObject projNode = this.mObjLoader.setupProject(this.getCluster().getRootNode(), this.getSource());
        this.mHlprLocale.setupLocales(aContext, this.getSource(), projNode, true);
        boolean bSAPLayoutInfoQuery = false;
        String sCubeName = (String)this.getSource().getScope("infoquery");
        String sCatalogName = (String)this.getSource().getScope("catalog");
        MFWNodeObject nsFolderNode = null;
        if (sCubeName != null && "sapBW".equals(this.getSource().getScope("objectLayout").toString())) {
            int nIdx = sCubeName.indexOf("/");
            String sInfoQuery = "$" + sCubeName.subSequence(0, nIdx);
            MFWMetadataXQERequest infoCubeReq = new MFWMetadataXQERequest(20, 0, 0, 0);
            infoCubeReq.addConstraint(50, "$INFOCUBE");
            infoCubeReq.addConstraint(7, sInfoQuery);
            MFWMetadataXQEResponse variablesResp = infoCubeReq.doMetadataRequest(aContext.getContentLocale(), this.getSource(), this.getRequestMethod(aContext, this.getSource()));
            String sDescription = variablesResp.getFirstEntity().getPropertyValue(13);
            MFWNodeObject nsRootNode = projNode.addObjectNode(gModelRes.RID_namespace);
            this.mObjLoader.setupRootNamespace(nsRootNode, sInfoQuery, sDescription);
            nsFolderNode = nsRootNode.addObjectNode(gModelRes.RID_folder);
            MFWMessage queriesFolder = new MFWMessage("mfwa4j", "RPT_OLP_OLAP_QUERIES", null);
            this.mObjLoader.setupFolder(nsFolderNode, queriesFolder.render(aContext.getContentLocale()));
            bSAPLayoutInfoQuery = true;
        }
        if (sCubeName == null) {
            sCubeName = (String)this.getSource().getScope("cube");
            sCatalogName = "$INFOCUBE";
        }
        MFWNodeObject nsNode = !bSAPLayoutInfoQuery ? projNode.addExpandableObjectNode(gModelRes.RID_namespace) : nsFolderNode.addExpandableObjectNode(gModelRes.RID_namespace);
        this.mDataSourceNode = this.mObjLoader.setupDataSource(aContext, projNode, this.getSource(), sCatalogName, sCubeName);
        String sLastSchemaUpdateDate = this.queryCubeInfo(aContext, true);
        this.mRootNamespace = this.mObjLoader.setupRootNamespace(nsNode, sCubeName, this.mDataSourceNode.getPropertyValue(gModelRes.RID_cubeDescription));
        this.mRootNamespaceID = this.mRootNamespace.getPropertyValue(gModelRes.RID_ID);
        MFWException.ASSERT((this.mRootNamespaceID != null ? 1 : 0) != 0, (String)"Expecting an ID property for root LWM namespace");
        if (bSAPLayoutInfoQuery) {
            nsFolderNode.setExpandStatus(gModelRes.RID_namespace, (byte)1);
        } else {
            projNode.setExpandStatus(gModelRes.RID_namespace, (byte)1);
        }
        projNode.setExpandStatus(gModelRes.RID_dataSource, (byte)1);
        this.mDataSourceNode.setExpandStatus(gModelRes.RID_property, (byte)2);
        ((MFWSapBWConnectionReuseInfo)this.getReuseInfo()).setSourceLastUpdateDate(sLastSchemaUpdateDate);
        ((MFWSapBWConnectionReuseInfo)this.getReuseInfo()).addRecentUser(aContext);
    }

    protected void reconstructSetup(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWNodeObject aProjNode = this.getCluster().getRootNode().getObjectNode(gModelRes.RID_project);
        MFWException.ASSERT((aProjNode != null ? 1 : 0) != 0, (String)"Failed to locate the project node in DimConnection::reconstructSetup");
        this.mHlprLocale.setupLocales(aContext, this.getSource(), aProjNode, false);
        this.mObjLoader = new MFWSapBWObjectLoader(this, this.mHlprLocale);
        this.mRootNamespace = aProjNode.getObjectNode(gModelRes.RID_namespace);
        MFWException.ASSERT((this.mRootNamespace != null ? 1 : 0) != 0, (String)"Failed to locate the root namespace node in DimConnection::reconstructSetup");
        this.mRootNamespaceID = this.mRootNamespace.getPropertyValue(gModelRes.RID_ID);
        MFWException.ASSERT((this.mRootNamespaceID != null ? 1 : 0) != 0, (String)"Expecting an ID property for root LWM namespace in DimConnection::reconstructSetup");
        this.mDataSourceNode = this.mObjLoader.reconstructDataSource(aProjNode);
        ((MFWSapBWConnectionReuseInfo)this.getReuseInfo()).addRecentUser(aContext);
    }

    protected void expand(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, MFWNodeObject objNode) {
        Step currStep = aQuerySpec.getCurrentStepPattern();
        MFWException.ASSERT((boolean)(currStep instanceof NameStep), (String)"Expecting a NameStep to expand");
        if (!"*".equals(((NameStep)currStep).getLocalName())) {
            this.expand(aContext, aQuerySpec, aQuerySpec.getCurrentStepPatternRID(), objNode);
        } else {
            MFWInfo[] vChildren = objNode.getObjectInfo().getChildrenInfo();
            for (int idx = 0; idx < vChildren.length; ++idx) {
                this.expand(aContext, aQuerySpec, vChildren[idx].getRID(), objNode);
            }
        }
    }

    protected String evaluateDynamicProperty(MFWRequestContextUser aContext, short ridDynProp, MFWNodeObject parentNode) {
        String outValue = null;
        outValue = ridDynProp == MFWModelRes.getInstance().RID_visible ? parentNode.getPropertyValue(MFWModelRes.getInstance().RID_visible) : super.evaluateDynamicProperty(aContext, ridDynProp, parentNode);
        return outValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MFWNodeObject lookup(MFWRequestContextUser aContext, MFWInfoProperty indexProp, String indexValue, MFWNodeObject rootNode, List<MFWNodeObject> ancestorsChain) {
        boolean bNameMatchupIsNeeded = this.mHlprLocale.getAllLocales().size() > 1;
        ArrayList vIDEntries = new ArrayList();
        MFWCrnIDHelper.parseID((String)indexValue, vIDEntries);
        if (vIDEntries.isEmpty()) {
            return null;
        }
        if (!this.doesNameMatch(this.mRootNamespace, (String)vIDEntries.get(0))) {
            return null;
        }
        MFWNodeObject lookedNode = null;
        String sPartialID = this.mRootNamespaceID;
        MFWNodeObject parentNode = this.mRootNamespace;
        MFWCluster aCluster = this.mRootNamespace.getCluster();
        for (int idx = 1; idx < vIDEntries.size(); ++idx) {
            sPartialID = MFWCrnIDHelper.addEntryToID((String)sPartialID, (String)((String)vIDEntries.get(idx)));
            lookedNode = aCluster.getIndexManager().lookup(indexProp, sPartialID);
            if (lookedNode == null) {
                short[] childRIDs = this.mOlapSchema.getChildTypes(parentNode.getNameRID());
                if (childRIDs == null) {
                    return null;
                }
                Object object = parentNode.getExpandLock();
                synchronized (object) {
                    for (int i = 0; lookedNode == null && i < childRIDs.length; ++i) {
                        MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)MFWModelRes.getInstance().getResource(childRIDs[i]));
                        this.expandChildren(aContext, aQuerySpec, parentNode, childRIDs[i]);
                        lookedNode = aCluster.getIndexManager().lookup(indexProp, sPartialID);
                        if (lookedNode != null || !bNameMatchupIsNeeded) continue;
                        lookedNode = this.lookChildrenByName(parentNode, childRIDs[i], (String)vIDEntries.get(idx));
                    }
                }
            }
            if (lookedNode == null) {
                return null;
            }
            parentNode = lookedNode;
        }
        if (lookedNode != null && ancestorsChain != null) {
            MFWCrnIDAdvancedLookup.addToAncestorsChain(lookedNode, (MFWNodeObject)this.mRootNamespace, ancestorsChain);
        }
        return lookedNode;
    }

    protected void notifyLinkSourceClosing(MFWCluster aSourceCluster, MFWRequestContextUser aContext) {
    }

    void expand(MFWRequestContextUser aContext, MFWQuerySpec querySpec, short ridChild, MFWNodeObject objNode) {
        if (objNode.getExpandStatus(ridChild) == 1) {
            return;
        }
        boolean bFound = this.expandChildren(aContext, querySpec, objNode, ridChild);
        if (!bFound) {
            bFound = this.expandFolders(aContext, querySpec, ridChild, objNode);
        }
        if (!bFound) {
            super.defaultExpand(aContext, ridChild, objNode);
        }
    }

    private MFWMetadataRequestMethod getRequestMethod(MFWRequestContextUser aContext, MFWMetadataSource aMetadataSrc) {
        if (this.mRequestMethod == null) {
            this.mRequestMethod = new MFWMetadataRequestMethod(aContext, aMetadataSrc);
        }
        return this.mRequestMethod;
    }

    private boolean expandChildren(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, MFWNodeObject parentNode, short ridChild) {
        if (!this.validateRequest(ridChild, parentNode)) {
            return false;
        }
        if (ridChild == MFWModelRes.getInstance().RID_rootMember) {
            return true;
        }
        if (parentNode.getExpandStatus(ridChild) == 1) {
            return true;
        }
        ArrayList olapTypes = null;
        olapTypes = "dataSource".equals(parentNode.getName()) && (ridChild == MFWModelRes.getInstance().RID_property || ridChild == MFWModelRes.getInstance().RID_cubeDefaultMeasure) ? this.mOlapSchema.getDatasourceObjectSpecs(ridChild) : this.mOlapSchema.getObjectSpecs(ridChild);
        if (olapTypes.size() == 0) {
            return false;
        }
        for (int idx = 0; idx < olapTypes.size(); ++idx) {
            MFWOLAPSchema.DimObjectSpec olapType = (MFWOLAPSchema.DimObjectSpec)olapTypes.get(idx);
            MFWMetadataXQERequest qfRequest = this.makeRequest(aContext, parentNode, olapType, aQuerySpec.getRetrievalDepth(), aQuerySpec.getRetrievalStartIndex(), aQuerySpec.getRetrievalCount());
            if (olapType.getOLAPType() != 110) {
                MFWMetadataXQEResponse qfResponse = qfRequest.doMetadataRequest(aContext.getContentLocale(), this.getSource(), this.getRequestMethod(aContext, this.getSource()));
                this.populateCluster(aContext, aQuerySpec, parentNode, olapType, qfResponse);
                continue;
            }
            this.populateCubeDefaultMeasure(qfRequest, this.getRequestMethod(aContext, this.getSource()), parentNode);
        }
        return true;
    }

    private void populateCubeDefaultMeasure(MFWMetadataXQERequest qfRequest, MFWMetadataRequestMethod requestMethod, MFWNodeObject objParent) {
        String defMsrExtName;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String sCubeName = (String)this.getSource().getScope("infoquery");
        String sCatalogName = (String)this.getSource().getScope("catalog");
        if (sCubeName == null) {
            sCubeName = (String)this.getSource().getScope("cube");
        }
        if ((defMsrExtName = qfRequest.queryCubeDefaultMeasure(sCatalogName, sCubeName, requestMethod)) == null) {
            objParent.setExpandStatus(gModelRes.RID_cubeDefaultMeasure, (byte)1);
            return;
        }
        objParent.addProperty(gModelRes.RID_cubeDefaultMeasure, defMsrExtName);
    }

    private boolean expandFolders(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, short ridPattern, MFWNodeObject objParent) {
        boolean bSupportsDimGroup;
        boolean bFound = false;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String sConfigSetting = this.getAdaptor().getSourceConfig().getCapability("Display_Path");
        boolean bSupportsDisplayPath = sConfigSetting != null && "true".equals(sConfigSetting);
        sConfigSetting = this.getAdaptor().getSourceConfig().getCapability("dimensionGroup");
        boolean bl = bSupportsDimGroup = sConfigSetting != null && "true".equals(sConfigSetting);
        if (ridPattern == gModelRes.RID_folder && objParent.getNameRID() == gModelRes.RID_namespace) {
            if (bSupportsDimGroup) {
                bFound = this.expandChildren(aContext, aQuerySpec, objParent, gModelRes.RID_dimension);
            }
            if (bSupportsDisplayPath) {
                bFound = this.expandChildren(aContext, aQuerySpec, objParent, gModelRes.RID_calculation);
            }
        } else if (bSupportsDisplayPath && ridPattern == gModelRes.RID_hierarchyFolder && objParent.getNameRID() == gModelRes.RID_dimension) {
            bFound = this.expandChildren(aContext, aQuerySpec, objParent, gModelRes.RID_hierarchy);
        } else if (bSupportsDisplayPath && ridPattern == gModelRes.RID_measureFolder && (objParent.getNameRID() == gModelRes.RID_dimension || objParent.getNameRID() == gModelRes.RID_measure)) {
            bFound = this.expandChildren(aContext, aQuerySpec, objParent, gModelRes.RID_measure);
        }
        return bFound;
    }

    MFWMetadataXQEResponse queryObjectRootMember(MFWRequestContextUser aContext, MFWNodeObject hierarchyObj, int nSize) {
        ArrayList olapTypes = this.mOlapSchema.getObjectSpecs(MFWModelRes.getInstance().RID_rootMember);
        MFWException.ASSERT((olapTypes.size() == 1 ? 1 : 0) != 0, (String)"Expecting exactly one OLAP type specification for root member");
        MFWMetadataXQERequest rootMemRequest = this.makeRequest(aContext, hierarchyObj, (MFWOLAPSchema.DimObjectSpec)olapTypes.get(0), 0, 0, nSize);
        return rootMemRequest.doMetadataRequest(aContext.getContentLocale(), this.getSource(), this.getRequestMethod(aContext, this.getSource()));
    }

    private MFWMetadataXQERequest makeRequest(MFWRequestContextUser aContext, MFWNodeObject objParent, MFWOLAPSchema.DimObjectSpec olapTypeInfo, int retrievalDepth, int startIndex, int retrievalCount) {
        MFWMetadataXQERequest outRequest = new MFWMetadataXQERequest(olapTypeInfo.getOLAPType(), retrievalDepth, startIndex, retrievalCount);
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWSapBWConnection.makeConnection(aContext, outRequest, this.getSource(), this.mHlprLocale.getDesignLocale(), this.getAdaptor().getSourceConfig());
        for (int idx = 0; idx < olapTypeInfo.getOLAPProperties().length; ++idx) {
            outRequest.addProperty(olapTypeInfo.getOLAPProperties()[idx]);
        }
        this.addConstraint(this.mDataSourceNode, outRequest);
        this.mHlprLocale.addAliasTablesForLocales(outRequest);
        switch (olapTypeInfo.getOLAPType()) {
            case 70: {
                if (objParent.getNameRID() == gModelRes.RID_dimension) {
                    this.addConstraint(objParent, outRequest);
                    outRequest.addConstraint(28, "0", false);
                    outRequest.addConstraint(53, this.getSource().getScope("dualStructures").toString(), false);
                    break;
                }
                if (objParent.getNameRID() == gModelRes.RID_measure || objParent.getNameRID() == gModelRes.RID_measureFolder) {
                    this.addConstraint(objParent, outRequest);
                    outRequest.addConstraint(51, "CHILDREN", false);
                    outRequest.addConstraint(53, this.getSource().getScope("dualStructures").toString(), false);
                    break;
                }
                MFWException.ASSERT((boolean)false, (String)"Unexpected parent object when querying measures");
                break;
            }
            case 30: {
                outRequest.addConstraint(53, this.getSource().getScope("dualStructures").toString(), false);
                this.setParentConstraints(objParent, gModelRes, outRequest);
                break;
            }
            case 80: {
                outRequest.addConstraint(28, "0", false);
                outRequest.addConstraint(59, "", false);
                outRequest.addConstraint(60, "", false);
                this.setParentConstraints(objParent, gModelRes, outRequest);
                break;
            }
            case 50: {
                List vPropNodes = objParent.getObjectNodes(gModelRes.RID_property);
                for (int idx = 0; idx < vPropNodes.size(); ++idx) {
                    MFWNodeObject propNodeObj = (MFWNodeObject)vPropNodes.get(idx);
                    String propName = propNodeObj.getPropertyValue(gModelRes.RID_name);
                    if (!"Valid_From".equals(propName) && !"Valid_To".equals(propName)) continue;
                    String sPropValue = propNodeObj.getPropertyValue(gModelRes.RID__Value);
                    String sTime = sPropValue.substring(0, sPropValue.indexOf(" "));
                    outRequest.addConstraint(57, sTime, false);
                    break;
                }
                this.setParentConstraints(objParent, gModelRes, outRequest);
                break;
            }
            case 100: 
            case 110: {
                String sCubeName = this.mDataSourceNode.getPropertyValue(gModelRes.RID_cube);
                if ("[".equals(sCubeName.substring(0, 1)) && "]".equals(sCubeName.substring(sCubeName.length() - 1, sCubeName.length()))) {
                    sCubeName = sCubeName.substring(1, sCubeName.length() - 1);
                }
                outRequest.addConstraint(7, sCubeName, false);
                break;
            }
            default: {
                this.setParentConstraints(objParent, gModelRes, outRequest);
            }
        }
        return outRequest;
    }

    public void setParentConstraints(MFWNodeObject objParent, MFWModelRes gModelRes, MFWMetadataXQERequest outRequest) {
        while (objParent.getNameRID() != gModelRes.RID_namespace) {
            this.addConstraint(objParent, outRequest);
            objParent = (MFWNodeObject)objParent.getParent();
        }
    }

    public static final void makeConnection(MFWRequestContextUser aContext, MFWMetadataXQERequest myReqHlpr, MFWMetadataSource aSource, String sDesignLocale, MFWConfiguration.MFWConfigSource srcConfig) {
        myReqHlpr.addConnectionEntry("dataSourceType", srcConfig.getQFWProviderName());
        myReqHlpr.addConnectionEntry("CAMPassport", aContext.getUserPassport());
        myReqHlpr.addConnectionEntry("contentManagerURI", MFWContentHelper.getCMGatewayURI());
        String requestID = MFWSapBWConnection.getConnectionValueFor(aContext.getConnectionSpec(), "requestID");
        if (requestID != null && requestID.length() > 0) {
            myReqHlpr.addConnectionEntry("requestID", requestID);
        }
        myReqHlpr.addConnectionEntry("serviceID", "MFWA4J");
        myReqHlpr.addConnectionEntry("productLocale", aContext.getProductLocale());
        String sRunLocale = (String)aSource.getConnectionItem("runLocale");
        if (sRunLocale == null || sRunLocale.length() == 0) {
            myReqHlpr.addConnectionEntry("runLocale", sDesignLocale);
        }
        for (Map.Entry aPair : aSource.getConnectionInfo().entrySet()) {
            myReqHlpr.addConnectionEntry((String)aPair.getKey(), (String)aPair.getValue());
        }
        for (Map.Entry aPair : aSource.getScopeInfo().entrySet()) {
            myReqHlpr.addConnectionEntry((String)aPair.getKey(), (String)aPair.getValue());
        }
        for (Map.Entry aPair : aSource.getSignonInfo().entrySet()) {
            myReqHlpr.addConnectionEntry((String)aPair.getKey(), (String)aPair.getValue());
        }
    }

    private boolean validateRequest(short ridChild, MFWNodeObject objParent) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String aProp = null;
        if (ridChild == gModelRes.RID_measure || ridChild == gModelRes.RID_measureFolder) {
            MFWNodeObject parent;
            for (parent = objParent; parent != null && parent.getNameRID() != gModelRes.RID_dimension; parent = parent.getParentObject()) {
            }
            MFWException.ASSERT((parent != null ? 1 : 0) != 0, (String)"Expecting a valid dimension in measure/measureFolder ancestry");
            aProp = parent.getPropertyValue(gModelRes.RID_type);
            if (aProp == null || !"measure".equals(aProp)) {
                return false;
            }
        } else {
            if (ridChild == gModelRes.RID_dimension || ridChild == gModelRes.RID_calculation) {
                return objParent.getNameRID() == gModelRes.RID_namespace;
            }
            if (ridChild == gModelRes.RID_hierarchy) {
                if (objParent.getNameRID() != gModelRes.RID_dimension) {
                    return false;
                }
                aProp = objParent.getPropertyValue(gModelRes.RID_type);
                if (aProp == null || "measure".equals(aProp)) {
                    return false;
                }
            } else if (ridChild == gModelRes.RID_queryItem) {
                if (objParent.getNameRID() != gModelRes.RID_level && objParent.getNameRID() != gModelRes.RID_hierarchy) {
                    return false;
                }
                aProp = objParent.getPropertyValue(gModelRes.RID_visible);
                if (aProp != null && "hiddenAndAccessible".equals(aProp)) {
                    return false;
                }
                if (objParent.getNameRID() == gModelRes.RID_hierarchy) {
                    aProp = objParent.getPropertyValue(gModelRes.RID_parentChild);
                    return aProp != null && "true".equals(aProp);
                }
            } else if (ridChild == gModelRes.RID_rootMember) {
                aProp = objParent.getPropertyValue(gModelRes.RID_visible);
                return aProp == null || !"hiddenAndAccessible".equals(aProp);
            }
        }
        return true;
    }

    private void populateCluster(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, MFWNodeObject objParent, MFWOLAPSchema.DimObjectSpec dimObjSpec, MFWMetadataXQEResponse response) {
        this.mObjLoader.populateCluster(aContext, aQuerySpec, dimObjSpec.getOLAPType(), objParent, response);
        objParent.setExpandStatus(dimObjSpec.getObjRID(), (byte)1);
    }

    private String queryCubeInfo(MFWRequestContextUser aContext, boolean doPopulateDataSrcInfo) {
        String outLastSchemaUpdate = null;
        ArrayList specs = this.mOlapSchema.getObjectSpecs(MFWModelRes.getInstance().RID_dataSource);
        MFWException.ASSERT((specs.size() == 1 ? 1 : 0) != 0, (String)"Expecting exactly one OLAP object spec for 'data source'");
        MFWOLAPSchema.DimObjectSpec cubeSpec = (MFWOLAPSchema.DimObjectSpec)specs.get(0);
        MFWMetadataXQERequest cubeReq = new MFWMetadataXQERequest(cubeSpec.getOLAPType(), 0, 0, 0);
        MFWSapBWConnection.makeConnection(aContext, cubeReq, this.getSource(), this.mHlprLocale.getDesignLocale(), this.getAdaptor().getSourceConfig());
        for (int idx = 0; idx < cubeSpec.getOLAPProperties().length; ++idx) {
            cubeReq.addProperty(cubeSpec.getOLAPProperties()[idx]);
        }
        this.addConstraint(this.mDataSourceNode, cubeReq);
        MFWMetadataXQEResponse cubeResp = cubeReq.doMetadataRequest(aContext.getContentLocale(), this.getSource(), this.getRequestMethod(aContext, this.getSource()));
        MFWMetadataXQEResponseEntity firstEntry = cubeResp.getFirstEntity();
        MFWException.ASSERT((firstEntry != null ? 1 : 0) != 0, (String)"Expecting a response entry in response to a cube properties");
        outLastSchemaUpdate = firstEntry.getPropertyValue(27);
        if (doPopulateDataSrcInfo) {
            this.mObjLoader.populateCubeProps(this.mDataSourceNode, this.getSource(), firstEntry);
        }
        return outLastSchemaUpdate;
    }

    private void addConstraint(MFWNodeObject objNode, MFWMetadataXQERequest myReqHlpr) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        if (objNode.getNameRID() == gModelRes.RID_folder || objNode.getNameRID() == gModelRes.RID_hierarchyFolder || objNode.getNameRID() == gModelRes.RID_measureFolder) {
            return;
        }
        if (objNode.getNameRID() == gModelRes.RID_dataSource) {
            String scopeDataSrc = objNode.getPropertyValue(gModelRes.RID_catalog);
            if (scopeDataSrc != null) {
                if ((String)this.getSource().getScope("infoquery") != null) {
                    myReqHlpr.addConstraint(50, scopeDataSrc);
                } else {
                    myReqHlpr.addConstraint(50, "$INFOCUBE");
                }
            }
            if ((scopeDataSrc = objNode.getPropertyValue(gModelRes.RID_schema)) != null) {
                myReqHlpr.addConstraint(52, scopeDataSrc);
            }
            if ((scopeDataSrc = objNode.getPropertyValue(gModelRes.RID_cube)) != null) {
                String sCubeName = scopeDataSrc;
                if ("[".equals(sCubeName.substring(0, 1)) && "]".equals(sCubeName.substring(sCubeName.length() - 1, sCubeName.length()))) {
                    sCubeName = sCubeName.substring(1, sCubeName.length() - 1);
                }
                myReqHlpr.addConstraint(7, sCubeName);
            }
        } else {
            String extName = objNode.getPropertyValue(gModelRes.RID_externalName);
            MFWException.ASSERT((extName != null ? 1 : 0) != 0, (String)"An externalName is expected -- AddConstraint");
            if (objNode.getNameRID() == gModelRes.RID_measureFolder) {
                myReqHlpr.addConstraint(34, extName);
            } else {
                StringBuffer sConstName = new StringBuffer(objNode.getName().substring(0, 1).toUpperCase());
                sConstName.append(objNode.getName().substring(1));
                sConstName.append("_Unique_Name");
                myReqHlpr.addConstraint(MFWOLAPSchema.OLAPProperty.getPropertyID(sConstName.toString()), extName);
            }
        }
    }

    private static String getConnectionValueFor(Element elmConn, String sPropName) {
        String sPropValue = "";
        if (elmConn == null) {
            return sPropValue;
        }
        Node nodeProp = elmConn.selectSingleNode(sPropName);
        if (nodeProp != null && nodeProp instanceof Element) {
            sPropValue = ((Element)nodeProp).attributeValue("value");
        }
        return sPropValue;
    }

    private boolean doesNameMatch(MFWNodeObject objNode, String sName) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        List vNames = objNode.getObjectNodes(gModelRes.RID_name);
        for (int idx = 0; idx < vNames.size(); ++idx) {
            String valueNode = ((MFWNodeObject)vNames.get(idx)).getPropertyValue(gModelRes.RID__Value);
            if (valueNode == null || !sName.equals(valueNode)) continue;
            return true;
        }
        return false;
    }

    private MFWNodeObject lookChildrenByName(MFWNodeObject objNode, short ridChildName, String sName) {
        List vChildren = objNode.getObjectNodes(ridChildName);
        for (int idx = 0; idx < vChildren.size(); ++idx) {
            if (!this.doesNameMatch((MFWNodeObject)vChildren.get(idx), sName)) continue;
            return (MFWNodeObject)vChildren.get(idx);
        }
        return null;
    }

    public MFWNodeObject getRootNamespace() {
        return this.mRootNamespace;
    }

    public MFWNodeObject getDataSource() {
        return this.mDataSourceNode;
    }
}

