/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorBW;

import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.resourcePool.MFWDSConnectionSpec;
import com.cognos.mfw4j.resourcePool.MFWDSSelectionCriteria;
import com.cognos.mfw4j.resourcePool.MFWUserPool;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfwa4j.adaptorBW.MFWMetadataRequestMethod;
import com.cognos.mfwa4j.adaptorBW.MFWMetadataXQERequest;
import com.cognos.mfwa4j.adaptorBW.MFWMetadataXQEResponse;
import com.cognos.mfwa4j.adaptorBW.MFWMetadataXQEResponseEntity;
import com.cognos.mfwa4j.adaptorBW.MFWOLAPSchema;
import com.cognos.mfwa4j.adaptorBW.MFWSapBWAdaptor;
import com.cognos.mfwa4j.adaptorBW.MFWSapBWConnection;
import com.cognos.mfwa4j.toolBox.MFWSharedContentHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.CRC32;
import org.dom4j.Element;
import org.dom4j.Node;

public class MFWSapBWConnectionReuseInfo
extends MFWConnectionReuseInfo {
    private long mDigSourceIdentity;
    private long mDigUserIdentity;
    private ArrayList<String> mLocales = null;
    private String mRootNamespaceID = null;
    private String mLastSchemaUpdateDate = null;
    private ArrayList<String> mRecentUsers;

    MFWSapBWConnectionReuseInfo(MFWConfiguration.MFWConfigSource aConfigSrc, MFWRequestContextUser aContext, MFWMetadataSource aMetadataSrc, MFWNodeObject aLinkParent) {
        super(aMetadataSrc);
        CRC32 myCRC = new CRC32();
        myCRC.update(MFWSharedContentHelper.getDigestedUserIdentity((MFWRequestContext)aContext));
        this.mDigUserIdentity = myCRC.getValue();
        this.mLocales = new ArrayList(1);
        this.mLocales.add(aContext.getContentLocale());
        this.populateConnectionItemsForXQE(aConfigSrc, aContext);
        myCRC.reset();
        myCRC.update(this.digestSourceIdentity(aContext, this.getMetadataSource()));
        this.mDigSourceIdentity = myCRC.getValue();
    }

    public void destroy() {
        super.destroy();
        if (this.mRecentUsers != null) {
            this.mRecentUsers.clear();
        }
        this.mLocales.clear();
    }

    long getSourceIdentityDigest() {
        return this.mDigSourceIdentity;
    }

    long getUserIendityDigest() {
        return this.mDigUserIdentity;
    }

    ArrayList<String> getLocales() {
        return this.mLocales;
    }

    String getRootNamespaceID() {
        return this.mRootNamespaceID;
    }

    public StringBuffer getPersistentPath() {
        StringBuffer path = new StringBuffer(MFWConfiguration.getInstance().getPMCDirectoryPath());
        path.append("/");
        path.append(Long.toString(this.mDigSourceIdentity));
        new File(path.toString()).mkdirs();
        path.append("/");
        path.append(Long.toString(this.mDigUserIdentity));
        return path;
    }

    protected boolean isCacheUpToDate(MFWRequestContextUser aContext, MFWConnectionReuseInfo thatReuseInfo) {
        MFWException.ASSERT((this.mLastSchemaUpdateDate != null ? 1 : 0) != 0, (String)"Expecting a valid last structural update date!");
        if (this.mRecentUsers != null && this.mRecentUsers.contains(aContext.getUserPassport())) {
            MFWSapBWAdaptor.debugTrace("The source's last update date was recently checked for user --- assume up-to-date", null);
            return true;
        }
        String sSourceUpdateDate = this.queryCubeLastSchemaUpdate(aContext);
        MFWSapBWAdaptor.debugTrace("Last Schema update date (source):", null);
        MFWSapBWAdaptor.debugTrace(sSourceUpdateDate, null);
        boolean isUptodate = this.mLastSchemaUpdateDate.equals(sSourceUpdateDate);
        if (isUptodate) {
            this.addRecentUser(aContext);
        }
        return isUptodate;
    }

    protected boolean isReusableFor(MFWConnectionReuseInfo thatReuseInfo) {
        MFWSapBWAdaptor.debugTrace("Can cache be reused?", (Object)this);
        MFWSapBWConnectionReuseInfo thatDimReuseInfo = (MFWSapBWConnectionReuseInfo)thatReuseInfo;
        if (thatDimReuseInfo.getSourceIdentityDigest() != this.mDigSourceIdentity) {
            MFWSapBWAdaptor.debugTrace("No ... Source mismatch", null);
            return false;
        }
        ArrayList<String> vThatLocales = thatDimReuseInfo.getLocales();
        for (int idx = 0; idx < vThatLocales.size(); ++idx) {
            if (this.mLocales.contains(vThatLocales.get(idx))) continue;
            MFWSapBWAdaptor.debugTrace("No ... locale mismatch", null);
            return false;
        }
        if (this.mRootNamespaceID != null && !this.mRootNamespaceID.equals(thatDimReuseInfo.getRootNamespaceID()) || thatDimReuseInfo.getRootNamespaceID() != null && !thatDimReuseInfo.getRootNamespaceID().equals(this.mRootNamespaceID)) {
            MFWSapBWAdaptor.debugTrace("No ... root namespace ID mismatch", null);
            return false;
        }
        if (this.mDigUserIdentity != thatDimReuseInfo.getUserIendityDigest()) {
            MFWSapBWAdaptor.debugTrace("No ... user identity mismatch", null);
            return false;
        }
        MFWSapBWAdaptor.debugTrace("Yes ... all reuse criteria are met!", null);
        return true;
    }

    void setSourceLastUpdateDate(String cubeLastSchemaUpdateDate) {
        this.mLastSchemaUpdateDate = cubeLastSchemaUpdateDate;
    }

    void addRecentUser(MFWRequestContextUser aContext) {
        if (this.mRecentUsers == null) {
            this.mRecentUsers = new ArrayList();
        }
        this.mRecentUsers.add(aContext.getUserPassport());
    }

    private byte[] digestSourceIdentity(MFWRequestContextUser aContext, MFWMetadataSource aMetadataSrc) {
        String cubePasswordStr;
        String passwordStr;
        String userNameStr;
        StringBuffer myDigest = new StringBuffer();
        for (Map.Entry aPair : aMetadataSrc.getConnectionInfo().entrySet()) {
            myDigest.append((String)aPair.getKey());
            myDigest.append((String)aPair.getValue());
        }
        for (Map.Entry aPair : aMetadataSrc.getScopeInfo().entrySet()) {
            myDigest.append((String)aPair.getKey());
            myDigest.append((String)aPair.getValue());
        }
        for (Map.Entry aPair : aMetadataSrc.getSignonInfo().entrySet()) {
            if ("ASTicket".equals((String)aPair.getKey())) continue;
            myDigest.append((String)aPair.getKey());
            myDigest.append((String)aPair.getValue());
        }
        for (Map.Entry aPair : aMetadataSrc.getAliasInfo().entrySet()) {
            myDigest.append((String)aPair.getKey());
            myDigest.append((String)aPair.getValue());
        }
        String sCmDataSrc = (String)aMetadataSrc.getConnectionItem("cmDataSource");
        Element elmConnSpec = aContext.getConnectionSpec();
        String searchPathStr = this.getConnectionValueFor(elmConnSpec, sCmDataSrc, "searchPath");
        if (searchPathStr != null && searchPathStr.length() > 0) {
            myDigest.append(searchPathStr);
        }
        if ((userNameStr = this.getConnectionValueFor(elmConnSpec, sCmDataSrc, "username")) != null && userNameStr.length() > 0) {
            myDigest.append(userNameStr);
        }
        if ((passwordStr = this.getConnectionValueFor(elmConnSpec, sCmDataSrc, "password")) != null && passwordStr.length() > 0) {
            myDigest.append(passwordStr);
        }
        if ((cubePasswordStr = this.getConnectionValueFor(elmConnSpec, sCmDataSrc, "cubePassword")) != null && cubePasswordStr.length() > 0) {
            myDigest.append(cubePasswordStr);
        }
        return myDigest.toString().getBytes();
    }

    private void populateConnectionItemsForXQE(MFWConfiguration.MFWConfigSource aConfigSrc, MFWRequestContextUser aContext) {
        String sCmDataSrc = (String)this.getMetadataSource().getConnectionItem("cmDataSource");
        if (sCmDataSrc != null && sCmDataSrc.length() != 0) {
            MFWDSSelectionCriteria dsSelection = new MFWDSSelectionCriteria(sCmDataSrc);
            MFWDSConnectionSpec myResolvedSpec = MFWUserPool.getInstance().getConnectionSpec((MFWRequestContext)aContext, dsSelection);
            if (myResolvedSpec.getSignonUserID() != null) {
                this.getMetadataSource().addSignon("username", (Object)myResolvedSpec.getSignonUserID());
            }
            if (myResolvedSpec.getSignonUserPWD() != null) {
                this.getMetadataSource().addSignon("password", (Object)myResolvedSpec.getSignonUserPWD());
            }
            String sConnectionString = myResolvedSpec.getConnectionString();
            MFWMetadataSource aMetadataSrc = this.getMetadataSource();
            aMetadataSrc.addConnectionItem("rawConnectionString", (Object)sConnectionString);
        }
    }

    private String getConnectionValueFor(Element elmConn, String sCMDataSrc, String sPropName) {
        Node searchPath;
        String sPropValue = "";
        if (elmConn == null) {
            return sPropValue;
        }
        Node nodeProp = elmConn.selectSingleNode("//connection/dataSource[@value='" + sCMDataSrc + "']");
        if (nodeProp != null && nodeProp instanceof Element && (searchPath = nodeProp.getParent().selectSingleNode(sPropName)) != null) {
            sPropValue = ((Element)searchPath).attributeValue("value");
        }
        return sPropValue;
    }

    String queryCubeLastSchemaUpdate(MFWRequestContextUser aContext) {
        MFWMetadataXQEResponse cubeResp;
        MFWMetadataXQEResponseEntity firstEntry;
        ArrayList specs = new MFWOLAPSchema().getObjectSpecs(MFWModelRes.getInstance().RID_dataSource);
        MFWException.ASSERT((specs.size() == 1 ? 1 : 0) != 0, (String)"Expecting exactly one OLAP object spec for 'data source'");
        MFWOLAPSchema.DimObjectSpec cubeSpec = (MFWOLAPSchema.DimObjectSpec)specs.get(0);
        MFWMetadataXQERequest cubeReq = new MFWMetadataXQERequest(cubeSpec.getOLAPType(), 0, 0, 0);
        MFWSapBWConnection.makeConnection(aContext, cubeReq, this.getMetadataSource(), aContext.getContentLocale(), MFWConfiguration.getInstance().getConfigInfoFor(this.getMetadataSource().getType()));
        cubeReq.addProperty(27);
        String scopeItem = (String)this.getMetadataSource().getScope("catalog");
        if (scopeItem != null && scopeItem.length() > 0) {
            cubeReq.addConstraint(50, scopeItem);
        }
        if ((scopeItem = (String)this.getMetadataSource().getScope("schema")) != null && scopeItem.length() > 0) {
            cubeReq.addConstraint(52, scopeItem);
        }
        if ((scopeItem = (String)this.getMetadataSource().getScope("cube")) != null && scopeItem.length() > 0) {
            cubeReq.addConstraint(7, scopeItem);
        }
        MFWException.ASSERT(((firstEntry = (cubeResp = cubeReq.doMetadataRequest(aContext.getContentLocale(), this.getMetadataSource(), new MFWMetadataRequestMethod(aContext, this.getMetadataSource()))).getFirstEntity()) != null ? 1 : 0) != 0, (String)"Expecting a response entry in response to a cube properties");
        return firstEntry.getPropertyValue(27);
    }
}

