/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorBW;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWCrnIDGenerator;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoObject;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWMessage;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import com.cognos.mfwa4j.adaptorBW.MFWMetadataXQEResponse;
import com.cognos.mfwa4j.adaptorBW.MFWMetadataXQEResponseEntity;
import com.cognos.mfwa4j.adaptorBW.MFWOLAPSchema;
import com.cognos.mfwa4j.adaptorBW.MFWSapBWConnection;
import com.cognos.mfwa4j.adaptorBW.MFWSapBWLocaleHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

final class MFWSapBWObjectLoader {
    private MFWSapBWConnection mSapBWConnection;
    private MFWCrnIDGenerator mIDGenerator;
    MFWSapBWLocaleHelper mHlprLocale;
    String mDataSourceId;
    private MFWOLAPSchema mOlapSchema;
    private static final int nKeyNameLength = 32;
    private static final int nCombinedDimensionPos = 33;
    private static final String SAPBW_Level00 = "[LEVEL00]";
    private static final String SAPBW_Level01 = "[LEVEL01]";
    private static final String SAPBW_Level02 = "[LEVEL02]";
    private static final String SAPBW_Level03 = "[LEVEL03]";
    private static final String SAPBW_CalDay1 = "[0CALDAY]";
    private static final String SAPBW_CalDay2 = "[0DATE]";
    private static final String SAPBW_UnitOfMeasure = "[0UNIT]";
    private static final String SAPBW_Currency = "[0CURRENCY]";
    private static final String SAPBW_0HierNode = "0HIER_NODE";
    private static final String SAPBW_kDateMinDefault = "1000-01-01 00:00:00.0";
    private static final String SAPBW_kDateMaxDefault = "9999-12-31 00:00:00.0";
    private static final String SAPBW_RestOfHierarchy = "[REST_H                          1HIER_REST]";
    private static final String SAPBW_MemberUniqueName = "[MEMBER_UNIQUE_NAME]";
    ArrayList vSAPTimeDimensions;
    int mExternalNrOfLevels = 0;

    MFWSapBWObjectLoader(MFWSapBWConnection dimConnection, MFWSapBWLocaleHelper hlprLocale) {
        this.mSapBWConnection = dimConnection;
        this.mIDGenerator = new MFWCrnIDGenerator(dimConnection.getCluster());
        this.mHlprLocale = hlprLocale;
        this.mDataSourceId = null;
        this.mOlapSchema = new MFWOLAPSchema();
        this.vSAPTimeDimensions = new ArrayList();
    }

    void destroy() {
        this.mSapBWConnection = null;
        this.mIDGenerator.destroy();
        this.mHlprLocale = null;
        this.mOlapSchema = null;
    }

    void populateCluster(MFWRequestContextUser aContext, MFWQuerySpec querySpec, short olapType, MFWNodeObject objNode, MFWMetadataXQEResponse response) {
        switch (olapType) {
            case 30: {
                this.populateDimensions(aContext, querySpec, objNode, response);
                break;
            }
            case 40: {
                this.populateHierarchies(aContext, querySpec, objNode, response);
                break;
            }
            case 50: {
                this.populateLevels(aContext, querySpec, objNode, response);
                break;
            }
            case 10: {
                this.populateAttributes(aContext, querySpec, objNode, response);
                break;
            }
            case 70: {
                this.populateMeasures(aContext, querySpec, objNode, response);
                break;
            }
            case 100: {
                this.populateVariables(aContext, querySpec, objNode, response);
                break;
            }
        }
    }

    MFWNodeObject setupProject(MFWNodeObject rootNode, MFWMetadataSource aMetadataSrc) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String sCmDataSrcName = (String)aMetadataSrc.getConnectionItem("cmDataSource");
        MFWNodeObject projNode = rootNode.addObjectNode(gModelRes.RID_project);
        MFWException.ASSERT((projNode != null ? 1 : 0) != 0, (String)"Failed to create the project node");
        String sUsedName = sCmDataSrcName == null || sCmDataSrcName.length() == 0 ? "olapProj" : sCmDataSrcName;
        projNode.addProperty(gModelRes.RID_name, sUsedName);
        projNode.addObjectNode(gModelRes.RID_parameterMaps);
        projNode.addObjectNode(gModelRes.RID_securityViews);
        return projNode;
    }

    MFWNodeObject setupRootNamespace(MFWNodeObject nsNode, String sCubeName, String sCubeDescription) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        StringBuffer sOutName = new StringBuffer();
        StringBuffer sOutDescription = new StringBuffer();
        StringBuffer sOutScreenTip = new StringBuffer();
        this.generateSAPBWNames(sCubeDescription, sCubeDescription, sCubeName, sOutName, sOutDescription, sOutScreenTip);
        this.genObjectProperties(sOutName.toString(), sOutDescription.toString(), sOutScreenTip.toString(), nsNode);
        this.addCustomProperty(nsNode, gModelRes, "uniqueName", "hidden", sCubeName);
        return nsNode;
    }

    void setupFolder(MFWNodeObject nsNode, String sName) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        this.genObjectProperties(sName, null, null, nsNode);
        this.addCustomProperty(nsNode, gModelRes, "uniqueName", "hidden", "folder");
    }

    MFWNodeObject reconstructDataSource(MFWNodeObject projNode) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWNodeObject dsNode = projNode.getObjectNode(gModelRes.RID_dataSource);
        MFWException.ASSERT((dsNode != null ? 1 : 0) != 0, (String)"Expecting a valid data source object --- DimObjectLoader::reconstructDataSource");
        this.mDataSourceId = dsNode.getPropertyValue(gModelRes.RID_ID);
        MFWException.ASSERT((this.mDataSourceId != null ? 1 : 0) != 0, (String)"Failed to generate an ID property");
        return dsNode;
    }

    MFWNodeObject setupDataSource(MFWRequestContextUser aContext, MFWNodeObject projNode, MFWMetadataSource aMetadataSrc, String sCatalogName, String sCubeName) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWNodeObject dsNode = projNode.addExpandableObjectNode(gModelRes.RID_dataSource);
        String sCmDataSrcName = (String)aMetadataSrc.getConnectionItem("cmDataSource");
        String sCmDataSrcUniqueName = this.makeDatasourceNameUnique(aContext, sCmDataSrcName);
        String sUsedName = this.mIDGenerator.generate(dsNode, sCmDataSrcUniqueName != null && sCmDataSrcUniqueName.length() > 0 ? sCmDataSrcUniqueName : sCubeName, true);
        this.mDataSourceId = dsNode.getPropertyValue(gModelRes.RID_ID);
        MFWException.ASSERT((this.mDataSourceId != null ? 1 : 0) != 0, (String)"Failed to generate an ID property");
        dsNode.addProperty(gModelRes.RID_name, sUsedName);
        MFWNodeObject objExtractSize = dsNode.addObjectNode(gModelRes.RID_property);
        objExtractSize.addProperty(gModelRes.RID_name, "extractSize");
        objExtractSize.addProperty(gModelRes.RID_type, "number");
        objExtractSize.addProperty(gModelRes.RID__Value, "10");
        String temp = (String)aMetadataSrc.getConnectionItem("cmDataSource");
        if (temp != null) {
            dsNode.addProperty(gModelRes.RID_cmDataSource, temp);
        } else {
            dsNode.addProperty(gModelRes.RID_cmDataSource, sCubeName);
        }
        if (sCatalogName != null && sCatalogName.length() > 0) {
            if ("$INFOCUBE".equals(sCatalogName)) {
                dsNode.addProperty(gModelRes.RID_catalog, sCubeName.substring(1));
            } else {
                dsNode.addProperty(gModelRes.RID_catalog, sCatalogName);
            }
        }
        dsNode.addProperty(gModelRes.RID_cube, "[" + sCubeName + "]");
        dsNode.addProperty(gModelRes.RID_schema, "SAP_BW");
        dsNode.addProperty(gModelRes.RID_queryType, "multidimensional");
        dsNode.addProperty(gModelRes.RID_interface, aMetadataSrc.getType());
        dsNode.addProperty(gModelRes.RID_functionSetID, "V_SAPBW");
        String tempValue = (String)aMetadataSrc.getConnectionItem("attribute");
        if ("dimension".equals(tempValue)) {
            dsNode.addProperty(gModelRes.getResourceID("attributeDimensionsAsProperties"), "false");
        }
        return dsNode;
    }

    void populateCubeProps(MFWNodeObject dataSourceNode, MFWMetadataSource aMetadataSrc, MFWMetadataXQEResponseEntity cubeEntity) {
        boolean isUnix;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWException.ASSERT((cubeEntity != null ? 1 : 0) != 0, (String)"Expecting at least one entry in response to Cube properties query");
        String sTemp = null;
        sTemp = cubeEntity.getPropertyValue(13);
        if (sTemp != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(gModelRes.RID_cubeDescription, sTemp);
        }
        if ((sTemp = !(isUnix = "/".equals(System.getProperty("file.separator"))) ? (String)aMetadataSrc.getConnectionItem("winDataSource") : (String)aMetadataSrc.getConnectionItem("unixDataSource")) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(gModelRes.RID_cubePath, sTemp);
        }
        if ((sTemp = cubeEntity.getPropertyValue(6)) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(gModelRes.RID_cubeCreatedOn, sTemp);
        }
        if ((sTemp = cubeEntity.getPropertyValue(26)) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(gModelRes.RID_cubeDataUpdatedOn, sTemp);
        }
        if ((sTemp = cubeEntity.getPropertyValue(27)) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(gModelRes.RID_cubeSchemaUpdatedOn, sTemp);
        }
        if ((sTemp = cubeEntity.getPropertyValue(24)) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(gModelRes.RID_cubeIsOptimized, sTemp);
        }
        if ((sTemp = cubeEntity.getPropertyValue(8)) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(gModelRes.RID_cubeCurrentPeriod, sTemp);
        }
    }

    void populateVariables(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, MFWMetadataXQEResponse response) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWMetadataXQEResponseEntity anEntity = response.getFirstEntity();
        MFWNodeObject objVariablesSAPBW = null;
        if (anEntity != null) {
            objVariablesSAPBW = this.addCustomProperty(objNode, gModelRes, "SAP BW Variables", "composite", null);
        }
        while (anEntity != null) {
            boolean bDateVariable;
            String sCaption = anEntity.getPropertyValue(5);
            String sVariableUniqueName = anEntity.getPropertyValue(61);
            String sVariableName = this.CleanupName(sVariableUniqueName);
            if (sCaption != null && sCaption.length() != 0 && !sCaption.equals(sVariableName)) {
                sVariableName = sVariableName + "(" + sCaption + ")";
            }
            MFWNodeObject objVariable = this.addCustomProperty(objVariablesSAPBW, gModelRes, sVariableName, "composite", null);
            this.addCustomProperty(objVariable, gModelRes, "name", "readOnly", sVariableUniqueName);
            MFWNodeObject objCaption = this.addCustomProperty(objVariable, gModelRes, "caption", "composite", null);
            this.addLocalizedCaptionsForVariables(anEntity, objCaption, gModelRes);
            String sDimension = anEntity.getPropertyValue(62);
            this.addCustomProperty(objVariable, gModelRes, gModelRes.getResource(gModelRes.RID_dimension), "hidden", sDimension);
            String sHierarchy = anEntity.getPropertyValue(63);
            this.addCustomProperty(objVariable, gModelRes, gModelRes.getResource(gModelRes.RID_hierarchy), "hidden", sHierarchy);
            String sTemp = anEntity.getPropertyValue(64);
            this.addCustomProperty(objVariable, gModelRes, "selectionType", "readOnly", sTemp);
            sTemp = anEntity.getPropertyValue(65);
            this.addCustomProperty(objVariable, gModelRes, "entryType", "readOnly", sTemp);
            String sType = anEntity.getPropertyValue(48);
            boolean bl = bDateVariable = (SAPBW_CalDay1.equals(sDimension) || SAPBW_CalDay2.equals(sDimension)) && !"NUMERIC".equals(sType) && !"HIERARCHY".equals(sType) && sHierarchy.equals(sDimension);
            if (bDateVariable) {
                this.addCustomProperty(objVariable, gModelRes, gModelRes.getResource(gModelRes.RID_datatype), "hidden", "xsdDate");
            } else {
                sTemp = anEntity.getPropertyValue(9);
                if ("character".equals(sTemp)) {
                    this.addCustomProperty(objVariable, gModelRes, gModelRes.getResource(gModelRes.RID_datatype), "hidden", "xsdString");
                } else if ("float64".equals(sTemp)) {
                    this.addCustomProperty(objVariable, gModelRes, gModelRes.getResource(gModelRes.RID_datatype), "hidden", "xsdFloat");
                } else if ("int64".equals(sTemp)) {
                    this.addCustomProperty(objVariable, gModelRes, gModelRes.getResource(gModelRes.RID_datatype), "hidden", "xsdInt");
                } else if ("int32".equals(sTemp)) {
                    this.addCustomProperty(objVariable, gModelRes, gModelRes.getResource(gModelRes.RID_datatype), "hidden", "xsdLong");
                } else if ("dateTime".equals(sTemp)) {
                    this.addCustomProperty(objVariable, gModelRes, gModelRes.getResource(gModelRes.RID_datatype), "hidden", "xsdDatetime");
                } else if ("date".equals(sTemp)) {
                    this.addCustomProperty(objVariable, gModelRes, gModelRes.getResource(gModelRes.RID_datatype), "hidden", "xsdDate");
                    bDateVariable = true;
                } else if ("memberUniqueName".equals(sTemp)) {
                    this.addCustomProperty(objVariable, gModelRes, gModelRes.getResource(gModelRes.RID_datatype), "hidden", "memberUniqueName");
                } else {
                    this.addCustomProperty(objVariable, gModelRes, gModelRes.getResource(gModelRes.RID_datatype), "hidden", "unsupported");
                }
            }
            String sDefLow = anEntity.getPropertyValue(66);
            String sDefHigh = anEntity.getPropertyValue(67);
            if (bDateVariable) {
                String sLowHigh = this.CleanupName(sDefLow);
                if (sLowHigh.length() != 0) {
                    sDefLow = sLowHigh.substring(0, 4) + "-" + sLowHigh.substring(4, 6) + "-" + sLowHigh.substring(6, 8);
                }
                if ((sLowHigh = this.CleanupName(sDefHigh)).length() != 0) {
                    sDefLow = sLowHigh.substring(0, 4) + "-" + sLowHigh.substring(4, 6) + "-" + sLowHigh.substring(6, 8);
                }
            }
            this.addCustomProperty(objVariable, gModelRes, "defaultLow", "string", sDefLow);
            this.addCustomProperty(objVariable, gModelRes, "defaultHigh", "string", sDefHigh);
            sTemp = anEntity.getPropertyValue(13);
            this.addCustomProperty(objVariable, gModelRes, "description", "string", sTemp);
            boolean bNumPickListValuesIsSet = false;
            if ("NUMERIC".equals(sType)) {
                this.addCustomProperty(objVariable, gModelRes, "type", "readOnly", "numeric");
                this.addCustomProperty(objVariable, gModelRes, "promptType", "readOnly", "typeIn");
                this.addCustomProperty(objVariable, gModelRes, "fixedValue", "string", "false");
            } else if ("HIERARCHY".equals(sType)) {
                this.addCustomProperty(objVariable, gModelRes, "type", "readOnly", "hierarchy");
                this.addCustomProperty(objVariable, gModelRes, "promptType", "readOnly", "notApplicable");
            } else {
                boolean bIsLowCardinality = this.isLowCardinality(aContext, querySpec, gModelRes, sDimension);
                if (sHierarchy.equals(sDimension)) {
                    this.addCustomProperty(objVariable, gModelRes, "type", "readOnly", "characteristic");
                    if (bDateVariable) {
                        this.addCustomProperty(objVariable, gModelRes, "promptType", "readOnly", "calendar");
                    } else if (bIsLowCardinality) {
                        this.addCustomProperty(objVariable, gModelRes, "promptType", "string", "pickList");
                    } else {
                        this.addCustomProperty(objVariable, gModelRes, "promptType", "string", "typeIn");
                    }
                } else {
                    this.addCustomProperty(objVariable, gModelRes, "type", "readOnly", "hierarchicalNode");
                    if (bIsLowCardinality) {
                        this.addCustomProperty(objVariable, gModelRes, "promptType", "string", "pickList");
                    } else {
                        this.addCustomProperty(objVariable, gModelRes, "promptType", "string", "typeIn");
                    }
                    this.addCustomProperty(objVariable, gModelRes, "trimLevels", "string", "0");
                    this.addCustomProperty(objVariable, gModelRes, "numPickListValues", "number", "0");
                    bNumPickListValuesIsSet = true;
                }
                this.addCustomProperty(objVariable, gModelRes, "showKeyAndCaption", "boolean", "false");
                this.addCustomProperty(objVariable, gModelRes, "fixedValue", "string", "false");
            }
            if (!bNumPickListValuesIsSet) {
                this.addCustomProperty(objVariable, gModelRes, "numPickListValues", "number", "0");
            }
            this.addCustomProperty(objVariable, gModelRes, "isKeyDate", "boolean", "false");
            anEntity = response.getNextEntity();
        }
    }

    void addLocalizedCaptionsForVariables(MFWMetadataXQEResponseEntity anEntity, MFWNodeObject objCaption, MFWModelRes gModelRes) {
        ArrayList vLocales = this.mHlprLocale.getAllLocales();
        for (int idx = 0; idx < vLocales.size(); ++idx) {
            String sCaption = anEntity.getPropertyValue(5, vLocales.get(idx).toString());
            this.addCustomProperty(objCaption, gModelRes, vLocales.get(idx).toString(), "string", sCaption);
        }
    }

    boolean isLowCardinality(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWModelRes gModelRes, String sDimension) {
        boolean bIsLowCardinality = false;
        ArrayList childDims = new ArrayList();
        this.mSapBWConnection.expand(aContext, querySpec, gModelRes.RID_dimension, this.mSapBWConnection.getRootNamespace());
        this.mSapBWConnection.getRootNamespace().findObjectNodesRecursively(gModelRes.RID_dimension, gModelRes.RID_folder, gModelRes.RID_externalName, sDimension, true, childDims);
        if (childDims.size() == 1) {
            List vPropNodes = ((MFWNodeObject)childDims.get(0)).getObjectNodes(gModelRes.RID_property);
            for (int idx = 0; idx < vPropNodes.size(); ++idx) {
                MFWNodeObject propNodeObj = (MFWNodeObject)vPropNodes.get(idx);
                String propName = propNodeObj.getPropertyValue(gModelRes.RID_name);
                if (!gModelRes.getResource(gModelRes.RID_cardinality).equals(propName)) continue;
                bIsLowCardinality = new Integer(propNodeObj.getPropertyValue(gModelRes.RID__Value)) < 1000;
                break;
            }
        }
        return bIsLowCardinality;
    }

    private String genObjectProperties(MFWMetadataXQEResponseEntity anEntity, MFWNodeObject objNode, int propID) {
        String idNode;
        String sIsHidden;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String sCaption = anEntity.getPropertyValue(propID);
        String sDescription = anEntity.getPropertyValue(13);
        String sUsedName = this.mIDGenerator.generate(objNode, sCaption, true);
        this.mHlprLocale.addLocalizedProperties(objNode, gModelRes.RID_name, sUsedName, anEntity, 5);
        if (sDescription != null && sDescription.length() > 0) {
            this.mHlprLocale.addLocalizedProperties(objNode, gModelRes.RID_description, sDescription, anEntity, 13);
        }
        if ((sIsHidden = anEntity.getPropertyValue(23)) != null && "true".equals(sIsHidden)) {
            objNode.addProperty(gModelRes.RID_visible, "hiddenAndAccessible");
        }
        MFWException.ASSERT(((idNode = objNode.getPropertyValue(gModelRes.RID_ID)) != null ? 1 : 0) != 0, (String)"Expecting a valid ID property");
        return idNode;
    }

    private String genObjectProperties(String sCaption, String sDescription, String sScreenTip, MFWNodeObject objNode) {
        String idNode;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String sUsedName = this.mIDGenerator.generate(objNode, sCaption, true);
        this.mHlprLocale.addLocalizedProperties(objNode, gModelRes.RID_name, sUsedName, null, -1);
        if (sDescription != null && sDescription.length() > 0) {
            this.mHlprLocale.addLocalizedProperties(objNode, gModelRes.RID_description, sDescription, null, -1);
        }
        if (sScreenTip != null && sScreenTip.length() > 0) {
            this.mHlprLocale.addLocalizedProperties(objNode, gModelRes.RID_screenTip, sScreenTip, null, -1);
        }
        MFWException.ASSERT(((idNode = objNode.getPropertyValue(gModelRes.RID_ID)) != null ? 1 : 0) != 0, (String)"Expecting a valid ID property");
        return idNode;
    }

    private void populateDimensions(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, MFWMetadataXQEResponse response) {
        ArrayList<MFWNodeObject> vMsrDims = new ArrayList<MFWNodeObject>();
        ArrayList<MFWNodeObject> vRegDims = new ArrayList<MFWNodeObject>();
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String sObjLayout = this.mSapBWConnection.getSource().getScope("objectLayout").toString();
        ArrayList vDuplicateNames = new ArrayList();
        if ("sapBW".equals(sObjLayout)) {
            this.collectConflictingFolderNames(response, vDuplicateNames);
        }
        HashMap mapDim2Folders = new HashMap();
        MFWMetadataXQEResponseEntity anEntity = response.getFirstEntity();
        while (anEntity != null) {
            String sDimGroupName = null;
            String sDimGroupDesc = null;
            String sCubeName = null;
            if ("sapBW".equals(sObjLayout)) {
                sDimGroupName = anEntity.getPropertyValue(14);
                sCubeName = anEntity.getPropertyValue(7);
                sDimGroupDesc = anEntity.getPropertyValue(15);
            }
            MFWNodeObject dimObj = null;
            dimObj = sDimGroupName != null && sDimGroupName.length() > 0 ? this.addDimensionToFolder(objNode, sDimGroupDesc, sCubeName, sDimGroupName, vDuplicateNames, mapDim2Folders) : objNode.addExpandableObjectNode(gModelRes.RID_dimension);
            String sCaption = anEntity.getPropertyValue(5);
            String sDescription = anEntity.getPropertyValue(13);
            String sTechnicalName = anEntity.getPropertyValue(16);
            StringBuffer sOutName = new StringBuffer();
            StringBuffer sOutDescription = new StringBuffer();
            StringBuffer sOutScreenTip = new StringBuffer();
            this.generateSAPBWNames(sCaption, sDescription, sTechnicalName, sOutName, sOutDescription, sOutScreenTip);
            String sType = anEntity.getPropertyValue(48);
            if ("Measure".equalsIgnoreCase(sType)) {
                MFWMessage keyFigures = new MFWMessage("mfwa4j", "RPT_OLP_OLAP_FACT", null);
                this.genObjectProperties(keyFigures.render(aContext.getContentLocale()), sOutDescription.toString(), sOutScreenTip.toString(), dimObj);
                MFWNodeObject objDualStructuresProp = dimObj.addObjectNode(gModelRes.RID_property);
                objDualStructuresProp.addProperty(gModelRes.RID_name, "dualStructures");
                objDualStructuresProp.addProperty(gModelRes.RID_type, "hidden");
                objDualStructuresProp.addProperty(gModelRes.RID__Value, this.mSapBWConnection.getSource().getScope("dualStructures").toString());
            } else {
                this.generateLocalizedObjectProperties(anEntity, dimObj, sTechnicalName, null, null, false, false);
            }
            String sTemp = anEntity.getPropertyValue(54);
            this.addCustomProperty(dimObj, gModelRes, gModelRes.getResource(gModelRes.RID_cardinality), "hidden", sTemp);
            sTemp = anEntity.getPropertyValue(38);
            dimObj.addProperty(gModelRes.RID_PPDS_CODE, sTemp);
            dimObj.addProperty(gModelRes.RID_definitionType, "mdQuery");
            dimObj.addProperty(gModelRes.RID_dataSourceRef, this.mDataSourceId);
            dimObj.addProperty(gModelRes.RID_externalName, sTechnicalName);
            String sIsStructure = anEntity.getPropertyValue(53);
            if (sIsStructure.equalsIgnoreCase("true")) {
                sType = "regular";
            }
            dimObj.addProperty(gModelRes.RID_type, sType);
            if ("SAPTime".equals(sType)) {
                this.vSAPTimeDimensions.add(sTechnicalName);
            }
            this.determineMembersRollup(dimObj, sType);
            if ("Measure".equalsIgnoreCase(sType)) {
                vMsrDims.add(dimObj);
            } else {
                vRegDims.add(dimObj);
                sTemp = anEntity.getPropertyValue(10);
                dimObj.addProperty(gModelRes.RID_defaultHierarchy, sTemp);
                this.mSapBWConnection.expand(aContext, querySpec, gModelRes.RID_hierarchy, dimObj);
                ArrayList childObjects = new ArrayList();
                dimObj.findObjectNodesRecursively(gModelRes.RID_hierarchy, gModelRes.RID_hierarchyFolder, gModelRes.RID_externalName, sTemp, true, childObjects);
                MFWException.ASSERT((childObjects.size() == 1 ? 1 : 0) != 0, (String)"Expecting one hierarchy object for dimension's specified default hierarchy:", (String)sTemp);
                String propId = ((MFWNodeObject)childObjects.get(0)).getPropertyValue(gModelRes.RID_ID);
                MFWException.ASSERT((propId != null ? 1 : 0) != 0, (String)"Expecting an ID property for the default hierarchy");
                dimObj.addProperty(gModelRes.RID_defaultHierarchy, propId);
            }
            anEntity = response.getNextEntity();
        }
        this.populateScopeRelations(objNode, vMsrDims, vRegDims);
    }

    private MFWNodeObject addDimensionToFolder(MFWNodeObject parentObj, String sDimGroupName, String sCubeName, String sDimGroupUniqueName, ArrayList vConflictingNames, HashMap mapDimGroups) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        StringBuffer sModifiedName = new StringBuffer("");
        if (vConflictingNames.contains(sDimGroupName)) {
            sModifiedName.append("*");
        }
        sModifiedName.append(sDimGroupName);
        String nameModified = sModifiedName.toString();
        MFWNodeObject objDimFolder = (MFWNodeObject)mapDimGroups.get(nameModified);
        if (objDimFolder == null) {
            objDimFolder = parentObj.addObjectNode(gModelRes.RID_folder);
            StringBuffer sOutName = new StringBuffer();
            StringBuffer sOutDescription = new StringBuffer();
            StringBuffer sOutScreenTip = new StringBuffer();
            this.generateSAPBWNames(nameModified, nameModified, sDimGroupUniqueName, sOutName, sOutDescription, sOutScreenTip);
            this.genObjectProperties(sOutName.toString(), sOutDescription.toString(), sOutScreenTip.toString(), objDimFolder);
            MFWNodeObject objUniqueNameProp = objDimFolder.addObjectNode(gModelRes.RID_property);
            objUniqueNameProp.addProperty(gModelRes.RID_name, "uniqueName");
            objUniqueNameProp.addProperty(gModelRes.RID_type, "hidden");
            objUniqueNameProp.addProperty(gModelRes.RID__Value, sCubeName + "_" + sDimGroupUniqueName);
            MFWNodeObject objDimGroupProp = objDimFolder.addObjectNode(gModelRes.RID_property);
            objDimGroupProp.addProperty(gModelRes.RID_name, "type");
            objDimGroupProp.addProperty(gModelRes.RID_type, "hidden");
            objDimGroupProp.addProperty(gModelRes.RID__Value, "dimensionGroup");
            mapDimGroups.put(nameModified, objDimFolder);
        }
        MFWNodeObject dimObj = objDimFolder.addExpandableObjectNode(gModelRes.RID_dimension);
        return dimObj;
    }

    private void generateSAPBWNames(String sCaption, String sDescription, String sUniqueName, StringBuffer sOutName, StringBuffer sOutDescription, StringBuffer sOutScreenTip) {
        String sNameType = this.mSapBWConnection.getSource().getScope("nameTypes").toString();
        if (sNameType.equalsIgnoreCase("technical")) {
            sOutName.append(this.CleanupName(sUniqueName));
            sOutScreenTip.append(sCaption);
            sOutDescription.append(sDescription.length() == 0 ? sCaption : sDescription);
        } else if (sNameType.equalsIgnoreCase("long")) {
            sOutScreenTip.append(this.CleanupName(sUniqueName));
            sOutName.append(sDescription.length() == 0 ? sCaption : sDescription);
            sOutDescription.append(sDescription.length() == 0 ? sOutName : sDescription);
        } else {
            sOutScreenTip.append(this.CleanupName(sUniqueName));
            sOutName.append(sCaption.length() == 0 ? sDescription : sCaption);
            sOutDescription.append(sDescription.length() == 0 ? sOutName : sDescription);
        }
    }

    private String CleanupName(String sOutName) {
        int nStrLength;
        if (sOutName == null || sOutName.length() == 0) {
            return sOutName;
        }
        String sTemp = sOutName;
        if (sOutName.charAt(0) == '$' || sOutName.charAt(0) == '[') {
            sTemp = sOutName.substring(1);
        }
        int nIdx = 0;
        nIdx = sOutName.lastIndexOf("].[");
        if (nIdx > 0) {
            sTemp = sOutName.substring(nIdx + 3);
            if ("]".equals(sTemp)) {
                sTemp = sOutName.substring(0, nIdx + 1);
                nIdx = sOutName.lastIndexOf("].[");
                if (nIdx > 0) {
                    sTemp = sOutName.substring(nIdx + 3);
                }
            }
        } else {
            nIdx = sOutName.lastIndexOf("]..[");
            if (nIdx > 0) {
                sTemp = sOutName.substring(nIdx + 4);
            }
        }
        sOutName = (nStrLength = sTemp.length()) > 1 && "]".equals(sTemp.substring(nStrLength - 1)) ? sTemp.substring(0, nStrLength - 1) : sTemp;
        return sOutName;
    }

    private void determineMembersRollup(MFWNodeObject objDim, String sDimType) {
        boolean bMembersRolledUp = true;
        if ("Account".equals(sDimType) || "Scenario".equals(sDimType) || "Time".equals(sDimType) && "PC".equals(this.mSapBWConnection.getSource().getType())) {
            bMembersRolledUp = false;
        }
        objDim.addProperty(MFWModelRes.getInstance().RID_membersRollup, bMembersRolledUp ? "true" : "false");
    }

    private void populateHierarchies(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, MFWMetadataXQEResponse response) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWMetadataXQEResponseEntity anEntity = response.getFirstEntity();
        while (anEntity != null) {
            String sValidTo;
            MFWNodeObject hierObj = objNode.addExpandableObjectNode(gModelRes.RID_hierarchy);
            String sTemp = null;
            String sValidFrom = anEntity.getPropertyValue(55);
            if (SAPBW_kDateMinDefault.equals(sValidFrom)) {
                sValidFrom = "";
            }
            if (SAPBW_kDateMaxDefault.equals(sValidTo = anEntity.getPropertyValue(56))) {
                sValidTo = "";
            }
            String sTechnicalName = anEntity.getPropertyValue(22);
            String sPostCaption = null;
            if (sValidFrom.length() != 0 || sValidTo.length() != 0) {
                String sFrom = sValidFrom.length() == 0 ? "..." : sValidFrom.substring(0, 10);
                String sTo = sValidTo.length() == 0 ? "..." : sValidTo.substring(0, 10);
                sPostCaption = "(" + sFrom + "-" + sTo + ")";
            }
            this.generateLocalizedObjectProperties(anEntity, hierObj, sTechnicalName, null, sPostCaption, false, false);
            if (sValidFrom != null && sValidFrom.length() > 0) {
                this.addCustomProperty(hierObj, gModelRes, "Valid_From", "dateTime", sValidFrom);
            }
            if (sValidTo != null && sValidTo.length() > 0) {
                this.addCustomProperty(hierObj, gModelRes, "Valid_To", "dateTime", sValidTo);
            }
            boolean bIsSingleRoot = false;
            MFWMetadataXQEResponse hlprRootMember = null;
            MFWMetadataXQEResponseEntity singleRootMemEntity = null;
            String sHierarchyType = "";
            String sDimensionString = "";
            String sDefaultHierarchyUniqueName = objNode.getPropertyValue(gModelRes.RID_defaultHierarchy);
            String sHierarchyUniqueName = anEntity.getPropertyValue(22);
            hierObj.addProperty(gModelRes.RID_externalName, sHierarchyUniqueName);
            if (sDefaultHierarchyUniqueName.equals(sHierarchyUniqueName)) {
                hlprRootMember = this.mSapBWConnection.queryObjectRootMember(aContext, hierObj, 2);
                singleRootMemEntity = hlprRootMember.getFirstEntity();
                bIsSingleRoot = singleRootMemEntity != null && hlprRootMember.getNextEntity() == null;
                sHierarchyType = "default";
            } else {
                hlprRootMember = this.mSapBWConnection.queryObjectRootMember(aContext, hierObj, 2);
                MFWMetadataXQEResponseEntity memEntity = hlprRootMember.getFirstEntity();
                boolean bRegularMember = false;
                StringBuffer sLeftPart = new StringBuffer();
                StringBuffer sRightPart = new StringBuffer();
                int nMemberCount = 0;
                while (!bRegularMember && memEntity != null) {
                    this.splitMUN(memEntity.getPropertyValue(35), sLeftPart, sRightPart);
                    boolean bl = bRegularMember = !SAPBW_RestOfHierarchy.equals(sRightPart.toString());
                    if (nMemberCount == 0) {
                        bIsSingleRoot = true;
                        singleRootMemEntity = memEntity;
                    }
                    memEntity = hlprRootMember.getNextEntity();
                    ++nMemberCount;
                }
                String sRightPartStr = sRightPart.toString();
                if (sRightPartStr.length() > 34) {
                    sDimensionString = sRightPart.toString().substring(33, sRightPartStr.length() - 1);
                }
                String sDimensionUN = objNode.getPropertyValue(gModelRes.RID_externalName);
                sHierarchyType = "time".equals(objNode.getPropertyValue(gModelRes.RID_type)) ? "time" : (sDimensionUN.equals(sDimensionString) ? "recursive" : (SAPBW_0HierNode.equals(sDimensionString) ? "text" : "characteristic"));
            }
            this.addCustomProperty(hierObj, gModelRes, "dimensionString", "hidden", sDimensionString);
            this.addCustomProperty(hierObj, gModelRes, "hierarchyType", "hidden", sHierarchyType);
            sTemp = anEntity.getPropertyValue(38);
            hierObj.addProperty(gModelRes.RID_PPDS_CODE, sTemp);
            hierObj.addProperty(gModelRes.RID_multiRoot, bIsSingleRoot ? "false" : "true");
            sTemp = anEntity.getPropertyValue(3);
            hierObj.addProperty(gModelRes.RID_balanced, sTemp);
            sTemp = anEntity.getPropertyValue(40);
            hierObj.addProperty(gModelRes.RID_ragged, sTemp);
            if (bIsSingleRoot && singleRootMemEntity != null) {
                sTemp = singleRootMemEntity.getPropertyValue(35);
                hierObj.addProperty(gModelRes.RID_rootMember, sTemp);
                if (sTemp.length() != 0) {
                    hierObj.addProperty(gModelRes.RID_rootMUN, this.providerMUNToCognosMUN(sTemp));
                }
                if ((sTemp = singleRootMemEntity.getPropertyValue(5)).length() != 0) {
                    this.mHlprLocale.addLocalizedProperties(hierObj, gModelRes.RID_rootCaption, sTemp, singleRootMemEntity, 5);
                }
            }
            hierObj.addProperty(gModelRes.RID_sortedHierarchy, "none");
            sTemp = anEntity.getPropertyValue(54);
            hierObj.addProperty(gModelRes.RID_cardinality, sTemp);
            sTemp = anEntity.getPropertyValue(37);
            hierObj.addProperty(gModelRes.RID_parentChild, sTemp);
            this.mSapBWConnection.expand(aContext, querySpec, gModelRes.RID_level, hierObj);
            hierObj.addProperty(gModelRes.RID_externalNumberOfLevels, new Integer(this.mExternalNrOfLevels).toString());
            anEntity = response.getNextEntity();
        }
    }

    private String providerMUNToCognosMUN(String sProviderMun) {
        return ":[BW]." + sProviderMun;
    }

    private void populateLevels(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, MFWMetadataXQEResponse response) {
        this.mExternalNrOfLevels = 0;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWMetadataXQEResponseEntity anEntity = response.getFirstEntity();
        boolean bIsForDefaultHierarchy = false;
        if (anEntity != null) {
            String sDefaultHierarchyUniqueName = objNode.getParentObject().getPropertyValue(gModelRes.RID_defaultHierarchy);
            String sHierarchyUniqueName = anEntity.getPropertyValue(22);
            if (sHierarchyUniqueName.equals(sDefaultHierarchyUniqueName)) {
                bIsForDefaultHierarchy = true;
            }
        }
        while (anEntity != null) {
            ++this.mExternalNrOfLevels;
            MFWNodeObject objLevel = objNode.addExpandableObjectNode(gModelRes.RID_level);
            String sTechnicalName = anEntity.getPropertyValue(29);
            this.generateLocalizedObjectProperties(anEntity, objLevel, sTechnicalName, null, null, bIsForDefaultHierarchy, false);
            objLevel.addProperty(gModelRes.RID_externalName, sTechnicalName);
            Integer nDateFormatLength = 0;
            String sDimensionType = objNode.getParentObject().getPropertyValue(gModelRes.RID_type);
            StringBuffer sLeftPart = new StringBuffer();
            StringBuffer sRightPart = new StringBuffer();
            if ("time".equals(sDimensionType)) {
                this.getSplitMUN(aContext, objLevel, sLeftPart, sRightPart);
                nDateFormatLength = sRightPart.length() > 34 ? Integer.valueOf(sRightPart.indexOf(" ") - 1) : Integer.valueOf(sRightPart.length() - 2);
            }
            this.addCustomProperty(objLevel, gModelRes, "dateFormatLength", "number", nDateFormatLength.toString());
            String sDimensionString = "";
            if (!bIsForDefaultHierarchy) {
                if (this.mExternalNrOfLevels == 1) {
                    List vPropNodes = objNode.getObjectNodes(gModelRes.RID_property);
                    for (int idx = 0; idx < vPropNodes.size(); ++idx) {
                        MFWNodeObject propNodeObj = (MFWNodeObject)vPropNodes.get(idx);
                        String propName = propNodeObj.getPropertyValue(gModelRes.RID_name);
                        if (!"dimensionString".equals(propName)) continue;
                        sDimensionString = propNodeObj.getPropertyValue(gModelRes.RID__Value);
                        objNode.removeChildNode((MFWNode)propNodeObj);
                        break;
                    }
                } else {
                    if (!"time".equals(sDimensionType)) {
                        this.getSplitMUN(aContext, objLevel, sLeftPart, sRightPart);
                    }
                    if (sRightPart.length() > 34) {
                        sDimensionString = sRightPart.substring(33, sRightPart.length() - 1);
                    }
                }
            }
            this.addCustomProperty(objLevel, gModelRes, "dimensionString", "hidden", sDimensionString);
            String sLevelCardinality = anEntity.getPropertyValue(54);
            this.addCustomProperty(objLevel, gModelRes, "levelCardinality", "hidden", sLevelCardinality);
            String sTemp = anEntity.getPropertyValue(38);
            objLevel.addProperty(gModelRes.RID_PPDS_CODE, sTemp);
            sTemp = anEntity.getPropertyValue(25);
            objLevel.addProperty(gModelRes.RID_isUnique, sTemp);
            sTemp = anEntity.getPropertyValue(28);
            objLevel.addProperty(gModelRes.RID_externalOrdinal, sTemp);
            anEntity = response.getNextEntity();
        }
    }

    private String rectifyLevelName(String sUniqueName, String sCaption) {
        int nIdx = sUniqueName.lastIndexOf("].[");
        String sLeftPart = sUniqueName.substring(0, nIdx + 1);
        String sRightPart = sUniqueName.substring(nIdx + 2);
        if (SAPBW_Level00.equals(sRightPart) && sCaption.indexOf("Level 00") > 0) {
            return sCaption.substring(0, sCaption.indexOf("Level 00")) + "(All)";
        }
        if ((SAPBW_Level01.equals(sRightPart) || SAPBW_Currency.equals(sLeftPart) || SAPBW_UnitOfMeasure.equals(sLeftPart)) && sCaption.indexOf("Level 01") > 0) {
            return sCaption.substring(0, sCaption.indexOf("Level 01") - 1);
        }
        return sCaption;
    }

    private MFWNodeObject addCustomProperty(MFWNodeObject objParentNode, MFWModelRes gModelRes, String sName, String sType, String sValue) {
        MFWNodeObject pCustProp = objParentNode.addObjectNode(gModelRes.RID_property);
        if (sName != null) {
            pCustProp.addProperty(gModelRes.RID_name, sName);
        }
        if (sType != null) {
            pCustProp.addProperty(gModelRes.RID_type, sType);
        }
        if (sValue != null) {
            pCustProp.addProperty(gModelRes.RID__Value, sValue);
        }
        return pCustProp;
    }

    private void getSplitMUN(MFWRequestContextUser aContext, MFWNodeObject objLevel, StringBuffer sLeftPart, StringBuffer sRightPart) {
        MFWMetadataXQEResponseEntity firstMember = this.mSapBWConnection.queryObjectRootMember(aContext, objLevel, 2).getFirstEntity();
        if (firstMember != null) {
            this.splitMUN(firstMember.getPropertyValue(35), sLeftPart, sRightPart);
        }
    }

    void splitMUN(String sMUN, StringBuffer sLeftPart, StringBuffer sRightPart) {
        int nIdx = sMUN.indexOf(".");
        sLeftPart.delete(0, sLeftPart.length());
        sRightPart.delete(0, sRightPart.length());
        sLeftPart.append(sMUN.substring(0, nIdx));
        sRightPart.append(sMUN.substring(nIdx + 1, sMUN.length()));
    }

    private void populateAttributes(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, MFWMetadataXQEResponse response) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String visibleProp = objNode.getPropertyValue(gModelRes.RID_visible);
        if (visibleProp != null && "hiddenAndAccessible".equals(visibleProp)) {
            return;
        }
        Object objQIKey = null;
        String sPromptFilterName = null;
        ESignatureType eMaxSigniture = ESignatureType.eSignatureUnknown;
        MFWMetadataXQEResponseEntity anEntity = response.getFirstEntity();
        boolean bIsSAPTime = false;
        int nLevelCardinality = 0;
        boolean bIsLastLevel = false;
        if (anEntity != null) {
            bIsSAPTime = this.isDimensionTypeSAPTime(anEntity, gModelRes);
            nLevelCardinality = this.getLevelCardinality(objNode, gModelRes);
            Integer nLevelNr = new Integer(objNode.getPropertyValue(gModelRes.RID_externalOrdinal));
            String propNrOfLevels = objNode.getParentObject().getPropertyValue(gModelRes.RID_externalNumberOfLevels);
            Integer nTotalNrOfLevels = new Integer(propNrOfLevels);
            if (nLevelNr + 1 == nTotalNrOfLevels) {
                bIsLastLevel = true;
            }
        }
        MFWNodeObject pBusinessKeyObj = objNode.addObjectNode(gModelRes.RID_queryItem);
        this.populatePreDefinedAttributes(objNode);
        while (anEntity != null) {
            int nIdx;
            MFWNodeObject pQIObj = objNode.addObjectNode(gModelRes.RID_queryItem);
            MFWNodeObject objName = objNode.getObjectNode(gModelRes.RID_name);
            String sLevelName = objName.getPropertyValue(gModelRes.RID__Value);
            String sTemp = sLevelName + " - ";
            String sTechnicalName = anEntity.getPropertyValue(2);
            this.generateLocalizedObjectProperties(anEntity, pQIObj, sTechnicalName, sTemp, null, false, false);
            pQIObj.addProperty(gModelRes.RID_externalName, sTechnicalName);
            pQIObj.addProperty(gModelRes.RID_usage, "attribute");
            sTemp = anEntity.getPropertyValue(9);
            pQIObj.addProperty(gModelRes.RID_datatype, sTemp);
            String sKeyID = objNode.getPropertyValue(gModelRes.RID_ID) + ".[" + sLevelName + "]";
            pQIObj.addProperty(gModelRes.RID_promptType, this.getPromptType(objNode, gModelRes, nLevelCardinality, bIsLastLevel, sTemp));
            int n = nIdx = sTechnicalName.lastIndexOf("].[") == -1 ? -1 : sTechnicalName.lastIndexOf("].[") + 3;
            if (nIdx != -1 && (sTechnicalName.charAt(nIdx) == '1' || sTechnicalName.charAt(nIdx) == '2' || sTechnicalName.charAt(nIdx) == '4' || sTechnicalName.charAt(nIdx) == '5')) {
                pQIObj.addProperty(gModelRes.RID_promptFilterItemRef, sKeyID);
                if (this.getCurrentSignature(sTechnicalName.charAt(nIdx)).compareTo(eMaxSigniture) > 0) {
                    MFWNodeObject attributeName = pQIObj.getObjectNode(gModelRes.RID_name);
                    String sName = attributeName.getPropertyValue(gModelRes.RID__Value);
                    sPromptFilterName = objNode.getPropertyValue(gModelRes.RID_ID) + ".[" + sName.toString() + "]";
                    eMaxSigniture = this.getCurrentSignature(sTechnicalName.charAt(nIdx));
                }
            }
            if ("date".equals(sTemp = objNode.getParentObject().getParentObject().getPropertyValue(gModelRes.RID_type))) {
                pQIObj.addProperty(gModelRes.RID_sortOnRef, sKeyID);
            }
            if ((sTemp = anEntity.getPropertyValue(42)) != null && sTemp.length() > 0 && !"_businessKey".equals(sTemp)) {
                this.mHlprLocale.addLocalizedProperties(pQIObj.addObjectNode(gModelRes.RID_role), gModelRes.RID_name, sTemp, null, -1);
            }
            anEntity = response.getNextEntity();
        }
        MFWNodeObject objLevelProp = objNode.getObjectNode(gModelRes.RID_name);
        String sName = objLevelProp.getPropertyValue(gModelRes.RID__Value);
        objLevelProp = objNode.getObjectNode(gModelRes.RID_description);
        String sDescription = objLevelProp.getPropertyValue(gModelRes.RID__Value);
        objLevelProp = objNode.getObjectNode(gModelRes.RID_screenTip);
        String sScreenTip = objLevelProp.getPropertyValue(gModelRes.RID__Value);
        this.genObjectProperties(sName, sDescription, sScreenTip, pBusinessKeyObj);
        pBusinessKeyObj.addProperty(gModelRes.RID_externalName, SAPBW_MemberUniqueName);
        pBusinessKeyObj.addProperty(gModelRes.RID_usage, "identifier");
        String sTemp = bIsSAPTime && bIsLastLevel ? "date" : "character";
        pBusinessKeyObj.addProperty(gModelRes.RID_datatype, sTemp);
        pBusinessKeyObj.addProperty(gModelRes.RID_promptType, this.getPromptType(objNode, gModelRes, nLevelCardinality, bIsLastLevel, sTemp));
        if (!(sPromptFilterName == null || bIsSAPTime && bIsLastLevel)) {
            pBusinessKeyObj.addProperty(gModelRes.RID_promptDisplayItemRef, sPromptFilterName);
        }
        this.mHlprLocale.addLocalizedProperties(pBusinessKeyObj.addObjectNode(gModelRes.RID_role), gModelRes.RID_name, "_businessKey", null, -1);
    }

    private void populatePreDefinedAttributes(MFWNodeObject objNode) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String visibleProp = objNode.getPropertyValue(gModelRes.RID_visible);
        if (visibleProp != null && "hiddenAndAccessible".equals(visibleProp)) {
            return;
        }
        int nLevelCardinality = this.getLevelCardinality(objNode, gModelRes);
        for (int idx = 0; idx < MFWOLAPSchema.mPredefinedAttributes.length; ++idx) {
            MFWOLAPSchema.PredefinedAttribute predefAttr = MFWOLAPSchema.mPredefinedAttributes[idx];
            MFWNodeObject objAttr = objNode.addObjectNode(gModelRes.RID_queryItem);
            String sCaption = predefAttr.mName;
            StringBuffer sOutName = new StringBuffer();
            StringBuffer sOutDescription = new StringBuffer();
            StringBuffer sOutScreenTip = new StringBuffer();
            this.generateSAPBWNames(sCaption, predefAttr.mDescription, predefAttr.mExternalName, sOutName, sOutDescription, sOutScreenTip);
            this.genObjectProperties(sOutName.toString(), sOutDescription.toString(), sOutScreenTip.toString(), objAttr);
            objAttr.addProperty(gModelRes.RID_externalName, predefAttr.mExternalName);
            objAttr.addProperty(gModelRes.RID_usage, "attribute");
            objAttr.addProperty(gModelRes.RID_datatype, predefAttr.mDatatype);
            objAttr.addProperty(gModelRes.RID_promptType, this.getPromptType(objNode, gModelRes, nLevelCardinality, false, predefAttr.mDatatype));
            if ("_rollupType".equals(sCaption)) {
                objAttr.addProperty(gModelRes.RID_hidden, "true");
            }
            MFWNodeObject objName = objNode.getObjectNode(gModelRes.RID_name);
            String sLevelName = objName.getPropertyValue(gModelRes.RID__Value);
            String sTemp = objNode.getParentObject().getParentObject().getPropertyValue(gModelRes.RID_type);
            if ("date".equals(sTemp)) {
                objAttr.addProperty(gModelRes.RID_sortOnRef, objNode.getPropertyValue(gModelRes.RID_ID) + ".[" + sLevelName + "]");
            }
            MFWNodeObject objRole = objAttr.addObjectNode(gModelRes.RID_role);
            this.mHlprLocale.addLocalizedProperties(objRole, gModelRes.RID_name, predefAttr.mRole, null, -1);
        }
        objNode.setExpandStatus(gModelRes.RID_queryItem, (byte)2);
    }

    private ESignatureType getCurrentSignature(char cIdxNr) {
        switch (cIdxNr) {
            case '1': {
                return ESignatureType.eSignatureName;
            }
            case '2': {
                return ESignatureType.eSignatureKey;
            }
            case '4': {
                return ESignatureType.eSignatureLongName;
            }
            case '5': {
                return ESignatureType.eSignatureMediumName;
            }
        }
        return ESignatureType.eSignatureUnknown;
    }

    private boolean isDimensionTypeSAPTime(MFWMetadataXQEResponseEntity anEntity, MFWModelRes gModelRes) {
        String sDimensionUN = anEntity.getPropertyValue(62);
        for (int idx = 0; idx < this.vSAPTimeDimensions.size(); ++idx) {
            if (!sDimensionUN.equals(this.vSAPTimeDimensions.get(idx).toString())) continue;
            return true;
        }
        return false;
    }

    private int getLevelCardinality(MFWNodeObject objNode, MFWModelRes gModelRes) {
        List vPropNodes = objNode.getObjectNodes(gModelRes.RID_property);
        for (int idx = 0; idx < vPropNodes.size(); ++idx) {
            MFWNodeObject propNodeObj = (MFWNodeObject)vPropNodes.get(idx);
            String propName = propNodeObj.getPropertyValue(gModelRes.RID_name);
            if (!"levelCardinality".equals(propName)) continue;
            return new Integer(propNodeObj.getPropertyValue(gModelRes.RID__Value));
        }
        return 0;
    }

    private String getPromptType(MFWNodeObject objNode, MFWModelRes gModelRes, int nLevelCardinality, boolean bIsLastLevel, String sDataType) {
        if (bIsLastLevel && "date".equals(sDataType)) {
            return "selectDate";
        }
        if (nLevelCardinality > 1000) {
            return "editBox";
        }
        return "selectValue";
    }

    private void populateMeasures(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, MFWMetadataXQEResponse response) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWMetadataXQEResponseEntity anEntity = response.getFirstEntity();
        while (anEntity != null) {
            MFWNodeObject pMsrObj = objNode.addExpandableObjectNode(gModelRes.RID_measure);
            String sTechnicalName = anEntity.getPropertyValue(34);
            this.generateLocalizedObjectProperties(anEntity, pMsrObj, sTechnicalName, null, null, false, true);
            pMsrObj.addProperty(gModelRes.RID_externalName, sTechnicalName);
            pMsrObj.addProperty(gModelRes.RID_usage, "fact");
            pMsrObj.addProperty(gModelRes.RID_format, "");
            String sTemp = anEntity.getPropertyValue(49);
            if ("Currency".equals(sTemp)) {
                pMsrObj.addProperty(gModelRes.RID_currency, "undefined");
            }
            sTemp = anEntity.getPropertyValue(9);
            pMsrObj.addProperty(gModelRes.RID_datatype, sTemp);
            sTemp = anEntity.getPropertyValue(39);
            pMsrObj.addProperty(gModelRes.RID_precision, sTemp == null || sTemp.length() == 0 ? "ZERO" : sTemp);
            sTemp = anEntity.getPropertyValue(43);
            pMsrObj.addProperty(gModelRes.RID_scale, sTemp == null || sTemp.length() == 0 ? "ZERO" : sTemp);
            String sAggrVal = anEntity.getPropertyValue(1);
            String mfwAggrVal = this.mOlapSchema.mapType(sAggrVal, MFWOLAPSchema.mAggregateTypes);
            pMsrObj.addProperty(gModelRes.RID_aggregationRule, mfwAggrVal);
            pMsrObj.addProperty(gModelRes.RID_promptType, "serverDetermined");
            pMsrObj.addProperty(gModelRes.RID_regularAggregate, mfwAggrVal);
            String sSemiAggregate = anEntity.getPropertyValue(47);
            pMsrObj.addProperty(gModelRes.RID_semiAggregate, this.mOlapSchema.mapType(sSemiAggregate, MFWOLAPSchema.mAggregateTypes));
            sTemp = anEntity.getPropertyValue(58);
            if (sTemp != null && sTemp.length() > 0) {
                MFWNodeObject objDimGroupProp = pMsrObj.addObjectNode(gModelRes.RID_aggregationRule);
                objDimGroupProp.addProperty(gModelRes.RID_dimensionRef, sTemp);
                objDimGroupProp.addProperty(gModelRes.RID_applyAggregate, this.mOlapSchema.mapType(sSemiAggregate, MFWOLAPSchema.mAggregateTypes));
            }
            pMsrObj.addProperty(gModelRes.RID_isHierarchical, "true");
            anEntity = response.getNextEntity();
        }
    }

    private void populateScopeRelations(MFWNodeObject objNode, ArrayList vMsrDims, ArrayList vRegDims) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        for (int mIdx = 0; mIdx < vMsrDims.size(); ++mIdx) {
            MFWNodeObject dimMsr = (MFWNodeObject)vMsrDims.get(mIdx);
            MFWNodeObject nameObj1 = dimMsr.getObjectNode(gModelRes.RID_name);
            String propVal1 = nameObj1.getPropertyValue(gModelRes.RID__Value);
            String sMsrDimName = propVal1 == null ? "" : propVal1;
            String propID1 = dimMsr.getPropertyValue(gModelRes.RID_ID);
            String sMsrDimID = propID1 == null ? "" : propID1;
            for (int rIdx = 0; rIdx < vRegDims.size(); ++rIdx) {
                MFWNodeObject dimReg = (MFWNodeObject)vRegDims.get(rIdx);
                if (vMsrDims.contains(dimReg)) continue;
                MFWNodeObject nameObj = dimReg.getObjectNode(gModelRes.RID_name);
                String propVal = nameObj.getPropertyValue(gModelRes.RID__Value);
                String sRegDimName = propVal == null ? "" : propVal;
                String propID = dimReg.getPropertyValue(gModelRes.RID_ID);
                String sRegDimID = propID == null ? "" : propID;
                MFWNodeObject pSRObj = objNode.addObjectNode(gModelRes.RID_scopeRelationship);
                StringBuffer sTemp = new StringBuffer(sMsrDimName);
                sTemp.append(" <--> ");
                sTemp.append(sRegDimName);
                String sUsedName = this.mIDGenerator.generate(pSRObj, sTemp.toString(), true);
                pSRObj.addProperty(gModelRes.RID_name, sUsedName);
                pSRObj.addProperty(gModelRes.RID_leftrefobj, sRegDimID);
                pSRObj.addProperty(gModelRes.RID_leftmincard, "one");
                pSRObj.addProperty(gModelRes.RID_leftmaxcard, "one");
                pSRObj.addProperty(gModelRes.RID_rightrefobj, sMsrDimID);
                pSRObj.addProperty(gModelRes.RID_rightmincard, "many");
                pSRObj.addProperty(gModelRes.RID_rightmaxcard, "many");
            }
        }
    }

    private ArrayList addOrFindFoldersForPath(MFWNodeObject parentObj, String sDisplayPath, ArrayList vObjCaptions, short ridFolder, HashMap mapPath2Objs) {
        ArrayList<MFWNodeObject> outFolderObjs = new ArrayList<MFWNodeObject>();
        ArrayList vPaths = new ArrayList();
        MFWStringHelper.split((String)sDisplayPath, (String)";", vPaths);
        for (int pIdx = 0; pIdx < vPaths.size(); ++pIdx) {
            MFWNodeObject folderParent = parentObj;
            ArrayList vFolders = new ArrayList();
            MFWStringHelper.split((String)((String)vPaths.get(pIdx)), (String)"\\", vFolders);
            StringBuffer sPartialPath = new StringBuffer("");
            MFWNodeObject pInnermostFolder = null;
            for (int fIdx = 0; fIdx < vFolders.size(); ++fIdx) {
                String sFolderName = (String)vFolders.get(fIdx);
                if (sFolderName.length() == 0) continue;
                sPartialPath.append("\\");
                sPartialPath.append(sFolderName);
                pInnermostFolder = (MFWNodeObject)mapPath2Objs.get(sPartialPath.toString());
                if (pInnermostFolder == null) {
                    sFolderName = MFWStringHelper.makeUnique((String)((String)vFolders.get(fIdx)), (List)vObjCaptions, (boolean)false);
                    MFWNodeObject folderObj = folderParent.addObjectNode(ridFolder);
                    this.genObjectProperties(sFolderName, "", "", folderObj);
                    mapPath2Objs.put(sPartialPath.toString(), folderObj);
                    pInnermostFolder = folderObj;
                }
                folderParent = pInnermostFolder;
            }
            MFWException.ASSERT((pInnermostFolder != null ? 1 : 0) != 0, (String)"A valid folder parent must have been added");
            outFolderObjs.add(pInnermostFolder);
        }
        MFWException.ASSERT((outFolderObjs.size() > 0 ? 1 : 0) != 0, (String)"At least one folder must exist for the given display path");
        return outFolderObjs;
    }

    private void addPropertyWithDefaultValue(MFWNodeObject objNode, short ridPropName) {
        MFWInfoObject objInfo = objNode.getObjectInfo();
        MFWInfo childInfo = objInfo.findChildInfo(ridPropName);
        MFWException.ASSERT((childInfo != null && childInfo.getNodeType() == 1 ? 1 : 0) != 0, (String)"must be a property");
        MFWInfoProperty propInfo = (MFWInfoProperty)childInfo;
        switch (propInfo.getDataType()) {
            case 2: {
                objNode.addProperty(ridPropName, propInfo.getDefaultEnumValue());
                break;
            }
            case 4: {
                objNode.addProperty(ridPropName, propInfo.getDefaultBooleanValue());
                break;
            }
            default: {
                objNode.addProperty(ridPropName, propInfo.getDefaultValue());
            }
        }
    }

    private void collectConflictingFolderNames(MFWMetadataXQEResponse respDimensions, ArrayList vConflictingName) {
        MFWMetadataXQEResponseEntity anEntity = respDimensions.getFirstEntity();
        while (anEntity != null) {
            String sDimGroupName = anEntity.getPropertyValue(14);
            String sDimCaption = anEntity.getPropertyValue(5);
            if (sDimGroupName != null && sDimGroupName.length() > 0 && sDimGroupName.equals(sDimCaption)) {
                vConflictingName.add(sDimGroupName);
            }
            anEntity = respDimensions.getNextEntity();
        }
    }

    private void collectObjectCaptions(MFWMetadataXQEResponse respObjects, ArrayList vCaptions) {
        MFWMetadataXQEResponseEntity anEntity = respObjects.getFirstEntity();
        while (anEntity != null) {
            String sDimCaption = anEntity.getPropertyValue(5);
            vCaptions.add(sDimCaption);
            anEntity = respObjects.getNextEntity();
        }
    }

    private String makeDatasourceNameUnique(MFWRequestContextUser aContext, String sCmDataSrcName) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        ArrayList<String> vDSNames = new ArrayList<String>();
        MFWCluster gwCluster = aContext.getGatewayCluster();
        if (gwCluster != null) {
            List vLinkedClusters = gwCluster.getAllLinkedClustersFor(aContext);
            for (int idx = 0; idx < vLinkedClusters.size(); ++idx) {
                MFWNodeObject pLinkProjNode = ((MFWCluster)vLinkedClusters.get(idx)).getRootNode().getObjectNode(gModelRes.RID_project);
                List vDatasources = pLinkProjNode.getObjectNodes(gModelRes.RID_dataSource);
                for (int j = 0; j < vDatasources.size(); ++j) {
                    String dsName = ((MFWNodeObject)vDatasources.get(j)).getPropertyValue(gModelRes.RID_name);
                    MFWException.ASSERT((dsName != null ? 1 : 0) != 0, (String)"Expecting a valid name property for linked data source");
                    vDSNames.add(dsName);
                }
            }
        }
        return MFWStringHelper.makeUnique((String)sCmDataSrcName, vDSNames, (boolean)false);
    }

    private void generateLocalizedObjectProperties(MFWMetadataXQEResponseEntity anEntity, MFWNodeObject pNodeObj, String sTechnicalName, String sPreCaption, String sPostCaption, boolean bIsForDefaultHierarchy, boolean bIsMeasure) {
        ArrayList<String> listCaptions = new ArrayList<String>();
        ArrayList<String> listDescriptions = new ArrayList<String>();
        ArrayList<String> listScreentips = new ArrayList<String>();
        for (int idx = 0; idx < this.mHlprLocale.getAllLocales().size(); ++idx) {
            String sLocale = (String)this.mHlprLocale.getAllLocales().get(idx);
            String sCaption = anEntity.getPropertyValue(5, sLocale);
            if (sPreCaption != null) {
                sCaption = sPreCaption + sCaption;
            }
            String sDescription = anEntity.getPropertyValue(13, sLocale);
            StringBuffer sOutName = new StringBuffer();
            StringBuffer sOutDescription = new StringBuffer();
            StringBuffer sOutScreenTip = new StringBuffer();
            this.generateSAPBWNames(sCaption, sDescription, sTechnicalName, sOutName, sOutDescription, sOutScreenTip);
            sCaption = sOutName.toString();
            if (sPostCaption != null) {
                sCaption = sCaption + sPostCaption;
            }
            if (bIsForDefaultHierarchy) {
                sCaption = this.rectifyLevelName(sTechnicalName, sCaption);
            }
            if (bIsMeasure) {
                sOutScreenTip.delete(0, sOutScreenTip.length());
            }
            listCaptions.add(sCaption);
            listDescriptions.add(sOutDescription.toString());
            listScreentips.add(sOutScreenTip.toString());
        }
        this.genObjectProperty(listCaptions, listDescriptions, listScreentips, pNodeObj);
    }

    private void genObjectProperty(ArrayList sCaptions, ArrayList sDescriptions, ArrayList sScreenTips, MFWNodeObject objNode) {
        int idx;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        ArrayList sLocales = this.mHlprLocale.getAllLocales();
        for (idx = 0; idx < sLocales.size(); ++idx) {
            this.mHlprLocale.addLocalizedProp(objNode, gModelRes.RID_name, (String)sCaptions.get(idx), (String)sLocales.get(idx));
        }
        if (sLocales.size() > 0) {
            this.mIDGenerator.generate(objNode, (String)sCaptions.get(0), true);
        }
        for (idx = 0; idx < sLocales.size(); ++idx) {
            this.mHlprLocale.addLocalizedProp(objNode, gModelRes.RID_description, (String)sDescriptions.get(idx), (String)sLocales.get(idx));
        }
        for (idx = 0; idx < sLocales.size(); ++idx) {
            this.mHlprLocale.addLocalizedProp(objNode, gModelRes.RID_screenTip, (String)sScreenTips.get(idx), (String)sLocales.get(idx));
        }
    }

    private static enum ESignatureType {
        eSignatureUnknown,
        eSignatureKey,
        eSignatureLongName,
        eSignatureMediumName,
        eSignatureName;

    }
}

