/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorDim;

import com.cognos.mfw4j.framework.MFWAdaptor;
import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWConnection;
import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWCrnIDAdvancedLookup;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.log.MFWLogRuntimeIndicators;
import com.cognos.mfw4j.utilities.MFWConnectionStringParser;
import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import com.cognos.mfwa4j.adaptorDim.MFWDimAdaptor;
import com.cognos.mfwa4j.adaptorDim.MFWDimConnectionReuseInfo;
import com.cognos.mfwa4j.adaptorDim.MFWDimLocaleHelper;
import com.cognos.mfwa4j.adaptorDim.MFWDimObjectLoader;
import com.cognos.mfwa4j.adaptorDim.MFWMetadataRequest;
import com.cognos.mfwa4j.adaptorDim.MFWMetadataResponse;
import com.cognos.mfwa4j.adaptorDim.MFWOLAPSchema;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.Step;

public final class MFWDimConnection
extends MFWConnection {
    private MFWNodeObject mDataSourceNode = null;
    private MFWNodeObject mRootNamespace = null;
    private String mRootNamespaceID = null;
    private MFWDimLocaleHelper mHlprLocale = null;
    private MFWDimObjectLoader mObjLoader = null;
    private MFWMetadataRequest mMDRequest = null;
    private MFWOLAPSchema mOlapSchema = null;
    private EExpandMode mExpandMode = EExpandMode.eExpandOnDemand;

    MFWDimConnection(MFWDimConnectionReuseInfo aReuseInfo, MFWDimAdaptor anAdaptor) {
        super((MFWConnectionReuseInfo)aReuseInfo, (MFWAdaptor)anAdaptor);
        MFWDimAdaptor.debugTrace("----------- Constructing a new connection:", (Object)this);
        this.mHlprLocale = new MFWDimLocaleHelper(this.getSource());
        this.mOlapSchema = new MFWOLAPSchema();
    }

    public void destroy() {
        MFWDimAdaptor.debugTrace("----------- destroying connection:", (Object)this);
        this.mHlprLocale.destroy();
        this.mObjLoader.destroy();
        this.mMDRequest.destroy();
        super.destroy();
    }

    EExpandMode getExpandMode() {
        return this.mExpandMode;
    }

    protected void initialSetup(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        this.mObjLoader = new MFWDimObjectLoader(this, this.mHlprLocale);
        MFWNodeObject projNode = this.mObjLoader.setupProject(this.getCluster().getRootNode(), this.getSource());
        this.mHlprLocale.setupLocales(aContext, projNode, aLinkNodeParent, true);
        this.mMDRequest = new MFWMetadataRequest(this.getSource(), this.mHlprLocale.getDesignLocale(), aContext);
        String sCubeName = (String)this.getSource().getScope("cube");
        if (sCubeName == null || sCubeName.length() == 0) {
            CubeRecord cubeResponse = this.mMDRequest.doCubeRequest(aContext, this.getSource(), null);
            sCubeName = cubeResponse.getName();
            this.getSource().addScope("cube", (Object)sCubeName);
            this.mMDRequest.setCubeName(sCubeName);
        }
        this.mRootNamespace = this.mObjLoader.setupRootNamespace(projNode, aLinkNodeParent, sCubeName);
        this.mRootNamespaceID = this.mRootNamespace.getPropertyValue(gModelRes.RID_ID);
        MFWException.ASSERT((this.mRootNamespaceID != null ? 1 : 0) != 0, (String)"Expecting an ID property for root LWM namespace");
        this.mDataSourceNode = this.mObjLoader.setupDataSource(aContext, projNode, this.getSource(), sCubeName);
        this.queryCubeInfo(aContext);
        projNode.setExpandStatus(gModelRes.RID_namespace, (byte)1);
        projNode.setExpandStatus(gModelRes.RID_dataSource, (byte)1);
        ((MFWDimConnectionReuseInfo)this.getReuseInfo()).addRecentUser(aContext);
    }

    protected void reconstructSetup(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
        this.mExpandMode = EExpandMode.eExpandAllDone;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWNodeObject aProjNode = this.getCluster().getRootNode().getObjectNode(gModelRes.RID_project);
        MFWException.ASSERT((aProjNode != null ? 1 : 0) != 0, (String)"Failed to locate the project node in DimConnection::reconstructSetup");
        this.mHlprLocale.setupLocales(aContext, aProjNode, aLinkNodeParent, false);
        this.mObjLoader = new MFWDimObjectLoader(this, this.mHlprLocale);
        this.mMDRequest = new MFWMetadataRequest(this.getSource(), this.mHlprLocale.getDesignLocale(), aContext);
        this.mRootNamespace = aProjNode.getObjectNode(gModelRes.RID_namespace);
        MFWException.ASSERT((this.mRootNamespace != null ? 1 : 0) != 0, (String)"Failed to locate the root namespace node in DimConnection::reconstructSetup");
        this.mRootNamespaceID = this.mRootNamespace.getPropertyValue(gModelRes.RID_ID);
        MFWException.ASSERT((this.mRootNamespaceID != null ? 1 : 0) != 0, (String)"Expecting an ID property for root LWM namespace in DimConnection::reconstructSetup");
        this.mDataSourceNode = this.mObjLoader.reconstructDataSource(aProjNode);
        ((MFWDimConnectionReuseInfo)this.getReuseInfo()).addRecentUser(aContext);
    }

    protected void expand(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, MFWNodeObject objNode) {
        Step currStep = aQuerySpec.getCurrentStepPattern();
        MFWException.ASSERT((boolean)(currStep instanceof NameStep), (String)"Expecting a NameStep to expand");
        if (!"*".equals(((NameStep)currStep).getLocalName())) {
            this.expand(aContext, aQuerySpec, aQuerySpec.getCurrentStepPatternRID(), objNode);
        } else {
            MFWInfo[] vChildren = objNode.getObjectInfo().getChildrenInfo();
            for (int idx = 0; idx < vChildren.length; ++idx) {
                this.expand(aContext, aQuerySpec, vChildren[idx].getRID(), objNode);
            }
        }
    }

    protected void expandAll(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
        this.mExpandMode = EExpandMode.eExpandAllStarted;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        StringBuilder dbgHint = new StringBuilder("Fully expanding LWM cube -namespace ID:");
        dbgHint.append(this.mRootNamespaceID);
        MFWLogRuntimeIndicators dbg = new MFWLogRuntimeIndicators(dbgHint.toString());
        MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)"*");
        this.expandChildren(aContext, aQuerySpec, this.mRootNamespace, gModelRes.RID_dimension);
        ArrayList childDims = new ArrayList();
        this.mRootNamespace.findObjectNodesRecursively(gModelRes.RID_dimension, gModelRes.RID_folder, (short)-1, null, false, childDims);
        MFWNodeObject objMrsDim = null;
        for (MFWNodeObject objDim : childDims) {
            if ("measure".equals(objDim.getPropertyValue(gModelRes.RID_type))) {
                this.expandAllMeasures(aContext, aQuerySpec, objDim);
                objMrsDim = objDim;
                continue;
            }
            ArrayList childHiers = new ArrayList();
            objDim.findObjectNodesRecursively(gModelRes.RID_hierarchy, gModelRes.RID_hierarchyFolder, (short)-1, null, false, childHiers);
            for (MFWNodeObject objHrchy : childHiers) {
                this.expandChildren(aContext, aQuerySpec, objHrchy, gModelRes.RID_level);
                ArrayList childLevels = new ArrayList();
                objHrchy.findObjectNodes(gModelRes.RID_level, (short)-1, null, childLevels);
                for (MFWNodeObject objLevel : childLevels) {
                    this.expandChildren(aContext, aQuerySpec, objLevel, gModelRes.RID_queryItem);
                }
                if (childLevels.size() == 0) {
                    this.expandChildren(aContext, aQuerySpec, objHrchy, gModelRes.RID_queryItem);
                }
                this.expandChildren(aContext, aQuerySpec, objHrchy, gModelRes.RID_rootCaption);
                if ("RO".equals(this.getSource().getType())) {
                    this.expandChildren(aContext, aQuerySpec, objHrchy, gModelRes.RID_calculatedMember);
                }
                if (!"TMR".equals(this.getSource().getType())) continue;
                this.expandChildren(aContext, aQuerySpec, objHrchy, gModelRes.RID_hierarchyNamedSet);
            }
        }
        this.expandChildren(aContext, aQuerySpec, this.mRootNamespace, gModelRes.RID_calculation);
        this.mExpandMode = EExpandMode.eExpandAllDone;
        Map<String, Object> aliasInfo = null;
        if ("TMR".equals(this.getSource().getType())) {
            aliasInfo = this.mHlprLocale.getEmptyAliasTablesForLocales();
        }
        this.populateCubeDefaultMeasure(aContext, aQuerySpec, this.mDataSourceNode, objMrsDim, aliasInfo);
        dbg.logEnd();
        this.mMDRequest.destroy();
    }

    protected String evaluateDynamicProperty(MFWRequestContextUser aContext, short ridDynProp, MFWNodeObject parentNode) {
        String outValue = null;
        outValue = ridDynProp == MFWModelRes.getInstance().RID_visible ? parentNode.getPropertyValue(MFWModelRes.getInstance().RID_visible) : super.evaluateDynamicProperty(aContext, ridDynProp, parentNode);
        return outValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MFWNodeObject lookup(MFWRequestContextUser aContext, MFWInfoProperty indexProp, String indexValue, MFWNodeObject rootNode, List<MFWNodeObject> ancestorsChain) {
        boolean bNameMatchupIsNeeded = this.mHlprLocale.getAllLocales().size() > 1 || "TMR".equals(this.getSource().getType());
        ArrayList vIDEntries = new ArrayList();
        MFWCrnIDHelper.parseID((String)indexValue, vIDEntries);
        if (vIDEntries.isEmpty()) {
            return null;
        }
        if (!this.doesNameMatch(this.mRootNamespace, (String)vIDEntries.get(0))) {
            return null;
        }
        if (this.mExpandMode == EExpandMode.eExpandAllDone) {
            if (!bNameMatchupIsNeeded) {
                return null;
            }
            MFWNodeObject objNode = null;
            MFWCrnIDAdvancedLookup myLookup = new MFWCrnIDAdvancedLookup(this.mRootNamespace.getParentObject(), this.mObjLoader.getIDGenerator(), (MFWRequestContext)aContext);
            objNode = myLookup.lookup(indexValue, ancestorsChain);
            if (objNode == null && ancestorsChain != null) {
                ancestorsChain.clear();
            }
            return objNode;
        }
        MFWNodeObject lookedNode = null;
        String sPartialID = this.mRootNamespaceID;
        MFWNodeObject parentNode = this.mRootNamespace;
        MFWCluster aCluster = this.mRootNamespace.getCluster();
        for (int idx = 1; idx < vIDEntries.size(); ++idx) {
            sPartialID = MFWCrnIDHelper.addEntryToID((String)sPartialID, (String)((String)vIDEntries.get(idx)));
            lookedNode = aCluster.getIndexManager().lookup(indexProp, sPartialID);
            if (lookedNode == null) {
                short[] childRIDs = this.mOlapSchema.getChildTypes(parentNode.getNameRID());
                if (childRIDs == null) {
                    return null;
                }
                Object object = parentNode.getExpandLock();
                synchronized (object) {
                    for (int i = 0; lookedNode == null && i < childRIDs.length; ++i) {
                        MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)MFWModelRes.getInstance().getResource(childRIDs[i]));
                        this.expandChildren(aContext, aQuerySpec, parentNode, childRIDs[i]);
                        lookedNode = aCluster.getIndexManager().lookup(indexProp, sPartialID);
                        if (lookedNode != null || !bNameMatchupIsNeeded) continue;
                        lookedNode = this.lookChildrenByName(parentNode, childRIDs[i], (String)vIDEntries.get(idx));
                    }
                }
            }
            if (lookedNode == null) {
                return null;
            }
            parentNode = lookedNode;
        }
        if (lookedNode != null && ancestorsChain != null) {
            MFWCrnIDAdvancedLookup.addToAncestorsChain(lookedNode, (MFWNodeObject)this.mRootNamespace, ancestorsChain);
        }
        return lookedNode;
    }

    protected void notifyLinkSourceClosing(MFWCluster aSourceCluster, MFWRequestContextUser aContext) {
        this.mMDRequest.destroy();
    }

    private void expand(MFWRequestContextUser aContext, MFWQuerySpec querySpec, short ridChild, MFWNodeObject objNode) {
        if (objNode.getExpandStatus(ridChild) == 1) {
            return;
        }
        boolean bFound = this.expandChildren(aContext, querySpec, objNode, ridChild);
        if (!bFound) {
            bFound = this.expandFolders(aContext, querySpec, ridChild, objNode);
        }
        if (!bFound) {
            super.defaultExpand(aContext, ridChild, objNode);
        }
    }

    final boolean expandChildren(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, MFWNodeObject parentNode, short ridChild) {
        if (!this.validateRequest(ridChild, parentNode)) {
            return false;
        }
        if (ridChild == MFWModelRes.getInstance().RID_rootMember) {
            return true;
        }
        if (parentNode.getExpandStatus(ridChild) == 1 && this.mExpandMode != EExpandMode.eExpandAllStarted) {
            return true;
        }
        ArrayList<MFWOLAPSchema.DimObjectSpec> olapTypes = this.mOlapSchema.getObjectSpecs(ridChild);
        if (olapTypes.size() == 0) {
            return false;
        }
        for (int idx = 0; idx < olapTypes.size(); ++idx) {
            Map<String, Object> aliasInfo;
            MFWOLAPSchema.DimObjectSpec olapType = olapTypes.get(idx);
            if (olapType.mObjOLAPType != 12) {
                aliasInfo = this.mHlprLocale.getAliasTables(olapType.mObjRID, this.getSource(), parentNode);
                List<? extends MetadataRecord> queryResponse = this.mMDRequest.doMetadataRequest(parentNode, olapType.mObjOLAPType, aliasInfo, aQuerySpec.getRetrievalStartIndex(), aQuerySpec.getRetrievalCount(), aContext);
                this.populateCluster(aContext, aQuerySpec, parentNode, olapType, queryResponse);
                continue;
            }
            aliasInfo = null;
            if ("TMR".equals(this.getSource().getType())) {
                aliasInfo = this.mHlprLocale.getAliasTables(olapType.mObjRID, this.getSource(), parentNode);
            }
            this.populateCubeDefaultMeasure(aContext, aQuerySpec, parentNode, null, aliasInfo);
        }
        return true;
    }

    private boolean expandFolders(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, short ridPattern, MFWNodeObject objParent) {
        boolean bSupportsDimGroup;
        boolean bFound = false;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String sConfigSetting = this.getAdaptor().getSourceConfig().getCapability("Display_Path");
        boolean bSupportsDisplayPath = sConfigSetting != null && "true".equals(sConfigSetting);
        sConfigSetting = this.getAdaptor().getSourceConfig().getCapability("dimensionGroup");
        boolean bl = bSupportsDimGroup = sConfigSetting != null && "true".equals(sConfigSetting);
        if (ridPattern == gModelRes.RID_folder && objParent.getNameRID() == gModelRes.RID_namespace) {
            if (bSupportsDimGroup) {
                bFound = this.expandChildren(aContext, aQuerySpec, objParent, gModelRes.RID_dimension);
            }
            if (bSupportsDisplayPath) {
                bFound = this.expandChildren(aContext, aQuerySpec, objParent, gModelRes.RID_calculation);
            }
        } else if (bSupportsDisplayPath && ridPattern == gModelRes.RID_hierarchyFolder && objParent.getNameRID() == gModelRes.RID_dimension) {
            bFound = this.expandChildren(aContext, aQuerySpec, objParent, gModelRes.RID_hierarchy);
        } else if (bSupportsDisplayPath && ridPattern == gModelRes.RID_measureFolder && (objParent.getNameRID() == gModelRes.RID_dimension || objParent.getNameRID() == gModelRes.RID_measure)) {
            bFound = this.expandChildren(aContext, aQuerySpec, objParent, gModelRes.RID_measure);
        }
        return bFound;
    }

    private boolean validateRequest(short ridChild, MFWNodeObject objParent) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        if (ridChild == gModelRes.RID_measure || ridChild == gModelRes.RID_measureFolder) {
            MFWNodeObject parent;
            for (parent = objParent; parent != null && parent.getNameRID() != gModelRes.RID_dimension; parent = parent.getParentObject()) {
            }
            MFWException.ASSERT((parent != null ? 1 : 0) != 0, (String)"Expecting a valid dimension in measure/measureFolder ancestry");
            String aProp = parent.getPropertyValue(gModelRes.RID_type);
            if (aProp == null || !"measure".equals(aProp)) {
                return false;
            }
        } else {
            if (ridChild == gModelRes.RID_dimension || ridChild == gModelRes.RID_calculation) {
                return objParent.getNameRID() == gModelRes.RID_namespace;
            }
            if (ridChild == gModelRes.RID_hierarchy) {
                if (objParent.getNameRID() != gModelRes.RID_dimension) {
                    return false;
                }
                String aProp = objParent.getPropertyValue(gModelRes.RID_type);
                if (aProp == null || "measure".equals(aProp)) {
                    return false;
                }
            } else {
                if (ridChild == gModelRes.RID_level) {
                    if (objParent.getNameRID() != gModelRes.RID_hierarchy) {
                        return false;
                    }
                    boolean aProp = objParent.getBooleanPropertyValue(gModelRes.RID_parentChild);
                    return !aProp;
                }
                if (ridChild == gModelRes.RID_hierarchyNamedSet) {
                    return objParent.getNameRID() == gModelRes.RID_hierarchy;
                }
                if (ridChild == gModelRes.RID_queryItem) {
                    if (objParent.getNameRID() != gModelRes.RID_level && objParent.getNameRID() != gModelRes.RID_hierarchy) {
                        return false;
                    }
                    String aProp = objParent.getPropertyValue(gModelRes.RID_visible);
                    if (aProp != null && ("hidden".equals(aProp) || "hiddenAndAccessible".equals(aProp))) {
                        return false;
                    }
                    if (objParent.getNameRID() == gModelRes.RID_hierarchy) {
                        boolean aBoolProp = objParent.getBooleanPropertyValue(gModelRes.RID_parentChild);
                        return aBoolProp;
                    }
                } else {
                    if (ridChild == gModelRes.RID_rootMember) {
                        String aProp = objParent.getPropertyValue(gModelRes.RID_visible);
                        return !"hidden".equals(aProp) && !"hiddenAndAccessible".equals(aProp);
                    }
                    if (ridChild == gModelRes.RID_rootCaption || ridChild == gModelRes.RID_rootMUN || ridChild == gModelRes.RID_rootMemberRollup || ridChild == gModelRes.RID_multiRoot) {
                        if (objParent.getNameRID() != gModelRes.RID_hierarchy) {
                            return false;
                        }
                        String aProp = objParent.getPropertyValue(gModelRes.RID_visible);
                        return !"hidden".equals(aProp) && !"hiddenAndAccessible".equals(aProp);
                    }
                    if (ridChild == gModelRes.RID_cubeDefaultMeasure) {
                        return objParent.getNameRID() == gModelRes.RID_dataSource;
                    }
                }
            }
        }
        return true;
    }

    private void populateCluster(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, MFWNodeObject objParent, MFWOLAPSchema.DimObjectSpec dimObjSpec, List<? extends MetadataRecord> response) {
        this.mObjLoader.populateCluster(aContext, aQuerySpec, dimObjSpec.mObjOLAPType, objParent, response);
        objParent.setExpandStatus(dimObjSpec.mObjRID, (byte)1);
    }

    private void populateCubeDefaultMeasure(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, MFWNodeObject objDataSource, MFWNodeObject objMeasureDim, Map<String, ? extends Object> aliasInfo) {
        MFWNodeObject objDefMsr;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String defMsrExtName = this.mMDRequest.queryCubeDefaultMeasure(aContext, aliasInfo);
        if (defMsrExtName == null || defMsrExtName.length() == 0) {
            objDataSource.setExpandStatus(gModelRes.RID_cubeDefaultMeasure, (byte)1);
            return;
        }
        if (objMeasureDim == null) {
            this.expandChildren(aContext, aQuerySpec, this.mRootNamespace, gModelRes.RID_dimension);
            ArrayList childDims = new ArrayList(2);
            this.mRootNamespace.findObjectNodesRecursively(gModelRes.RID_dimension, gModelRes.RID_folder, gModelRes.RID_type, "measure", true, childDims);
            MFWException.ASSERT((childDims.size() == 1 ? 1 : 0) != 0, (String)"Expecting one measure dimension when populating cubeDefaultMeasure");
            objMeasureDim = (MFWNodeObject)childDims.get(0);
        }
        MFWException.ASSERT(((objDefMsr = this.findMeasureWithMatchingExtName(aContext, aQuerySpec, objMeasureDim, defMsrExtName)) != null ? 1 : 0) != 0, (String)"Unable to find a measure correspondng to cube's default measure=", (String)defMsrExtName);
        objDataSource.addProperty(gModelRes.RID_cubeDefaultMeasure, objDefMsr.getPropertyValue(gModelRes.RID_ID));
    }

    MFWNodeObject findMeasureWithMatchingExtName(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, MFWNodeObject objParent, String defMeasureExtName) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        this.expandChildren(aContext, aQuerySpec, objParent, gModelRes.RID_measure);
        ArrayList childMsrs = new ArrayList();
        objParent.findObjectNodesRecursively(gModelRes.RID_measure, gModelRes.RID_measureFolder, (short)-1, null, false, childMsrs);
        for (MFWNodeObject objMsr : childMsrs) {
            if (!defMeasureExtName.equals(objMsr.getPropertyValue(gModelRes.RID_externalName))) continue;
            return objMsr;
        }
        for (MFWNodeObject objMsr : childMsrs) {
            MFWNodeObject outMsr = this.findMeasureWithMatchingExtName(aContext, aQuerySpec, objMsr, defMeasureExtName);
            if (outMsr == null) continue;
            return outMsr;
        }
        return null;
    }

    private void expandAllMeasures(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, MFWNodeObject objParent) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        this.expandChildren(aContext, aQuerySpec, objParent, gModelRes.RID_measure);
        ArrayList childMsrs = new ArrayList();
        objParent.findObjectNodesRecursively(gModelRes.RID_measure, gModelRes.RID_measureFolder, (short)-1, null, false, childMsrs);
        for (MFWNodeObject objMsr : childMsrs) {
            this.expandAllMeasures(aContext, aQuerySpec, objMsr);
        }
        if ("RO".equals(this.getSource().getType()) && (objParent.getNameRID() == gModelRes.RID_dimension || objParent.getNameRID() == gModelRes.RID_measureFolder)) {
            this.expandAllMeasureFolders(aContext, aQuerySpec, objParent);
        }
    }

    private void expandAllMeasureFolders(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, MFWNodeObject objParent) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        List measureFolders = objParent.getObjectNodes(gModelRes.RID_measureFolder);
        for (int idx = 0; idx < measureFolders.size(); ++idx) {
            MFWNodeObject measureFolder = (MFWNodeObject)measureFolders.get(idx);
            this.expandAllMeasures(aContext, aQuerySpec, measureFolder);
        }
    }

    private String queryCubeInfo(MFWRequestContextUser aContext) {
        String outLastSchemaUpdate = null;
        Map<String, Object> aliasInfo = null;
        if ("TMR".equals(this.getSource().getType()) || "TM".equals(this.getSource().getType())) {
            aliasInfo = this.mHlprLocale.getAliasTables(MFWModelRes.getInstance().RID_cube, this.getSource(), null);
        }
        CubeRecord cubeResponse = this.mMDRequest.doCubeRequest(aContext, this.getSource(), aliasInfo);
        DateTimeValue dtValue = cubeResponse.getSchemaUpdateDate();
        outLastSchemaUpdate = MFWMetadataResponse.toModelString(dtValue);
        String cubePath = null;
        if ("PC".equals(this.getSource().getType())) {
            MFWConnectionStringParser myConnParser = new MFWConnectionStringParser(this.mMDRequest.getResolvedConnectionStr());
            cubePath = "/".equals(System.getProperty("file.separator")) ? myConnParser.getValue("UNIX_PATH") : myConnParser.getValue("WIN_PATH");
        }
        this.mObjLoader.populateCubeProps(this.mDataSourceNode, cubePath, cubeResponse);
        return outLastSchemaUpdate;
    }

    String getParentChildLevelInfo(MFWNodeObject hierarchyNode, MFWRequestContextUser aContext) {
        StringBuilder outInfo = new StringBuilder("<levels>");
        Map<String, Object> aliasInfo = this.mHlprLocale.getAliasTables(MFWModelRes.getInstance().RID_level, this.getSource(), hierarchyNode);
        MetadataRestriction lvlRest = this.mMDRequest.makeQueryConstraints(hierarchyNode, (short)5, aliasInfo, 0, 0);
        List<? extends MetadataRecord> levelRecords = this.mMDRequest.doMetadataRequest((short)5, lvlRest, aContext);
        for (MetadataRecord metadataRecord : levelRecords) {
            LevelRecord lvlRecord = (LevelRecord)metadataRecord;
            outInfo.append("<level>");
            outInfo.append("<externalName>");
            outInfo.append(MFWStringHelper.escapeXMLChars((String)lvlRecord.getUniqueName()));
            outInfo.append("</externalName>");
            lvlRest.add(RestrictionType.LEVEL_UNIQUE_NAME, (Object)lvlRecord.getUniqueName());
            List<? extends MetadataRecord> attributeRecords = this.mMDRequest.doMetadataRequest((short)1, lvlRest, aContext);
            for (MetadataRecord metadataRecord2 : attributeRecords) {
                PropertyRecord attrRecord = (PropertyRecord)metadataRecord2;
                outInfo.append("<attribute>");
                outInfo.append("<externalName>");
                outInfo.append(MFWStringHelper.escapeXMLChars((String)attrRecord.getUniqueName()));
                outInfo.append("</externalName>");
                outInfo.append("</attribute>");
            }
            outInfo.append("</level>");
        }
        outInfo.append("</levels>");
        return outInfo.toString();
    }

    String getMeasureHierarchyInfo(MFWNodeObject measureDimNode, MFWRequestContextUser aContext) {
        StringBuilder outInfo = new StringBuilder("<hierarchies>");
        Map<String, Object> aliasInfo = this.mHlprLocale.getAliasTables(MFWModelRes.getInstance().RID_measure, this.getSource(), measureDimNode);
        MetadataRestriction hrchyRest = this.mMDRequest.makeQueryConstraints(measureDimNode, (short)4, aliasInfo, 0, 0);
        List<? extends MetadataRecord> hierarchyRecords = this.mMDRequest.doMetadataRequest((short)4, hrchyRest, aContext);
        for (MetadataRecord metadataRecord : hierarchyRecords) {
            HierarchyRecord hrchyRecord = (HierarchyRecord)metadataRecord;
            outInfo.append("<hierarchy>");
            outInfo.append("<externalName>");
            outInfo.append(MFWStringHelper.escapeXMLChars((String)hrchyRecord.getUniqueName()));
            outInfo.append("</externalName>");
            hrchyRest.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)hrchyRecord.getUniqueName());
            List<? extends MetadataRecord> levelRecords = this.mMDRequest.doMetadataRequest((short)5, hrchyRest, aContext);
            for (MetadataRecord metadataRecord2 : levelRecords) {
                LevelRecord lvlRecord = (LevelRecord)metadataRecord2;
                outInfo.append("<level>");
                outInfo.append("<externalName>");
                outInfo.append(MFWStringHelper.escapeXMLChars((String)lvlRecord.getUniqueName()));
                outInfo.append("</externalName>");
                outInfo.append("</level>");
            }
            outInfo.append("</hierarchy>");
        }
        outInfo.append("</hierarchies>");
        return outInfo.toString();
    }

    MemberRecord getFirstNamedSetMember(MFWNodeObject calcNode, MFWRequestContextUser aContext) {
        MetadataRestriction memRest = this.mMDRequest.makeQueryConstraints(calcNode, (short)11, null, 0, 1);
        List<? extends MetadataRecord> memRecords = this.mMDRequest.doMetadataRequest((short)11, memRest, aContext);
        if (memRecords != null && memRecords.size() > 0) {
            return (MemberRecord)memRecords.get(0);
        }
        return null;
    }

    String getNamedSetLevels(MFWNodeObject namedSetNode, MFWRequestContextUser aContext) {
        StringBuilder outInfo = new StringBuilder();
        List<String> vNames = this.mMDRequest.queryNamedSetLevelNames(aContext, namedSetNode);
        if (vNames != null && vNames.size() > 0) {
            outInfo.append("<levels>");
            for (String aLevelUName : vNames) {
                outInfo.append("<level>");
                outInfo.append("<externalName>");
                outInfo.append(MFWStringHelper.escapeXMLChars((String)aLevelUName));
                outInfo.append("</externalName>");
                outInfo.append("</level>");
            }
            outInfo.append("</levels>");
        }
        return outInfo.toString();
    }

    private boolean doesNameMatch(MFWNodeObject objNode, String sName) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        List vNames = objNode.getObjectNodes(MFWModelRes.getInstance().RID_name);
        for (int idx = 0; idx < vNames.size(); ++idx) {
            String value = ((MFWNodeObject)vNames.get(idx)).getPropertyValue(gModelRes.RID__Value);
            if (value == null || !sName.equals(value)) continue;
            return true;
        }
        return false;
    }

    private MFWNodeObject lookChildrenByName(MFWNodeObject objNode, short ridChildName, String sName) {
        List vChildren = objNode.getObjectNodes(ridChildName);
        for (int idx = 0; idx < vChildren.size(); ++idx) {
            if (!this.doesNameMatch((MFWNodeObject)vChildren.get(idx), sName)) continue;
            return (MFWNodeObject)vChildren.get(idx);
        }
        return null;
    }

    static enum EExpandMode {
        eExpandOnDemand,
        eExpandAllStarted,
        eExpandAllDone;

    }
}

