/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorDim;

import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.log.MFWLogDimAdaptorTraceEvent;
import com.cognos.mfw4j.resourcePool.MFWGenericEntry;
import com.cognos.mfw4j.resourcePool.MFWUserPool;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import com.cognos.mfwa4j.adaptorDim.MFWDimLocaleHelper;
import com.cognos.mfwa4j.adaptorDim.MFWMetadataRequest;
import com.cognos.mfwa4j.adaptorDim.MFWMetadataResponse;
import com.cognos.mfwa4j.toolBox.MFWSharedContentHelper;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.metadata.record.CubeRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;

public class MFWDimConnectionReuseInfo
extends MFWConnectionReuseInfo {
    private long mDigSourceIdentity;
    private long mDigUserIdentity;
    private ArrayList<String> mLocales = null;
    private String mRootNamespaceID = null;
    private String mLastSchemaUpdateDate = null;
    private int mCubeSchemaUpdateRetainPeriod = 30000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MFWDimConnectionReuseInfo(MFWConfiguration.MFWConfigSource aConfigSrc, MFWRequestContextUser aContext, MFWMetadataSource aMetadataSrc, MFWNodeObject aLinkParent) {
        super(aMetadataSrc);
        String maxRetain = aConfigSrc.getCapability("schemaUpdateRetainPeriod");
        if (maxRetain != null && maxRetain.length() > 0) {
            this.mCubeSchemaUpdateRetainPeriod = Integer.parseInt(maxRetain) * 1000;
        }
        CRC32 myCRC = new CRC32();
        MFWLogDimAdaptorTraceEvent logEvent = new MFWLogDimAdaptorTraceEvent();
        logEvent.log(new String[]{"\n***New MFWDimConnectionReuseInfo", Integer.toString(((Object)((Object)this)).hashCode())});
        List<String> vUserMems = MFWSharedContentHelper.getUserIdentity((MFWRequestContext)aContext);
        logEvent.log(new String[]{"\t******User Membership:"});
        for (String usrMem : vUserMems) {
            logEvent.log(new String[]{usrMem});
        }
        myCRC.update(MFWSharedContentHelper.getDigestedUserIdentity((MFWRequestContext)aContext));
        this.mDigUserIdentity = myCRC.getValue();
        logEvent.log(new String[]{"\t******User Membership digest:", Long.toString(this.mDigUserIdentity)});
        if (aLinkParent == null) {
            this.mLocales = new ArrayList(1);
            this.mLocales.add(aContext.getContentLocale());
        } else {
            this.mLocales = MFWDimLocaleHelper.getProjectLocales(aLinkParent);
        }
        if (aLinkParent != null) {
            this.mRootNamespaceID = aLinkParent.getPropertyValue(MFWModelRes.getInstance().RID_ID);
            MFWException.ASSERT((this.mRootNamespaceID != null ? 1 : 0) != 0, (String)"Expecting an ID property for parent LWM namespace");
        }
        myCRC.reset();
        MFWMetadataRequest odpReq = null;
        try {
            odpReq = new MFWMetadataRequest(aMetadataSrc, this.mLocales.get(0), aContext);
            String resolvedConnStr = odpReq.getResolvedConnectionStr();
            myCRC.update(this.digestSourceIdentity(resolvedConnStr, logEvent, aContext, this.getMetadataSource()));
            this.mDigSourceIdentity = myCRC.getValue();
            logEvent.log(new String[]{"\t******Source digest:", Long.toString(this.mDigSourceIdentity)});
            this.mLastSchemaUpdateDate = this.queryCubeLastSchemaUpdate(aMetadataSrc, resolvedConnStr, odpReq, aContext, aLinkParent);
            logEvent.log(new String[]{"\t******Last Schema Update Date:", this.mLastSchemaUpdateDate});
        }
        finally {
            if (odpReq != null) {
                odpReq.destroy();
            }
        }
    }

    public void destroy() {
        super.destroy();
        this.mLocales.clear();
    }

    long getSourceIdentityDigest() {
        return this.mDigSourceIdentity;
    }

    long getUserIendityDigest() {
        return this.mDigUserIdentity;
    }

    ArrayList<String> getLocales() {
        return this.mLocales;
    }

    String getRootNamespaceID() {
        return this.mRootNamespaceID;
    }

    public StringBuffer getPersistentPath() {
        StringBuffer path = new StringBuffer(MFWConfiguration.getInstance().getPMCDirectoryPath());
        path.append("/");
        path.append(Long.toString(this.mDigSourceIdentity));
        path.append("/");
        path.append(MFWStringHelper.cleanupFileName((String)this.mLastSchemaUpdateDate));
        path.append("-");
        path.append(Long.toString(this.mDigUserIdentity));
        return path;
    }

    protected boolean isCacheUpToDate(MFWRequestContextUser aContext, MFWConnectionReuseInfo thatReuseInfo) {
        MFWDimConnectionReuseInfo thatDimReuseInfo = (MFWDimConnectionReuseInfo)thatReuseInfo;
        boolean isUptodate = this.mLastSchemaUpdateDate.equals(thatDimReuseInfo.mLastSchemaUpdateDate);
        MFWLogDimAdaptorTraceEvent logEvent = new MFWLogDimAdaptorTraceEvent();
        logEvent.log(new String[]{"\n===MFWDimConnectionReuseInfo isCacheUpToDate:", Integer.toString(((Object)((Object)this)).hashCode()), "is up-to-date for:", Integer.toString(thatReuseInfo.hashCode())});
        logEvent.log(new String[]{"\t======this schemaUpdate:", this.mLastSchemaUpdateDate, "that schemaUpdate:", thatDimReuseInfo.mLastSchemaUpdateDate, isUptodate ? "YES" : "NO"});
        if (isUptodate) {
            this.addRecentUser(aContext);
        }
        return isUptodate;
    }

    protected boolean isReusableFor(MFWConnectionReuseInfo thatReuseInfo) {
        MFWDimConnectionReuseInfo thatDimReuseInfo = (MFWDimConnectionReuseInfo)thatReuseInfo;
        MFWLogDimAdaptorTraceEvent logEvent = new MFWLogDimAdaptorTraceEvent();
        logEvent.log(new String[]{"\n===MFWDimConnectionReuseInfo isReusableFor:", Integer.toString(((Object)((Object)this)).hashCode()), "can be reused for:", Integer.toString(thatReuseInfo.hashCode())});
        logEvent.log(new String[]{"\t======this sourceDigest:", Long.toString(this.mDigSourceIdentity), "that sourceDigest:", Long.toString(thatDimReuseInfo.mDigSourceIdentity)});
        if (thatDimReuseInfo.mDigSourceIdentity != this.mDigSourceIdentity) {
            return false;
        }
        logEvent.log(new String[]{"\t======this userIdentityDigest:", Long.toString(this.mDigUserIdentity), "that userIdentityDigest:", Long.toString(thatDimReuseInfo.mDigUserIdentity)});
        if (this.mDigUserIdentity != thatDimReuseInfo.mDigUserIdentity) {
            return false;
        }
        logEvent.log(new String[]{"\t======YES ... it is reuseable"});
        return true;
    }

    void addRecentUser(MFWRequestContextUser aContext) {
    }

    private byte[] digestSourceIdentity(String resolvedConnStr, MFWLogDimAdaptorTraceEvent logEvent, MFWRequestContextUser aContext, MFWMetadataSource aMetadataSrc) {
        String sItem;
        StringBuilder myDigest = new StringBuilder();
        if (this.mRootNamespaceID != null) {
            myDigest.append(this.mRootNamespaceID);
            logEvent.log(new String[]{"\t******RootNamespaceID:", this.mRootNamespaceID});
        }
        logEvent.log(new String[]{"\t******Model Locales:"});
        for (String desLocale : this.mLocales) {
            myDigest.append(desLocale);
            logEvent.log(new String[]{desLocale});
        }
        myDigest.append(resolvedConnStr);
        logEvent.log(new String[]{"\t******Resolved Connection String:", resolvedConnStr});
        String tempValue = (String)aMetadataSrc.getConnectionItem("attribute");
        if ("dimension".equals(tempValue)) {
            myDigest.append("attribute");
            myDigest.append("dimension");
            logEvent.log(new String[]{"\t******attribute:", "dimension"});
        }
        if ((sItem = (String)aMetadataSrc.getScope("catalog")) != null && sItem.length() > 0) {
            myDigest.append("catalog");
            myDigest.append(sItem);
            logEvent.log(new String[]{"\t******Catalog:", sItem});
        }
        if ((sItem = (String)aMetadataSrc.getScope("schema")) != null && sItem.length() > 0) {
            myDigest.append("schema");
            myDigest.append(sItem);
            logEvent.log(new String[]{"\t******Schema:", sItem});
        }
        if ((sItem = (String)aMetadataSrc.getScope("cube")) != null && sItem.length() > 0) {
            myDigest.append("cube");
            myDigest.append(sItem);
            logEvent.log(new String[]{"\t******Cube:", sItem});
        }
        if ((sItem = (String)aMetadataSrc.getConnectionItem("cmDataSource")) != null && sItem.length() > 0) {
            myDigest.append("cmDataSource");
            myDigest.append(sItem);
            logEvent.log(new String[]{"\t******cmDataSource:", sItem});
        }
        for (Map.Entry aPair : aMetadataSrc.getAliasInfo().entrySet()) {
            myDigest.append((String)aPair.getKey());
            myDigest.append((String)aPair.getValue());
            logEvent.log(new String[]{"\t******Alias Info:", (String)aPair.getKey(), ",", (String)aPair.getValue()});
        }
        return myDigest.toString().getBytes();
    }

    private String queryCubeLastSchemaUpdate(MFWMetadataSource aMetadataSrc, String resolvedConnStr, MFWMetadataRequest cubeReq, MFWRequestContextUser aContext, MFWNodeObject aLinkParent) {
        StringBuilder cubeKey = new StringBuilder("CUBE_KEY");
        cubeKey.append(resolvedConnStr);
        cubeKey.append((String)aMetadataSrc.getScope("catalog"));
        cubeKey.append((String)aMetadataSrc.getScope("schema"));
        cubeKey.append((String)aMetadataSrc.getScope("cube"));
        String strCubeKey = cubeKey.toString();
        String outUpdateDate = null;
        MFWGenericEntry cachedEntry = MFWUserPool.getInstance().findOrAddGenericCacheItem((Object)strCubeKey, this.mCubeSchemaUpdateRetainPeriod, aContext.getIgnoreUpdateRetainPeriod());
        if (cachedEntry.doesValueNeedSetting()) {
            outUpdateDate = this.getSchemaUpdateDateFromCube(aMetadataSrc, cubeReq, aContext, aLinkParent, outUpdateDate, cachedEntry);
        } else {
            outUpdateDate = (String)cachedEntry.getValue();
            if (outUpdateDate == null) {
                outUpdateDate = this.getSchemaUpdateDateFromCube(aMetadataSrc, cubeReq, aContext, aLinkParent, outUpdateDate, cachedEntry);
            }
        }
        return outUpdateDate;
    }

    private String getSchemaUpdateDateFromCube(MFWMetadataSource aMetadataSrc, MFWMetadataRequest cubeReq, MFWRequestContextUser aContext, MFWNodeObject aLinkParent, String outUpdateDate, MFWGenericEntry cachedEntry) {
        try {
            Map<String, Object> aliasInfo = null;
            if ("TMR".equals(aMetadataSrc.getType()) || "TM".equals(aMetadataSrc.getType())) {
                MFWDimLocaleHelper aHlprLocale = new MFWDimLocaleHelper(aMetadataSrc);
                aHlprLocale.setupLocales(aContext, null, aLinkParent, false);
                aliasInfo = aHlprLocale.getAliasTables(MFWModelRes.getInstance().RID_cube, aMetadataSrc, null);
            }
            CubeRecord cubeResponse = cubeReq.doCubeRequest(aContext, aMetadataSrc, aliasInfo);
            DateTimeValue dtValue = cubeResponse.getSchemaUpdateDate();
            outUpdateDate = MFWMetadataResponse.toModelString(dtValue);
            cachedEntry.setValue((Object)outUpdateDate);
        }
        catch (Throwable th) {
            cachedEntry.setValueFailed(th);
            throw cachedEntry.getSetException();
        }
        return outUpdateDate;
    }
}

