/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorDimMDDS;

import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.resourcePool.MFWDSConnectionSpec;
import com.cognos.mfw4j.resourcePool.MFWDSSelectionCriteria;
import com.cognos.mfw4j.resourcePool.MFWUserPool;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWConnectionStringParser;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWDimAdaptor;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWDimConnection;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWDimLocaleHelper;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWMetadataRequest;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWMetadataResponse;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWOLAPSchema;
import com.cognos.mfwa4j.v5Bridge.MFWV5Bridge;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.CRC32;
import org.dom4j.Element;
import org.dom4j.Node;

public class MFWDimConnectionReuseInfo
extends MFWConnectionReuseInfo {
    private long mDigSourceIdentity;
    private long mDigUserIdentity;
    private ArrayList<String> mLocales = null;
    private String mRootNamespaceID = null;
    private String mLastSchemaUpdateDate = null;
    private ArrayList<String> mRecentUsers;

    MFWDimConnectionReuseInfo(MFWConfiguration.MFWConfigSource aConfigSrc, MFWRequestContextUser aContext, MFWMetadataSource aMetadataSrc, MFWNodeObject aLinkParent) {
        super(aMetadataSrc);
        CRC32 myCRC = new CRC32();
        myCRC.update(MFWUserPool.getInstance().getDigestedUserIdentity((MFWRequestContext)aContext));
        this.mDigUserIdentity = myCRC.getValue();
        if (aLinkParent == null) {
            this.mLocales = new ArrayList(1);
            this.mLocales.add(aContext.getContentLocale());
        } else {
            this.mLocales = MFWDimLocaleHelper.getProjectLocales(aLinkParent);
        }
        if (aLinkParent != null) {
            this.mRootNamespaceID = aLinkParent.getPropertyValue(MFWModelRes.getInstance().RID_ID);
            MFWException.ASSERT((this.mRootNamespaceID != null ? 1 : 0) != 0, (String)"Expecting an ID property for parent LWM namespace");
        }
        this.populateConnectionItems(aConfigSrc, aContext);
        myCRC.reset();
        myCRC.update(this.digestSourceIdentity(aContext, this.getMetadataSource()));
        this.mDigSourceIdentity = myCRC.getValue();
        this.mLastSchemaUpdateDate = this.queryCubeLastSchemaUpdate(aContext);
    }

    public void destroy() {
        super.destroy();
        if (this.mRecentUsers != null) {
            this.mRecentUsers.clear();
        }
        this.mLocales.clear();
    }

    long getSourceIdentityDigest() {
        return this.mDigSourceIdentity;
    }

    long getUserIendityDigest() {
        return this.mDigUserIdentity;
    }

    ArrayList<String> getLocales() {
        return this.mLocales;
    }

    String getRootNamespaceID() {
        return this.mRootNamespaceID;
    }

    public StringBuffer getPersistentPath() {
        StringBuffer path = new StringBuffer(MFWConfiguration.getInstance().getPMCDirectoryPath());
        path.append("/");
        path.append(Long.toString(this.mDigSourceIdentity));
        path.append("/");
        path.append(MFWStringHelper.cleanupFileName((String)this.mLastSchemaUpdateDate));
        path.append("-");
        path.append(Long.toString(this.mDigUserIdentity));
        return path;
    }

    protected boolean isCacheUpToDate(MFWRequestContextUser aContext, MFWConnectionReuseInfo thatReuseInfo) {
        MFWDimAdaptor.debugTrace("Is cache up-to-date?", (Object)this);
        MFWDimAdaptor.debugTrace("Last Schema update date (cache):", null);
        MFWDimAdaptor.debugTrace(this.mLastSchemaUpdateDate, null);
        MFWDimConnectionReuseInfo thatDimReuseInfo = (MFWDimConnectionReuseInfo)thatReuseInfo;
        MFWDimAdaptor.debugTrace("Last Schema update date (source):", null);
        MFWDimAdaptor.debugTrace(thatDimReuseInfo.mLastSchemaUpdateDate, null);
        boolean isUptodate = this.mLastSchemaUpdateDate.equals(thatDimReuseInfo.mLastSchemaUpdateDate);
        if (isUptodate) {
            this.addRecentUser(aContext);
        }
        return isUptodate;
    }

    protected boolean isReusableFor(MFWConnectionReuseInfo thatReuseInfo) {
        MFWDimAdaptor.debugTrace("Can cache be reused?", (Object)this);
        MFWDimConnectionReuseInfo thatDimReuseInfo = (MFWDimConnectionReuseInfo)thatReuseInfo;
        if (thatDimReuseInfo.getSourceIdentityDigest() != this.mDigSourceIdentity) {
            MFWDimAdaptor.debugTrace("No ... Source mismatch", null);
            return false;
        }
        ArrayList<String> vThatLocales = thatDimReuseInfo.getLocales();
        for (int idx = 0; idx < vThatLocales.size(); ++idx) {
            if (this.mLocales.contains(vThatLocales.get(idx))) continue;
            MFWDimAdaptor.debugTrace("No ... locale mismatch", null);
            return false;
        }
        if (this.mRootNamespaceID != null && !this.mRootNamespaceID.equals(thatDimReuseInfo.getRootNamespaceID()) || thatDimReuseInfo.getRootNamespaceID() != null && !thatDimReuseInfo.getRootNamespaceID().equals(this.mRootNamespaceID)) {
            MFWDimAdaptor.debugTrace("No ... root namespace ID mismatch", null);
            return false;
        }
        if (this.mDigUserIdentity != thatDimReuseInfo.getUserIendityDigest()) {
            MFWDimAdaptor.debugTrace("No ... user identity mismatch", null);
            return false;
        }
        MFWDimAdaptor.debugTrace("Yes ... all reuse criteria are met!", null);
        return true;
    }

    void addRecentUser(MFWRequestContextUser aContext) {
        if (this.mRecentUsers == null) {
            this.mRecentUsers = new ArrayList();
        }
        this.mRecentUsers.add(aContext.getUserPassport());
    }

    private byte[] digestSourceIdentity(MFWRequestContextUser aContext, MFWMetadataSource aMetadataSrc) {
        String cubePasswordStr;
        String passwordStr;
        String userNameStr;
        StringBuilder myDigest = new StringBuilder();
        for (Map.Entry aPair : aMetadataSrc.getConnectionInfo().entrySet()) {
            myDigest.append((String)aPair.getKey());
            myDigest.append((String)aPair.getValue());
        }
        for (Map.Entry aPair : aMetadataSrc.getScopeInfo().entrySet()) {
            myDigest.append((String)aPair.getKey());
            myDigest.append((String)aPair.getValue());
        }
        for (Map.Entry aPair : aMetadataSrc.getSignonInfo().entrySet()) {
            if ("ASTicket".equals((String)aPair.getKey())) continue;
            myDigest.append((String)aPair.getKey());
            myDigest.append((String)aPair.getValue());
        }
        for (Map.Entry aPair : aMetadataSrc.getAliasInfo().entrySet()) {
            myDigest.append((String)aPair.getKey());
            myDigest.append((String)aPair.getValue());
        }
        String sCmDataSrc = (String)aMetadataSrc.getConnectionItem("cmDataSource");
        Element elmConnSpec = aContext.getConnectionSpec();
        String searchPathStr = this.getConnectionValueFor(elmConnSpec, sCmDataSrc, "searchPath");
        if (searchPathStr != null && searchPathStr.length() > 0) {
            myDigest.append(searchPathStr);
        }
        if ((userNameStr = this.getConnectionValueFor(elmConnSpec, sCmDataSrc, "username")) != null && userNameStr.length() > 0) {
            myDigest.append(userNameStr);
        }
        if ((passwordStr = this.getConnectionValueFor(elmConnSpec, sCmDataSrc, "password")) != null && passwordStr.length() > 0) {
            myDigest.append(passwordStr);
        }
        if ((cubePasswordStr = this.getConnectionValueFor(elmConnSpec, sCmDataSrc, "cubePassword")) != null && cubePasswordStr.length() > 0) {
            myDigest.append(cubePasswordStr);
        }
        return myDigest.toString().getBytes();
    }

    private void populateConnectionItems(MFWConfiguration.MFWConfigSource aConfigSrc, MFWRequestContextUser aContext) {
        this.populateConnectionItemsForV5(aConfigSrc, aContext);
    }

    private void populateConnectionItemsForV5(MFWConfiguration.MFWConfigSource aConfigSrc, MFWRequestContextUser aContext) {
        String cubePasswordStr;
        String sCmDataSrc = (String)this.getMetadataSource().getConnectionItem("cmDataSource");
        if (sCmDataSrc == null || sCmDataSrc.length() == 0) {
            return;
        }
        MFWDSSelectionCriteria dsSelection = new MFWDSSelectionCriteria(sCmDataSrc);
        Element connectionSpec = aContext.getConnectionSpec();
        if (connectionSpec != null) {
            String cubePass;
            String namespace;
            String pwdSignon;
            String uidSignon;
            String searchPathStr = this.getConnectionValueFor(connectionSpec, sCmDataSrc, "searchPath");
            if (searchPathStr.length() > 0) {
                dsSelection.setCMConnectionPath(searchPathStr);
                if (searchPathStr.contains("dataSourceConnection")) {
                    String[] tokens2;
                    String dataSourceConnection = "";
                    String connectionStr = searchPathStr.substring(searchPathStr.indexOf("dataSourceConnection"));
                    String[] tokens1 = connectionStr.split("name=");
                    if (tokens1.length >= 2 && (tokens2 = tokens1[1].split("'")).length >= 2) {
                        dataSourceConnection = tokens2[1];
                        dsSelection.setCMConnectionName(dataSourceConnection);
                    }
                }
            }
            if ((uidSignon = this.getConnectionValueFor(connectionSpec, sCmDataSrc, "username")).length() > 0) {
                dsSelection.setSignonUserID(uidSignon);
            }
            if ((pwdSignon = this.getConnectionValueFor(connectionSpec, sCmDataSrc, "password")).length() > 0) {
                dsSelection.setSignonPassword(pwdSignon);
            }
            if ((namespace = this.getConnectionValueFor(connectionSpec, sCmDataSrc, "namespace")).length() > 0) {
                dsSelection.setCubeAuthenticationNamespace(namespace);
            }
            if ((cubePass = this.getConnectionValueFor(connectionSpec, sCmDataSrc, "cubePassword")).length() > 0) {
                dsSelection.setCubeAuthenticationPassword(cubePass);
            }
        }
        MFWDSConnectionSpec myResolvedSpec = MFWUserPool.getInstance().getConnectionSpec((MFWRequestContext)aContext, dsSelection);
        boolean isUnix = "/".equals(System.getProperty("file.separator"));
        if (!isUnix && myResolvedSpec.getCryptoHandle() != null) {
            this.getMetadataSource().addSignon("SSODelegationHandle", (Object)myResolvedSpec.getCryptoHandle());
        }
        if (myResolvedSpec.getCubeAuthenticationNamespace() != null) {
            this.getMetadataSource().addSignon("namespace", (Object)myResolvedSpec.getCubeAuthenticationNamespace());
        }
        if (myResolvedSpec.getTicket() != null) {
            this.getMetadataSource().addSignon("ASTicket", (Object)myResolvedSpec.getTicket());
        }
        if (myResolvedSpec.getConnectionSearchPath() != null) {
            this.getMetadataSource().addSignon("searchPath", (Object)myResolvedSpec.getConnectionSearchPath());
        }
        if ((cubePasswordStr = this.getConnectionValueFor(connectionSpec, sCmDataSrc, "cubePassword")) != null && cubePasswordStr.length() > 0) {
            this.getMetadataSource().addSignon("cubePassword", (Object)cubePasswordStr);
        }
        if (myResolvedSpec.getSignonUserID() != null) {
            this.getMetadataSource().addSignon("username", (Object)myResolvedSpec.getSignonUserID());
        }
        if (myResolvedSpec.getSignonUserPWD() != null) {
            this.getMetadataSource().addSignon("password", (Object)myResolvedSpec.getSignonUserPWD());
        }
        MFWConnectionStringParser myConnParser = new MFWConnectionStringParser(myResolvedSpec.getConnectionString());
        Map mapConfigConnItems = aConfigSrc.getConnectionItems();
        for (Map.Entry aPair : mapConfigConnItems.entrySet()) {
            String itemKey = (String)aPair.getKey();
            String itemValue = (String)aPair.getValue();
            String sConnItem = myConnParser.getValue(itemKey);
            if (sConnItem == null || sConnItem.length() == 0) continue;
            this.getMetadataSource().addConnectionItem(itemValue == null || itemValue.length() == 0 ? itemKey : itemValue, (Object)sConnItem);
        }
    }

    private String getConnectionValueFor(Element elmConn, String sCMDataSrc, String sPropName) {
        Node searchPath;
        String sPropValue = "";
        if (elmConn == null) {
            return sPropValue;
        }
        Node nodeProp = elmConn.selectSingleNode("//connection/dataSource[@value='" + sCMDataSrc + "']");
        if (nodeProp != null && nodeProp instanceof Element && (searchPath = nodeProp.getParent().selectSingleNode(sPropName)) != null) {
            sPropValue = ((Element)searchPath).attributeValue("value");
        }
        return sPropValue;
    }

    String queryCubeLastSchemaUpdate(MFWRequestContextUser aContext) {
        ArrayList<MFWOLAPSchema.DimObjectSpec> specs = new MFWOLAPSchema().getObjectSpecs(MFWModelRes.getInstance().RID_dataSource);
        MFWException.ASSERT((specs.size() == 1 ? 1 : 0) != 0, (String)"Expecting exactly one OLAP object spec for 'data source'");
        MFWOLAPSchema.DimObjectSpec cubeSpec = specs.get(0);
        MFWMetadataRequest cubeReq = new MFWMetadataRequest(cubeSpec.getOLAPMetadataClass(), 0, 0, 0);
        MFWDimConnection.makeConnection(aContext, cubeReq, this.getMetadataSource(), aContext.getContentLocale(), MFWConfiguration.getInstance().getConfigInfoFor(this.getMetadataSource().getType()));
        cubeReq.addProperty("Last_Schema_Update");
        String scopeItem = (String)this.getMetadataSource().getScope("catalog");
        if (scopeItem != null && scopeItem.length() > 0) {
            cubeReq.addConstraint("Catalog_Name", scopeItem);
        }
        if ((scopeItem = (String)this.getMetadataSource().getScope("schema")) != null && scopeItem.length() > 0) {
            cubeReq.addConstraint("Schema_Name", scopeItem);
        }
        if ((scopeItem = (String)this.getMetadataSource().getScope("cube")) != null && scopeItem.length() > 0) {
            cubeReq.addConstraint("Cube_Name", scopeItem);
        }
        MFWV5Bridge myV5Bridge = MFWV5Bridge.create(aContext);
        MFWMetadataResponse cubeResp = MFWMetadataRequest.doMetadataRequest(aContext.getContentLocale(), this.getMetadataSource(), cubeReq, myV5Bridge);
        myV5Bridge.terminate();
        Element firstEntry = cubeResp.getFirstEntity();
        MFWException.ASSERT((firstEntry != null ? 1 : 0) != 0, (String)"Expecting a response entry in response to a cube properties");
        return MFWMetadataResponse.getPropertyValue(firstEntry, "Last_Schema_Update");
    }
}

