/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorDimMDDS;

import java.util.ArrayList;

final class MFWMUNTransformations {
    static final int inName = 0;
    static final int inWhitespaceBeforeName = 1;
    static final int inWhitespaceAfterName = 2;

    MFWMUNTransformations() {
    }

    static String providerMUNToCognosMUN(String providerType, String providerMUN) {
        String cognosMUN = null;
        if (providerMUN == "") {
            return "";
        }
        String sConvertedUName = null;
        sConvertedUName = "PC".equals(providerType) || "XO".equals(providerType) ? MFWMUNTransformations.StripProviderMUNHead(2, providerMUN) : providerMUN;
        cognosMUN = ":";
        cognosMUN = cognosMUN + "[";
        cognosMUN = cognosMUN + providerType;
        cognosMUN = cognosMUN + "].";
        cognosMUN = cognosMUN + sConvertedUName;
        return cognosMUN;
    }

    private static String StripProviderMUNHead(int stripCount, String memberName) {
        String tailName = "";
        ArrayList<String> nameParts = new ArrayList<String>();
        MFWMUNTransformations.QFS_ExtractNamePartsFromString(memberName, nameParts);
        for (int i = stripCount; i < nameParts.size(); ++i) {
            if (i > stripCount) {
                tailName = tailName + ".";
            }
            tailName = tailName + "[";
            int pos = 0;
            StringBuffer tempStr = new StringBuffer(nameParts.get(i));
            while ((pos = tempStr.indexOf("]", pos)) != -1) {
                tempStr.insert(pos, "]");
                pos += 2;
            }
            tailName = tailName + tempStr.toString();
            tailName = tailName + "]";
        }
        return tailName;
    }

    private static boolean QFS_ExtractNamePartsFromString(String nameStr, ArrayList<String> nameParts) {
        int lexState = 1;
        int inStrLength = nameStr.length();
        for (int idx = 0; idx < inStrLength; ++idx) {
            int back;
            char symb = nameStr.charAt(idx);
            if (symb == '[' && lexState == 1) {
                lexState = 0;
                nameParts.add("");
                continue;
            }
            if (symb == ']' && lexState == 0) {
                if (idx < inStrLength - 1 && nameStr.charAt(++idx) == ']') {
                    back = nameParts.size() - 1;
                    nameParts.set(back, nameParts.get(back) + "]");
                    continue;
                }
                lexState = 2;
                --idx;
                continue;
            }
            if (symb == '.' && lexState == 2) {
                lexState = 1;
                continue;
            }
            if (symb == '.' && lexState == 1) {
                nameParts.add("");
                continue;
            }
            if (lexState != 0) break;
            back = nameParts.size() - 1;
            nameParts.set(back, nameParts.get(back) + symb);
        }
        if (lexState == 0) {
            return false;
        }
        if (lexState == 1) {
            nameParts.add("");
        }
        return true;
    }
}

