/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorDimMDDS;

import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.log.MFWLogDimAdaptorTraceEvent;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWMessage;
import com.cognos.mfw4j.utilities.QFException;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWMetadataResponse;
import com.cognos.mfwa4j.v5Bridge.MFWV5Bridge;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

final class MFWMetadataRequest {
    private Element mCommand = null;
    private Element mConnection = null;
    private Element mMetadata = null;
    private Element mConstraints = null;
    private Element mProperties = null;
    private Element mAliasTableMap = null;
    private StringBuffer mRequestID = null;

    static MFWMetadataResponse doMetadataRequest(String contentLocale, MFWMetadataSource aMetadataSrc, MFWMetadataRequest mdRequest, MFWV5Bridge v5Bridge) {
        MFWException.ASSERT((mdRequest.mCommand != null && mdRequest.mMetadata != null ? 1 : 0) != 0, (String)"The request is not valid");
        String strRequest = mdRequest.mCommand.asXML();
        Element domResponse = null;
        String strClass = mdRequest.mMetadata.attributeValue("class");
        MFWLogDimAdaptorTraceEvent log = new MFWLogDimAdaptorTraceEvent();
        log.logMDRequest(strClass, strRequest);
        try {
            domResponse = v5Bridge.doV5Request(mdRequest.mRequestID.toString(), strRequest);
            log.logMDResponse(strClass, domResponse.asXML());
        }
        catch (QFException qe) {
            StringBuffer temp = new StringBuffer(strClass);
            temp.append("***Failed");
            log.logMDResponse(temp.toString(), qe.getMessage());
            MFWMetadataRequest.handleMDDSException(contentLocale, aMetadataSrc, mdRequest, qe);
            throw qe;
        }
        catch (RuntimeException rt) {
            StringBuffer temp = new StringBuffer(strClass);
            temp.append("***Failed");
            log.logMDResponse(temp.toString(), rt.getMessage());
            throw rt;
        }
        return new MFWMetadataResponse(domResponse);
    }

    MFWMetadataRequest(String className) {
        this.initialize(className, 0, 0, 0);
    }

    MFWMetadataRequest(String className, int iDepth, int iStart, int iCount) {
        this.initialize(className, iDepth, iStart, iCount);
    }

    private void initialize(String className, int iDepth, int iStart, int iCount) {
        Document document = DocumentHelper.createDocument();
        this.mCommand = document.addElement("command");
        if (className != null && className.length() > 0) {
            this.mMetadata = this.mCommand.addElement("metadata");
            this.mMetadata.addAttribute("class", className);
            this.mMetadata.addAttribute("returnSchema", "false");
            this.mMetadata.addAttribute("depth", Integer.toString(iDepth));
            this.mMetadata.addAttribute("resultStart", Integer.toString(iStart));
            this.mMetadata.addAttribute("resultCount", Integer.toString(iCount));
            if ("Members".equals(className)) {
                Element elmCalcMems = this.mMetadata.addElement("includeCalculatedMembers");
                elmCalcMems.addAttribute("value", "true");
            }
        }
        this.mRequestID = new StringBuffer(className);
    }

    String getMetadataClass() {
        return this.mMetadata.attributeValue("class");
    }

    void addConnectionEntry(String entryName, String entryValue) {
        if ("cmDataSource".equals(entryName)) {
            return;
        }
        if (this.mConnection == null) {
            this.mConnection = this.mCommand.addElement("connection");
        }
        Element elmEntry = this.mConnection.addElement(entryName);
        elmEntry.addAttribute("value", entryValue);
    }

    void addProperty(String propName) {
        if (this.mProperties == null) {
            this.mProperties = this.mMetadata.addElement("properties");
        }
        Element elmProp = this.mProperties.addElement("property");
        StringBuffer temp = new StringBuffer("./@");
        temp.append(propName);
        elmProp.addAttribute("name", temp.toString());
    }

    void addConstraint(String constName, String constValue) {
        if (this.mConstraints == null) {
            this.mConstraints = this.mMetadata.addElement("constraints");
        }
        Element elmProp = this.mConstraints.addElement("constraint");
        StringBuffer constraint = new StringBuffer(".[@");
        constraint.append(constName);
        constraint.append("='");
        constraint.append(constValue);
        constraint.append("']");
        elmProp.addAttribute("condition", constraint.toString());
        this.mRequestID.append("_");
        this.mRequestID.append(constValue);
    }

    void addConstraint(String condition) {
        if (this.mConstraints == null) {
            this.mConstraints = this.mMetadata.addElement("constraints");
        }
        Element elmProp = this.mConstraints.addElement("constraint");
        elmProp.addAttribute("condition", condition);
    }

    void addAliasTable(String locale, String tableName) {
        if (this.mAliasTableMap == null) {
            this.mAliasTableMap = this.mCommand.addElement("aliasTableMap");
        }
        Element elmTable = this.mAliasTableMap.addElement("aliasTable");
        elmTable.addAttribute("lang", locale);
        if (tableName != null && tableName.length() > 0) {
            elmTable.addAttribute("name", tableName);
        }
    }

    private static void handleMDDSException(String contentLocale, MFWMetadataSource aMetadataSrc, MFWMetadataRequest mdRequest, QFException qe) {
        String faultSubCodeStr = null;
        MFWMessage faultMessage = null;
        switch (qe.getErrorCode()) {
            case -5000043: 
            case -5000042: {
                faultSubCodeStr = "1";
                faultMessage = new MFWMessage("mfwa4j", "DIM_ERR_FAILED_MISSING_UID", null);
                break;
            }
            case -5000044: {
                faultSubCodeStr = "2";
                faultMessage = new MFWMessage("mfwa4j", "DIM_ERR_INVALID_CONNECTION_STRING", null);
                break;
            }
            case -5000045: {
                faultSubCodeStr = "3";
                faultMessage = new MFWMessage("mfwa4j", "DIM_ERR_INVALID_SERVER", null);
                break;
            }
            case -5050102: 
            case -5000046: 
            case -3000350: {
                faultSubCodeStr = "4";
                faultMessage = new MFWMessage("mfwa4j", "DIM_ERR_FAILED_NO_CONNECT", null);
                break;
            }
            case -5000048: {
                faultSubCodeStr = "6";
                faultMessage = new MFWMessage("mfwa4j", "DIM_ERR_INVALID_CUBE_PASSWORD", null);
                break;
            }
            default: {
                throw qe;
            }
        }
        Element originalExcpDom = qe.getDOM();
        Document document = DocumentHelper.createDocument();
        Element elmFault = document.addElement("Fault");
        MFWMetadataRequest.createElementWithText(elmFault, "faultCode", "CQE_803");
        Element elmFSC = MFWMetadataRequest.createElementWithText(elmFault, "faultSubcode", faultSubCodeStr);
        Node securityProblem = originalExcpDom.selectSingleNode("//securityProblem");
        if (securityProblem != null) {
            elmFSC.addAttribute("needUserClass", ((Element)securityProblem).attributeValue("needUserClass"));
            elmFSC.addAttribute("needPassword", ((Element)securityProblem).attributeValue("needPassword"));
        }
        MFWMetadataRequest.createElementWithText(elmFault, "faultDataSource", (String)aMetadataSrc.getConnectionItem("cmDataSource"));
        Element elmFaultConn = elmFault.addElement("faultConnection");
        Node searchPathList = mdRequest.mConnection.selectSingleNode("//searchPath");
        if (searchPathList != null) {
            Node temp = (Node)searchPathList.clone();
            temp.detach();
            elmFaultConn.add(temp);
        }
        Element elmFaultDS = elmFault.addElement("dataSource");
        MFWMetadataRequest.createElementWithAttribute(elmFaultDS, "name", "value", (String)aMetadataSrc.getConnectionItem("cmDataSource"));
        MFWMetadataRequest.createElementWithAttribute(elmFaultDS, "type", "value", aMetadataSrc.getType());
        MFWMessage msg = new MFWMessage("mfwa4j", "DIM_ERR_CONNECTION_FAULT", null);
        MFWMetadataRequest.createElementWithText(elmFault, "faultSubstring", msg.render(contentLocale));
        QFException ambiguousExp = new QFException(803);
        ambiguousExp.setDOM(elmFault);
        ambiguousExp.addMessage(faultMessage);
        throw ambiguousExp;
    }

    private static Element createElementWithAttribute(Element elmPrent, String tag, String attrName, String attrValue) {
        Element elm = elmPrent.addElement(tag);
        elm.addAttribute(attrName, attrValue);
        return elm;
    }

    private static Element createElementWithText(Element elmPrent, String tag, String text) {
        Element elm = elmPrent.addElement(tag);
        if (text != null) {
            elm.setText(text);
        }
        return elm;
    }
}

