/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorFM;

import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoObject;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeLink;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import com.cognos.mfwa4j.adaptorFM.MFWFmConnection;
import com.cognos.mfwa4j.adaptorFM.MFWFmDynamicSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

final class MFWFmModelLoader
extends DefaultHandler {
    private static final String TAG_CONNECTION = "connection";
    private static final String TAG_DQUOTE = "\"";
    private static final String TAG_DYNAMICSOURCE = "dynamicSource";
    private static final String TAG_EQ_DQUOTE = "=\"";
    private static final String TAG_EXTERNALNAME = "externalName";
    private static final String TAG_LEFT = "left";
    private static final String TAG_LINKEDNODE = "linkedNode";
    private static final String TAG_MDDIMENSION = "mdDimension";
    private static final String TAG_NAME = "name";
    private static final String TAG_QUERYPATH = "queryPath";
    private static final String TAG_RIGHT = "right";
    private static final String TAG_SCOPE = "scope";
    private static final String TAG_SIGNON = "signon";
    private static final String TAG_SOURCE = "source";
    private static final String TAG_SPACE = " ";
    private static final String TAG_TYPE = "type";
    private static final String TAG_VALUE = "value";
    private static final String TAG_PARAMETERMAPENTRY = "parameterMapEntry";
    private static final String TAG_refobjViaShortcut = "refobjViaShortcut";
    private static final String TAG_expression = "expression";
    private static final String[] gSkippedElements = new String[]{"access", "aggregateRules", "dataSources", "decisionRole", "definition", "determinants", "filters", "functionSets", "locales", "memberSort", "physicalSources", "previewFilters", "procParameters", "project", "promptInfo", "qosOverrides", "roles", "securityFilters", "sources"};
    private static final String[] gQSubjDefinitionTypes = new String[]{"dbQuery", "mdQuery", "modelQuery", "queryOperation", "storedProcedure"};
    private static final String[] gTreatedAsText = new String[]{"expression", "format", "sql"};
    private static final String[] gRelationshipTypes = new String[]{"relationship", "relationshipShortcut", "scopeRelationship"};
    private static final String[] gRelationshipEndProps = new String[]{"maxcard", "mincard", "refobj"};
    private static final String[] gSpecialCustomProps = new String[]{"PPDS_CODE", "rootMemberRollup", "sourceType", "sourcePath"};
    private static final String[] gLinkedSourcesSpec = new String[]{"connection", "scope", "signon"};
    private MFWModelRes mModelRes = null;
    private MFWFmConnection mOwnerConnection = null;
    private Stack<MFWNodeObject> mElements = new Stack();
    private StringBuilder mText;
    private StringBuilder mUnTaggedExpr;
    private boolean mDoUnTagExpr;
    private boolean mIgnore;
    private String mIgnoreTag;
    private boolean mTreatedAsText;
    private boolean mRelationLeft;
    private boolean mRelationRight;
    private boolean mCollectSecurityObj;
    private SortedSet<String> mSecurityObjs;
    private boolean mParsingParameterMapEntry = false;
    private boolean mLinkedNode;
    private boolean mLinkedSource;
    private short mLinkNodeRID;
    private MFWMetadataSource mLinkedSrc;
    private String mLinkedNodeQuery;
    private MFWInfoProperty mCurrentProp;
    private SortedSet<String> mSecurityFilterViewRefs;

    MFWFmModelLoader(MFWRequestContextUser aContext, MFWFmConnection fmConnection) {
        this.mElements.add(fmConnection.getProjectNode());
        this.mModelRes = MFWModelRes.getInstance();
        this.mOwnerConnection = fmConnection;
        this.mText = new StringBuilder("");
        this.mUnTaggedExpr = new StringBuilder("");
        this.mDoUnTagExpr = false;
        this.mIgnore = false;
        this.mIgnoreTag = null;
        this.mTreatedAsText = false;
        this.mRelationLeft = false;
        this.mRelationRight = false;
        this.mCollectSecurityObj = false;
        this.mSecurityObjs = new TreeSet<String>();
        this.mSecurityFilterViewRefs = new TreeSet<String>();
        this.mLinkedNode = false;
        this.mLinkedSource = false;
        this.mLinkNodeRID = (short)-1;
        this.mLinkedSrc = null;
        this.mLinkedNodeQuery = null;
    }

    public void destroy() {
        this.mModelRes = null;
        this.mOwnerConnection = null;
        this.mElements.clear();
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.mIgnore || this.contains(qName, gSkippedElements) || this.otherSkips(qName, (MFWNode)this.mElements.peek())) {
            return;
        }
        if (TAG_PARAMETERMAPENTRY.equals(qName)) {
            this.mParsingParameterMapEntry = true;
        }
        if (this.contains(qName, gTreatedAsText)) {
            this.mTreatedAsText = true;
            this.mDoUnTagExpr = TAG_expression.equals(qName);
            this.treatAsText(true, qName, attributes);
        } else {
            if (this.mTreatedAsText) {
                this.treatAsText(true, qName, attributes);
                return;
            }
            if (TAG_LEFT.equals(qName) && this.contains(this.mElements.peek().getName(), gRelationshipTypes)) {
                this.mRelationLeft = true;
                return;
            }
            if (TAG_RIGHT.equals(qName) && this.contains(this.mElements.peek().getName(), gRelationshipTypes)) {
                this.mRelationRight = true;
                return;
            }
            if (this.isLinkedNodeBegin(qName, attributes)) {
                return;
            }
        }
        if (qName == TAG_MDDIMENSION) {
            qName = TAG_EXTERNALNAME;
        } else if (this.contains(qName, gRelationshipEndProps)) {
            StringBuilder temp = new StringBuilder();
            if (this.mRelationLeft) {
                temp.append(TAG_LEFT);
            }
            if (this.mRelationRight) {
                temp.append(TAG_RIGHT);
            }
            temp.append(qName);
            qName = temp.toString();
        }
        if (!this.mTreatedAsText) {
            this.mText.setLength(0);
        }
        MFWNodeObject topNode = this.mElements.peek();
        if (this.contains(qName, gQSubjDefinitionTypes)) {
            topNode.addProperty(this.mModelRes.RID_definitionType, qName);
            return;
        }
        MFWInfo childInfo = this.lookupChildInfo(topNode, qName);
        if (childInfo == null) {
            this.mIgnore = true;
            this.mIgnoreTag = qName;
            if (this.mTreatedAsText) {
                this.mTreatedAsText = false;
                this.mText.setLength(0);
                this.mUnTaggedExpr.setLength(0);
            }
            return;
        }
        if (childInfo.getNodeType() == 1) {
            this.mCurrentProp = (MFWInfoProperty)childInfo;
        } else {
            this.mCurrentProp = null;
            MFWNodeObject objNode = null;
            if (childInfo.getRID() == this.mModelRes.RID_securityViews || childInfo.getRID() == this.mModelRes.RID_parameterMaps) {
                objNode = topNode.getObjectNode(childInfo.getRID());
            }
            if (objNode == null) {
                objNode = topNode.addObjectNode(childInfo.getRID());
            }
            this.mElements.push(objNode);
            this.mCollectSecurityObj = this.mCollectSecurityObj || childInfo.getRID() == this.mModelRes.RID_securityFilterDefinition;
            for (int idx = 0; idx < attributes.getLength(); ++idx) {
                MFWInfo attrInfo = this.lookupChildInfo(objNode, attributes.getQName(idx));
                if (attrInfo == null) continue;
                if (attrInfo.getRID() == this.mModelRes.RID_locale) {
                    objNode.addProperty(attrInfo.getRID(), MFWStringHelper.normalizeCRNLocale((String)attributes.getValue(idx)));
                    continue;
                }
                objNode.addProperty(attrInfo.getRID(), attributes.getValue(idx));
            }
        }
    }

    @Override
    public final void endElement(String uri, String localName, String qName) {
        String textValue;
        if (TAG_PARAMETERMAPENTRY.equals(qName)) {
            this.mParsingParameterMapEntry = false;
        }
        if (this.mIgnore) {
            if (qName.equals(this.mIgnoreTag)) {
                this.mIgnore = false;
                this.mIgnoreTag = null;
            }
            return;
        }
        if (this.contains(qName, gSkippedElements) || this.contains(qName, gQSubjDefinitionTypes) || this.otherSkips(qName, (MFWNode)this.mElements.peek())) {
            return;
        }
        if (this.isLinkedNodeEnd(qName)) {
            return;
        }
        if (this.mTreatedAsText) {
            this.endAsTextTreatedProperty(qName);
            return;
        }
        if (TAG_LEFT.equals(qName)) {
            this.mRelationLeft = false;
            return;
        }
        if (TAG_RIGHT.equals(qName)) {
            this.mRelationRight = false;
            return;
        }
        MFWNodeObject topNode = this.mElements.peek();
        boolean trimTheValue = true;
        if (TAG_EXTERNALNAME.equals(qName) || this.mParsingParameterMapEntry && TAG_VALUE.equals(qName)) {
            trimTheValue = false;
        }
        String string = textValue = trimTheValue ? MFWFmModelLoader.myTrim(this.mText) : this.mText.toString();
        if (textValue != null && textValue.length() > 0) {
            if (this.mCurrentProp == null) {
                topNode.addProperty(this.mModelRes.RID__Value, textValue);
            } else if (this.mCurrentProp.getRID() == this.mModelRes.RID_locale || this.mCurrentProp.getRID() == this.mModelRes.RID_defaultLocale) {
                topNode.addProperty(this.mCurrentProp.getRID(), MFWStringHelper.normalizeCRNLocale((String)textValue));
            } else {
                topNode.addProperty(this.mCurrentProp.getRID(), textValue);
            }
        }
        this.mOwnerConnection.getIDGenerator().generate(topNode, this.mCurrentProp);
        this.mText.setLength(0);
        if (this.mCurrentProp != null) {
            if (this.mCollectSecurityObj) {
                if (this.mCurrentProp.getRID() == this.mModelRes.RID_cmSearchPath) {
                    if (textValue != null && textValue.length() > 0) {
                        this.mSecurityObjs.add(textValue);
                    }
                    this.mCollectSecurityObj = false;
                } else if (this.mCurrentProp.getRID() == this.mModelRes.RID_viewref) {
                    if (textValue != null && textValue.length() > 0) {
                        this.mSecurityFilterViewRefs.add(textValue);
                    }
                    this.mCollectSecurityObj = false;
                }
            }
            this.mCurrentProp = null;
        } else {
            String nameProp;
            this.mElements.pop();
            if (topNode.getNameRID() == this.mModelRes.RID_property && (nameProp = topNode.getPropertyValue(this.mModelRes.RID_name)) != null) {
                if (this.contains(nameProp, gSpecialCustomProps)) {
                    this.fixCustomProperty(topNode, nameProp);
                } else if (TAG_DYNAMICSOURCE.equals(nameProp)) {
                    this.setupLinkToLWMSource(topNode);
                }
            }
        }
    }

    private void endAsTextTreatedProperty(String qName) {
        String unTaggedTextValue;
        MFWException.ASSERT((this.mCurrentProp != null ? 1 : 0) != 0, (String)"Expecting a valid text-treated property");
        this.treatAsText(false, qName, null);
        if (!this.contains(qName, gTreatedAsText)) {
            return;
        }
        this.mTreatedAsText = false;
        String textValue = MFWFmModelLoader.myTrim(this.mText);
        if (textValue != null && textValue.length() > 0) {
            this.mElements.peek().addProperty(this.mCurrentProp.getRID(), textValue);
        }
        this.mText.setLength(0);
        if (this.mDoUnTagExpr && this.mUnTaggedExpr.length() > 0 && (unTaggedTextValue = MFWFmModelLoader.myTrim(this.mUnTaggedExpr)) != null && unTaggedTextValue.length() > 0) {
            this.mElements.peek().addProperty(this.mModelRes.RID_unTaggedExpression, unTaggedTextValue);
        }
        this.mDoUnTagExpr = false;
        this.mUnTaggedExpr.setLength(0);
        this.mCurrentProp = null;
    }

    @Override
    public final void characters(char[] data, int posStart, int length) {
        if (this.mIgnore) {
            return;
        }
        if (this.mTreatedAsText) {
            MFWFmModelLoader.myXmlEncodeAndAppend(data, posStart, length, this.mText);
            if (this.mDoUnTagExpr) {
                this.mUnTaggedExpr.append(data, posStart, length);
            }
        } else {
            this.mText.append(data, posStart, length);
        }
    }

    private boolean isFmModelWithRelationalDataources(MFWNodeObject projectRootNode) {
        MFWException.ASSERT((projectRootNode != null ? 1 : 0) != 0, (String)"Invalid root node to determine if FM model is relational");
        for (Object dataSource : projectRootNode.getObjectNodes(this.mModelRes.RID_dataSource)) {
            MFWNodeObject datasourceObjectNode;
            if (!(dataSource instanceof MFWNodeObject) || (datasourceObjectNode = (MFWNodeObject)dataSource).getNameRID() != this.mModelRes.RID_dataSource) continue;
            String queryType = datasourceObjectNode.getPropertyValue(this.mModelRes.RID_queryType);
            if (queryType == null) {
                return true;
            }
            if (!"relational".equals(queryType)) continue;
            return true;
        }
        return false;
    }

    void doPostLoad(MFWNodeObject projNode, MFWMetadataSource aSource) {
        MFWNodeObject objDataSecurity = null;
        if (!this.mSecurityObjs.isEmpty()) {
            objDataSecurity = projNode.addObjectNode(this.mModelRes.RID_modelDataSecurityObjects);
            for (String secObj : this.mSecurityObjs) {
                objDataSecurity.addProperty(this.mModelRes.RID_cmSearchPath, secObj);
            }
        }
        if (!this.mSecurityFilterViewRefs.isEmpty()) {
            objDataSecurity = projNode.addObjectNode(this.mModelRes.RID_modelDataViewrefObjects);
            for (String secObj : this.mSecurityFilterViewRefs) {
                objDataSecurity.addProperty(this.mModelRes.RID_viewref, secObj);
            }
        }
        this.setupLinkToImpliedFmPhysicalSource(projNode, aSource);
    }

    private void setupLinkToImpliedFmPhysicalSource(MFWNodeObject projectRootNode, MFWMetadataSource aSource) {
        String modelFilePath;
        MFWException.ASSERT((projectRootNode != null ? 1 : 0) != 0, (String)"Invalid root node for physical source to FM model");
        if (!this.isFmModelWithRelationalDataources(projectRootNode)) {
            return;
        }
        short ridPhysicalSrc = this.mModelRes.getResourceID("physicalSource");
        List projLinks = projectRootNode.getLinkNodes();
        for (int idx = 0; projLinks != null && idx < projLinks.size(); ++idx) {
            MFWNodeLink aProjLink = (MFWNodeLink)projLinks.get(idx);
            if (aProjLink.getLinkChildRID() != ridPhysicalSrc) continue;
            return;
        }
        MFWMetadataSource aPhysSourceStatic = MFWMetadataSource.create((String)"modelPhysicalFM");
        String modelCMPath = (String)aSource.getConnectionItem("cmSearchPath");
        if (modelCMPath != null) {
            aPhysSourceStatic.addConnectionItem("cmSearchPath", (Object)modelCMPath);
        }
        if ((modelFilePath = (String)aSource.getConnectionItem("modelFilePath")) != null) {
            aPhysSourceStatic.addConnectionItem("modelFilePath", (Object)modelFilePath);
        }
        short idLinkSrcStatic = this.mOwnerConnection.getCluster().getLinkManager().findOrAddLink(aPhysSourceStatic, projectRootNode);
        projectRootNode.addLinkNode(ridPhysicalSrc, idLinkSrcStatic, "/physicalSources/physicalSource");
        projectRootNode.addLinkNode(this.mModelRes.RID_physMDExtractFeedback, idLinkSrcStatic, "/physicalSources/physMDExtractFeedback");
    }

    private final boolean isLinkedNodeBegin(String sName, Attributes atts) {
        boolean bResult = false;
        if (TAG_LINKEDNODE.equals(sName)) {
            this.beginLinkedNode(atts);
            bResult = true;
        } else if (this.mLinkedNode && TAG_SOURCE.equals(sName)) {
            this.beginLinkedSource(atts);
            bResult = true;
        } else if (this.mLinkedNode && TAG_QUERYPATH.equals(sName)) {
            MFWException.ASSERT((atts != null && atts.getLength() == 1 && TAG_VALUE.equals(atts.getQName(0)) ? 1 : 0) != 0, (String)"Expecting a valid 'value' attribute for link queryPath element");
            this.mLinkedNodeQuery = atts.getValue(0);
            bResult = true;
        } else if (this.mLinkedSource && this.contains(sName, gLinkedSourcesSpec)) {
            this.doLinkedSourceSpec(sName, atts);
            bResult = true;
        }
        return bResult;
    }

    private final void beginLinkedSource(Attributes atts) {
        this.mLinkedSource = true;
        MFWException.ASSERT((atts != null && atts.getLength() == 1 && TAG_TYPE.equals(atts.getQName(0)) ? 1 : 0) != 0, (String)"Expecting a valid 'type' attribute for link source element");
        this.mLinkedSrc = MFWMetadataSource.create((String)atts.getValue(0));
    }

    private final void beginLinkedNode(Attributes atts) {
        MFWException.ASSERT((!this.mLinkedNode ? 1 : 0) != 0, (String)"Nested linked nodes are not expected");
        this.mLinkedNode = true;
        MFWException.ASSERT((atts != null && atts.getLength() == 1 && TAG_TYPE.equals(atts.getQName(0)) ? 1 : 0) != 0, (String)"Expecting a valid 'type' attribute for link element");
        MFWNodeObject topNode = this.mElements.peek();
        MFWInfo childInfo = this.lookupChildInfo(topNode, atts.getValue(0));
        MFWException.ASSERT((childInfo != null ? 1 : 0) != 0, (String)atts.getValue(0), (String)" is not a valid child for the parent and cannot be used as a linked node");
        this.mLinkNodeRID = childInfo.getRID();
    }

    private final boolean isLinkedNodeEnd(String sName) {
        boolean bResult = false;
        if (TAG_LINKEDNODE.equals(sName)) {
            this.endLinkedNode();
            bResult = true;
        } else if (this.mLinkedSource && TAG_SOURCE.equals(sName)) {
            this.mLinkedSource = false;
            bResult = true;
        } else if (this.mLinkedNode && TAG_QUERYPATH.equals(sName)) {
            bResult = true;
        } else if (this.mLinkedSource && this.contains(sName, gLinkedSourcesSpec)) {
            bResult = true;
        }
        return bResult;
    }

    private final void doLinkedSourceSpec(String sName, Attributes atts) {
        MFWException.ASSERT((atts != null && atts.getLength() == 2 && TAG_NAME.equals(atts.getQName(0)) && TAG_VALUE.equals(atts.getQName(1)) ? 1 : 0) != 0, (String)"Expecting valid 'name' and 'value' attributes for link source element");
        String sNameAttr = atts.getValue(0);
        String sValueAttr = atts.getValue(1);
        if (TAG_CONNECTION.equals(sName)) {
            this.mLinkedSrc.addConnectionItem(sNameAttr, (Object)sValueAttr);
        } else if (TAG_SCOPE.equals(sName)) {
            this.mLinkedSrc.addScope(sNameAttr, (Object)sValueAttr);
        } else if (TAG_SIGNON.equals(sName)) {
            this.mLinkedSrc.addSignon(sNameAttr, (Object)sValueAttr);
        } else {
            MFWException.ASSERT((boolean)false, (String)"Unexpected linked source connection spec:", (String)sName);
        }
    }

    private final void endLinkedNode() {
        MFWException.ASSERT((this.mLinkedSrc != null ? 1 : 0) != 0, (String)"The linked node source cannot be NULL");
        MFWException.ASSERT((this.mLinkNodeRID != -1 ? 1 : 0) != 0, (String)"The linked node type cannot be unknown");
        MFWException.ASSERT((this.mLinkedNodeQuery != null ? 1 : 0) != 0, (String)"The linked node query path cannot be empty");
        MFWNodeObject parentNode = this.mElements.peek();
        short idLinkSrc = this.mOwnerConnection.getCluster().getLinkManager().findOrAddLink(this.mLinkedSrc, parentNode);
        this.mLinkedSrc = null;
        this.mLinkedNode = false;
        parentNode.addLinkNode(this.mLinkNodeRID, idLinkSrc, this.mLinkedNodeQuery);
    }

    void setupLinkToLWMSource(MFWNodeObject dynSrcNode) {
        String valueProp = dynSrcNode.getPropertyValue(this.mModelRes.RID__Value);
        if (valueProp == null) {
            return;
        }
        MFWNodeObject linkParent = dynSrcNode.getParentObject();
        ArrayList outList = new ArrayList(1);
        linkParent.findObjectNodes(this.mModelRes.RID_property, this.mModelRes.RID_name, "dynamicContent", outList);
        if (outList.size() != 1 || !"true".equals(((MFWNodeObject)outList.get(0)).getPropertyValue(this.mModelRes.RID__Value))) {
            return;
        }
        MFWFmDynamicSource dynSrc = MFWFmDynamicSource.create(valueProp);
        MFWMetadataSource aLWMSrc = MFWMetadataSource.create((String)dynSrc.getDataSourceType());
        aLWMSrc.addConnectionItem("cmDataSource", (Object)dynSrc.getCMDataSource());
        String tempValue = dynSrc.getOtherValue("attributeDimensionsAsProperties");
        if ("false".equals(tempValue)) {
            aLWMSrc.addConnectionItem("attribute", (Object)"dimension");
        }
        if (dynSrc.getCatalog() != null) {
            aLWMSrc.addScope("catalog", (Object)dynSrc.getCatalog());
        }
        if (dynSrc.getSchema() != null) {
            aLWMSrc.addScope("schema", (Object)dynSrc.getSchema());
        }
        if (dynSrc.getCube() != null) {
            aLWMSrc.addScope("cube", (Object)dynSrc.getCube());
        }
        for (Map.Entry aPair : dynSrc.getAliasInfo()) {
            aLWMSrc.addAlias((String)aPair.getKey(), (Object)((String)aPair.getValue()));
        }
        aLWMSrc.addConnectionItem("queryStack", (Object)this.mOwnerConnection.getQueryStack());
        short idLinkSrc = this.mOwnerConnection.getCluster().getLinkManager().findOrAddLink(aLWMSrc, linkParent);
        linkParent.addLinkNode(this.mModelRes.RID_dimension, idLinkSrc, "/project/namespace[0]/dimension");
        linkParent.addLinkNode(this.mModelRes.RID_folder, idLinkSrc, "/project/namespace[0]/folder");
        linkParent.addLinkNode(this.mModelRes.RID_scopeRelationship, idLinkSrc, "/project/namespace[0]/scopeRelationship");
        linkParent.addLinkNode(this.mModelRes.RID_calculation, idLinkSrc, "/project/namespace[0]/calculation");
        linkParent.addLinkNode(this.mModelRes.RID_shortcut, idLinkSrc, "/project/namespace[0]/shortcut");
        linkParent.addProperty(this.mModelRes.getResourceID("isCube"), true);
        linkParent.addProperty(this.mModelRes.getResourceID("cubeType"), dynSrc.getDataSourceType());
        linkParent.addProperty(this.mModelRes.getResourceID("cubeCMDataSource"), dynSrc.getCMDataSource());
        dynSrc.destroy();
    }

    private boolean contains(String tagName, String[] anArray) {
        boolean bFound = false;
        for (int idx = 0; !bFound && idx < anArray.length; ++idx) {
            bFound = tagName.equals(anArray[idx]);
        }
        return bFound;
    }

    boolean otherSkips(String tagName, MFWNode topNode) {
        return TAG_TYPE.equals(tagName) && topNode.getNameRID() == this.mModelRes.RID_dataSource;
    }

    private void fixCustomProperty(MFWNodeObject objNode, String nameProp) {
        String sValue = objNode.getPropertyValue(MFWModelRes.getInstance().RID__Value);
        if (sValue == null) {
            sValue = "";
        }
        MFWNodeObject parentNode = objNode.getParentObject();
        parentNode.addProperty(this.mModelRes.getResourceID(nameProp), sValue);
    }

    private void treatAsText(boolean bBeginElm, String sElmName, Attributes attributes) {
        if (!bBeginElm) {
            this.mText.append("</");
            this.mText.append(sElmName);
            this.mText.append(">");
            return;
        }
        this.mText.append("<");
        this.mText.append(sElmName);
        for (int idx = 0; attributes != null && idx < attributes.getLength(); ++idx) {
            this.mText.append(TAG_SPACE);
            this.mText.append(attributes.getQName(idx));
            this.mText.append(TAG_EQ_DQUOTE);
            this.mText.append(attributes.getValue(idx));
            this.mText.append(TAG_DQUOTE);
        }
        this.mText.append(">");
        if (this.mDoUnTagExpr && (this.mCurrentProp != null && this.mCurrentProp.getRID() == this.mModelRes.RID_expression || this.mCurrentProp == null && TAG_expression.equals(sElmName)) && TAG_refobjViaShortcut.equals(sElmName)) {
            this.mDoUnTagExpr = false;
            this.mUnTaggedExpr.setLength(0);
        }
    }

    private MFWInfo lookupChildInfo(MFWNodeObject objNode, String childName) {
        MFWInfoObject objInfo = objNode.getObjectInfo();
        MFWInfo anInfo = objInfo.findChildInfo(childName);
        return anInfo;
    }

    private static String myTrim(StringBuilder inStr) {
        int idxEnd;
        int idxBegin;
        String outStr = null;
        if (inStr.length() == 0) {
            return outStr;
        }
        int maxLen = inStr.length();
        for (idxBegin = 0; idxBegin < maxLen && Character.isWhitespace(inStr.charAt(idxBegin)); ++idxBegin) {
        }
        if (idxBegin == maxLen) {
            return null;
        }
        for (idxEnd = maxLen - 1; idxEnd >= 0 && Character.isWhitespace(inStr.charAt(idxEnd)); --idxEnd) {
        }
        outStr = inStr.substring(idxBegin, idxEnd + 1);
        return outStr;
    }

    private static void myXmlEncodeAndAppend(char[] data, int posStart, int length, StringBuilder strAppendTo) {
        block5: for (int idx = posStart; idx < posStart + length; ++idx) {
            char ch = data[idx];
            switch (ch) {
                case '<': {
                    strAppendTo.append("&lt;");
                    continue block5;
                }
                case '>': {
                    strAppendTo.append("&gt;");
                    continue block5;
                }
                case '&': {
                    strAppendTo.append("&amp;");
                    continue block5;
                }
                default: {
                    strAppendTo.append(ch);
                }
            }
        }
    }
}

