/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorOData;

import com.cognos.ccl4j.util.CCLFileUtils;
import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.implPersistence.MFWPersistentMetadataCluster;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import java.io.File;
import java.util.Calendar;

class MFWODataConnectionReuseInfo
extends MFWConnectionReuseInfo {
    private static final String FORWARDSLASH = "/";
    private String cmDataSrc = null;
    private long modifiedTime = 0L;

    MFWODataConnectionReuseInfo(MFWRequestContextUser aContext, MFWMetadataSource aMetadataSrc) {
        super(aMetadataSrc);
        this.cmDataSrc = (String)aMetadataSrc.getConnectionItem("cmDataSource");
        MFWException.ASSERT((this.cmDataSrc != null ? 1 : 0) != 0, (String)"The OData source must contain a cmDataSource connection parameter.");
        String filePath = (String)aMetadataSrc.getConnectionItem("modelFilePath");
        this.modifiedTime = filePath != null ? MFWODataConnectionReuseInfo.getFileModificationTime(filePath) : 0L;
    }

    static MFWODataConnectionReuseInfo reconstruct(MFWPersistentMetadataCluster aPMC, int aPosition) {
        MFWODataConnectionReuseInfo outRI = new MFWODataConnectionReuseInfo();
        outRI.load(aPMC, aPosition);
        return outRI;
    }

    private MFWODataConnectionReuseInfo() {
    }

    protected boolean isReusableFor(MFWConnectionReuseInfo thatReuseInfo) {
        return this.cmDataSrc.equals(thatReuseInfo.getMetadataSource().getConnectionItem("cmDataSource"));
    }

    public StringBuffer getPersistentPath() {
        StringBuffer path = new StringBuffer(MFWConfiguration.getInstance().getPMCDirectoryPath());
        path.append(FORWARDSLASH);
        path.append(MFWStringHelper.cleanupFileName((String)this.cmDataSrc));
        path.append(FORWARDSLASH);
        path.append(Long.toString(this.modifiedTime));
        return path;
    }

    protected boolean isCacheUpToDate(MFWRequestContextUser aContext, MFWConnectionReuseInfo thatReuseInfo) {
        MFWODataConnectionReuseInfo thatOwlReuseInfo = (MFWODataConnectionReuseInfo)thatReuseInfo;
        return this.modifiedTime == thatOwlReuseInfo.modifiedTime;
    }

    private static long getFileModificationTime(String filePath) {
        File aFile = null;
        try {
            aFile = CCLFileUtils.check((String)filePath, (int)49);
        }
        catch (CCLFileUtils.FileCheckException fileCheckException) {
            // empty catch block
        }
        MFWException.ASSERT((aFile != null ? 1 : 0) != 0, (String)"Unable to get the last modification time for:", (String)filePath);
        Calendar lastModified = Calendar.getInstance();
        lastModified.setTimeInMillis(aFile.lastModified());
        return lastModified.getTimeInMillis();
    }
}

