/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorOData;

import org.odata4j.edm.EdmFunctionParameter;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;

final class SimpleDataTypeConverter {
    public static final byte kOperandTypeUnknown = 0;
    public static final byte kOperandTypeUnsupported = 1;
    public static final byte kOperandTypeUnspecified = 2;
    public static final byte kOperandTypeBinary = 3;
    public static final byte kOperandTypeBlob = 4;
    public static final byte kOperandTypeBoolean = 5;
    public static final byte kOperandTypeDatabaseKey = 6;
    public static final byte kOperandTypeDate = 7;
    public static final byte kOperandTypeDateTime = 8;
    public static final byte kOperandTypeNull = 9;
    public static final byte kOperandTypeNumeric = 10;
    public static final byte kOperandTypeString = 11;
    public static final byte kOperandTypeTime = 12;
    public static final byte kOperandTypeTimeInterval = 13;
    public static final byte kOperandTypeTuple = 14;
    public static final byte kOperandTypeYMDInterval = 15;

    SimpleDataTypeConverter() {
    }

    public static DataTypeInfo getMappingInfo(EdmProperty eProperty) {
        Integer scaleObj;
        Integer precisionObj;
        EdmType eType = eProperty.getType();
        String typeName = eType.getFullyQualifiedTypeName();
        EdmSimpleType sType = EdmType.getSimple((String)typeName);
        int maxLength = -1;
        int precision = 256;
        int scale = 0;
        Integer maxLengthObj = eProperty.getMaxLength();
        if (maxLengthObj != null) {
            maxLength = maxLengthObj;
        }
        if ((precisionObj = eProperty.getPrecision()) != null) {
            precision = precisionObj;
        }
        if ((scaleObj = eProperty.getScale()) != null) {
            scale = scaleObj;
        }
        return SimpleDataTypeConverter.getDataTypeInfo(sType, maxLength, precision, scale, eProperty.isNullable());
    }

    public static DataTypeInfo getMappingInfo(EdmFunctionParameter parameter) {
        EdmType eType = parameter.getType();
        Boolean isNullable = parameter.isNullable();
        return SimpleDataTypeConverter.getDataTypeInfo(EdmType.getSimple((String)eType.getFullyQualifiedTypeName()), -1, 256, 0, isNullable != null && isNullable != false);
    }

    private static DataTypeInfo getDataTypeInfo(EdmSimpleType<?> sType, int maxLength, int precision, int scale, boolean isNullable) {
        DataTypeInfo dtInfo = null;
        if (sType == EdmSimpleType.INT16 || sType == EdmSimpleType.SBYTE || sType == EdmSimpleType.BYTE) {
            dtInfo = new DataTypeInfo("int16", 10, 5, 0, 2, isNullable);
        } else if (sType == EdmSimpleType.INT32) {
            dtInfo = new DataTypeInfo("int32", 10, 9, 0, 4, isNullable);
        } else if (sType == EdmSimpleType.INT64) {
            dtInfo = new DataTypeInfo("int64", 10, 19, 0, 8, isNullable);
        } else if (sType == EdmSimpleType.STRING) {
            dtInfo = new DataTypeInfo("characterLength16", 11, maxLength, 0, maxLength * 2 + 2, isNullable);
        } else if (sType == EdmSimpleType.BINARY) {
            dtInfo = new DataTypeInfo("binary", 3, 0, 0, maxLength, isNullable);
        } else if (sType == EdmSimpleType.BOOLEAN) {
            dtInfo = new DataTypeInfo("boolean", 5, 0, 0, 2, isNullable);
        } else if (sType == EdmSimpleType.DECIMAL) {
            dtInfo = new DataTypeInfo("decimal", 10, precision, scale, precision / 2, isNullable);
        } else if (sType == EdmSimpleType.SINGLE) {
            dtInfo = new DataTypeInfo("float32", 10, 38, 0, 4, isNullable);
        } else if (sType == EdmSimpleType.DOUBLE) {
            dtInfo = new DataTypeInfo("float64", 10, 38, 0, 8, isNullable);
        } else if (sType == EdmSimpleType.GUID) {
            dtInfo = new DataTypeInfo("binary", 3, 0, 0, 16, isNullable);
        } else if (sType == EdmSimpleType.DATETIME) {
            dtInfo = new DataTypeInfo("dateTime", 8, 9, 0, 12, isNullable);
        } else if (sType == EdmSimpleType.DATETIMEOFFSET) {
            dtInfo = new DataTypeInfo("dateTime", 8, 9, 0, 12, isNullable);
        } else if (sType == EdmSimpleType.TIME) {
            dtInfo = new DataTypeInfo("time", 8, 9, 0, 12, isNullable);
        }
        return dtInfo;
    }

    public static final class DataTypeInfo {
        private String mMFWType;
        private byte category;
        private int precision;
        private int scale;
        private int size;
        private boolean nullable;

        DataTypeInfo(String mfwType, byte typeCategory, int thePrecision, int theScale, int theSize, boolean isNullable) {
            this.mMFWType = mfwType;
            this.category = typeCategory;
            this.precision = thePrecision;
            this.scale = theScale;
            this.size = theSize;
            this.nullable = isNullable;
        }

        public String getTypeName() {
            return this.mMFWType;
        }

        public byte getTypeCategory() {
            return this.category;
        }

        public int getDefaultPrecision() {
            return this.precision;
        }

        public int getDefaultScale() {
            return this.scale;
        }

        public int getDefaultSize() {
            return this.size;
        }

        public boolean isNullable() {
            return this.nullable;
        }
    }
}

