/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorPhysicalMD;

import com.cognos.mfw4j.framework.MFWAdaptor;
import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWConnection;
import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWCrnIDAdvancedLookup;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfwa4j.adaptorPhysicalMD.MFWPhysMDAdaptor;
import com.cognos.mfwa4j.adaptorPhysicalMD.MFWPhysMDAdaptorConnectionReuse;
import com.cognos.mfwa4j.adaptorPhysicalMD.MFWPhysMDLoaderDatabase;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.CheckBoolean;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.CheckString;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.MFWDump;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.MFWPhysID;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.MFWPhysMDLog;
import com.cognos.mfwa4j.adaptorPhysicalMDFM.MFWPhysMDIDGenerator;
import java.util.List;

public final class MFWPhysMDAdaptorConnection
extends MFWConnection {
    private static MFWModelRes mPhysMDRes = MFWModelRes.getInstance();
    private MFWPhysMDLog mDbgTrace = MFWPhysMDLog.getInstance();
    private MFWNodeObject mPhysicalSources = null;
    private MFWPhysMDIDGenerator mIDGenerator;
    private MFWInfoProperty mIndexProp = (MFWInfoProperty)MFWModel.getInstance().findInfoByGUID((short)100);

    MFWPhysMDAdaptorConnection(MFWConnectionReuseInfo aReuseInfo, MFWPhysMDAdaptor anAdaptor) {
        super(aReuseInfo, (MFWAdaptor)anAdaptor);
        this.mDbgTrace.logStart();
        this.mDbgTrace.log("----------- Constructed physical metadata connection:  %d", ((Object)((Object)this)).hashCode());
        this.mDbgTrace.logEnd();
    }

    public void destroy() {
        this.mPhysicalSources = null;
        this.mIDGenerator = null;
        this.mIndexProp = null;
        super.destroy();
        this.mDbgTrace.logStart();
        this.mDbgTrace.log("----------- Destroyed physical metadata connection:  %d", ((Object)((Object)this)).hashCode());
        this.mDbgTrace.logEnd();
        this.mDbgTrace = null;
    }

    public MFWNodeObject getPhysicalSources() {
        return this.mPhysicalSources;
    }

    private MFWQuerySpec resolveLinkQuerySpec(MFWQuerySpec aQuerySpec) {
        MFWQuerySpec resolvedQuerySpec2;
        MFWQuerySpec resolvedQuerySpec;
        String sPhysMDLinkSpec = "/physicalSources/physicalSource";
        if ("/physicalSources/physicalSource".equals(aQuerySpec.getXPathQuery()) && (resolvedQuerySpec = aQuerySpec.getPrimaryQuerySpec()) != null && "/physicalSources/physicalSource".equals(resolvedQuerySpec.getXPathQuery()) && (resolvedQuerySpec2 = resolvedQuerySpec.getPrimaryQuerySpec()) != null) {
            return resolvedQuerySpec2;
        }
        return aQuerySpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expand(MFWRequestContextUser aContext, MFWQuerySpec expandQuerySpec, MFWNodeObject objNode) {
        super.setCaseSensitiveResult(true);
        this.mDbgTrace.logStart();
        this.mDbgTrace.log("+--------------------- Physical Metadata Query ---------------------", new Object[0]);
        this.mDbgTrace.log("| Original Query:  %s", expandQuerySpec.getXPathQuery());
        MFWQuerySpec linkQuerySpec = this.resolveLinkQuerySpec(expandQuerySpec);
        this.mDbgTrace.log("| Resolved Query:  %s", linkQuerySpec.getXPathQuery());
        this.mDbgTrace.log("+-------------------------------------------------------------------", new Object[0]);
        this.mDbgTrace.logEnd();
        MFWNodeObject expandedObject = null;
        try {
            MFWPhysID objPhysID;
            String sXPathQuery;
            short nTargetRID = linkQuerySpec.getCurrentStepPatternRID();
            if (this.canExpand(objNode, nTargetRID) && !(sXPathQuery = linkQuerySpec.getXPathQuery()).contains("/subroutine") && (expandedObject = this.find(objPhysID = MFWPhysID.parseXPath(sXPathQuery), aContext)) == null) {
                expandedObject = this.load(objPhysID, aContext);
            }
        }
        catch (Throwable th) {
            try {
                if (this.mDbgTrace.isEnabled() || CheckBoolean.isTrue(MFWPhysMDAdaptor.capability_CreateTestcases(), false)) {
                    MFWDump dump = new MFWDump(this);
                    boolean bDumped = dump.createPhysicalMetadataDump(this.getLinkNodeParent(), expandQuerySpec, linkQuerySpec, expandedObject, th, aContext);
                    if (this.mDbgTrace.isEnabled()) {
                        this.mDbgTrace.logStart();
                        this.mDbgTrace.log("+========================== ERROR ===============================", new Object[0]);
                        this.mDbgTrace.log("| An unhandled physical metadata exception occurred!", new Object[0]);
                        this.mDbgTrace.log("| ", new Object[0]);
                        this.mDbgTrace.log("| Query:                      %s", linkQuerySpec.getXPathQuery());
                        this.mDbgTrace.log("| Dump folder:                %s", dump.getDumpFolderName());
                        this.mDbgTrace.log("| Dump folder name is of the format CONNECTIONHASH_YYYYMMDD_HHMMSSMMM", new Object[0]);
                        this.mDbgTrace.log("+----------------------------------------------------------------", new Object[0]);
                        this.mDbgTrace.log("| Exception Message:          %s", th.getMessage());
                        this.mDbgTrace.log("| Dump created successfully:  %b", bDumped);
                        this.mDbgTrace.log("+================================================================", new Object[0]);
                        this.mDbgTrace.logEnd();
                    }
                }
            }
            finally {
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                throw new RuntimeException(th);
            }
        }
        try {
            if (!CheckBoolean.isTrue(MFWPhysMDAdaptor.capability_CreateTestcases(), false)) break block14;
            MFWDump dump = new MFWDump(this);
            boolean bDumped = dump.createPhysicalMetadataDump(this.getLinkNodeParent(), expandQuerySpec, linkQuerySpec, expandedObject, null, aContext);
            if (this.mDbgTrace.isEnabled()) {
                this.mDbgTrace.logStart();
                this.mDbgTrace.log("+-------------------------- TESTCASE ----------------------------", new Object[0]);
                this.mDbgTrace.log("| Creating testcases for all physical metadata queries.", new Object[0]);
                this.mDbgTrace.log("| ", new Object[0]);
                this.mDbgTrace.log("| Query:                      %s", linkQuerySpec.getXPathQuery());
                this.mDbgTrace.log("| Dump folder:                %s", dump.getDumpFolderName());
                this.mDbgTrace.log("| Dump folder name is of the format CONNECTIONHASH_YYYYMMDD_HHMMSSMMM", new Object[0]);
                this.mDbgTrace.log("+----------------------------------------------------------------", new Object[0]);
                this.mDbgTrace.log("| Dump created successfully:  %b", bDumped);
                this.mDbgTrace.log("+----------------------------------------------------------------", new Object[0]);
                this.mDbgTrace.logEnd();
            }
        }
        finally {
            return;
        }
        {
            block14: {
            }
        }
    }

    private MFWNodeObject getLinkNodeParent() {
        MFWPhysMDAdaptorConnectionReuse reuseInfo = (MFWPhysMDAdaptorConnectionReuse)this.getReuseInfo();
        return reuseInfo.getLinkNodeParent();
    }

    private boolean canExpand(MFWNodeObject objNode, short ridChild) {
        boolean bCanExpand = false;
        short nameRID = objNode.getNameRID();
        if (nameRID == MFWPhysMDAdaptorConnection.mPhysMDRes.RID_physicalSources && ridChild == MFWPhysMDAdaptorConnection.mPhysMDRes.RID_physicalSource) {
            bCanExpand = objNode.getExpandStatus(ridChild) != 1;
        }
        return bCanExpand;
    }

    private boolean canExpand(MFWPhysID physID) {
        return CheckString.exists(physID.getTable());
    }

    public MFWNodeObject find(MFWPhysID objPhysID, MFWRequestContextUser aContext) {
        if (!objPhysID.isValidPhysID()) {
            return null;
        }
        MFWNodeObject matchedTarget = this.getStaticObject(objPhysID.getID());
        if (matchedTarget == null) {
            matchedTarget = this.getDynamicObject(objPhysID.getID());
        }
        return matchedTarget;
    }

    public MFWNodeObject load(MFWPhysID objPhysID, MFWRequestContextUser aContext) {
        MFWException.ASSERT((boolean)CheckString.exists(objPhysID.getID()), (String)"Invalid sPhysID value");
        if (MFWCrnIDHelper.isMacro((String)objPhysID.getCmDatasource()) || MFWCrnIDHelper.isMacro((String)objPhysID.getCatalog()) || MFWCrnIDHelper.isMacro((String)objPhysID.getSchema())) {
            return null;
        }
        MFWNodeObject loadedObject = null;
        if (this.canExpand(objPhysID)) {
            MFWPhysMDLoaderDatabase dbLoader = new MFWPhysMDLoaderDatabase(aContext, this, this.mIDGenerator);
            loadedObject = dbLoader.load(objPhysID);
        }
        return loadedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MFWNodeObject lookup(MFWRequestContextUser aContext, MFWInfoProperty indexProp, String sPhysID, MFWNodeObject rootNode, List<MFWNodeObject> ancestorsChain) {
        this.mDbgTrace.logStart();
        this.mDbgTrace.log("+-------------------- Physical Metadata Lookup ---------------------", new Object[0]);
        this.mDbgTrace.log("| Physical Metadata ID:  %s", sPhysID);
        this.mDbgTrace.log("+-------------------------------------------------------------------", new Object[0]);
        this.mDbgTrace.logEnd();
        MFWNodeObject lookedNode = null;
        try {
            MFWPhysID objPhysID = MFWPhysID.parsePhysID(sPhysID);
            lookedNode = this.find(objPhysID, aContext);
            if (lookedNode == null) {
                lookedNode = this.load(objPhysID, aContext);
            }
            if (lookedNode != null && ancestorsChain != null) {
                MFWCrnIDAdvancedLookup.addToAncestorsChain((MFWNodeObject)lookedNode, (MFWNodeObject)this.mPhysicalSources, ancestorsChain);
            }
        }
        catch (Throwable th) {
            try {
                if (this.mDbgTrace.isEnabled() || CheckBoolean.isTrue(MFWPhysMDAdaptor.capability_CreateTestcases(), false)) {
                    MFWDump dump = new MFWDump(this);
                    boolean bDumped = dump.createPhysicalMetadataDump(this.getLinkNodeParent(), sPhysID, lookedNode, th, aContext);
                    if (this.mDbgTrace.isEnabled()) {
                        this.mDbgTrace.logStart();
                        this.mDbgTrace.log("+========================== ERROR ===============================", new Object[0]);
                        this.mDbgTrace.log("| An unhandled physical metadata exception occurred!", new Object[0]);
                        this.mDbgTrace.log("| ", new Object[0]);
                        this.mDbgTrace.log("| Lookup:                     %s", sPhysID);
                        this.mDbgTrace.log("| Dump folder:                %s", dump.getDumpFolderName());
                        this.mDbgTrace.log("| Dump folder name is of the format CONNECTIONHASH_YYYYMMDD_HHMMSSMMM", new Object[0]);
                        this.mDbgTrace.log("+----------------------------------------------------------------", new Object[0]);
                        this.mDbgTrace.log("| Exception Message:          %s", th.getMessage());
                        this.mDbgTrace.log("| Dump created successfully:  %b", bDumped);
                        this.mDbgTrace.log("+================================================================", new Object[0]);
                        this.mDbgTrace.logEnd();
                    }
                }
            }
            finally {
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                throw new RuntimeException(th);
            }
        }
        try {
            if (CheckBoolean.isTrue(MFWPhysMDAdaptor.capability_CreateTestcases(), false)) {
                MFWDump dump = new MFWDump(this);
                boolean bDumped = dump.createPhysicalMetadataDump(this.getLinkNodeParent(), sPhysID, lookedNode, null, aContext);
                if (this.mDbgTrace.isEnabled()) {
                    this.mDbgTrace.logStart();
                    this.mDbgTrace.log("+-------------------------- TESTCASE ----------------------------", new Object[0]);
                    this.mDbgTrace.log("| Creating testcases for all physical metadata lookups.", new Object[0]);
                    this.mDbgTrace.log("| ", new Object[0]);
                    this.mDbgTrace.log("| Lookup:                     %s", sPhysID);
                    this.mDbgTrace.log("| Dump folder:                %s", dump.getDumpFolderName());
                    this.mDbgTrace.log("| Dump folder name is of the format CONNECTIONHASH_YYYYMMDD_HHMMSSMMM", new Object[0]);
                    this.mDbgTrace.log("+----------------------------------------------------------------", new Object[0]);
                    this.mDbgTrace.log("| Dump created successfully:  %b", bDumped);
                    this.mDbgTrace.log("+----------------------------------------------------------------", new Object[0]);
                    this.mDbgTrace.logEnd();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return lookedNode;
    }

    public MFWNodeObject getStaticObject(MFWNodeObject parentObject, String sChildName) {
        String sParentID = parentObject.getPropertyValue(MFWPhysMDAdaptorConnection.mPhysMDRes.RID_ID);
        String sID = MFWCrnIDHelper.addEntryToID((String)sParentID, (String)sChildName);
        return this.getStaticObject(sID);
    }

    protected MFWNodeObject getStaticObject(String sID) {
        MFWCluster aCluster = this.getLinkNodeParent().getCluster();
        MFWNodeObject lookedNode = aCluster.getIndexManager().lookup(this.mIndexProp, sID);
        if (lookedNode == null) {
            // empty if block
        }
        return lookedNode;
    }

    public MFWNodeObject getDynamicObject(MFWNodeObject parentObject, String sChildName) {
        String sParentID = parentObject.getPropertyValue(MFWPhysMDAdaptorConnection.mPhysMDRes.RID_ID);
        String sID = MFWCrnIDHelper.addEntryToID((String)sParentID, (String)sChildName);
        return this.getDynamicObject(sID);
    }

    MFWNodeObject getDynamicObject(String sQueryPhysID) {
        MFWCluster aCluster = this.getCluster();
        MFWNodeObject lookedNode = aCluster.getIndexManager().lookup(this.mIndexProp, sQueryPhysID);
        if (lookedNode == null) {
            // empty if block
        }
        return lookedNode;
    }

    public void initialSetup(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
        MFWException.ASSERT((aLinkNodeParent != null && aLinkNodeParent.getNameRID() == MFWPhysMDAdaptorConnection.mPhysMDRes.RID_physicalSources ? 1 : 0) != 0, (String)"Expecting a link node parent of type physical sources");
        this.mIDGenerator = new MFWPhysMDIDGenerator(this.getCluster().getIndexManager());
        this.mPhysicalSources = this.getCluster().getRootNode().addExpandableObjectNode(MFWPhysMDAdaptorConnection.mPhysMDRes.RID_physicalSources);
        this.mIDGenerator.generate(this.mPhysicalSources, null);
    }
}

