/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorPhysicalMD;

import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.CheckString;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.MFWPhysMDLog;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.StringUtils;

public final class MFWPhysMDAdaptorConnectionReuse
extends MFWConnectionReuseInfo {
    private MFWPhysMDLog mLogEvent = MFWPhysMDLog.getInstance();
    private eModelSource mFmModelSource = eModelSource.Unknown;
    private String mFmModelPackageIdentifier = null;
    private String mFmModelTimeStamp = null;
    private String mFmModelPath = null;
    private MFWNodeObject mLinkNodeParent = null;

    MFWPhysMDAdaptorConnectionReuse(MFWRequestContextUser aContext, MFWMetadataSource aMetadataSrc, MFWNodeObject aLinkParent) {
        super(aMetadataSrc);
        MFWException.ASSERT((aLinkParent != null ? 1 : 0) != 0, (String)"Expecting a valid link parent node when creating reuse info for physical metadata");
        this.mLinkNodeParent = aLinkParent;
        MFWException.ASSERT((boolean)"modelPhysical".equals(aMetadataSrc.getType()), (String)"Invalid physical metadata source for connection reuse info");
        this.mFmModelPath = (String)aMetadataSrc.getConnectionItem("cmSearchPath");
        this.mFmModelSource = eModelSource.ContentManager;
        if (!CheckString.exists(this.mFmModelPath)) {
            this.mFmModelPath = (String)aMetadataSrc.getConnectionItem("modelFilePath");
            this.mFmModelSource = eModelSource.Filesystem;
        }
        MFWException.ASSERT((this.mFmModelPath != null ? 1 : 0) != 0, (String)"The published model must have a path where it is stored");
        String sFmModelPMCPath = aLinkParent.getCluster().getConnection().getReuseInfo().getPersistentClusterFilePath();
        MFWException.ASSERT((sFmModelPMCPath != null ? 1 : 0) != 0, (String)"Expecting a valid persistent cluster file path for parent of the physical metadata cluster");
        int lastSlash = sFmModelPMCPath.lastIndexOf(47);
        this.mFmModelPackageIdentifier = sFmModelPMCPath.substring(0, lastSlash);
        this.mFmModelTimeStamp = sFmModelPMCPath.substring(lastSlash + 1, sFmModelPMCPath.indexOf(".pmc"));
        MFWException.ASSERT((this.mFmModelPackageIdentifier != null && this.mFmModelTimeStamp != null ? 1 : 0) != 0, (String)"Unable to extract reuse factors for physical metadata connection from PMC path:", (String)sFmModelPMCPath);
    }

    public void destroy() {
        this.mLinkNodeParent = null;
        this.mFmModelSource = eModelSource.Unknown;
        super.destroy();
    }

    protected boolean isReusableFor(MFWConnectionReuseInfo targetReuseInfo) {
        boolean bMatch;
        this.mLogEvent.logStart();
        this.mLogEvent.log("Can cache be reused?", new Object[0]);
        this.mLogEvent.log("ReuseInfo cache  hashCode=%d", ((Object)((Object)this)).hashCode());
        this.mLogEvent.log("ReuseInfo target hashCode=%d", targetReuseInfo.hashCode());
        this.mLogEvent.log("Cache's  fm metadata source:  %s", this.mFmModelPath);
        String sConnectionItem = (String)targetReuseInfo.getMetadataSource().getConnectionItem(this.mFmModelSource == eModelSource.ContentManager ? "cmSearchPath" : "modelFilePath");
        this.mLogEvent.log("Target's fm metadata source:  %s", StringUtils.null2NA(sConnectionItem));
        MFWPhysMDAdaptorConnectionReuse thatReuseInfo = (MFWPhysMDAdaptorConnectionReuse)targetReuseInfo;
        boolean bl = bMatch = this.mFmModelPackageIdentifier.equals(thatReuseInfo.mFmModelPackageIdentifier) && this.mLinkNodeParent != null && thatReuseInfo.mLinkNodeParent != null && this.mLinkNodeParent.equals(thatReuseInfo.mLinkNodeParent);
        if (bMatch) {
            this.mLogEvent.log("Cache is reusable...all reuse criteria passed.", new Object[0]);
        } else {
            this.mLogEvent.log("Cache is not reusable...mismatched fm model sources.", new Object[0]);
        }
        this.mLogEvent.logEnd();
        return bMatch;
    }

    public StringBuffer getPersistentPath() {
        StringBuffer path = new StringBuffer(this.mFmModelPackageIdentifier);
        path.append("/");
        path.append(this.mFmModelTimeStamp);
        path.append("_MD");
        return path;
    }

    protected boolean isCacheUpToDate(MFWRequestContextUser aContext, MFWConnectionReuseInfo targetReuseInfo) {
        boolean bMatch = false;
        this.mLogEvent.logStart();
        this.mLogEvent.log("Is cache up-to-date?", new Object[0]);
        this.mLogEvent.log("ReuseInfo cache  hashCode=%d", ((Object)((Object)this)).hashCode());
        if (this.mFmModelSource == eModelSource.ContentManager) {
            this.mLogEvent.log("Last FM model update date (cache):  %s", this.mFmModelTimeStamp);
            String targetTimeStamp = ((MFWPhysMDAdaptorConnectionReuse)targetReuseInfo).mFmModelTimeStamp;
            this.mLogEvent.log("Last FM model update date (target):  %s", targetTimeStamp);
            bMatch = this.mFmModelTimeStamp.equals(targetTimeStamp);
            if (bMatch) {
                this.mLogEvent.log("Yes...content manager model has not been updated", new Object[0]);
            } else {
                this.mLogEvent.log("No...content manager model was updated", new Object[0]);
            }
        } else {
            this.mLogEvent.log("Yes...the source model does not reside in content manager", new Object[0]);
            bMatch = true;
        }
        this.mLogEvent.logEnd();
        return bMatch;
    }

    public MFWNodeObject getLinkNodeParent() {
        return this.mLinkNodeParent;
    }

    private static enum eModelSource {
        Unknown,
        ContentManager,
        Filesystem;

    }
}

