/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorPhysicalMD;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfwa4j.adaptorPhysicalMD.MFWPhysMDAdaptor;
import com.cognos.mfwa4j.adaptorPhysicalMD.MFWPhysMDAdaptorConnection;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.CheckString;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.FmCclDataTypes;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.MFWPhysID;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.MFWPhysMDLog;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.QueryPhysMDCache;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.QueryRelMDResultHandler;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.QueryRelmdGateway;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.StringUtils;
import com.cognos.mfwa4j.adaptorPhysicalMDFM.MFWPhysMDIDGenerator;
import com.ibm.cognos.relmd.metadata._schema.elements.Column;
import com.ibm.cognos.relmd.metadata._schema.properties.SqlColumn;
import java.util.ArrayList;
import java.util.concurrent.locks.ReadWriteLock;

final class MFWPhysMDLoaderDatabase {
    private static MFWModelRes mPhysMDRes = MFWModelRes.getInstance();
    private MFWPhysMDLog mDbgTrace = MFWPhysMDLog.getInstance();
    private QueryRelmdGateway mGw;
    private MFWPhysMDIDGenerator mIDGenerator;
    private MFWPhysMDAdaptorConnection mPhysMDAdapterConnection;

    MFWPhysMDLoaderDatabase(MFWRequestContextUser aRequestContextUser, MFWPhysMDAdaptorConnection aPhysMDAdapterConnection, MFWPhysMDIDGenerator aIDGenerator) {
        this.mPhysMDAdapterConnection = aPhysMDAdapterConnection;
        this.mGw = new QueryRelmdGateway(aRequestContextUser, MFWPhysMDAdaptor.capability_UseXQEConnectionPool());
        MFWException.ASSERT((aIDGenerator != null ? 1 : 0) != 0, (String)"Null id generator for physical metadata database loader");
        this.mIDGenerator = aIDGenerator;
    }

    public void destroy() {
        this.mGw = null;
        this.mIDGenerator = null;
        this.mPhysMDAdapterConnection = null;
    }

    public MFWNodeObject load(MFWPhysID objPhysID) {
        MFWException.ASSERT((boolean)CheckString.exists(objPhysID.getTable()), (String)"Missing target name for database lookup");
        this.mDbgTrace.logStart();
        this.mDbgTrace.log("DBLoader(id=%d) search:  [%s].[%s].[%s].[%s]", this.hashCode(), objPhysID.getCmDatasource(), objPhysID.getCatalog(), objPhysID.getSchema(), objPhysID.getTable());
        MFWNodeObject objTarget = this.mPhysMDAdapterConnection.getDynamicObject(objPhysID.getID());
        if (objTarget != null) {
            return objTarget;
        }
        MFWNodeObject objTargetParent = this.findOrAddTargetParent(objPhysID);
        objTarget = this.loadTargetTable(objTargetParent, objPhysID);
        if (objTarget != null) {
            this.mDbgTrace.log("loaded object definition:", new Object[0]);
            this.mDbgTrace.log((MFWNode)objTarget);
        }
        this.mDbgTrace.log("DBLoader(id=%d) search for '%s':  %s", this.hashCode(), objPhysID.getTable(), objTarget != null ? "Success" : "No match found!");
        this.mDbgTrace.logEnd();
        return objTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MFWNodeObject loadTargetTable(MFWNodeObject objTableParent, MFWPhysID objPhysID) {
        MFWNodeObject objTable = null;
        ReadWriteLock parentLock = (ReadWriteLock)objTableParent.getExpandLock();
        MFWException.ASSERT((parentLock != null ? 1 : 0) != 0, (String)"Expecting a valid expand lock when adding table:", (String)objPhysID.getTable());
        parentLock.writeLock().lock();
        try {
            objTable = this.mPhysMDAdapterConnection.getDynamicObject(objPhysID.getID());
            if (objTable != null) {
                MFWNodeObject mFWNodeObject = objTable;
                return mFWNodeObject;
            }
            QueryRelMDResultHandler targetMDResults = this.queryRelMD(objPhysID);
            if (!targetMDResults.targetExists()) {
                MFWNodeObject mFWNodeObject = null;
                return mFWNodeObject;
            }
            this.mDbgTrace.log("DBLoader(id=%d) creating table:  [%s]", this.hashCode(), objPhysID.getTable());
            objTable = objTableParent.addExpandableObjectNode(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_table);
            this.setBasicProperties(objTable, objPhysID.getTable());
            objTable.addProperty(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_type, targetMDResults.isTargetView() ? "view" : "table");
            this.loadColumns(objTable, objPhysID, targetMDResults);
            objTableParent.setExpandStatus(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_table, (byte)3);
        }
        finally {
            parentLock.writeLock().unlock();
        }
        return objTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryRelMDResultHandler queryRelMD(MFWPhysID objPhysID) {
        try {
            QueryRelMDResultHandler targetMDResults;
            this.mGw.openConnection(objPhysID.getCmDatasource());
            QueryRelMDResultHandler queryRelMDResultHandler = targetMDResults = this.mGw.queryTarget(objPhysID);
            return queryRelMDResultHandler;
        }
        finally {
            this.mGw.closeConnection();
        }
    }

    private MFWNodeObject findOrAddTargetParent(MFWPhysID objPhysID) {
        MFWNodeObject objDataSrc = this.findOrAddPhysicalSource(this.mPhysMDAdapterConnection.getPhysicalSources(), objPhysID.getCmDatasource());
        MFWNodeObject objCatalog = this.findOrAddCatalog(objDataSrc, objPhysID.getCatalog());
        return this.findOrAddSchema(objCatalog, objPhysID.getSchema());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MFWNodeObject findOrAddPhysicalSource(MFWNodeObject physParent, String sCmDatasourceName) {
        MFWException.ASSERT((boolean)CheckString.exists(sCmDatasourceName), (String)"Missing cm datasource name for database lookup");
        ReadWriteLock parentLock = (ReadWriteLock)physParent.getExpandLock();
        MFWException.ASSERT((parentLock != null ? 1 : 0) != 0, (String)"Expecting a valid expand lock when adding data source:", (String)sCmDatasourceName);
        MFWNodeObject loadedObject = null;
        parentLock.readLock().lock();
        try {
            loadedObject = this.lookupPhysicalDataSource(physParent, sCmDatasourceName);
            if (loadedObject != null) {
                MFWNodeObject mFWNodeObject = loadedObject;
                return mFWNodeObject;
            }
        }
        finally {
            parentLock.readLock().unlock();
        }
        parentLock.writeLock().lock();
        try {
            loadedObject = this.lookupPhysicalDataSource(physParent, sCmDatasourceName);
            if (loadedObject == null) {
                this.mDbgTrace.log("DBLoader(id=%d) creating physical source for CM connection:  [%s]", this.hashCode(), sCmDatasourceName);
                loadedObject = physParent.addExpandableObjectNode(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_physicalSource);
                this.setBasicProperties(loadedObject, sCmDatasourceName);
                physParent.setExpandStatus(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_physicalSource, (byte)3);
            }
        }
        finally {
            parentLock.writeLock().unlock();
        }
        return loadedObject;
    }

    private MFWNodeObject lookupPhysicalDataSource(MFWNodeObject physParent, String sCmDatasourceName) {
        MFWNodeObject physSource = null;
        ArrayList<MFWNodeObject> listCachedPhysicalSource = QueryPhysMDCache.findObjectNodes(physParent, MFWPhysMDLoaderDatabase.mPhysMDRes.RID_physicalSource, MFWPhysMDLoaderDatabase.mPhysMDRes.RID_name, sCmDatasourceName, false);
        MFWException.ASSERT((listCachedPhysicalSource.size() <= 1 ? 1 : 0) != 0, (String)("Ambiguous Physical Sources named '" + sCmDatasourceName + "'"));
        if (listCachedPhysicalSource.size() > 0) {
            this.mDbgTrace.log("DBLoader(id=%d) found cached CM connection:  [%s]", this.hashCode(), sCmDatasourceName);
            physSource = listCachedPhysicalSource.get(0);
            String sCacheName = physSource.getPropertyValue(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_name);
            if (!sCmDatasourceName.equals(sCacheName)) {
                this.mDbgTrace.log("Warning! Loading physical source with different case:   cmDatasource Loading[%s] != Cached[%s]", this.hashCode(), sCmDatasourceName, sCacheName);
            }
        }
        return physSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MFWNodeObject findOrAddCatalog(MFWNodeObject physParent, String sCatalogName) {
        MFWException.ASSERT((sCatalogName != null ? 1 : 0) != 0, (String)"Missing catalog name for database lookup");
        String sCatalogID = MFWCrnIDHelper.addEntryToID((String)physParent.getPropertyValue(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_ID), (String)sCatalogName);
        MFWNodeObject loadedObject = this.mPhysMDAdapterConnection.getDynamicObject(sCatalogID);
        if (loadedObject != null) {
            return loadedObject;
        }
        ReadWriteLock parentLock = (ReadWriteLock)physParent.getExpandLock();
        MFWException.ASSERT((parentLock != null ? 1 : 0) != 0, (String)"Expecting a valid expand lock when adding catalog:", (String)sCatalogName);
        parentLock.writeLock().lock();
        try {
            loadedObject = this.mPhysMDAdapterConnection.getDynamicObject(sCatalogID);
            if (loadedObject == null) {
                this.mDbgTrace.log("DBLoader(id=%d) creating catalog:  [%s]", this.hashCode(), sCatalogName);
                loadedObject = physParent.addExpandableObjectNode(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_catalog);
                this.setBasicProperties(loadedObject, sCatalogName);
                physParent.setExpandStatus(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_catalog, (byte)3);
            }
        }
        finally {
            parentLock.writeLock().unlock();
        }
        return loadedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MFWNodeObject findOrAddSchema(MFWNodeObject physParent, String sSchemaName) {
        MFWException.ASSERT((sSchemaName != null ? 1 : 0) != 0, (String)"Missing schema name for database lookup");
        String sSchemaID = MFWCrnIDHelper.addEntryToID((String)physParent.getPropertyValue(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_ID), (String)sSchemaName);
        MFWNodeObject loadedObject = this.mPhysMDAdapterConnection.getDynamicObject(sSchemaID);
        if (loadedObject != null) {
            return loadedObject;
        }
        ReadWriteLock parentLock = (ReadWriteLock)physParent.getExpandLock();
        MFWException.ASSERT((parentLock != null ? 1 : 0) != 0, (String)"Expecting a valid expand lock when adding schema:", (String)sSchemaName);
        parentLock.writeLock().lock();
        try {
            loadedObject = this.mPhysMDAdapterConnection.getDynamicObject(sSchemaID);
            if (loadedObject == null) {
                this.mDbgTrace.log("DBLoader(id=%d) creating schema:  [%s]", this.hashCode(), sSchemaName);
                loadedObject = physParent.addExpandableObjectNode(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_schema);
                this.setBasicProperties(loadedObject, sSchemaName);
                physParent.setExpandStatus(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_schema, (byte)3);
            }
        }
        finally {
            parentLock.writeLock().unlock();
        }
        return loadedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadColumns(MFWNodeObject objTable, MFWPhysID objPhysID, QueryRelMDResultHandler targetMDResults) {
        ReadWriteLock tableLock = (ReadWriteLock)objTable.getExpandLock();
        MFWException.ASSERT((tableLock != null ? 1 : 0) != 0, (String)"Expecting a valid expand lock for new table:", (String)objPhysID.getTable());
        tableLock.writeLock().lock();
        try {
            for (Column aCol : targetMDResults.getTargetColumns()) {
                SqlColumn sqlCol = this.mGw.getDataTypeMappingToolkit().fmColumn((SqlColumn)aCol, targetMDResults.getColumnConversionRules());
                this.addColumn(objTable, aCol.objectName(), aCol.description(), sqlCol.datatype(), sqlCol.hasSize() != false ? sqlCol.size() : null, sqlCol.hasPrecision() != false ? sqlCol.precision() : null, sqlCol.hasScale() != false ? sqlCol.scale() : null, sqlCol.hasIsNullable() != false ? sqlCol.isNullable() : null);
            }
        }
        finally {
            tableLock.writeLock().unlock();
        }
    }

    private MFWNodeObject addColumn(MFWNodeObject physParent, String sColumnName, String sColumnDescription, String sFmDataType, Integer size, Integer precision, Integer scale, Boolean isNullable) {
        this.mDbgTrace.log("RELMD column [%s] attributes:", sColumnName);
        MFWNodeObject physColumn = physParent.addObjectNode(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_column);
        this.setBasicProperties(physColumn, sColumnName);
        this.loadColumnProperties(physColumn, sColumnName, sColumnDescription, sFmDataType, size, precision, scale, isNullable);
        physParent.setExpandStatus(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_column, (byte)1);
        return physColumn;
    }

    private void loadColumnProperties(MFWNodeObject physColumn, String sDbColumnName, String sDbColumnDescription, String sFmDataType, Integer size, Integer precision, Integer scale, Boolean isNullable) {
        this.mDbgTrace.log("  ID=%s", physColumn.getPropertyValue(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_ID));
        MFWException.ASSERT((boolean)CheckString.exists(sFmDataType), (String)"Missing FM data type attribute for column and datatype: ", (String)sDbColumnName, (String)sFmDataType);
        this.mDbgTrace.log("  FM  datatype=%s", StringUtils.null2null(sFmDataType));
        String sCclDataType = FmCclDataTypes.convertToCCL(sFmDataType);
        this.mDbgTrace.log("  CCL datatype=%s", StringUtils.null2null(sCclDataType));
        MFWException.ASSERT((boolean)CheckString.exists(sCclDataType), (String)"Missing CCL data type for DB column and datatype: ", (String)sDbColumnName, (String)sFmDataType);
        physColumn.addProperty(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_datatype, sCclDataType);
        if (size != null) {
            String sSize = String.valueOf(size);
            physColumn.addProperty(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_size, sSize);
            this.mDbgTrace.log("  size=%s", sSize);
        }
        if (precision != null) {
            String sPrecision = String.valueOf(precision);
            physColumn.addProperty(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_precision, sPrecision);
            this.mDbgTrace.log("  precision=%s", sPrecision);
        }
        if (scale != null) {
            String sScale = String.valueOf(scale);
            physColumn.addProperty(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_scale, sScale);
            this.mDbgTrace.log("  scale=%s", sScale);
        }
        if (isNullable != null) {
            String sNullable = String.valueOf(isNullable);
            if (!sNullable.equals("false")) {
                physColumn.addProperty(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_nullable, sNullable);
            }
            this.mDbgTrace.log("  nullable=%s", sNullable);
        }
    }

    private void setBasicProperties(MFWNodeObject physObject, String sName) {
        physObject.addProperty(MFWPhysMDLoaderDatabase.mPhysMDRes.RID_name, sName);
        this.mIDGenerator.generate(physObject, sName);
    }
}

