/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataDBConnectionPool;

import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWXMLDump;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataDBConnectionPool.IDbConnectionPool;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DbConnectionPoolImposter
implements IDbConnectionPool {
    static LinkedHashMap<String, String[]> m_mapJdbcInfo = null;
    public static final String m_sJdbcInfoFilename = "MFWPhysMDLoaderDBInfo.xml";
    String m_sValidConnectionNames = "";
    String m_sJdbcConnectionName;
    String[] m_info;
    private Connection mConnection;

    public DbConnectionPoolImposter(String sJdbcConnectionName) {
        MFWException.ASSERT((sJdbcConnectionName != null ? 1 : 0) != 0, (String)"JDBC Connection name not found in 'MFWPhysMDLoaderDBInfo.xml'");
        this.m_sJdbcConnectionName = sJdbcConnectionName;
        this.load();
        this.getEntry();
    }

    public String imposterFilename() {
        return m_sJdbcInfoFilename;
    }

    private void load() {
        if (m_mapJdbcInfo == null) {
            m_mapJdbcInfo = new LinkedHashMap();
            MFWException.ASSERT((boolean)new File(m_sJdbcInfoFilename).exists(), (String)"Missing file: \"MFWPhysMDLoaderDBInfo.xml\"");
            try {
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document aDocument = docBuilder.parse(m_sJdbcInfoFilename);
                this.m_sValidConnectionNames = "Valid connection names loaded:\n";
                NodeList nodeList = aDocument.getElementsByTagName("jdbcConnection");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element elementJdbcInfo = (Element)nodeList.item(i);
                    String sJdbcConnectionName = elementJdbcInfo.getAttribute("jdbcConnectionName");
                    String sCmDataSourceName = elementJdbcInfo.getAttribute("cmDataSource");
                    String sConnection = elementJdbcInfo.getAttribute("jdbcConnectionString");
                    String sUserID = elementJdbcInfo.getAttribute("userID");
                    String sPassword = elementJdbcInfo.getAttribute("password");
                    String sDriverClass = elementJdbcInfo.getAttribute("driverClass");
                    String sVendorType = elementJdbcInfo.getAttribute("vendorType");
                    m_mapJdbcInfo.put(sJdbcConnectionName.toLowerCase(), new String[]{sCmDataSourceName, sConnection, sUserID, sPassword, sDriverClass, sVendorType});
                    this.m_sValidConnectionNames = this.m_sValidConnectionNames + sJdbcConnectionName + "\n";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                MFWException.ASSERT((boolean)false, (String)"Unable to load \"MFWPhysMDLoaderDBInfo.xml\"");
            }
        }
    }

    private void getEntry() {
        this.m_info = m_mapJdbcInfo.get(this.m_sJdbcConnectionName.toLowerCase());
        MFWException.ASSERT((this.m_info != null ? 1 : 0) != 0, (String)("JDBC Connection name \"" + this.m_sJdbcConnectionName + "\" not found in '" + m_sJdbcInfoFilename + "'\n\n" + this.m_sValidConnectionNames));
    }

    public String connectionName() {
        return this.m_sJdbcConnectionName;
    }

    @Override
    public String connectionString() {
        return this.m_info[1];
    }

    @Override
    public String userID() {
        return this.m_info[2];
    }

    @Override
    public String password() {
        return this.m_info[3];
    }

    @Override
    public String driverClass() {
        return this.m_info[4];
    }

    @Override
    public String vendorType() {
        return this.m_info[5];
    }

    @Override
    public Connection doConnectionBorrow() {
        try {
            Class.forName(this.driverClass());
            this.mConnection = DriverManager.getConnection(this.connectionString(), this.userID(), this.password());
            return this.mConnection;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void doConnectionReturn() {
        try {
            if (this.mConnection != null) {
                this.mConnection.close();
                this.mConnection = null;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void setNotReusable() {
    }

    @Override
    public String toXml() {
        MFWXMLDump dump = new MFWXMLDump();
        dump.addElement("jdbcConnection", 0);
        dump.addAttribute("jdbcConnectionName", this.connectionName());
        dump.addAttribute("cmDataSource", this.connectionName());
        dump.addAttribute("jdbcConnectionString", this.connectionString());
        dump.addAttribute("userID", this.userID());
        dump.addAttribute("password", this.password());
        dump.addAttribute("driverClass", this.driverClass());
        dump.addAttribute("vendorType", this.vendorType());
        dump.endElement(true);
        return dump.getXML();
    }
}

