/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities;

import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.CheckString;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.MFWPhysMDXPath;
import java.util.ArrayList;
import org.jaxen.expr.NameStep;

public final class MFWPhysID {
    private String mID = null;
    private String msPhysSources;
    private String msCmDatasource;
    private String msCatalog;
    private String msSchema;
    private String msTable;

    public MFWPhysID(String sCmDatasource, String sCatalog, String sSchema, String sTable) {
        this.msPhysSources = CheckString.exists(sCmDatasource) ? ":physicalSources" : null;
        this.msCmDatasource = sCmDatasource;
        this.msCatalog = sCatalog;
        this.msSchema = sSchema;
        this.msTable = sTable;
    }

    public String getPhysSources() {
        return this.msPhysSources;
    }

    public String getCmDatasource() {
        return this.msCmDatasource;
    }

    public String getCatalog() {
        return this.msCatalog;
    }

    public String getSchema() {
        return this.msSchema;
    }

    public String getTable() {
        return this.msTable;
    }

    public static MFWPhysID parseXPath(String sXPathQuery) {
        MFWPhysID physID = new MFWPhysID(null, null, null, null);
        MFWPhysMDXPath myXPath = new MFWPhysMDXPath(sXPathQuery);
        int nDepth = 0;
        for (NameStep myStep : myXPath) {
            ++nDepth;
            if ("*".equals(myStep.getLocalName())) {
                throw new RuntimeException("Unsupported physical metadata XPath syntax");
            }
            String sName = myXPath.getPredicateName(myStep);
            switch (nDepth) {
                case 1: {
                    if (!myStep.getLocalName().equals("project") && !myStep.getLocalName().equals("physicalSources")) {
                        return physID;
                    }
                    physID.msPhysSources = ":physicalSources";
                    break;
                }
                case 2: {
                    if (!myStep.getLocalName().equals("physicalSource")) {
                        return physID;
                    }
                    physID.msCmDatasource = sName;
                    break;
                }
                case 3: {
                    if (!myStep.getLocalName().equals("catalog")) {
                        return physID;
                    }
                    physID.msCatalog = sName;
                    break;
                }
                case 4: {
                    if (!myStep.getLocalName().equals("schema")) {
                        return physID;
                    }
                    physID.msSchema = sName;
                    break;
                }
                case 5: {
                    if (!myStep.getLocalName().equals("table")) {
                        return physID;
                    }
                    physID.msTable = sName;
                    break;
                }
            }
        }
        return physID;
    }

    public static MFWPhysID parsePhysID(String sPhysID) {
        MFWPhysID physID = new MFWPhysID(null, null, null, null);
        if (!sPhysID.equals("")) {
            ArrayList vIDEntries = new ArrayList();
            MFWCrnIDHelper.parseID((String)sPhysID, vIDEntries);
            if (vIDEntries.size() >= 1 && ":physicalSources".equals(vIDEntries.get(0))) {
                physID.msPhysSources = (String)vIDEntries.get(0);
                physID.msCmDatasource = vIDEntries.size() >= 2 ? (String)vIDEntries.get(1) : null;
                physID.msCatalog = vIDEntries.size() >= 3 ? (String)vIDEntries.get(2) : null;
                physID.msSchema = vIDEntries.size() >= 4 ? (String)vIDEntries.get(3) : null;
                physID.msTable = vIDEntries.size() >= 5 ? (String)vIDEntries.get(4) : null;
            }
        }
        return physID;
    }

    public String getID() {
        if (this.mID != null) {
            return this.mID;
        }
        StringBuilder sPhysID = new StringBuilder();
        sPhysID.append("[:physicalSources]");
        if (CheckString.exists(this.msCmDatasource)) {
            sPhysID.append(".[");
            sPhysID.append(this.msCmDatasource);
            sPhysID.append("]");
            if (this.msCatalog != null) {
                sPhysID.append(".[");
                sPhysID.append(this.msCatalog);
                sPhysID.append("]");
                if (this.msSchema != null) {
                    sPhysID.append(".[");
                    sPhysID.append(this.msSchema);
                    sPhysID.append("]");
                    if (CheckString.exists(this.msTable)) {
                        sPhysID.append(".[");
                        sPhysID.append(this.msTable);
                        sPhysID.append("]");
                    }
                }
            }
        }
        this.mID = sPhysID.toString();
        return this.mID;
    }

    public boolean isValidPhysID() {
        return ":physicalSources".equals(this.msPhysSources);
    }
}

