/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities;

import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.Iterator;
import java.util.List;
import org.jaxen.JaxenHandler;
import org.jaxen.expr.EqualityExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.LiteralExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.Step;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathHandler;
import org.jaxen.saxpath.XPathReader;
import org.jaxen.saxpath.helpers.XPathReaderFactory;

final class MFWPhysMDXPath
implements Iterable<NameStep> {
    private String mXPath;
    private List<NameStep> mSteps;

    MFWPhysMDXPath(String sXPath) {
        this.mXPath = sXPath;
        try {
            XPathReader xpathReader = XPathReaderFactory.createReader();
            JaxenHandler myHandler = new JaxenHandler();
            xpathReader.setXPathHandler((XPathHandler)myHandler);
            xpathReader.parse(this.mXPath);
            Expr xExpr = myHandler.getXPathExpr().getRootExpr();
            MFWException.ASSERT((boolean)(xExpr instanceof LocationPath), (String)"Unable to parse XPath query:", (String)this.mXPath);
            LocationPath rootPath = (LocationPath)xExpr;
            this.mSteps = rootPath.getSteps();
        }
        catch (SAXPathException pe) {
            throw new RuntimeException(pe.getMessage(), pe);
        }
    }

    String getPredicateName(NameStep currStep) {
        List listPreds = currStep.getPredicates();
        MFWException.ASSERT((listPreds.size() <= 1 ? 1 : 0) != 0, (String)"Unsupported number of predicate expressions");
        if (listPreds.size() == 1) {
            Expr predExpr = ((Predicate)listPreds.get(0)).getExpr();
            MFWException.ASSERT((boolean)(predExpr instanceof EqualityExpr), (String)"Expecting an equality predicate");
            Expr exprLHS = ((EqualityExpr)predExpr).getLHS();
            MFWException.ASSERT((exprLHS instanceof LocationPath && ((LocationPath)exprLHS).getSteps().size() == 1 && ((LocationPath)exprLHS).getSteps().get(0) instanceof NameStep ? 1 : 0) != 0, (String)"Predicate has an unsupported left hand side");
            String sLeft = ((NameStep)((LocationPath)exprLHS).getSteps().get(0)).getLocalName();
            MFWException.ASSERT(("name".compareToIgnoreCase(sLeft) == 0 ? 1 : 0) != 0, (String)"Unsupported predicate expression");
            Expr exprRHS = ((EqualityExpr)predExpr).getRHS();
            MFWException.ASSERT((boolean)(exprRHS instanceof LiteralExpr), (String)"Predicate has an unsupported right hand side");
            String sObjectName = ((LiteralExpr)exprRHS).getLiteral();
            MFWException.ASSERT((boolean)"=".equals(((EqualityExpr)predExpr).getOperator()), (String)"Unsupported predicate operator");
            return sObjectName;
        }
        return null;
    }

    @Override
    public Iterator<NameStep> iterator() {
        return this.mSteps.iterator();
    }

    public short getStepRID(NameStep aStep) {
        return MFWQuerySpec.getStepRID((Step)aStep);
    }
}

