/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities;

import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWMessage;
import com.cognos.mfwa4j.adaptorPhysicalMD.MFWPhysMDAdaptor;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.MFWPhysID;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.MFWPhysMDLog;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.QueryRelmdGateway;
import com.ibm.cognos.relmd.metadata._schema.Catalog;
import com.ibm.cognos.relmd.metadata._schema.Schema;
import com.ibm.cognos.relmd.metadata._schema.Synonym;
import com.ibm.cognos.relmd.metadata._schema.Table;
import com.ibm.cognos.relmd.metadata._schema.View;
import com.ibm.cognos.relmd.metadata._schema.elements.Column;
import com.ibm.cognos.relmd.metadata._schema.properties.SqlObjectPath;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.rules.SqlColumnConversionRules;
import com.ibm.cognos.relmd.metadata.import_.results.SqlObjectColumnsResults;
import com.ibm.cognos.relmd.session._schema.SqlObjectConflict;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.util.ArrayList;
import java.util.List;

public class QueryRelMDResultHandler
implements SqlObjectColumnsResults {
    private MFWPhysMDLog mDbgTrace = MFWPhysMDLog.getInstance();
    private QueryRelmdGateway mQueryRelmdGW;
    private MFWPhysID mPhysID;
    private SqlColumnConversionRules mDataTypeRules;
    private ArrayList<Synonym> mSynonymsList = new ArrayList();
    private ArrayList<Column> mColumnList = new ArrayList();
    private boolean mTargetFound = false;
    private boolean mIsView;

    QueryRelMDResultHandler(QueryRelmdGateway qgw, MFWPhysID objPhysID, SqlColumnConversionRules dataTypeRules) {
        this.mQueryRelmdGW = qgw;
        this.mPhysID = objPhysID;
        this.mDataTypeRules = dataTypeRules;
    }

    public boolean targetExists() {
        return this.mTargetFound;
    }

    public boolean isTargetView() {
        return this.mIsView;
    }

    public List<Column> getTargetColumns() {
        return this.mColumnList;
    }

    public SqlColumnConversionRules getColumnConversionRules() {
        return this.mDataTypeRules;
    }

    public Handler<Column> columnHandler() {
        return new Handler<Column>(){

            public void handle(Column column) {
                MFWException.ASSERT((column != null ? 1 : 0) != 0, (String)"RELMD passed null column when looking for: ", (String)QueryRelMDResultHandler.this.mPhysID.getID());
                MFWException.ASSERT((boolean)(QueryRelMDResultHandler.this.mTargetFound = true), (String)"Columns are being added without finding a target first while looking for: ", (String)QueryRelMDResultHandler.this.mPhysID.getID());
                QueryRelMDResultHandler.this.mColumnList.add(column);
            }
        };
    }

    public Handler<Catalog> catalogHandler() {
        return new Handler<Catalog>(){

            public void handle(Catalog catalog) {
                MFWException.ASSERT((catalog != null ? 1 : 0) != 0, (String)"RELMD passed null catalog when looking for: ", (String)QueryRelMDResultHandler.this.mPhysID.getID());
                if (!"".equals(QueryRelMDResultHandler.this.mPhysID.getCatalog())) {
                    MFWException.ASSERT((0 == QueryRelMDResultHandler.this.mPhysID.getCatalog().compareToIgnoreCase(catalog.objectName()) ? 1 : 0) != 0, (String)("Unexpected catalog '" + catalog.objectName() + "'"));
                }
            }
        };
    }

    public Handler<Schema> schemaHandler() {
        return new Handler<Schema>(){

            public void handle(Schema schema) {
                MFWException.ASSERT((schema != null ? 1 : 0) != 0, (String)"RELMD passed null schema when looking for: ", (String)QueryRelMDResultHandler.this.mPhysID.getID());
                if (!"".equals(QueryRelMDResultHandler.this.mPhysID.getSchema())) {
                    MFWException.ASSERT((schema.objectName() != null ? 1 : 0) != 0, (String)"RELMD passed null schema when looking for: ", (String)QueryRelMDResultHandler.this.mPhysID.getID());
                    MFWException.ASSERT((0 == QueryRelMDResultHandler.this.mPhysID.getSchema().compareToIgnoreCase(schema.objectName()) ? 1 : 0) != 0, (String)("Unexpected schema '" + schema.objectName() + "'"));
                }
            }
        };
    }

    public Handler<SqlObjectConflict> sqlObjectConflictHandler() {
        return new Handler<SqlObjectConflict>(){

            public void handle(SqlObjectConflict obj) {
                StringBuffer sMsg = new StringBuffer("Ambiguous SQL query!  The query has matched multiple objects...");
                for (SqlObjectPath path : obj.sqlObjectPathCollection()) {
                    sMsg.append(String.format("\nAmbiguous:  catalog:[%s] schema:[%s] object:[%s]", path.schemaPath().parentCatalogName(), path.schemaPath().parentSchemaName(), path.objectName()));
                }
                QueryRelMDResultHandler.this.mDbgTrace.log(sMsg.toString(), new Object[0]);
                QueryRelMDResultHandler.this.mQueryRelmdGW.cancelQuery();
                MFWMessage m = new MFWMessage("mfw4j", "MFW_UT_INTERNAL_ERROR_DETAIL", (Object[])new String[]{sMsg.toString()});
                MFWException e = new MFWException();
                e.addMessage(m);
                throw e;
            }
        };
    }

    public Handler<Synonym> synonymHandler() {
        return new Handler<Synonym>(){

            public void handle(Synonym synonym) {
                MFWException.ASSERT((synonym != null ? 1 : 0) != 0, (String)"RELMD passed null synonym");
                QueryRelMDResultHandler.this.mSynonymsList.add(synonym);
                if (QueryRelMDResultHandler.this.mSynonymsList.size() == 1) {
                    QueryRelMDResultHandler.this.mDbgTrace.log("DBLoader(id=%d) matched a synonym", this.hashCode());
                } else {
                    QueryRelMDResultHandler.this.mDbgTrace.log("DBLoader(id=%d) synonym target resolved to a synonym", this.hashCode());
                    int nMaxSynonymTraversals = MFWPhysMDAdaptor.capability_MaxSynonymTraversals();
                    if (-1 != nMaxSynonymTraversals && QueryRelMDResultHandler.this.mSynonymsList.size() > nMaxSynonymTraversals) {
                        QueryRelMDResultHandler.this.mDbgTrace.log("Maximum number of traversals(%d) exceeded", nMaxSynonymTraversals);
                        QueryRelMDResultHandler.this.mDbgTrace.log("RELMD query cancelled.", new Object[0]);
                        QueryRelMDResultHandler.this.mQueryRelmdGW.cancelQuery();
                    }
                }
            }
        };
    }

    public Handler<Table> tableHandler() {
        return new Handler<Table>(){

            public void handle(Table table) {
                MFWException.ASSERT((table != null ? 1 : 0) != 0, (String)"RELMD passed null table");
                if (QueryRelMDResultHandler.this.mSynonymsList.size() == 0) {
                    QueryRelMDResultHandler.this.mDbgTrace.log("DBLoader(id=%d) matched a table", this.hashCode());
                    MFWException.ASSERT((0 == QueryRelMDResultHandler.this.mPhysID.getTable().compareToIgnoreCase(table.objectName()) ? 1 : 0) != 0, (String)("Unexpected table '" + table.objectName() + "'"));
                } else {
                    QueryRelMDResultHandler.this.mDbgTrace.log("DBLoader(id=%d) synonym target resolved to a table", this.hashCode());
                    String sTargetSynonym = ((Synonym)QueryRelMDResultHandler.this.mSynonymsList.get(0)).objectName();
                    MFWException.ASSERT((0 == QueryRelMDResultHandler.this.mPhysID.getTable().compareToIgnoreCase(sTargetSynonym) ? 1 : 0) != 0, (String)("Unexpected table '" + table.objectName() + "'"));
                }
                QueryRelMDResultHandler.this.mIsView = false;
                QueryRelMDResultHandler.this.mTargetFound = true;
            }
        };
    }

    public Handler<View> viewHandler() {
        return new Handler<View>(){

            public void handle(View view) {
                MFWException.ASSERT((view != null ? 1 : 0) != 0, (String)"RELMD passed null view");
                if (QueryRelMDResultHandler.this.mSynonymsList.size() == 0) {
                    QueryRelMDResultHandler.this.mDbgTrace.log("DBLoader(id=%d) matched a view", this.hashCode());
                    MFWException.ASSERT((0 == QueryRelMDResultHandler.this.mPhysID.getTable().compareToIgnoreCase(view.objectName()) ? 1 : 0) != 0, (String)"Unexpected table name");
                    QueryRelMDResultHandler.this.mIsView = true;
                } else {
                    QueryRelMDResultHandler.this.mDbgTrace.log("DBLoader(id=%d) synonym target resolved to a view", this.hashCode());
                    String sTargetSynonym = ((Synonym)QueryRelMDResultHandler.this.mSynonymsList.get(0)).objectName();
                    MFWException.ASSERT((0 == QueryRelMDResultHandler.this.mPhysID.getTable().compareToIgnoreCase(sTargetSynonym) ? 1 : 0) != 0, (String)("Unexpected synonym '" + view.objectName() + "'"));
                    QueryRelMDResultHandler.this.mIsView = false;
                }
                QueryRelMDResultHandler.this.mTargetFound = true;
            }
        };
    }
}

