/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.IMFWUsageIndicator;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataDBConnectionPool.DbConnectionPool;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataDBConnectionPool.DbConnectionPoolImposter;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataDBConnectionPool.IDbConnectionPool;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.CheckString;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.MFWPhysID;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.MFWPhysMDLog;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.QueryRelMDResultHandler;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.StringUtils;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.MetadataSqlColumnConversionToolkit;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportToolkit;
import com.ibm.cognos.relmd.metadata.import_.functions.SqlObjectColumnsImport;
import com.ibm.cognos.relmd.metadata.import_.results.SqlObjectColumnsResults;
import com.ibm.cognos.relmd.metadata.import_.rules.SqlObjectColumnsImportRules;
import com.ibm.cognos.relmd.metadata.objectPaths.MetadataObjectPathsToolkit;
import com.ibm.cognos.relmd.metadata.objectPaths.SqlObjectQueryPath;
import com.ibm.cognos.relmd.session.SessionToolkit;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.session.access.SessionAccessToolkit;
import com.ibm.cognos.relmd.session.query.SessionQueryRules;
import com.ibm.cognos.relmd.vendor.VendorRules;
import com.ibm.cognos.relmd.vendor.VendorToolkit;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.vendor.access.VendorAccessToolkit;
import com.ibm.cognos.relmd.vendor.access._schema.BeginJava;
import com.ibm.cognos.relmd.vendor.access._schema.BeginSql;
import com.ibm.cognos.relmd.vendor.access._schema.ExecutionError;
import com.ibm.cognos.relmd.vendor.access._schema.ExecutionInformation;
import com.ibm.cognos.relmd.vendor.access._schema.ResultSetProcessingError;
import com.ibm.cognos.relmd.vendor.access._schema.ResultSetProcessingInformation;
import com.ibm.cognos.relmd.vendor.connection.ConnectionParameters;
import com.ibm.cognos.relmd.vendor.connection.ExtendedParameterLookup;
import com.ibm.cognos.relmd.vendor.connection.VendorConnectionToolkit;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;

public final class QueryRelmdGateway {
    private static final String TAG_lookupConnection = "MFWA4J/QueryRelmdGateway/lookupConnection";
    private static final String TAG_openConnection = "MFWA4J/QueryRelmdGateway/openConnection";
    private static final String TAG_closeConnection = "MFWA4J/QueryRelmdGateway/closeConnection";
    private static final String TAG_runQuery = "MFWA4J/QueryRelmdGateway/runQuery";
    private MFWPhysMDLog mDbgTrace = MFWPhysMDLog.getInstance();
    private static boolean mbInitRelmd = false;
    private static Map<Database.EVendorType, VendorRules> mConfiguredRulesMap;
    private MFWRequestContextUser mUserContext;
    private IDbConnectionPool mConnectionPoolItem;
    private String msCmDatasourceName;
    private boolean mbUseXQEConnectionPool;
    private Connection mRelmdConnection;
    private Relmd mRelmdGateway = RelmdGateway.relmd();
    private SessionToolkit mSessionToolkit = this.mRelmdGateway.sessionToolkit();
    private SessionAccessToolkit mSessionAccessToolkit = this.mSessionToolkit.sessionAccessToolkit();
    private MetadataToolkit mMetadataToolkit = this.mRelmdGateway.metadataToolkit();
    private MetadataImportToolkit mRelmdImportToolkit = this.mMetadataToolkit.metadataImportToolkit();
    private MetadataSqlColumnConversionToolkit mDataTypeMappingToolkit = this.mMetadataToolkit.metadataSqlColumnConversionToolkit();
    private VendorToolkit mVendorToolkit = this.mRelmdGateway.vendorToolkit();
    private VendorAccessToolkit mVendorAccessToolkit = this.mVendorToolkit.vendorAccessToolkit();
    private VendorConnectionToolkit mVendorConnectionToolkit = this.mVendorToolkit.vendorConnectionToolkit();
    private MetadataObjectPathsToolkit mObjectPathsToolkit = this.mMetadataToolkit.metadataObjectPathsToolkit();
    private SqlObjectColumnsImport mRunQuery_TargetColumnsImport;
    private SessionAccess mSessionAccess;
    VendorAccessHandler mRelmdEventCollector = new VendorAccessHandler(){
        private Handler<BeginJava> m_beginJavaHandler = new Handler<BeginJava>(){

            public void handle(BeginJava event) {
                QueryRelmdGateway.this.mDbgTrace.logStart();
                String jdbcMethodName = event.methodName();
                String[] params = event.parameters();
                QueryRelmdGateway.this.mDbgTrace.log("RELMD JAVA API call:  %s, params: %s", jdbcMethodName, null != params ? params.toString() : "<empty>");
                QueryRelmdGateway.this.mDbgTrace.logEnd();
            }
        };
        private Handler<BeginSql> m_beginSqlHandler = new Handler<BeginSql>(){

            public void handle(BeginSql arg0) {
                QueryRelmdGateway.this.mDbgTrace.logStart();
                String sqlText = arg0.sqlText();
                QueryRelmdGateway.this.mDbgTrace.log("RELMD Generated SQL:  %s", sqlText);
                QueryRelmdGateway.this.mDbgTrace.logEnd();
            }
        };
        private Handler<ExecutionError> m_executionErrorHandler = new Handler<ExecutionError>(){

            public void handle(ExecutionError arg0) {
                QueryRelmdGateway.this.mDbgTrace.logStart();
                String message = arg0.message();
                QueryRelmdGateway.this.mDbgTrace.log("RELMD JSQL Error:  %s", message);
                QueryRelmdGateway.this.mDbgTrace.logEnd();
            }
        };
        private Handler<ExecutionInformation> m_executioInfoHandler = new Handler<ExecutionInformation>(){

            public void handle(ExecutionInformation arg0) {
                QueryRelmdGateway.this.mDbgTrace.logStart();
                String message = arg0.message();
                QueryRelmdGateway.this.mDbgTrace.log("RELMD JSQL Info:  %s", message);
                QueryRelmdGateway.this.mDbgTrace.logEnd();
            }
        };
        private Handler<ResultSetProcessingError> m_resultSetProcessingErrorHandler = new Handler<ResultSetProcessingError>(){

            public void handle(ResultSetProcessingError arg0) {
                QueryRelmdGateway.this.mDbgTrace.logStart();
                int iteration = arg0.rowNumber();
                String message = arg0.message();
                QueryRelmdGateway.this.mDbgTrace.log("RELMD JDBC ResultSet Processing Error, iteration: %s, message: %s", iteration, message);
                QueryRelmdGateway.this.mDbgTrace.logEnd();
            }
        };
        private Handler<ResultSetProcessingInformation> m_resultSetProcessingInformationHandler = new Handler<ResultSetProcessingInformation>(){

            public void handle(ResultSetProcessingInformation arg0) {
                QueryRelmdGateway.this.mDbgTrace.logStart();
                int iteration = arg0.rowNumber();
                String message = arg0.message();
                QueryRelmdGateway.this.mDbgTrace.log("RELMD JDBC ResultSet Processing Info, iteration: %s, message: %s", iteration, message);
                QueryRelmdGateway.this.mDbgTrace.logEnd();
            }
        };

        public Handler<BeginJava> beginJavaHandler() {
            return this.m_beginJavaHandler;
        }

        public Handler<BeginSql> beginSqlHandler() {
            return this.m_beginSqlHandler;
        }

        public Handler<ExecutionError> executionErrorHandler() {
            return this.m_executionErrorHandler;
        }

        public Handler<ExecutionInformation> executionInformationHandler() {
            return this.m_executioInfoHandler;
        }

        public Handler<ResultSetProcessingError> resultSetProcessingErrorHandler() {
            return this.m_resultSetProcessingErrorHandler;
        }

        public Handler<ResultSetProcessingInformation> resultSetProcessingInformationHandler() {
            return this.m_resultSetProcessingInformationHandler;
        }
    };

    public QueryRelmdGateway(MFWRequestContextUser aUserContext, boolean bUseXQEConnectionPool) {
        QueryRelmdGateway.initRelmd();
        MFWException.ASSERT((boolean)mbInitRelmd, (String)"RELMD is not initialized");
        this.mUserContext = aUserContext;
        this.mbUseXQEConnectionPool = bUseXQEConnectionPool;
    }

    private static void initRelmd() {
        if (!mbInitRelmd) {
            ICCLConfiguration icclConfig = CCLConfigurationFactory.getInstance();
            try {
                mConfiguredRulesMap = RelmdGateway.relmd().vendorToolkit().configuredRules(icclConfig);
            }
            catch (FileNotFoundException e) {
                MFWException.ASSERT((boolean)false, (String)e.toString());
            }
            MFWException.ASSERT((mConfiguredRulesMap != null ? 1 : 0) != 0, (String)"RELMD is not initialized");
            mbInitRelmd = true;
        }
    }

    public void destroy() {
        this.mConnectionPoolItem = null;
        this.mRelmdGateway = null;
        this.mRelmdImportToolkit = null;
        this.mDataTypeMappingToolkit = null;
        this.mRelmdEventCollector = null;
        this.mMetadataToolkit = null;
        this.mVendorToolkit = null;
        this.mObjectPathsToolkit = null;
        this.mUserContext = null;
    }

    IDbConnectionPool lookupConnection(String sCmDatasourceName) {
        long b4Time = System.currentTimeMillis();
        IDbConnectionPool connectionInfo = this.mbUseXQEConnectionPool ? new DbConnectionPool(sCmDatasourceName, (ExecutionEnvironment)this.mUserContext.getXQEExecutionEnvironment()) : new DbConnectionPoolImposter(sCmDatasourceName);
        this.logUsageIndicator(TAG_lookupConnection, b4Time);
        return connectionInfo;
    }

    public void openConnection(String sCmDatasourceName) {
        this.msCmDatasourceName = sCmDatasourceName;
        this.mDbgTrace.logStart();
        this.mDbgTrace.log("Open a JDBC connection for the following:", new Object[0]);
        this.mDbgTrace.log("  cmDatasource=%s", sCmDatasourceName);
        if (this.mbUseXQEConnectionPool) {
            this.mDbgTrace.log("Using XQE connection pool...", new Object[0]);
        } else {
            this.mDbgTrace.log("Using connection pool imposter...", new Object[0]);
        }
        this.mConnectionPoolItem = this.lookupConnection(sCmDatasourceName);
        this.mDbgTrace.log(this.mConnectionPoolItem);
        this.mDbgTrace.log("Borrowing the JDBC connection...", new Object[0]);
        ExtendedParameterLookup extendedParameterLookup = null;
        long b4Time = System.currentTimeMillis();
        this.mRelmdConnection = this.mConnectionPoolItem.doConnectionBorrow();
        Database.EVendorType vendorType = this.vendorType();
        Database.EVendorType rawVendorType = this.vendorType();
        ConnectionParameters connectionParameters = this.mVendorConnectionToolkit.connectionParameters(vendorType, rawVendorType, this.mConnectionPoolItem.connectionString(), this.mConnectionPoolItem.driverClass(), this.mConnectionPoolItem.userID(), this.mConnectionPoolItem.password(), extendedParameterLookup, "en");
        VendorAccessResults vendorAccess = this.mVendorAccessToolkit.vendorAccessResults(this.mRelmdEventCollector);
        SessionQueryRules sessionQueryRules = this.vendorRules().sessionQueryRules();
        this.mSessionAccess = this.mSessionAccessToolkit.sessionAccess(this.mRelmdConnection, connectionParameters, sessionQueryRules, vendorAccess);
        this.logUsageIndicator(TAG_openConnection, b4Time);
        this.mDbgTrace.log("JDBC connection borrowed.", new Object[0]);
        this.mDbgTrace.logEnd();
    }

    public void closeConnection() {
        this.mDbgTrace.logStart();
        this.mDbgTrace.log("Returning the JDBC connection...", new Object[0]);
        long b4Time = System.currentTimeMillis();
        if (this.mConnectionPoolItem != null) {
            this.mConnectionPoolItem.doConnectionReturn();
            this.mConnectionPoolItem = null;
        }
        this.logUsageIndicator(TAG_closeConnection, b4Time);
        this.msCmDatasourceName = null;
        this.mRelmdConnection = null;
        this.mRunQuery_TargetColumnsImport = null;
        this.mDbgTrace.log("JDBC connection returned", new Object[0]);
        this.mDbgTrace.logEnd();
    }

    public void setNotReusable() {
        if (this.mConnectionPoolItem != null) {
            this.mConnectionPoolItem.setNotReusable();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Database.EVendorType vendorType() {
        Database.EVendorType vendorType = Database.EVendorType.valueOf((String)this.mConnectionPoolItem.vendorType());
        if (vendorType.equals((Object)Database.EVendorType.db2)) {
            try {
                DatabaseMetaData md = this.mRelmdConnection.getMetaData();
                String productVersion = md.getDatabaseProductVersion();
                if (productVersion.indexOf("DSN") >= 0) return Database.EVendorType.generic;
                if (productVersion.indexOf("QSQ") < 0) return vendorType;
                return Database.EVendorType.generic;
            }
            catch (SQLException se) {
                throw new RuntimeException(se);
            }
        }
        if (!vendorType.equals((Object)Database.EVendorType.netezza)) return vendorType;
        return Database.EVendorType.generic;
    }

    private VendorRules vendorRules() {
        Database.EVendorType keyVendorType = this.vendorType();
        VendorRules vendorRules = null;
        if (mConfiguredRulesMap.containsKey(keyVendorType)) {
            vendorRules = mConfiguredRulesMap.get(keyVendorType);
        } else {
            MFWException.ASSERT((boolean)false, (String)("Vendor rules missing for '" + keyVendorType.toString() + "'"));
        }
        MFWException.ASSERT((vendorRules != null ? 1 : 0) != 0, (String)"Failed to lookup vendor rules");
        return vendorRules;
    }

    void cancelQuery() {
        this.mRunQuery_TargetColumnsImport.stop();
    }

    public MetadataSqlColumnConversionToolkit getDataTypeMappingToolkit() {
        return this.mDataTypeMappingToolkit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryRelMDResultHandler queryTarget(MFWPhysID objPhysID) {
        long b4Time = System.currentTimeMillis();
        MFWException.ASSERT((boolean)CheckString.exists(objPhysID.getTable()), (String)"Search missing target object name");
        MFWException.ASSERT((objPhysID.getCatalog() != null ? 1 : 0) != 0, (String)"Null catalog name");
        MFWException.ASSERT((objPhysID.getSchema() != null ? 1 : 0) != 0, (String)"Null schema name");
        VendorRules vendorRules = this.vendorRules();
        SessionQueryRules sessionQueryRules = vendorRules.sessionQueryRules();
        Database.ECatalogSupport catalogSupport = sessionQueryRules.catalogSupport();
        SqlObjectQueryPath sqlObjectQueryPath = this.mObjectPathsToolkit.sqlObjectQueryPath(catalogSupport, CheckString.exists(objPhysID.getCatalog()) ? objPhysID.getCatalog() : null, CheckString.exists(objPhysID.getSchema()) ? objPhysID.getSchema() : null, objPhysID.getTable());
        QueryRelMDResultHandler resultsHandler = new QueryRelMDResultHandler(this, objPhysID, vendorRules.sqlColumnConversionRules());
        SqlObjectColumnsImportRules columnRules = vendorRules.metadataImportRules().sqlObjectColumnsImportRules();
        this.mRunQuery_TargetColumnsImport = this.mRelmdImportToolkit.sqlObjectColumnsImport(this.mSessionAccess, sqlObjectQueryPath, columnRules, (SqlObjectColumnsResults)resultsHandler);
        try {
            this.mRunQuery_TargetColumnsImport.run(this.mRelmdConnection);
            this.logUsageIndicator(TAG_runQuery, b4Time);
        }
        catch (Throwable th) {
            if (th instanceof RuntimeException && "jdbcSQLException".equalsIgnoreCase(th.getMessage())) {
                this.setNotReusable();
            }
            try {
                String sErrMsg = "\n\nMFW Physical Metadata database lookup failed.\n\n  MFW Query:\n                            Database: '" + StringUtils.null2NA(this.msCmDatasourceName) + "'\n                             Catalog: '" + StringUtils.null2NA(objPhysID.getCatalog()) + "'\n                              Schema: '" + StringUtils.null2NA(objPhysID.getSchema()) + "'\n                              Object: '" + StringUtils.null2NA(objPhysID.getTable()) + "'\n\n  JDBC connection:\n                     Connection name: '" + StringUtils.null2NA(this.msCmDatasourceName) + "'\n                   Connection String: '" + StringUtils.null2NA(this.mConnectionPoolItem.connectionString()) + "'\n                              UserID: '" + StringUtils.null2NA(this.mConnectionPoolItem.userID()) + "'\n                        Driver Class: '" + StringUtils.null2NA(this.mConnectionPoolItem.driverClass()) + "'\n                         Vendor Type: '" + StringUtils.null2NA(this.mConnectionPoolItem.vendorType()) + "'\n\n  RELMD object selections:\n    [" + StringUtils.null2NA(sqlObjectQueryPath.toString()).trim() + "]\n\n  Error message:\n    [" + StringUtils.null2NA(th.getMessage()).trim() + "]\n\n  Stack trace:\n    [" + StringUtils.null2NA(StringUtils.getStackTrace(th)).trim() + "]\n\n";
                this.mDbgTrace.log(sErrMsg, new Object[0]);
            }
            finally {
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                throw new RuntimeException(th);
            }
        }
        return resultsHandler;
    }

    private void logUsageIndicator(String category, long b4Time) {
        long executionTime = System.currentTimeMillis() - b4Time;
        IMFWUsageIndicator usageIndicator = this.mUserContext.getXQEUsageIndicatorService();
        if (usageIndicator != null) {
            usageIndicator.logMeasurements(category, executionTime);
        }
    }

    static {
        QueryRelmdGateway.initRelmd();
    }
}

