/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorPhysicalMDFM;

import com.cognos.mfw4j.framework.MFWAdaptor;
import com.cognos.mfw4j.framework.MFWConnection;
import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.log.MFWLogRuntimeIndicators;
import com.cognos.mfw4j.utilities.IMFWUsageIndicator;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfwa4j.adaptorPhysicalMDFM.MFWPhysMDFMAdaptor;
import com.cognos.mfwa4j.adaptorPhysicalMDFM.MFWPhysMDFMConnectionReuse;
import com.cognos.mfwa4j.adaptorPhysicalMDFM.MFWPhysMDFMLoader;
import com.cognos.mfwa4j.adaptorPhysicalMDFM.MFWPhysMDIDGenerator;
import java.util.List;

final class MFWPhysMDFMConnection
extends MFWConnection {
    private static final String TAG_buildPMC = "MFWA4J/PhysMDConnection/buildPhysMDPMC";

    MFWPhysMDFMConnection(MFWConnectionReuseInfo aReuseInfo, MFWPhysMDFMAdaptor anAdaptor) {
        super(aReuseInfo, (MFWAdaptor)anAdaptor);
    }

    public void destroy() {
        super.destroy();
    }

    public void initialSetup(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
        MFWException.ASSERT((aLinkNodeParent != null && aLinkNodeParent.getNameRID() == MFWModelRes.getInstance().RID_project ? 1 : 0) != 0, (String)"Expecting a link node parent of type project");
        MFWLogRuntimeIndicators dbg = null;
        StringBuilder dbgHint = new StringBuilder("Loading Physical Metadata for FM model ");
        dbgHint.append(((MFWPhysMDFMConnectionReuse)this.getReuseInfo()).getBaseModelPath());
        try {
            dbg = new MFWLogRuntimeIndicators(dbgHint.toString());
            MFWPhysMDIDGenerator myIDGenerator = new MFWPhysMDIDGenerator(this.getCluster().getIndexManager());
            MFWNodeObject objPhysMDSrcs = this.getCluster().getRootNode().addObjectNode(MFWModelRes.getInstance().RID_physicalSources);
            myIDGenerator.generate(objPhysMDSrcs, null);
            this.setupDynamicPhysicalMetadataLink(objPhysMDSrcs);
            long b4PMCBuildTime = System.currentTimeMillis();
            MFWPhysMDFMLoader myLoader = new MFWPhysMDFMLoader(myIDGenerator, objPhysMDSrcs, aLinkNodeParent, aContext);
            myLoader.extractMetadata();
            long executionTime = System.currentTimeMillis() - b4PMCBuildTime;
            IMFWUsageIndicator usageIndicator = aContext.getXQEUsageIndicatorService();
            if (usageIndicator != null) {
                usageIndicator.logMeasurements(TAG_buildPMC, executionTime);
            }
            dbg.logEnd();
        }
        catch (RuntimeException rt) {
            if (dbg != null) {
                dbg.logEnd((Throwable)rt);
            }
            throw rt;
        }
        catch (Exception e) {
            if (dbg != null) {
                dbg.logEnd((Throwable)e);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void setupDynamicPhysicalMetadataLink(MFWNodeObject objPhysMDSrcs) {
        String modelFilePath;
        MFWMetadataSource aPhysSource = MFWMetadataSource.create((String)"modelPhysical");
        String modelCMPath = (String)this.getSource().getConnectionItem("cmSearchPath");
        if (modelCMPath != null) {
            aPhysSource.addConnectionItem("cmSearchPath", (Object)modelCMPath);
        }
        if ((modelFilePath = (String)this.getSource().getConnectionItem("modelFilePath")) != null) {
            aPhysSource.addConnectionItem("modelFilePath", (Object)modelFilePath);
        }
        short idLinkSrc = this.getCluster().getLinkManager().findOrAddLink(aPhysSource, objPhysMDSrcs);
        objPhysMDSrcs.addLinkNode(MFWModelRes.getInstance().RID_physicalSource, idLinkSrc, "/physicalSources/physicalSource");
    }

    protected void reconstructSetup(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
    }

    protected void expandAll(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
    }

    protected void expand(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, MFWNodeObject objNode) {
        super.defaultExpand(aContext, aQuerySpec.getCurrentStepPatternRID(), objNode);
    }

    protected MFWNodeObject lookup(MFWRequestContextUser context, MFWInfoProperty indexProp, String indexValue, MFWNodeObject rootNode, List<MFWNodeObject> ancestorsChain) {
        return null;
    }
}

