/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorPhysicalMDFM;

import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.implPersistence.MFWPersistentMetadataCluster;
import com.cognos.mfw4j.utilities.MFWException;

final class MFWPhysMDFMConnectionReuse
extends MFWConnectionReuseInfo {
    private String mFmModelPackageIdentifier = null;
    private String mFmModelTimeStamp = null;
    private String mFmModelPath = null;

    static MFWPhysMDFMConnectionReuse reconstruct(MFWPersistentMetadataCluster aPMC, int aPosition) {
        MFWPhysMDFMConnectionReuse outRI = new MFWPhysMDFMConnectionReuse();
        outRI.load(aPMC, aPosition);
        return outRI;
    }

    MFWPhysMDFMConnectionReuse(MFWRequestContextUser aContext, MFWMetadataSource aMetadataSrc, MFWNodeObject aLinkParent) {
        super(aMetadataSrc);
        MFWException.ASSERT((aLinkParent != null ? 1 : 0) != 0, (String)"Expecting a valid link parent node when creating reuse info for physical metadata");
        this.mFmModelPath = (String)aMetadataSrc.getConnectionItem("cmSearchPath");
        if (this.mFmModelPath == null || this.mFmModelPath.length() == 0) {
            this.mFmModelPath = (String)aMetadataSrc.getConnectionItem("modelFilePath");
        }
        MFWException.ASSERT((this.mFmModelPath != null ? 1 : 0) != 0, (String)"The published model must have a path where it is stored");
        String sFmModelPMCPath = aLinkParent.getCluster().getConnection().getReuseInfo().getPersistentClusterFilePath();
        MFWException.ASSERT((sFmModelPMCPath != null ? 1 : 0) != 0, (String)"Expecting a valid persistent cluster file path for parent of the physical metadata cluster");
        int lastSlash = sFmModelPMCPath.lastIndexOf(47);
        this.mFmModelPackageIdentifier = sFmModelPMCPath.substring(0, lastSlash);
        this.mFmModelTimeStamp = sFmModelPMCPath.substring(lastSlash + 1, sFmModelPMCPath.indexOf(".pmc"));
        MFWException.ASSERT((this.mFmModelPackageIdentifier != null && this.mFmModelTimeStamp != null ? 1 : 0) != 0, (String)"Unable to extract reuse factors for physical metadata connection from PMC path:", (String)sFmModelPMCPath);
    }

    private MFWPhysMDFMConnectionReuse() {
    }

    public void destroy() {
        super.destroy();
    }

    protected boolean isReusableFor(MFWConnectionReuseInfo targetReuseInfo) {
        boolean bMatch = this.mFmModelPackageIdentifier.equals(((MFWPhysMDFMConnectionReuse)targetReuseInfo).mFmModelPackageIdentifier);
        return bMatch;
    }

    public StringBuffer getPersistentPath() {
        StringBuffer path = new StringBuffer(this.mFmModelPackageIdentifier);
        path.append("/");
        path.append(this.mFmModelTimeStamp);
        path.append("_Phys");
        return path;
    }

    protected boolean isCacheUpToDate(MFWRequestContextUser aContext, MFWConnectionReuseInfo targetReuseInfo) {
        boolean bMatch = false;
        String targetTimeStamp = ((MFWPhysMDFMConnectionReuse)targetReuseInfo).mFmModelTimeStamp;
        bMatch = this.mFmModelTimeStamp.equals(targetTimeStamp);
        return bMatch;
    }

    final String getBaseModelPath() {
        return this.mFmModelPath;
    }
}

