/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorReport;

import com.cognos.ccl4j.util.CCLXMLUtils;
import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWCrnIDGenerator;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.log.MFWLogReportClusterBeforeValidation;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import com.cognos.mfwa4j.adaptorReport.BasedOnInfo;
import com.cognos.mfwa4j.adaptorReport.MFWDBConversions;
import com.cognos.mfwa4j.adaptorReport.MFWRptAdaptor;
import com.cognos.mfwa4j.adaptorReport.MFWV5ExpressionParser;
import com.cognos.mfwa4j.adaptorReport.MFWV5QueryHelper;
import com.cognos.mfwa4j.v5Bridge.MFWV5Bridge;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

class MFWV5ModelLoader {
    private MFWRequestContextUser m_context;
    private MFWCrnIDGenerator m_pIDGenerator;
    private XMLStreamReader m_parser;
    private MFWMetadataSource m_metadataSrc;
    private MFWCluster m_cluster;
    private String m_rootNamespaceName;
    private MFWModelRes m_modelRes;
    private MFWNodeObject m_projectNode;
    private MFWNodeObject m_rootNamespaceNode;
    private String m_expressionLocale;
    private String m_pkgPath;
    private int m_relationshipCount = 0;
    private Hashtable<MFWNodeObject, MFWNodeObject> m_queryToRelationships = new Hashtable();
    private ArrayList<MFWNodeObject> m_objectsToValidate = new ArrayList();
    private ArrayList<MFWNodeObject> m_dataSources = new ArrayList();
    private ArrayList<BasedOnInfo> m_vBasedOnItems = new ArrayList();
    private ArrayList<PropValueToFix> m_refObjsToFix = new ArrayList();
    private ArrayList<PropValueToFix> m_expressionsToFix = new ArrayList();

    MFWV5ModelLoader(MFWCluster cluster, MFWMetadataSource aMetadataSrc, MFWRequestContextUser aContext) {
        this.m_cluster = cluster;
        this.m_context = aContext;
        this.m_metadataSrc = aMetadataSrc;
        this.m_modelRes = MFWModelRes.getInstance();
        this.m_projectNode = null;
    }

    void destroy() {
        this.m_context = null;
        this.m_pIDGenerator.destroy();
        this.m_pIDGenerator = null;
        this.m_refObjsToFix.clear();
        this.m_expressionsToFix.clear();
    }

    void load(String v5Spec) {
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(v5Spec.getBytes("UTF-8"));
            XMLInputFactory factory = XMLInputFactory.newInstance();
            this.m_parser = factory.createXMLStreamReader(inStream);
            this.startRoot();
            this.parseComplete();
        }
        catch (XMLStreamException st) {
            throw new RuntimeException(st.getMessage(), st);
        }
        catch (UnsupportedEncodingException ue) {
            throw new RuntimeException(ue.getMessage(), ue);
        }
    }

    private boolean moveToTag(String localName, String parentContext) throws XMLStreamException {
        int next = this.m_parser.next();
        while (next != 8) {
            if (next == 1 && localName.equals(this.m_parser.getLocalName())) {
                return true;
            }
            if (next == 2 && parentContext != null && parentContext.equals(this.m_parser.getLocalName())) {
                return false;
            }
            next = this.m_parser.next();
        }
        return false;
    }

    private boolean endEncountered(String endTag) {
        if (this.m_parser.getEventType() == 8) {
            return true;
        }
        return this.m_parser.getEventType() == 2 && endTag.equals(this.m_parser.getLocalName());
    }

    private void startRoot() throws XMLStreamException {
        MFWException.ASSERT((boolean)this.moveToTag("querySet", null), (String)"Failed to find querySet");
        String exprLocale = this.m_parser.getAttributeValue(null, "expressionLocale");
        this.populateRootElements(exprLocale);
        while (!this.endEncountered("querySet")) {
            int next = this.m_parser.next();
            if (next != 1) continue;
            String elm = this.m_parser.getLocalName();
            if ("queries".equals(elm)) {
                this.processQueries(this.m_rootNamespaceNode);
                continue;
            }
            if (!"modelPath".equals(elm)) continue;
            this.processModelPath();
        }
    }

    private void processModelPath() throws XMLStreamException {
        MFWMetadataSource aLinkedSrc = MFWMetadataSource.create((String)"modelFM");
        this.m_pkgPath = this.m_parser.getElementText();
        aLinkedSrc.addConnectionItem("cmSearchPath", (Object)this.m_pkgPath);
        short idLinkSrc = this.m_cluster.getLinkManager().findOrAddLink(aLinkedSrc, this.m_rootNamespaceNode);
        this.m_rootNamespaceNode.addLinkNode(this.m_modelRes.RID_namespace, idLinkSrc, "/project/namespace[0]");
        MFWNodeObject pCustomProp = this.m_rootNamespaceNode.addObjectNode(this.m_modelRes.RID_property);
        pCustomProp.addProperty(this.m_modelRes.RID_name, "package");
        pCustomProp.addProperty(this.m_modelRes.RID__Value, this.m_pkgPath);
    }

    private void processQueries(MFWNodeObject namespace) throws XMLStreamException {
        while (this.moveToTag("query", "queries")) {
            String name = this.m_parser.getAttributeValue(null, "name");
            MFWNodeObject pObjQS = namespace.addObjectNode(this.m_modelRes.RID_querySubject);
            this.genObjectProperties(pObjQS, name);
            pObjQS.addProperty(this.m_modelRes.RID_definitionType, "modelQuery");
            while (!this.endEncountered("query")) {
                int next = this.m_parser.next();
                if (next != 1) continue;
                String elm = this.m_parser.getLocalName();
                if ("source".equals(elm)) {
                    String elem;
                    int n = this.m_parser.nextTag();
                    if (n != 1 || "model".equals(elem = this.m_parser.getLocalName()) || "queryRef".equals(elem)) continue;
                    if ("sqlQuery".equals(elem)) {
                        this.processSql(pObjQS);
                        continue;
                    }
                    if ("queryOperation".equals(elem)) {
                        this.processQueryOperation(pObjQS);
                        continue;
                    }
                    if (!"joinOperation".equals(elem)) continue;
                    this.processJoinOperand(pObjQS);
                    continue;
                }
                if ("selection".equals(elm)) {
                    this.processSelection(pObjQS);
                    continue;
                }
                if ("detailFilters".equals(elm)) {
                    this.processDetailFilters(pObjQS);
                    continue;
                }
                if ("summaryFilters".equals(elm)) {
                    this.processSummaryFilters(pObjQS);
                    continue;
                }
                if (!"slicer".equals(elm)) continue;
                this.processSlicer(pObjQS);
            }
            this.m_objectsToValidate.add(pObjQS);
        }
    }

    private void processSlicer(MFWNodeObject pObjQS) throws XMLStreamException {
        while (this.moveToTag("slicerMemberSet", "slicer")) {
            String expr = this.m_parser.getElementText();
            this.m_expressionsToFix.add(new PropValueToFix(pObjQS, this.m_modelRes.RID_slicerMemberSet, expr));
        }
    }

    private void processDetailFilters(MFWNodeObject pObjQS) throws XMLStreamException {
        while (this.moveToTag("detailFilter", "detailFilters")) {
            MFWNodeObject pFilterDef = pObjQS.addObjectNode(this.m_modelRes.RID_filterDefinition);
            String use = this.m_parser.getAttributeValue(null, "use");
            String mfwValue = use != null ? MFWV5ModelLoader.MapV5UseToMFW(use) : "always";
            pFilterDef.addProperty(this.m_modelRes.RID_apply, mfwValue);
            String postAutoAggregation = this.m_parser.getAttributeValue(null, "postAutoAggregation");
            if (postAutoAggregation != null) {
                pFilterDef.addProperty(this.m_modelRes.RID_postAutoAggregation, postAutoAggregation);
            }
            while (this.moveToTag("filterExpression", "detailFilter")) {
                String expr = this.m_parser.getElementText();
                this.m_expressionsToFix.add(new PropValueToFix(pFilterDef, this.m_modelRes.RID_expression, expr));
            }
        }
    }

    private void processSummaryFilters(MFWNodeObject pObjQS) throws XMLStreamException {
        while (this.moveToTag("summaryFilter", "summaryFilters")) {
            MFWNodeObject pSummaryFilter = pObjQS.addObjectNode(this.m_modelRes.RID_summaryFilter);
            String useValue = this.m_parser.getAttributeValue(null, "use");
            if (useValue != null) {
                pSummaryFilter.addProperty(this.m_modelRes.RID_use, useValue);
            }
            while (!this.endEncountered("summaryFilter")) {
                int n = this.m_parser.nextTag();
                if (n != 1) continue;
                String elm = this.m_parser.getLocalName();
                if ("filterExpression".equals(elm)) {
                    String expr = this.m_parser.getElementText();
                    this.m_expressionsToFix.add(new PropValueToFix(pSummaryFilter, this.m_modelRes.RID_filterExpression, expr));
                    continue;
                }
                if (!"summaryFilterLevels".equals(elm)) continue;
                while (this.moveToTag("summaryFilterLevel", "summaryFilterLevels")) {
                    String refDataItem = this.m_parser.getAttributeValue(null, "refDataItem");
                    if (refDataItem == null) continue;
                    pSummaryFilter.addProperty(this.m_modelRes.RID_summaryFilterLevel, refDataItem);
                }
            }
        }
    }

    private void processSelection(MFWNodeObject pObjQS) throws XMLStreamException {
        String autoSummary = this.m_parser.getAttributeValue(null, "autoSummary");
        if (autoSummary != null) {
            pObjQS.addProperty(this.m_modelRes.RID_autoSummary, autoSummary);
        } else {
            pObjQS.addProperty(this.m_modelRes.RID_autoSummary, true);
        }
        while (this.moveToTag("dataItem", "selection")) {
            String extendedCalculatedMember;
            String solveOrder;
            String onInaccessibleMember;
            String naInCalcMemberContext;
            String detail;
            String rollupAggregate;
            String sort;
            String mfwAggregateType;
            String name = this.m_parser.getAttributeValue(null, "name");
            MFWNodeObject pObjQItem = pObjQS.addObjectNode(this.m_modelRes.RID_queryItem);
            this.genObjectProperties(pObjQItem, name);
            String aggregate = this.m_parser.getAttributeValue(null, "aggregate");
            if (aggregate != null && (mfwAggregateType = MFWV5ModelLoader.MapV5AggregateToMFW(aggregate)) != null) {
                pObjQItem.addProperty(this.m_modelRes.RID_regularAggregate, mfwAggregateType);
            }
            if ((sort = this.m_parser.getAttributeValue(null, "sort")) != null) {
                pObjQItem.addProperty(this.m_modelRes.RID_sort, sort);
            }
            if ((rollupAggregate = this.m_parser.getAttributeValue(null, "rollupAggregate")) != null) {
                pObjQItem.addProperty(this.m_modelRes.RID_rollupAggregate, rollupAggregate);
            }
            if ((detail = this.m_parser.getAttributeValue(null, "detail")) != null) {
                pObjQItem.addProperty(this.m_modelRes.RID_detail, detail);
            }
            if ((naInCalcMemberContext = this.m_parser.getAttributeValue(null, "naInCalcMemberContext")) != null) {
                pObjQItem.addProperty(this.m_modelRes.RID_naInCalcMemberContext, naInCalcMemberContext);
            }
            if ((onInaccessibleMember = this.m_parser.getAttributeValue(null, "onInaccessibleMember")) != null) {
                pObjQItem.addProperty(this.m_modelRes.RID_onInaccessibleMember, onInaccessibleMember);
            }
            if ((solveOrder = this.m_parser.getAttributeValue(null, "solveOrder")) != null) {
                pObjQItem.addProperty(this.m_modelRes.RID_solveOrder, solveOrder);
            }
            if ((extendedCalculatedMember = this.m_parser.getAttributeValue(null, "extendedCalculatedMember")) != null) {
                pObjQItem.addProperty(this.m_modelRes.RID_extendedCalculatedMember, extendedCalculatedMember);
            }
            if (!this.moveToTag("expression", "dataItem")) continue;
            String exp = this.m_parser.getElementText();
            this.m_expressionsToFix.add(new PropValueToFix(pObjQItem, this.m_modelRes.RID_expression, exp));
        }
    }

    private void processSql(MFWNodeObject querySubject) throws XMLStreamException {
        MFWNodeObject dbQuerySubject = this.m_rootNamespaceNode.addObjectNode(this.m_modelRes.RID_querySubject);
        String name = this.m_parser.getAttributeValue(null, "name");
        this.genObjectProperties(dbQuerySubject, name);
        String dataSource = this.m_parser.getAttributeValue(null, "dataSource");
        String type = this.m_parser.getAttributeValue(null, "type");
        String sqlType = "native";
        if (type != null) {
            sqlType = type;
        }
        MFWNodeObject dataSourceNode = null;
        for (int i = 0; i < this.m_dataSources.size(); ++i) {
            String cmDataSource = this.m_dataSources.get(i).getPropertyValue(this.m_modelRes.RID_cmDataSource);
            if (!cmDataSource.equals(dataSource)) continue;
            dataSourceNode = this.m_dataSources.get(i);
            break;
        }
        if (dataSourceNode == null) {
            dataSourceNode = this.m_projectNode.addObjectNode(this.m_modelRes.RID_dataSource);
            String dataSourceNodeName = this.m_rootNamespaceName;
            dataSourceNodeName = dataSourceNodeName + dataSource;
            this.m_dataSources.add(dataSourceNode);
            this.genObjectPropertiesSimpleName(dataSourceNode, dataSourceNodeName);
            dataSourceNode.addProperty(this.m_modelRes.RID_cmDataSource, dataSource);
        }
        String idValue = dataSourceNode.getPropertyValue(this.m_modelRes.RID_ID);
        dbQuerySubject.addProperty(this.m_modelRes.RID_dataSourceRef, idValue);
        dbQuerySubject.addProperty(this.m_modelRes.RID_definitionType, "dbQuery");
        while (!this.endEncountered("sqlQuery")) {
            int next = this.m_parser.next();
            if (next != 1) continue;
            String elm = this.m_parser.getLocalName();
            if ("sqlText".equals(elm)) {
                String sqlString = "<sql type=\"";
                sqlString = sqlString + sqlType;
                sqlString = sqlString + "\">";
                String newValue = this.m_parser.getElementText();
                StringBuffer sqlOut = new StringBuffer();
                CCLXMLUtils.xmlEncode((String)newValue, (StringBuffer)sqlOut);
                sqlString = sqlString + sqlOut.toString();
                sqlString = sqlString + "</sql>";
                dbQuerySubject.addProperty(this.m_modelRes.RID_sql, sqlString);
                continue;
            }
            if (!"mdProjectedItems".equals(elm)) continue;
            while (this.moveToTag("mdProjectedItem", "mdProjectedItems")) {
                String itemName = this.m_parser.getAttributeValue(null, "name");
                MFWNodeObject objNode = dbQuerySubject.addObjectNode(this.m_modelRes.RID_queryItem);
                this.genObjectProperties(objNode, itemName);
                objNode.addProperty(this.m_modelRes.RID_externalName, itemName);
            }
        }
        this.m_objectsToValidate.add(dbQuerySubject);
    }

    private void processJoinOperand(MFWNodeObject querySubject) throws XMLStreamException {
        MFWNodeObject relationship = this.m_rootNamespaceNode.addObjectNode(this.m_modelRes.RID_relationship);
        String buf = "New Relationship ";
        buf = buf + Integer.toString(this.m_relationshipCount);
        ++this.m_relationshipCount;
        this.genObjectPropertiesSimpleName(relationship, buf);
        int next = this.m_parser.nextTag();
        while (!this.endEncountered("joinOperation")) {
            if (next == 1) {
                String elm = this.m_parser.getLocalName();
                if ("joinFilter".equals(elm)) {
                    if (this.moveToTag("filterExpression", "joinFilter")) {
                        String expression = this.m_parser.getElementText();
                        this.m_expressionsToFix.add(new PropValueToFix(relationship, this.m_modelRes.RID_expression, expression));
                    }
                } else if ("joinOperands".equals(elm)) {
                    MFWException.ASSERT((boolean)this.moveToTag("joinOperand", "joinOprands"), (String)"Missing join operand");
                    String card = this.m_parser.getAttributeValue(null, "cardinality");
                    String[] minMax = new String[2];
                    this.parseCardinalities(minMax, card);
                    relationship.addProperty(this.m_modelRes.RID_leftmincard, minMax[0]);
                    relationship.addProperty(this.m_modelRes.RID_leftmaxcard, minMax[1]);
                    if (this.moveToTag("queryRef", "joinOperand")) {
                        this.m_refObjsToFix.add(new PropValueToFix(relationship, this.m_modelRes.RID_leftrefobj, this.m_parser.getAttributeValue(null, "refQuery")));
                    }
                    MFWException.ASSERT((boolean)this.moveToTag("joinOperand", "joinOprands"), (String)"Missing join operand");
                    String card2 = this.m_parser.getAttributeValue(null, "cardinality");
                    String[] minMax2 = new String[2];
                    this.parseCardinalities(minMax2, card2);
                    relationship.addProperty(this.m_modelRes.RID_rightmincard, minMax2[0]);
                    relationship.addProperty(this.m_modelRes.RID_rightmaxcard, minMax2[1]);
                    if (this.moveToTag("queryRef", "joinOperand")) {
                        this.m_refObjsToFix.add(new PropValueToFix(relationship, this.m_modelRes.RID_rightrefobj, this.m_parser.getAttributeValue(null, "refQuery")));
                    }
                }
            }
            next = this.m_parser.nextTag();
        }
        this.m_queryToRelationships.put(querySubject, relationship);
    }

    private void processQueryOperation(MFWNodeObject querySubject) throws XMLStreamException {
        String name = this.m_parser.getAttributeValue(null, "name");
        String setOperation = this.m_parser.getAttributeValue(null, "setOperation");
        String dupli = this.m_parser.getAttributeValue(null, "duplicates");
        MFWNodeObject queryOp = this.m_rootNamespaceNode.addObjectNode(this.m_modelRes.RID_querySubject);
        this.m_objectsToValidate.add(queryOp);
        this.genObjectProperties(queryOp, name);
        queryOp.addProperty(this.m_modelRes.RID_definitionType, "queryOperation");
        queryOp.addProperty(this.m_modelRes.RID_setOperation, setOperation != null ? setOperation : "UNION");
        if (dupli != null) {
            queryOp.addProperty(this.m_modelRes.RID_duplicates, dupli);
        } else {
            queryOp.addProperty(this.m_modelRes.RID_duplicates, "remove");
        }
        this.m_parser.next();
        while (!this.endEncountered("queryOperation")) {
            int next = this.m_parser.next();
            if (next != 1) continue;
            String elm = this.m_parser.getLocalName();
            if ("queryRefs".equals(elm)) {
                MFWNodeObject querySubjectRefs = queryOp.addObjectNode(this.m_modelRes.RID_querySubjectRefs);
                while (this.moveToTag("queryRef", "queryRefs")) {
                    String refQuery = this.m_parser.getAttributeValue(null, "refQuery");
                    this.m_refObjsToFix.add(new PropValueToFix(querySubjectRefs, this.m_modelRes.RID_refobj, refQuery));
                }
                continue;
            }
            if (!"projectionList".equals(elm)) continue;
            while (this.moveToTag("queryItem", "projectionList")) {
                String itemName = this.m_parser.getAttributeValue(null, "name");
                MFWNodeObject objNode = queryOp.addObjectNode(this.m_modelRes.RID_queryItem);
                this.genObjectProperties(objNode, itemName);
                objNode.addProperty(this.m_modelRes.RID_externalName, itemName);
            }
        }
    }

    private void populateRootElements(String expressionLocale) {
        this.m_expressionLocale = expressionLocale;
        this.m_rootNamespaceName = (String)this.m_metadataSrc.getConnectionItem("ReportName");
        if (this.m_rootNamespaceName == null || "".equals(this.m_rootNamespaceName)) {
            this.m_rootNamespaceName = "Report";
        }
        this.m_projectNode = this.m_cluster.getRootNode().getObjectNode(this.m_modelRes.RID_project);
        if (this.m_projectNode == null) {
            MFWException.ASSERT((boolean)false, (String)"No project node present for report adaptor.");
        }
        this.m_projectNode.addProperty(this.m_modelRes.RID_name, this.m_rootNamespaceName);
        this.m_projectNode.addProperty(this.m_modelRes.RID_locale, this.m_expressionLocale);
        this.m_projectNode.addProperty(this.m_modelRes.RID_defaultLocale, this.m_expressionLocale);
        this.m_pIDGenerator = new MFWCrnIDGenerator(this.m_cluster);
        this.m_pIDGenerator.generate(this.m_projectNode, this.m_rootNamespaceName, false);
        this.m_rootNamespaceNode = this.m_projectNode.addObjectNode(this.m_modelRes.RID_namespace);
        String sUsedName = this.m_pIDGenerator.generate(this.m_rootNamespaceNode, this.m_rootNamespaceName, false);
        this.addLocalizedProperty(this.m_rootNamespaceNode, this.m_modelRes.RID_name, sUsedName, this.m_expressionLocale);
    }

    private MFWNodeObject addLocalizedProperty(MFWNodeObject pParentObj, short ridPropName, String sValue, String locale) {
        MFWNodeObject pLocProp = pParentObj.addObjectNode(ridPropName);
        pLocProp.addProperty(this.m_modelRes.RID_locale, locale);
        pLocProp.addProperty(this.m_modelRes.RID__Value, sValue);
        return pLocProp;
    }

    private void genObjectPropertiesSimpleName(MFWNodeObject objNode, String sSuggestedName) {
        String sActualName = this.m_pIDGenerator.generate(objNode, sSuggestedName, false);
        objNode.addProperty(this.m_modelRes.RID_name, sActualName);
    }

    private void genObjectProperties(MFWNodeObject objNode, String sSuggestedName) {
        String sActualName = this.m_pIDGenerator.generate(objNode, sSuggestedName, false);
        if (sSuggestedName != null && sSuggestedName.length() != 0) {
            this.addLocalizedProperty(objNode, this.m_modelRes.RID_name, sActualName, this.m_expressionLocale);
        }
    }

    private void parseCardinalities(String[] minMax, String cardinality) {
        if (cardinality.length() <= 2) {
            MFWRptAdaptor.ThrowInternal();
        }
        if (cardinality.charAt(0) == '0') {
            minMax[0] = "zero";
        } else if (cardinality.charAt(0) == '1') {
            minMax[0] = "one";
        } else {
            MFWRptAdaptor.ThrowInternal();
        }
        if (cardinality.charAt(2) == '0') {
            minMax[1] = "zero";
        } else if (cardinality.charAt(2) == '1') {
            minMax[1] = "one";
        } else if (cardinality.charAt(2) == 'N') {
            minMax[1] = "many";
        }
    }

    private static String MapV5UseToMFW(String v5UseValue) {
        Object mfwValue = null;
        mfwValue = "required".equals(v5UseValue) ? "always" : ("optional".equals(v5UseValue) ? "asNeeded" : ("prohibited".equals(v5UseValue) ? null : "always"));
        return mfwValue;
    }

    static String MapV5AggregateToMFW(String v5Aggregate) {
        String mfwAggregate = null;
        mfwAggregate = "none".equals(v5Aggregate) ? "unsupported" : ("total".equals(v5Aggregate) ? "sum" : ("automatic".equals(v5Aggregate) ? "countNonZero" : ("summarize".equals(v5Aggregate) || "notApplicable".equals(v5Aggregate) ? "" : v5Aggregate)));
        return mfwAggregate;
    }

    private void parseComplete() {
        MFWLogReportClusterBeforeValidation bv = new MFWLogReportClusterBeforeValidation("MFWV5ModelLoader::parseComplete()", this.m_cluster);
        bv.logEnd();
        boolean suppressDataTypeValidation = false;
        String value = (String)this.m_metadataSrc.getConnectionItem("suppressReportValidation");
        if ("true".equals(value)) {
            suppressDataTypeValidation = true;
        }
        if (!suppressDataTypeValidation) {
            this.validateSpecForDataTypes();
        }
        this.convertExpressions();
        if (!suppressDataTypeValidation) {
            this.calculateModeledProperties();
        }
    }

    private void convertExpressions() {
        for (int i = 0; i < this.m_expressionsToFix.size(); ++i) {
            PropValueToFix expr2Fix = this.m_expressionsToFix.get(i);
            String exprValue = expr2Fix.mPropValue;
            String outExpression = null;
            MFWNodeObject pParentItem = expr2Fix.mPropParent;
            if (pParentItem.getNameRID() == this.m_modelRes.RID_queryItem) {
                BasedOnInfo pBasedOnInfo = new BasedOnInfo(pParentItem);
                this.m_vBasedOnItems.add(pBasedOnInfo);
                outExpression = MFWV5ExpressionParser.parse(exprValue, expr2Fix.mPropParent, this.m_rootNamespaceName, pBasedOnInfo.m_basedOnIDs, this.m_cluster.getIndexManager());
            } else {
                outExpression = MFWV5ExpressionParser.parse(exprValue, expr2Fix.mPropParent, this.m_rootNamespaceName, null, this.m_cluster.getIndexManager());
            }
            if (outExpression != null) {
                String finalExpression = MFWStringHelper.escapeAndTagStr((String)"expression", (String)outExpression.toString());
                expr2Fix.mPropParent.addProperty(expr2Fix.mPropRID, finalExpression);
                continue;
            }
            expr2Fix.mPropParent.addProperty(expr2Fix.mPropRID, expr2Fix.mPropValue);
        }
        this.m_expressionsToFix.clear();
        String rootNamespaceID = this.m_rootNamespaceNode.getPropertyValue(this.m_modelRes.RID_ID);
        for (int i = 0; i < this.m_refObjsToFix.size(); ++i) {
            PropValueToFix refObj2Fix = this.m_refObjsToFix.get(i);
            String exprValue = refObj2Fix.mPropValue;
            StringBuffer reference = new StringBuffer(rootNamespaceID);
            reference.append(".[");
            reference.append(exprValue);
            reference.append("]");
            refObj2Fix.mPropParent.addProperty(refObj2Fix.mPropRID, reference.toString());
        }
        this.m_refObjsToFix.clear();
    }

    private void calculateModeledProperties() {
        for (int idx = 0; idx < this.m_objectsToValidate.size(); ++idx) {
            List vQueryItems = this.m_objectsToValidate.get(idx).getObjectNodes(this.m_modelRes.RID_queryItem);
            for (int qIdx = 0; qIdx < vQueryItems.size(); ++qIdx) {
                this.setModeledProperties((MFWNodeObject)vQueryItems.get(qIdx));
            }
        }
    }

    void setModeledProperties(MFWNodeObject pQItemNode) {
        String pAggregateProp;
        BasedOnInfo basedOnInfo = this.findBasedOnInfoFor(pQItemNode);
        if (basedOnInfo == null || basedOnInfo.m_basedOnIDs.size() != 1) {
            this.setDefaultUsageAndAggregate(pQItemNode);
            return;
        }
        MFWNodeObject pBasedOnItem = this.lookupObjectByID((String)basedOnInfo.m_basedOnIDs.get(0));
        if (pBasedOnItem == null || pBasedOnItem.getNameRID() != this.m_modelRes.RID_queryItem && pBasedOnItem.getNameRID() != this.m_modelRes.RID_measure && pBasedOnItem.getNameRID() != this.m_modelRes.RID_calculation) {
            this.setDefaultUsageAndAggregate(pQItemNode);
            return;
        }
        if (pBasedOnItem.getPropertyValue(this.m_modelRes.RID_usage) == null) {
            this.setModeledProperties(pBasedOnItem);
        }
        if ((pAggregateProp = pQItemNode.getPropertyValue(this.m_modelRes.RID_regularAggregate)) != null && !"".equals(pAggregateProp) && !"unsupported".equals(pAggregateProp)) {
            String pUsageNode = pQItemNode.getPropertyValue(this.m_modelRes.RID_usage);
            if (pUsageNode != null) {
                pQItemNode.addProperty(this.m_modelRes.RID_usage, "fact");
            }
        } else {
            this.replicateProperty(pQItemNode, pBasedOnItem, this.m_modelRes.RID_usage);
            this.replicateProperty(pQItemNode, pBasedOnItem, this.m_modelRes.RID_regularAggregate);
        }
        this.replicateProperty(pQItemNode, pBasedOnItem, this.m_modelRes.RID_semiAggregate);
        this.replicateProperty(pQItemNode, pBasedOnItem, this.m_modelRes.RID_format);
        this.replicateProperty(pQItemNode, pBasedOnItem, this.m_modelRes.RID_currency);
        this.replicateProperty(pQItemNode, pBasedOnItem, this.m_modelRes.RID_displayType);
        this.replicateProperty(pQItemNode, pBasedOnItem, this.m_modelRes.RID_MIMEType);
        this.replicateProperty(pQItemNode, pBasedOnItem, this.m_modelRes.RID_sortOnRef);
        this.replicateProperty(pQItemNode, pBasedOnItem, this.m_modelRes.RID_promptType);
        this.replicateProperty(pQItemNode, pBasedOnItem, this.m_modelRes.RID_promptFilterItemRef);
        this.replicateProperty(pQItemNode, pBasedOnItem, this.m_modelRes.RID_promptDisplayItemRef);
        this.replicateProperty(pQItemNode, pBasedOnItem, this.m_modelRes.RID_promptCascadeOnRef);
    }

    void setDefaultUsageAndAggregate(MFWNodeObject pItem) {
        String pUsageNode = pItem.getPropertyValue(this.m_modelRes.RID_usage);
        if (pUsageNode != null && !"unknown".equals(pUsageNode)) {
            return;
        }
        String pAggregateProp = pItem.getPropertyValue(this.m_modelRes.RID_regularAggregate);
        if (pAggregateProp != null && !"unsupported".equals(pAggregateProp)) {
            pItem.addProperty(this.m_modelRes.RID_usage, "fact");
        } else {
            String pDataTypeProp = pItem.getPropertyValue(this.m_modelRes.RID_datatype);
            if (pDataTypeProp != null) {
                short opType = MFWDBConversions.translateOperandType(pDataTypeProp);
                String eUsage = MFWV5QueryHelper.calculateBasicUsage(opType);
                pItem.addProperty(this.m_modelRes.RID_usage, eUsage);
                if (pItem.getPropertyValue(this.m_modelRes.RID_regularAggregate) == null && pItem.getPropertyValue(this.m_modelRes.RID_semiAggregate) == null) {
                    StringBuffer eRegularAggr = new StringBuffer();
                    StringBuffer eSemiaggr = new StringBuffer();
                    this.calculateBasicAggregate(opType, eUsage, eRegularAggr, eSemiaggr);
                    pItem.addProperty(this.m_modelRes.RID_regularAggregate, eRegularAggr.toString());
                    pItem.addProperty(this.m_modelRes.RID_semiAggregate, eSemiaggr.toString());
                }
            }
        }
    }

    void calculateBasicAggregate(short opType, String eUsage, StringBuffer regularAggr, StringBuffer semiAggr) {
        if (opType == 10 || opType == 13) {
            if ("fact".equals(eUsage)) {
                regularAggr.append("sum");
                semiAggr.append("sum");
            } else {
                regularAggr.append("count");
                semiAggr.append("unsupported");
            }
        } else {
            regularAggr.append("unsupported");
            semiAggr.append("unsupported");
        }
    }

    MFWNodeObject lookupObjectByID(String sID) {
        MFWNodeObject pObj = this.m_cluster.lookup(MFWModel.getInstance().getIDPropertyInfo(), sID, this.m_context, null);
        return pObj;
    }

    void replicateProperty(MFWNodeObject pObj, MFWNodeObject pBasedOnObj, short ridProp) {
        String pBasedOnProp = pBasedOnObj.getPropertyValue(ridProp);
        if (pBasedOnProp != null) {
            pObj.addProperty(ridProp, pBasedOnProp);
        }
    }

    private BasedOnInfo findBasedOnInfoFor(MFWNodeObject pItem) {
        for (int i = 0; i < this.m_vBasedOnItems.size(); ++i) {
            BasedOnInfo info = this.m_vBasedOnItems.get(i);
            if (info.m_itemObj != pItem) continue;
            return info;
        }
        return null;
    }

    private void validateSpecForDataTypes() {
        Document doc = DocumentHelper.createDocument();
        MFWV5QueryHelper helper = new MFWV5QueryHelper(this.m_expressionLocale, this.m_context);
        Element command = helper.prepareValidateRequest(this.m_objectsToValidate, this.m_queryToRelationships, this.m_pkgPath, doc);
        MFWV5Bridge bridge = MFWV5Bridge.create(this.m_context);
        helper.populateQuerySubjectItemDataTypes(this.m_objectsToValidate, bridge, command);
        bridge.terminate();
    }

    private static class PropValueToFix {
        MFWNodeObject mPropParent;
        short mPropRID;
        String mPropValue;

        PropValueToFix(MFWNodeObject parent, short propRID, String propValue) {
            this.mPropParent = parent;
            this.mPropRID = propRID;
            this.mPropValue = propValue;
        }
    }
}

