/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorReport;

import com.cognos.ccl4j.util.CCLXMLUtils;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.log.MFWLogReportClusterValidationResult;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfwa4j.adaptorReport.MFWDBConversions;
import com.cognos.mfwa4j.adaptorReport.MFWRptAdaptor;
import com.cognos.mfwa4j.v5Bridge.MFWV5Bridge;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class MFWV5QueryHelper {
    private String m_defaultLocale;
    private MFWRequestContextUser m_context;
    private MFWModelRes m_modelRes;

    public MFWV5QueryHelper(String defaultLocale, MFWRequestContextUser context) {
        this.m_defaultLocale = defaultLocale;
        this.m_context = context;
        this.m_modelRes = MFWModelRes.getInstance();
    }

    public void destroy() {
    }

    Element prepareValidateRequest(ArrayList objectsToValidate, Hashtable queryToRelationships, String pkgPath, Document doc) {
        Element command = MFWV5QueryHelper.createCommandElement(doc, this.m_defaultLocale, this.m_context, false);
        Element validate = command.addElement("validate");
        validate.addAttribute("compatibility", "1");
        Element querySet = validate.addElement("querySet");
        querySet.addAttribute("expressionLocale", "en");
        Element model = querySet.addElement("modelPath");
        model.setText(pkgPath);
        Element queries = querySet.addElement("queries");
        Element queryResultDefinitions = querySet.addElement("queryResultDefinitions");
        int size = objectsToValidate.size();
        int start = 0;
        ArrayList<String> queryNamesSoFar = new ArrayList<String>();
        this.populateModelQueryNames(queryNamesSoFar, objectsToValidate);
        for (int i = start; i < size; ++i) {
            MFWNodeObject querySubject = (MFWNodeObject)objectsToValidate.get(i);
            if (querySubject.getNameRID() == this.m_modelRes.RID_querySubject) {
                ArrayList vNameObjects = new ArrayList();
                querySubject.findObjectNodes(this.m_modelRes.RID_name, this.m_modelRes.RID_locale, this.m_defaultLocale, vNameObjects);
                if (vNameObjects.size() <= 0) {
                    MFWRptAdaptor.ThrowInternal();
                }
                String valueNode = ((MFWNodeObject)vNameObjects.get(0)).getPropertyValue(this.m_modelRes.RID__Value);
                MFWNodeObject obj = querySubject;
                String resultDefName = "resultDefinition_";
                resultDefName = resultDefName + valueNode;
                if (querySubject.getPropertyValue(this.m_modelRes.RID_setOperation) == null) {
                    MFWNodeObject it = (MFWNodeObject)queryToRelationships.get(obj);
                    if (it != null) {
                        this.buildRelationship(obj, it, doc, queries, queryResultDefinitions, resultDefName, valueNode);
                        continue;
                    }
                    if ("dbQuery".equals(querySubject.getPropertyValue(this.m_modelRes.RID_definitionType))) {
                        this.buildDBQuery(querySubject, doc, queries, queryResultDefinitions, resultDefName, valueNode);
                        continue;
                    }
                    this.buildModelQuery(querySubject, doc, queries, queryResultDefinitions, resultDefName, valueNode);
                    continue;
                }
                this.buildQuerySetQuery(querySubject, doc, queries, queryResultDefinitions, resultDefName, valueNode, queryNamesSoFar);
                continue;
            }
            MFWRptAdaptor.ThrowInternal();
        }
        this.buildQueryFeedBackAndRequestHints(doc, validate, querySet);
        Element promptDom = this.m_context.getPromptResolution();
        if (promptDom != null) {
            Element promptInfo = (Element)promptDom.clone();
            promptInfo.detach();
            validate.add(promptInfo);
        }
        return command;
    }

    void buildDBQuery(MFWNodeObject dbQuery, Document doc, Element queries, Element queryResultDefinitions, String resultDefinitionName, String queryNodeName) {
        String dataSourceRef;
        Element query = queries.addElement("query");
        String queryName = queryNodeName;
        queryName = queryName + "dummyQuery";
        query.addAttribute("name", queryNodeName);
        Element source = query.addElement("source");
        Element sqlQuery = source.addElement("sqlQuery");
        sqlQuery.addAttribute("name", queryName);
        String typeNode = dbQuery.getPropertyValue(this.m_modelRes.RID_type);
        if (typeNode != null) {
            sqlQuery.addAttribute("type", typeNode);
        }
        MFWException.ASSERT(((dataSourceRef = dbQuery.getPropertyValue(this.m_modelRes.RID_dataSourceRef)) != null ? 1 : 0) != 0, (String)"dataSource not found in db query");
        MFWInfoProperty idPropInfo = (MFWInfoProperty)MFWModel.getInstance().findInfoByRID(this.m_modelRes.RID_ID);
        MFWNodeObject trueDataSource = dbQuery.getCluster().getIndexManager().lookup(idPropInfo, dataSourceRef);
        MFWException.ASSERT((trueDataSource != null ? 1 : 0) != 0, (String)"Could not find datasource by reference");
        String dataSourceCMNode = trueDataSource.getPropertyValue(this.m_modelRes.RID_cmDataSource);
        MFWException.ASSERT((dataSourceCMNode != null ? 1 : 0) != 0, (String)"Query item with current locale not found");
        sqlQuery.addAttribute("dataSource", dataSourceCMNode);
        Element sqlText = sqlQuery.addElement("sqlText");
        String sql = dbQuery.getPropertyValue(this.m_modelRes.RID_sql);
        String strippedSQL = this.stripFMSQLTag(sql);
        StringBuffer buf = new StringBuffer();
        CCLXMLUtils.xmlEncode((String)strippedSQL, (StringBuffer)buf);
        sqlText.setText(buf.toString());
        Element projectedItems = sqlQuery.addElement("mdProjectedItems");
        List dbQueryItems = dbQuery.getObjectNodes(this.m_modelRes.RID_queryItem);
        for (int i = 0; i < dbQueryItems.size(); ++i) {
            Element projectedItem = projectedItems.addElement("mdProjectedItem");
            ArrayList vNameObjects = new ArrayList();
            ((MFWNodeObject)dbQueryItems.get(i)).findObjectNodes(this.m_modelRes.RID_name, this.m_modelRes.RID_locale, this.m_defaultLocale, vNameObjects);
            MFWException.ASSERT((vNameObjects.size() > 0 ? 1 : 0) != 0, (String)"Query item with current locale not found");
            String valueNode = ((MFWNodeObject)vNameObjects.get(0)).getPropertyValue(this.m_modelRes.RID__Value);
            MFWException.ASSERT((valueNode != null ? 1 : 0) != 0, (String)"Name has no value");
            projectedItem.addAttribute("name", valueNode);
        }
        this.createSelectionAndResultItems(dbQuery, doc, query, queryResultDefinitions, resultDefinitionName, queryNodeName, queryName, false);
    }

    void populateQuerySubjectItemDataTypes(ArrayList<MFWNodeObject> objectsToValidate, MFWV5Bridge session, Element command) {
        Element response = this.sendRequestToSession(command, session);
        for (int objIdx = 0; objIdx < objectsToValidate.size(); ++objIdx) {
            String valueNode;
            MFWNodeObject objToValidate = objectsToValidate.get(objIdx);
            ArrayList names = new ArrayList();
            objToValidate.findObjectNodes(this.m_modelRes.RID_name, this.m_modelRes.RID_locale, this.m_defaultLocale, names);
            if (objToValidate.getNameRID() != this.m_modelRes.RID_querySubject) continue;
            if (names.size() <= 0) {
                this.assignDefaultDatatypes(objToValidate);
                continue;
            }
            String name = valueNode = ((MFWNodeObject)names.get(0)).getPropertyValue(this.m_modelRes.RID__Value);
            List props = response.getDocument().selectNodes("//queryFeedbackResult/property[@queryName='resultDefinition_" + name + "']");
            if (props.size() == 0) {
                this.assignDefaultDatatypes(objToValidate);
                continue;
            }
            this.updateQuerySubjectItems(objToValidate, (Element)props.get(0));
        }
    }

    void assignDefaultDatatypes(MFWNodeObject objToValidate) {
        List queryItems = objToValidate.getObjectNodes(this.m_modelRes.RID_queryItem);
        for (int qiIdx = 0; qiIdx < queryItems.size(); ++qiIdx) {
            ((MFWNodeObject)queryItems.get(qiIdx)).addProperty(this.m_modelRes.RID_datatype, "unknown");
        }
    }

    private void populateModelQueryNames(ArrayList<String> queryNamesSoFar, ArrayList<MFWNodeObject> objectsToValidate) {
        for (int i = 0; i < objectsToValidate.size(); ++i) {
            MFWNodeObject obj = objectsToValidate.get(i);
            if (obj.getNameRID() != this.m_modelRes.RID_querySubject) continue;
            ArrayList vNameObjects = new ArrayList();
            obj.findObjectNodes(this.m_modelRes.RID_name, this.m_modelRes.RID_locale, this.m_defaultLocale, vNameObjects);
            if (vNameObjects.size() <= 0) {
                MFWRptAdaptor.ThrowInternal();
            }
            String valueNode = ((MFWNodeObject)vNameObjects.get(0)).getPropertyValue(this.m_modelRes.RID__Value);
            queryNamesSoFar.add(valueNode);
        }
    }

    void buildQueryFeedBackAndRequestHints(Document doc, Element validate, Element querySet) {
        Element requestHints = querySet.addElement("requestHints");
        Element queryProcessing1 = requestHints.addElement("queryProcessing");
        queryProcessing1.addAttribute("value", "minimizeLocal");
        Element queryFeedback = validate.addElement("queryFeedback");
        queryFeedback.addAttribute("severityLevel", "error");
        Element property = queryFeedback.addElement("property");
        property.addAttribute("name", "columnList");
    }

    private void buildQuerySetQuery(MFWNodeObject querySetQuery, Document doc, Element queries, Element queryResultDefinitions, String resultDefinitionName, String queryNodeName, ArrayList<String> queryNamesSoFar) {
        Element query = queries.addElement("query");
        String uniqueName = this.makeQueryNameUnique(queryNodeName + "dummyQuery", queryNamesSoFar);
        queryNamesSoFar.add(uniqueName);
        query.addAttribute("name", queryNodeName);
        Element source = query.addElement("source");
        Element queryOperation = source.addElement("queryOperation");
        queryOperation.addAttribute("name", uniqueName);
        String setOp = querySetQuery.getPropertyValue(this.m_modelRes.RID_setOperation);
        queryOperation.addAttribute("setOperation", setOp);
        String dup = querySetQuery.getPropertyValue(this.m_modelRes.RID_duplicates);
        if (dup != null) {
            queryOperation.addAttribute("duplicates", dup);
        }
        Element queryRefsElm = queryOperation.addElement("queryRefs");
        MFWNodeObject queryRefs = querySetQuery.getObjectNode(this.m_modelRes.RID_querySubjectRefs);
        List props = queryRefs.getPropertyValues(this.m_modelRes.RID_refobj);
        if (props.size() != 2) {
            MFWRptAdaptor.ThrowInternal();
        }
        Element queryRef1 = queryRefsElm.addElement("queryRef");
        queryRef1.addAttribute("refQuery", (String)props.get(0));
        Element queryRef2 = queryRefsElm.addElement("queryRef");
        queryRef2.addAttribute("refQuery", (String)props.get(1));
        Element projectedItems = queryOperation.addElement("projectionList");
        List querySetItems = querySetQuery.getObjectNodes(this.m_modelRes.RID_queryItem);
        for (int i = 0; i < querySetItems.size(); ++i) {
            String valueNode;
            Element queryItem = projectedItems.addElement("queryItem");
            ArrayList vNameObjects = new ArrayList();
            ((MFWNodeObject)querySetItems.get(i)).findObjectNodes(this.m_modelRes.RID_name, this.m_modelRes.RID_locale, this.m_defaultLocale, vNameObjects);
            if (vNameObjects.size() <= 0) {
                MFWRptAdaptor.ThrowInternal();
            }
            if ((valueNode = ((MFWNodeObject)vNameObjects.get(0)).getPropertyValue(this.m_modelRes.RID__Value)) == null) {
                MFWRptAdaptor.ThrowInternal();
            }
            queryItem.addAttribute("name", valueNode);
        }
        this.createSelectionAndResultItems(querySetQuery, doc, query, queryResultDefinitions, resultDefinitionName, queryNodeName, uniqueName, false);
    }

    private String makeQueryNameUnique(String suggestedName, ArrayList<String> queryNamesSoFar) {
        int currentNum = 1;
        boolean unique = false;
        String currentName = suggestedName;
        while (unique) {
            boolean foundMatch = false;
            for (int i = 0; i < queryNamesSoFar.size(); ++i) {
                if (queryNamesSoFar.indexOf(currentName) == -1) continue;
                currentName = suggestedName;
                currentName = currentName + Integer.toString(currentNum);
                ++currentNum;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            unique = false;
        }
        return currentName;
    }

    String stripFMSQLTag(String sqlText) {
        int endOfStartTag = sqlText.indexOf(">");
        int startOfEndTag = sqlText.indexOf("</sql>");
        String strippedSQL = sqlText.substring(endOfStartTag + 1, startOfEndTag);
        return strippedSQL;
    }

    void buildModelQuery(MFWNodeObject modelQuery, Document doc, Element queries, Element queryResultDefinitions, String resultDefinitionName, String queryName) {
        Element query = queries.addElement("query");
        query.addAttribute("name", queryName);
        Element source = query.addElement("source");
        source.addElement("model");
        this.createSelectionAndResultItems(modelQuery, doc, query, queryResultDefinitions, resultDefinitionName, queryName, "", true);
        this.buildQueryHints(query, doc);
    }

    void buildQueryHints(Element query, Document doc) {
        Element queryHints = query.addElement("queryHints");
        Element crossProduct = queryHints.addElement("crossProductAllowed");
        crossProduct.addAttribute("value", "allow");
    }

    void createSelectionAndResultItems(MFWNodeObject querySubject, Document doc, Element query, Element queryResultDefinitions, String resultDefinitionName, String queryName, String innerName, boolean isModelSource) {
        Element queryResultDefinition = queryResultDefinitions.addElement("queryResultDefinition");
        queryResultDefinition.addAttribute("name", resultDefinitionName);
        queryResultDefinition.addAttribute("refQuery", queryName);
        Element edges = queryResultDefinition.addElement("edges");
        Element edge = edges.addElement("edge");
        edge.addAttribute("name", "columns");
        Element edgeGroups = edge.addElement("edgeGroups");
        Element edgeGroup = edgeGroups.addElement("edgeGroup");
        Element valueSets = edgeGroup.addElement("valueSets");
        Element valueSet = valueSets.addElement("valueSet");
        valueSet.addAttribute("name", "valueSet1");
        Element groupBody = valueSet.addElement("groupBody");
        groupBody.addAttribute("name", "groupbody");
        List modelQueryItemsList = querySubject.getObjectNodes(this.m_modelRes.RID_queryItem);
        Element selection = query.addElement("selection");
        selection.addAttribute("autoSummary", "false");
        for (int i = 0; i < modelQueryItemsList.size(); ++i) {
            CharSequence exprText;
            String nameValueNode;
            Element dataItem = selection.addElement("dataItem");
            ArrayList vNameObjects = new ArrayList();
            ((MFWNodeObject)modelQueryItemsList.get(i)).findObjectNodes(this.m_modelRes.RID_name, this.m_modelRes.RID_locale, this.m_defaultLocale, vNameObjects);
            if (vNameObjects.size() <= 0) {
                MFWRptAdaptor.ThrowInternal();
            }
            if ((nameValueNode = ((MFWNodeObject)vNameObjects.get(0)).getPropertyValue(this.m_modelRes.RID__Value)) == null) {
                MFWRptAdaptor.ThrowInternal();
            }
            dataItem.addAttribute("name", nameValueNode);
            Element dataItemExpression = dataItem.addElement("expression");
            String expressionText = ((MFWNodeObject)modelQueryItemsList.get(i)).getPropertyValue(this.m_modelRes.RID_expression);
            if (expressionText != null) {
                dataItemExpression.setText(expressionText);
            } else if (isModelSource) {
                exprText = ((MFWNodeObject)modelQueryItemsList.get(i)).getPropertyValue(this.m_modelRes.RID_ID);
                dataItemExpression.setText((String)exprText);
            } else {
                exprText = new StringBuffer();
                ((StringBuffer)exprText).append("[");
                ((StringBuffer)exprText).append(innerName);
                ((StringBuffer)exprText).append("].[");
                ((StringBuffer)exprText).append(nameValueNode);
                ((StringBuffer)exprText).append("]");
                String strText = ((StringBuffer)exprText).toString();
                dataItemExpression.setText(strText);
            }
            String aggregateNode = ((MFWNodeObject)modelQueryItemsList.get(i)).getPropertyValue(this.m_modelRes.RID_regularAggregate);
            if (aggregateNode != null) {
                String v5Aggregate = this.mapMFWAggregateToV5(aggregateNode);
                dataItem.addAttribute("aggregate", v5Aggregate);
            }
            Element dataItemRef = groupBody.addElement("dataItemRef");
            dataItemRef.addAttribute("refDataItem", nameValueNode);
        }
    }

    void buildRelationship(MFWNodeObject modelQuery, MFWNodeObject relationship, Document doc, Element queries, Element queryResultDefinitions, String resultDefinitionName, String queryName) {
        Element query = queries.addElement("query");
        String leftRefObj = relationship.getPropertyValue(this.m_modelRes.RID_leftrefobj);
        String rightRefObj = relationship.getPropertyValue(this.m_modelRes.RID_rightrefobj);
        String leftMinCard = relationship.getPropertyValue(this.m_modelRes.RID_leftmincard);
        String leftMaxCard = relationship.getPropertyValue(this.m_modelRes.RID_leftmaxcard);
        String rightMinCard = relationship.getPropertyValue(this.m_modelRes.RID_rightmincard);
        String rightMaxCard = relationship.getPropertyValue(this.m_modelRes.RID_rightmaxcard);
        String expression = relationship.getPropertyValue(this.m_modelRes.RID_expression);
        if (leftRefObj == null || rightRefObj == null || leftMinCard == null || leftMaxCard == null || rightMinCard == null || rightMaxCard == null) {
            MFWRptAdaptor.ThrowInternal();
        }
        query.addAttribute("name", queryName);
        Element source = query.addElement("source");
        Element joinOperation = source.addElement("joinOperation");
        Element joinOperands = joinOperation.addElement("joinOperands");
        Element left = joinOperands.addElement("joinOperand");
        Element right = joinOperands.addElement("joinOperand");
        String leftCard = this.buildV5Cardinality(leftMinCard, leftMaxCard);
        left.addAttribute("cardinality", leftCard);
        String rightCard = this.buildV5Cardinality(rightMinCard, rightMaxCard);
        right.addAttribute("cardinality", rightCard);
        Element leftQuery = left.addElement("queryRef");
        leftQuery.addAttribute("refQuery", leftRefObj);
        Element rightQuery = right.addElement("queryRef");
        rightQuery.addAttribute("refQuery", rightRefObj);
        Element joinFilter = joinOperation.addElement("joinFilter");
        Element filterExpression = joinFilter.addElement("filterExpression");
        filterExpression.setText(expression);
        this.createSelectionAndResultItems(modelQuery, doc, query, queryResultDefinitions, resultDefinitionName, queryName, "", true);
    }

    void updateQuerySubjectItems(MFWNodeObject querySubject, Element property) {
        List columnInfos = property.selectNodes("columnList/item");
        List queryItems = querySubject.getObjectNodes(this.m_modelRes.RID_queryItem);
        for (int i = 0; i < columnInfos.size(); ++i) {
            Element elem = (Element)columnInfos.get(i);
            String name = elem.attributeValue("name");
            boolean updated = false;
            for (int qIndex = 0; qIndex < queryItems.size(); ++qIndex) {
                String nameValueNode;
                ArrayList vNameObjects = new ArrayList();
                ((MFWNodeObject)queryItems.get(qIndex)).findObjectNodes(this.m_modelRes.RID_name, this.m_modelRes.RID_locale, this.m_defaultLocale, vNameObjects);
                if (vNameObjects.size() <= 0) {
                    MFWRptAdaptor.ThrowInternal();
                }
                if ((nameValueNode = ((MFWNodeObject)vNameObjects.get(0)).getPropertyValue(this.m_modelRes.RID__Value)) == null) {
                    MFWRptAdaptor.ThrowInternal();
                }
                if (!nameValueNode.equals(name)) continue;
                this.adoptItemProperties((MFWNodeObject)queryItems.get(qIndex), elem);
                updated = true;
                break;
            }
            if (updated) continue;
            MFWRptAdaptor.ThrowInternal();
        }
    }

    String buildV5Cardinality(String minCard, String maxCard) {
        String min = "";
        String max = "";
        if (minCard.equals("zero")) {
            min = "0";
        } else if (minCard.equals("one")) {
            min = "1";
        }
        if (maxCard.equals("zero")) {
            max = "0";
        } else if (maxCard.equals("one")) {
            max = "1";
        } else if (maxCard.equals("many")) {
            max = "N";
        }
        String outCard = min;
        outCard = outCard + ":";
        outCard = outCard + max;
        return outCard;
    }

    void adoptItemProperties(MFWNodeObject queryItem, Element colInfo) {
        String type = colInfo.attributeValue("type");
        String length = colInfo.attributeValue("length");
        String precision = colInfo.attributeValue("precision");
        String scale = colInfo.attributeValue("scale");
        String mfwDataType = MFWDBConversions.translateDataType(type, length);
        if (mfwDataType == null) {
            MFWRptAdaptor.ThrowException("RPT_HLP_VALIDATION_RETURNED_UNSUPPORTED_DATATYPE");
        }
        queryItem.addProperty(this.m_modelRes.RID_datatype, mfwDataType);
        queryItem.addProperty(this.m_modelRes.RID_scale, scale);
        queryItem.addProperty(this.m_modelRes.RID_precision, precision);
    }

    String mapMFWAggregateToV5(String mfwAggregate) {
        String v5Aggregate = null;
        v5Aggregate = mfwAggregate.equals("unsupported") ? "none" : (mfwAggregate.equals("sum") ? "total" : (mfwAggregate.equals("countNonZero") ? "automatic" : mfwAggregate));
        return v5Aggregate;
    }

    Element sendRequestToSession(Element command, MFWV5Bridge session) {
        String requestID = "ReportQueryValidate";
        MFWLogReportClusterValidationResult log = new MFWLogReportClusterValidationResult("MFWV5QueryHelper::sendRequestToSession", command);
        try {
            Element response = session.doV5Request(requestID, command.asXML());
            log.setResponse(response);
            log.logEnd();
            return response;
        }
        catch (RuntimeException rt) {
            log.logEnd((Throwable)rt);
            throw rt;
        }
    }

    static Element createCommandElement(Document doc, String sRunLocale, MFWRequestContextUser aContext, boolean preventReportPlanning) {
        Element connDom;
        Element command = doc.addElement("command");
        Element connection = command.addElement("connection");
        Element provider = connection.addElement("QFProviderType");
        provider.addAttribute("value", "QueryFrameworkService");
        Element serviceID = connection.addElement("serviceID");
        serviceID.addAttribute("value", "MFWA4J");
        Element passport = connection.addElement("CAMPassport");
        passport.addAttribute("value", aContext.getUserPassport());
        if (preventReportPlanning) {
            Element reportPlanning = connection.addElement("preventReportPlanning");
            reportPlanning.addAttribute("value", "true");
        }
        if ((connDom = aContext.getConnectionSpec()) != null) {
            List children = connDom.selectNodes("*");
            for (int i = 0; i < children.size(); ++i) {
                Node elmDSType;
                Node node = (Node)children.get(i);
                if (!(node instanceof Element)) continue;
                String name = node.getName();
                if (!("serviceID".equals(name) || "CAMPassport".equals(name) || "QFProviderType".equals(name))) {
                    Node importedNode = (Node)node.clone();
                    importedNode.detach();
                    connection.add(importedNode);
                }
                if (!preventReportPlanning || !name.equals("connection") || (elmDSType = node.selectSingleNode("//*dataSourceType[@value='bmeModel']")) == null) continue;
                ((Element)elmDSType).attributeValue("bmeModelForReport");
            }
        }
        return command;
    }

    static String calculateBasicUsage(short opType) {
        String eUsage = null;
        eUsage = opType == 10 || opType == 13 ? "fact" : (opType == 7 || opType == 8 || opType == 12 ? "identifier" : "attribute");
        return eUsage;
    }
}

