/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.exceptions;

import com.cognos.ccl4j.diagnostics.CCLCheck;
import com.cognos.ccl4j.exceptions.CCLExceptionImpl;
import com.cognos.ccl4j.exceptions.ICCLExceptionHandling;
import com.cognos.ccl4j.message.CCLMsg;
import com.cognos.ccl4j.message.CCLMsgInfo;
import com.cognos.ccl4j.message.CCLMsgParam;
import com.cognos.ccl4j.resource.CCLResource;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;

public class CCLException
extends Exception
implements ICCLExceptionHandling {
    static final long serialVersionUID = -1006155497243764567L;
    CCLExceptionImpl _impl = null;

    public CCLException(String sCode) {
        super(sCode);
        CCLCheck.validString(sCode);
        this.init(null, sCode, 4, null);
    }

    public CCLException(Throwable thChained) {
        super(thChained);
        CCLCheck.nonNull(thChained);
        this.init(thChained, null, 4, null);
    }

    public CCLException(Throwable thChained, String sCode) {
        super(sCode, thChained);
        CCLCheck.nonNull(thChained);
        CCLCheck.validString(sCode);
        this.init(thChained, sCode, 4, null);
    }

    public CCLException(String sCode, CCLMsgParam p0) {
        super(sCode);
        CCLMsgParam[] cCLMsgParamArray;
        CCLCheck.validString(sCode);
        CCLCheck.nonNull(p0);
        if (p0 == null) {
            cCLMsgParamArray = null;
        } else {
            CCLMsgParam[] cCLMsgParamArray2 = new CCLMsgParam[1];
            cCLMsgParamArray = cCLMsgParamArray2;
            cCLMsgParamArray2[0] = p0;
        }
        CCLMsgParam[] vP = cCLMsgParamArray;
        this.init(null, sCode, 4, vP);
    }

    public CCLException(Throwable thChained, String sCode, CCLMsgParam p0) {
        super(sCode, thChained);
        CCLCheck.nonNull(thChained, p0);
        CCLCheck.validString(sCode);
        this.init(thChained, sCode, 4, new CCLMsgParam[]{p0});
    }

    public CCLException(String sCode, CCLMsgParam p0, CCLMsgParam p1) {
        super(sCode);
        CCLCheck.validString(sCode);
        CCLCheck.nonNull(p0, p1);
        this.init(null, sCode, 4, new CCLMsgParam[]{p0, p1});
    }

    public CCLException(Throwable thChained, String sCode, CCLMsgParam p0, CCLMsgParam p1) {
        super(sCode, thChained);
        CCLCheck.validString(sCode);
        CCLCheck.nonNull(thChained, p0, p1);
        this.init(thChained, sCode, 4, new CCLMsgParam[]{p0, p1});
    }

    public CCLException(String sCode, CCLMsgParam[] vP) {
        super(sCode);
        CCLCheck.validString(sCode);
        CCLCheck.nonNull(vP);
        this.init(null, sCode, 4, vP);
    }

    public CCLException(Throwable thChained, String sCode, CCLMsgParam[] vP) {
        super(sCode, thChained);
        CCLCheck.validString(sCode);
        CCLCheck.nonNull(thChained, vP);
        this.init(thChained, sCode, 4, vP);
    }

    private void init(Throwable exChained, String sCode, int nType, CCLMsgParam[] vP) {
        this._impl = new CCLExceptionImpl(this, exChained, sCode, nType, vP, null);
    }

    @Override
    public ICCLExceptionHandling setProperty(String sPropertyKey, Object propertyValue) {
        CCLCheck.validString(sPropertyKey);
        CCLCheck.nonNull(propertyValue);
        this._impl.setProperty(sPropertyKey, propertyValue);
        return this;
    }

    @Override
    public Object getProperty(String sPropertyKey) {
        CCLCheck.validString(sPropertyKey);
        return this._impl.getProperty(sPropertyKey);
    }

    @Override
    public Map getProperties() {
        return this._impl.getProperties();
    }

    public void setIsSystemProblem(boolean b) {
        this._impl.setIsSystemProblem(b);
    }

    public void setIsRecoverableSystemProblem(boolean b) {
        this._impl.setIsRecoverableSystemProblem(b);
    }

    @Override
    public boolean isClientProblem() {
        return this._impl.isClientProblem();
    }

    @Override
    public boolean isRecoverableProblem() {
        return this._impl.isRecoverableProblem();
    }

    public CCLException beClientProblem() {
        this._impl.beClientProblem();
        return this;
    }

    public CCLException beSystemProblem() {
        this._impl.beSystemProblem();
        return this;
    }

    public CCLException beRecoverableSystemProblem() {
        this._impl.beRecoverableSystemProblem();
        return this;
    }

    @Override
    public void setOnClientError(int n) {
        this._impl.setOnClientError(n);
    }

    @Override
    public int getOnClientError() {
        return this._impl.getOnClientError();
    }

    public CCLException beTextException() {
        this._impl.beTextException();
        return this;
    }

    public CCLException bePresentableException() {
        this._impl.bePresentableException();
        return this;
    }

    public void setImpl(CCLExceptionImpl impl) {
        CCLCheck.nonNull(impl);
        this._impl = impl;
    }

    public CCLExceptionImpl getImpl() {
        return this._impl;
    }

    @Override
    public CCLMsgInfo getMsgInfo() {
        return this._impl.getMsgInfo();
    }

    @Override
    public Throwable getRootException() {
        return this._impl.getRootException();
    }

    public CCLMsg addMessage(CCLMsg msg) {
        CCLCheck.nonNull(msg);
        return this._impl.addMessage(msg);
    }

    public void addMessages(CCLMsgInfo mi) {
        CCLCheck.nonNull(mi);
        this._impl.addMessages(mi);
    }

    @Override
    public String toString() {
        return this._impl.toString();
    }

    @Override
    public String getMessage() {
        return this._impl.getMessage(null);
    }

    @Override
    public void prepareMessage(CCLResource res) {
        this._impl.prepareMessage(res);
    }

    @Override
    public String getLocalizedMessage(CCLResource res) {
        return this._impl.getLocalizedMessage(res);
    }

    @Override
    public synchronized String getMessage(CCLResource res) {
        CCLCheck.nonNull(res);
        String sRet = null;
        sRet = this._impl.getMessage(res);
        return sRet;
    }

    @Override
    public synchronized void printStackTrace(CCLResource res) {
        CCLCheck.nonNull(res);
        this.prepareMessage(res);
        super.printStackTrace();
    }

    @Override
    public synchronized void printStackTrace(PrintStream printstream, CCLResource res) {
        CCLCheck.nonNull(printstream);
        this.prepareMessage(res);
        super.printStackTrace(printstream);
    }

    @Override
    public synchronized void printStackTrace(PrintWriter printwriter, CCLResource res) {
        CCLCheck.nonNull(printwriter);
        this.prepareMessage(res);
        super.printStackTrace(printwriter);
    }
}

