/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.message;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.ccl4j.message.CCLMsgParam;
import java.util.ArrayList;

public class CCLMsg {
    private boolean _bIsSystemMessage = true;
    private boolean _bIsTextMessage = false;
    private boolean _bIsPresentableMessage = false;
    private String _sMsgCodeOrText = null;
    public static final int TYPE_DEBUG = 1;
    public static final int TYPE_INFO = 2;
    public static final int TYPE_WARNING = 3;
    public static final int TYPE_ERROR = 4;
    private int _nType = 4;
    private ArrayList _vParams = null;

    public CCLMsg setIsSystemMessage(boolean b) {
        this._bIsSystemMessage = b;
        return this;
    }

    public CCLMsg beSystemMessage() {
        return this.setIsSystemMessage(true);
    }

    public CCLMsg beClientMessage() {
        return this.setIsSystemMessage(false);
    }

    public boolean isClientMessage() {
        return !this._bIsSystemMessage;
    }

    public boolean isSystemMessage() {
        return this._bIsSystemMessage;
    }

    public CCLMsg setIsTextMessage(boolean b) {
        if (b != this._bIsTextMessage) {
            this._bIsTextMessage = b;
            if (this._bIsTextMessage) {
                this._vParams = null;
            }
        }
        return this;
    }

    public CCLMsg beTextMessage() {
        return this.setIsTextMessage(true);
    }

    public boolean isTextMessage() {
        return this._bIsTextMessage;
    }

    public CCLMsg setIsPresentableMessage(boolean b) {
        this._bIsPresentableMessage = b;
        return this;
    }

    public CCLMsg bePresentableMessage() {
        return this.setIsPresentableMessage(true);
    }

    public boolean isPresentableMessage() {
        return this._bIsPresentableMessage || !this._bIsTextMessage;
    }

    public CCLMsg setType(int nType) {
        this._nType = nType;
        return this;
    }

    public int getType() {
        return this._nType;
    }

    public CCLMsg beWarning() {
        return this.setType(3);
    }

    public CCLMsg beInfo() {
        return this.setType(2);
    }

    public CCLMsg beDebug() {
        return this.setType(1);
    }

    private CCLMsg() {
    }

    public CCLMsg(String sMsgCode) {
        this._init(sMsgCode, null);
    }

    public CCLMsg(String sMsgCode, CCLMsgParam p0) {
        CCLMsgParam[] vP = new CCLMsgParam[]{p0};
        this._init(sMsgCode, vP);
    }

    public CCLMsg(String sMsgCode, CCLMsgParam p0, CCLMsgParam p1) {
        CCLMsgParam[] vP = new CCLMsgParam[]{p0, p1};
        this._init(sMsgCode, vP);
    }

    public CCLMsg(String sMsgCode, CCLMsgParam[] vP) {
        this._init(sMsgCode, vP);
    }

    private void _init(String sMsgCode, CCLMsgParam[] vP) {
        this._sMsgCodeOrText = sMsgCode;
        if (vP != null) {
            for (int i = 0; i < vP.length; ++i) {
                CCLMsgParam p = vP[i];
                this.addParam(p);
            }
        }
    }

    private void addParam(CCLMsgParam p) {
        if (p != null) {
            if (this._vParams == null) {
                this._vParams = new ArrayList();
            }
            this._vParams.add(p);
        }
    }

    public ArrayList getParams() {
        return this._vParams;
    }

    public String getMsgCode() {
        if (this.isTextMessage()) {
            throw new CCLRuntimeException("cannot access msg code on text message");
        }
        return this._sMsgCodeOrText;
    }

    public String getText() {
        if (!this.isTextMessage()) {
            throw new CCLRuntimeException("cannot access text from resource-string message");
        }
        return this._sMsgCodeOrText;
    }

    public void debugStringToSB(StringBuffer sb) {
        sb.append("[CCLMsg: ");
        sb.append(this._bIsSystemMessage ? "system " : "client ");
        if (this.isTextMessage()) {
            sb.append("text='").append(this._sMsgCodeOrText).append('\'');
        } else {
            if (this._sMsgCodeOrText != null) {
                sb.append("code='").append(this._sMsgCodeOrText).append('\'');
            }
            if (this._vParams != null) {
                sb.append(" params=[");
                for (int i = 0; i < this._vParams.size(); ++i) {
                    CCLMsgParam p = (CCLMsgParam)this._vParams.get(i);
                    sb.append(Integer.toString(i)).append(':');
                    p.debugStringToSB(sb);
                    sb.append(' ');
                }
                sb.append(']');
            }
        }
        sb.append(']');
    }
}

