/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.util;

import com.cognos.ccl4j.diagnostics.CCLCheck;
import com.cognos.ccl4j.exceptions.CCLNotImplementedException;
import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.ccl4j.logging.ICCLDebugLogging;
import com.cognos.ccl4j.logging.ICCLLoggable;
import com.cognos.ccl4j.logging.ICCLServiceAuditLogging;
import com.cognos.ccl4j.util.CCLFileUtils;
import com.cognos.ccl4j.util.CCLStringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CCLProperties
extends Properties
implements ICCLLoggable,
Map<Object, Object> {
    private PropertiesProxy _ourPropsProxy = null;
    private Properties _chainedProps = null;
    String _sLoadedFromFilepath = null;
    private String _sDescr = null;
    private ICCLDebugLogging _logDebug = null;

    public Properties getProperties() {
        if (this._ourPropsProxy == null) {
            this._ourPropsProxy = new PropertiesProxy(this);
        }
        return this._ourPropsProxy;
    }

    public void load(String sFilepath) {
        FileInputStream fis = null;
        try {
            CCLCheck.validString(sFilepath);
            File f = new File(sFilepath);
            if (!f.exists()) {
                throw new CCLRuntimeException("file not found");
            }
            this._sLoadedFromFilepath = sFilepath;
            fis = new FileInputStream(sFilepath);
            this.load(fis);
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "loading from '" + CCLFileUtils.getNicePath(sFilepath) + "'");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioex) {}
            }
        }
    }

    public static CCLProperties loadAndChain(CCLProperties oldProps, String sFilepath) {
        CCLCheck.validString(sFilepath);
        CCLProperties propsNewHeadOfChain = oldProps;
        if (CCLFileUtils.exists(sFilepath)) {
            CCLProperties props = new CCLProperties();
            props.load(sFilepath);
            props.chainToProperties(propsNewHeadOfChain);
            propsNewHeadOfChain = props;
        }
        if (propsNewHeadOfChain == null) {
            propsNewHeadOfChain = new CCLProperties();
        }
        return propsNewHeadOfChain;
    }

    public static CCLProperties loadAndChain(CCLProperties oldProps, InputStream is) {
        CCLCheck.nonNull(is);
        CCLProperties propsNewHeadOfChain = oldProps;
        try {
            CCLProperties props = new CCLProperties();
            props.load(is);
            props.chainToProperties(propsNewHeadOfChain);
            propsNewHeadOfChain = props;
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "Loading properties from stream.");
        }
        return propsNewHeadOfChain;
    }

    public String getLoadedFromFilepath() {
        return this._sLoadedFromFilepath;
    }

    public void setDescription(String s) {
        this._sDescr = s;
    }

    public String getDescription() {
        return this._sDescr;
    }

    public void chainToProperties(Properties chainedProperties) {
        CCLProperties propsToChainTo = this;
        while (propsToChainTo._chainedProps != null) {
            if (propsToChainTo._chainedProps instanceof CCLProperties) {
                propsToChainTo = (CCLProperties)propsToChainTo._chainedProps;
                continue;
            }
            throw new CCLRuntimeException("Cannot chain to java.util.Properties object, only CCLProperties");
        }
        propsToChainTo._chainedProps = chainedProperties;
    }

    @Override
    public String getProperty(String sKey, String sDefault) {
        String sRet = this.getProperty(sKey);
        if (sRet == null && sDefault != null) {
            sRet = sDefault;
        }
        return sRet;
    }

    @Override
    public String getProperty(String sKey) {
        String sRet = super.getProperty(sKey);
        if (sRet == null && this._chainedProps != null) {
            sRet = this._chainedProps.getProperty(sKey);
        }
        if (sRet != null) {
            sRet = CCLStringUtils.replace(sRet, (Map)this, false);
        }
        return sRet;
    }

    public int getIntProperty(String sKey, int nDefault) throws NumberFormatException {
        int nRet = nDefault;
        String sValue = this.getProperty(sKey);
        if (sValue != null) {
            nRet = Integer.parseInt(sValue);
        }
        return nRet;
    }

    public boolean getBoolProperty(String sKey, boolean bDefault) {
        boolean bRet = bDefault;
        String sValue = this.getProperty(sKey);
        if (sValue != null) {
            bRet = this.parseBoolean(sValue);
        }
        return bRet;
    }

    private boolean parseBoolean(String strValue) {
        if (strValue != null) {
            if (strValue.equalsIgnoreCase("1") || strValue.equalsIgnoreCase("true") || strValue.equalsIgnoreCase("t") || strValue.equalsIgnoreCase("yes") || strValue.equalsIgnoreCase("y")) {
                return true;
            }
            if (strValue.equalsIgnoreCase("0") || strValue.equalsIgnoreCase("false") || strValue.equalsIgnoreCase("f") || strValue.equalsIgnoreCase("no") || strValue.equalsIgnoreCase("n")) {
                return false;
            }
        }
        return false;
    }

    public String getIndexedProperty(String sKey, int nIndex) {
        String sRet = null;
        String sInt = Integer.toString(nIndex);
        String sFullKey = sKey + "." + sInt;
        sRet = this.getProperty(sFullKey);
        return sRet;
    }

    public List getIndexedProperties(String sKey) {
        ArrayList<String> vRet = new ArrayList<String>();
        int i = 0;
        while (true) {
            String sValue;
            if ((sValue = this.getIndexedProperty(sKey, i)) != null) {
                vRet.add(sValue);
            } else if (i > 0) break;
            ++i;
        }
        return vRet;
    }

    public List getIndexedProperties(String sKey, int nMaxIndex) {
        ArrayList<String> vRet = new ArrayList<String>();
        for (int i = 0; i <= nMaxIndex; ++i) {
            String sValue = this.getIndexedProperty(sKey, i);
            if (sValue == null) continue;
            vRet.add(sValue);
        }
        return vRet;
    }

    @Override
    public String toString() {
        String sRet = null;
        sRet = super.toString();
        return sRet;
    }

    @Override
    public void list(PrintStream out) {
        Properties propsCurrent = this;
        while (propsCurrent != null) {
            ArrayList vLines = CCLProperties.getListLines(propsCurrent);
            for (String sLine : vLines) {
                out.println(sLine);
            }
            if (propsCurrent instanceof CCLProperties) {
                CCLProperties p = propsCurrent;
                propsCurrent = p._chainedProps;
                continue;
            }
            propsCurrent = null;
        }
    }

    @Override
    public void list(PrintWriter out) {
        Properties propsCurrent = this;
        while (propsCurrent != null) {
            ArrayList vLines = CCLProperties.getListLines(propsCurrent);
            for (String sLine : vLines) {
                out.println(sLine);
            }
            if (propsCurrent instanceof CCLProperties) {
                CCLProperties p = propsCurrent;
                propsCurrent = p._chainedProps;
                continue;
            }
            propsCurrent = null;
        }
    }

    private static ArrayList getListLines(Properties props) {
        ArrayList<String> vLines = new ArrayList<String>();
        String sDescr = CCLProperties.getPropDescr(props);
        if (CCLCheck.isValidString(sDescr)) {
            vLines.add(sDescr);
        }
        Enumeration<Object> enumKeys = props.keys();
        while (enumKeys.hasMoreElements()) {
            String sKey = (String)enumKeys.nextElement();
            String sValue = props.getProperty(sKey);
            if (sValue != null) {
                vLines.add("    " + sKey + "='" + sValue + "'");
                continue;
            }
            vLines.add("    " + sKey + "=<null>");
        }
        return vLines;
    }

    private static String getPropDescr(Properties props) {
        String sRet = "";
        StringBuffer sb = new StringBuffer(1024);
        if (props instanceof CCLProperties) {
            CCLProperties cclprops = (CCLProperties)props;
            sb.append("CCLProperties: ");
            if (cclprops._sDescr != null) {
                sb.append(cclprops._sDescr);
            }
            if (cclprops._sLoadedFromFilepath != null) {
                if (cclprops._sDescr != null) {
                    sb.append(" (");
                }
                sb.append("file: '");
                sb.append(cclprops._sLoadedFromFilepath);
                sb.append("'");
                if (cclprops._sDescr != null) {
                    sb.append(")");
                }
            }
        } else {
            sb.append(props.getClass().getName());
            sb.append(": ");
        }
        sRet = sb.toString();
        return sRet;
    }

    @Override
    public void setLoggers(ICCLServiceAuditLogging logService, ICCLDebugLogging logDebug) {
        this._logDebug = logDebug;
    }

    @Override
    public int size() {
        int nRet = super.size();
        if (this._chainedProps != null) {
            Set keySet = this.keySet();
            nRet = keySet.size();
        }
        return nRet;
    }

    @Override
    public boolean isEmpty() {
        boolean bRet = true;
        if (!super.isEmpty()) {
            bRet = false;
        } else if (this._chainedProps != null) {
            bRet = this._chainedProps.isEmpty();
        }
        return bRet;
    }

    @Override
    public boolean containsKey(Object key) {
        boolean bRet = super.containsKey(key);
        if (!bRet && this._chainedProps != null) {
            bRet = this._chainedProps.containsKey(key);
        }
        return bRet;
    }

    @Override
    public boolean containsValue(Object obj) {
        boolean bRet = super.containsValue(obj);
        if (!bRet && this._chainedProps != null) {
            bRet = this._chainedProps.containsValue(obj);
        }
        return bRet;
    }

    @Override
    public Object get(Object key) {
        Object objRet = super.get(key);
        if (objRet == null && this._chainedProps != null) {
            objRet = this._chainedProps.get(key);
        }
        return objRet;
    }

    @Override
    public Object put(Object key, Object value) {
        return super.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        Object objRet = super.remove(key);
        if (this._chainedProps != null) {
            Object o = this._chainedProps.remove(key);
            if (objRet == null) {
                objRet = o;
            }
        }
        return objRet;
    }

    @Override
    public void putAll(Map map) {
        super.putAll((Map<?, ?>)map);
    }

    @Override
    public void clear() {
        super.clear();
        if (this._chainedProps != null) {
            this._chainedProps.clear();
        }
    }

    @Override
    public Set keySet() {
        HashSet<Object> setRet = new HashSet<Object>();
        Set<Object> setKeys = super.keySet();
        setRet.addAll(setKeys);
        if (this._chainedProps != null) {
            Set<Object> s = this._chainedProps.keySet();
            setRet.addAll(s);
        }
        return setRet;
    }

    public Enumeration propertyNames() {
        throw new CCLNotImplementedException("propertyNames");
    }

    @Override
    public Collection values() {
        throw new CCLNotImplementedException("CCLProperties.values()");
    }

    @Override
    public Set entrySet() {
        throw new CCLNotImplementedException("CCLProperties.entrySet()");
    }

    @Override
    public boolean equals(Object obj) {
        throw new CCLNotImplementedException("CCLProperties.equals()");
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private int super_size() {
        return super.size();
    }

    private boolean super_isEmpty() {
        return super.isEmpty();
    }

    private boolean super_containsKey(Object obj) {
        return super.containsKey(obj);
    }

    private boolean super_containsValue(Object obj) {
        return super.containsValue(obj);
    }

    private Object super_get(Object obj) {
        return super.get(obj);
    }

    private Object super_put(Object obj, Object obj1) {
        return super.put(obj, obj1);
    }

    private Object super_remove(Object obj) {
        return super.remove(obj);
    }

    private void super_putAll(Map map) {
        super.putAll((Map<?, ?>)map);
    }

    private void super_clear() {
        super.clear();
    }

    private Set super_keySet() {
        return super.keySet();
    }

    private Collection super_values() {
        return super.values();
    }

    private Set super_entrySet() {
        return super.entrySet();
    }

    private boolean super_equals(Object obj) {
        return super.equals(obj);
    }

    private Object super_setProperty(String s, String s1) {
        return super.setProperty(s, s1);
    }

    private String super_getProperty(String s) {
        return super.getProperty(s);
    }

    private String super_getProperty(String s, String s1) {
        return super.getProperty(s, s1);
    }

    private Enumeration super_propertyNames() {
        return super.propertyNames();
    }

    private void super_list(PrintStream printstream) {
        super.list(printstream);
    }

    private void super_list(PrintWriter printwriter) {
        super.list(printwriter);
    }

    public static CCLProperties getCommandArgsAsProperties(String[] vArgs) {
        CCLProperties props = new CCLProperties();
        if (vArgs != null && vArgs.length > 0) {
            for (int i = 0; i < vArgs.length; ++i) {
                String sArg = vArgs[i];
                if (sArg.startsWith("-")) {
                    sArg = sArg.substring(1);
                }
                String sValue = null;
                if (i + 1 < vArgs.length) {
                    sValue = vArgs[i + 1];
                    if (sValue.startsWith("-")) {
                        sValue = null;
                    } else {
                        ++i;
                    }
                }
                if (sValue == null) {
                    sValue = "";
                }
                props.put(sArg, sValue);
            }
        }
        return props;
    }

    public static class PropertiesProxy
    extends Properties {
        private CCLProperties _realProps = null;

        public PropertiesProxy(CCLProperties properties) {
            this._realProps = properties;
        }

        @Override
        public int size() {
            return this._realProps.super_size();
        }

        @Override
        public boolean isEmpty() {
            return this._realProps.super_isEmpty();
        }

        @Override
        public boolean containsKey(Object obj) {
            return this._realProps.super_containsKey(obj);
        }

        @Override
        public boolean containsValue(Object obj) {
            return this._realProps.super_containsValue(obj);
        }

        @Override
        public Object get(Object obj) {
            return this._realProps.super_get(obj);
        }

        @Override
        public Object put(Object obj, Object obj1) {
            return this._realProps.super_put(obj, obj1);
        }

        @Override
        public Object remove(Object obj) {
            return this._realProps.super_remove(obj);
        }

        @Override
        public void putAll(Map map) {
            this._realProps.super_putAll(map);
        }

        @Override
        public void clear() {
            this._realProps.super_clear();
        }

        @Override
        public Set keySet() {
            return this._realProps.super_keySet();
        }

        @Override
        public Collection values() {
            return this._realProps.super_values();
        }

        @Override
        public Set entrySet() {
            return this._realProps.super_entrySet();
        }

        @Override
        public boolean equals(Object obj) {
            return this._realProps.super_equals(obj);
        }

        @Override
        public int hashCode() {
            return this._realProps.hashCode();
        }

        @Override
        public synchronized Object setProperty(String s, String s1) {
            return this._realProps.super_setProperty(s, s1);
        }

        @Override
        public synchronized void load(InputStream inputstream) throws IOException {
            throw new CCLNotImplementedException("This properties object is loaded internally");
        }

        @Override
        public synchronized void store(OutputStream outputstream, String s) throws IOException {
            throw new CCLNotImplementedException("not implemented");
        }

        @Override
        public String getProperty(String s) {
            return this._realProps.super_getProperty(s);
        }

        @Override
        public String getProperty(String s, String s1) {
            return this._realProps.super_getProperty(s, s1);
        }

        public Enumeration propertyNames() {
            return this._realProps.super_propertyNames();
        }

        @Override
        public void list(PrintStream printstream) {
            this._realProps.super_list(printstream);
        }

        @Override
        public void list(PrintWriter printwriter) {
            this._realProps.super_list(printwriter);
        }
    }
}

