/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.util;

import com.cognos.ccl4j.diagnostics.CCLCheck;
import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.ccl4j.util.CCLFileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public final class CCLShellUtils {
    private static final long FILE_CHANNEL_COPY_SIZE_MINIMUM = 0x100000L;

    private CCLShellUtils() {
    }

    public static void ensureFileExists(String sPath) {
        CCLCheck.nonNull(sPath);
        File fPath = new File(sPath);
        if (!fPath.exists()) {
            String sNicePath = CCLFileUtils.getNicePath(fPath.getPath());
            throw new CCLRuntimeException("File path does not exist: '" + sNicePath + "'");
        }
    }

    public static void ensureFileNotPresent(String sPath) {
        if (CCLCheck.isValidString(sPath)) {
            File fPath = new File(sPath);
            CCLShellUtils.ensureFileNotPresent(fPath);
        }
    }

    public static void ensureFileNotPresent(File f) {
        if (f == null) {
            throw new CCLRuntimeException("null parameter");
        }
        if (f.exists()) {
            CCLShellUtils.deletePath(f);
        }
    }

    private static void deletePath(File fPath) {
        if (fPath.isDirectory()) {
            CCLShellUtils.deleteDirectory(fPath);
        } else {
            CCLShellUtils.deleteSingle(fPath);
        }
    }

    private static void deleteDirectory(File fDir) {
        File[] vFiles = fDir.listFiles();
        for (int i = 0; i < vFiles.length; ++i) {
            File f = vFiles[i];
            CCLShellUtils.deletePath(f);
        }
        CCLShellUtils.deleteSingle(fDir);
    }

    private static void deleteSingle(File f) {
        boolean bDeleted = f.delete();
        if (!bDeleted && f.exists()) {
            throw new CCLRuntimeException("could not delete '" + f.getAbsolutePath() + "'");
        }
    }

    public static boolean isWin32Platform() {
        boolean isWin32 = false;
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (osArch != null && osName != null && osName.indexOf("windows") != -1 && osArch.indexOf("64") == -1) {
            isWin32 = true;
        }
        return isWin32;
    }

    public static boolean isWin64Platform() {
        boolean isWin64 = false;
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (osName != null && osArch != null && osName.indexOf("windows") != -1 && osArch.indexOf("64") != -1) {
            isWin64 = true;
        }
        return isWin64;
    }

    public static void copyFile(String sFromFile, String sToFile) {
        CCLCheck.isValidString(sFromFile);
        CCLCheck.isValidString(sToFile);
        CCLShellUtils.copyFile(new File(sFromFile), new File(sToFile));
    }

    public static void copyFile(File fFrom, File fTo) {
        CCLCheck.nonNull(fFrom, fTo);
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int flags = 0;
            CCLFileUtils.check(fFrom, flags);
            if (!fTo.exists() && fTo.isAbsolute()) {
                fTo.createNewFile();
            }
            from = new FileInputStream(fFrom);
            to = new FileOutputStream(fTo);
            long fileSize = fFrom.length();
            if (fFrom.length() >= 0x100000L) {
                CCLShellUtils.nioCopyFile(from, to, fileSize);
            } else {
                CCLShellUtils.copyFile(from, to);
            }
            from.close();
            to.close();
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "copying file. from='" + fFrom.getPath() + "' to='" + fTo.getPath() + "'");
        }
    }

    private static void copyFile(FileInputStream from, FileOutputStream to) throws IOException {
        int bytes_read;
        byte[] buffer = new byte[4096];
        while ((bytes_read = from.read(buffer)) != -1) {
            to.write(buffer, 0, bytes_read);
        }
    }

    private static void nioCopyFile(FileInputStream source_fis, FileOutputStream target_fos, long size) throws IOException {
        long count;
        FileChannel source = source_fis.getChannel();
        FileChannel target = target_fos.getChannel();
        long block_size = Math.min(65536L, size);
        long position = 0L;
        long remaining_count = size;
        do {
            count = source.transferTo(position, block_size, target);
            position += count;
        } while ((remaining_count -= count) > 0L);
    }

    public static boolean isPathNewer(String sReferencePath, String sPossiblyNewerPath) {
        boolean bRet = false;
        CCLCheck.nonNull(sReferencePath, sPossiblyNewerPath);
        File fA = new File(sReferencePath);
        if (!fA.exists()) {
            throw new CCLRuntimeException("Reference path must exist: '" + CCLFileUtils.getNicePath(sReferencePath) + "'");
        }
        File fB = new File(sPossiblyNewerPath);
        if (!fB.exists()) {
            bRet = true;
        } else {
            long nLastModB;
            long nLastModA = fA.lastModified();
            if (nLastModA > (nLastModB = fB.lastModified())) {
                bRet = true;
            }
        }
        return bRet;
    }

    public static void walk(String sStartingDir, IDirectoryWalkCallback cb, Object arg) {
        CCLCheck.nonNull(sStartingDir, cb);
        CCLShellUtils.walk(sStartingDir, ".", cb, arg);
    }

    private static void walk(String sStartingDir, String sRelDirpath, IDirectoryWalkCallback cb, Object arg) {
        File fStartingDir = new File(sStartingDir);
        if (fStartingDir.isDirectory()) {
            String[] vFilenames = fStartingDir.list();
            cb.walking(arg, sStartingDir, sRelDirpath, vFilenames);
            for (int i = 0; i < vFilenames.length; ++i) {
                String sNewSegments;
                String sPath;
                String sFilename = vFilenames[i];
                if (sFilename == null || !CCLFileUtils.isDirectory(sPath = CCLFileUtils.join(sStartingDir, sNewSegments = File.separator + sFilename))) continue;
                String sRelPath = sRelDirpath + sNewSegments;
                CCLShellUtils.walk(sPath, sRelPath, cb, arg);
            }
        }
    }

    public static interface IDirectoryWalkCallback {
        public void walking(Object var1, String var2, String var3, String[] var4);
    }
}

