/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.util;

import com.cognos.ccl4j.diagnostics.CCLCheck;
import com.cognos.ccl4j.exceptions.CCLException;
import com.cognos.ccl4j.util.CCLStringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class CCLWeb64 {
    private static final String encTable = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789*-";
    private static final char web64PadChar = '_';
    private static final byte[] web64DecodeTable = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 63, 0, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 0, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0, 0, 0, 0, 0};
    private static final int BUFFER_SIZE = 8092;

    public static String encode(byte[] buf) {
        int c = 0;
        int size = buf.length;
        int rsize = (size / 3 + 1) * 4;
        StringBuffer ret = new StringBuffer(rsize);
        for (int i = 0; i < size; ++i) {
            byte b = buf[i];
            c = b >> 2 & 0x3F;
            ret.append(encTable.charAt(c));
            c = b << 4 & 0x30;
            if (++i < size) {
                b = buf[i];
                c |= b >> 4 & 0xF;
            }
            ret.append(encTable.charAt(c));
            if (i < size) {
                c = b << 2 & 0x3C;
                if (++i < size) {
                    b = buf[i];
                    c |= b >> 6 & 3;
                }
                ret.append(encTable.charAt(c));
            } else {
                ++i;
                ret.append('_');
            }
            if (i < size) {
                c = buf[i] & 0x3F;
                ret.append(encTable.charAt(c));
                continue;
            }
            ret.append('_');
        }
        return ret.toString();
    }

    public static byte[] decode(String str) throws InvalidWeb64Exception {
        byte[] baRet = null;
        byte[] baBuffer = null;
        int nIdxOut = 0;
        CCLCheck.nonNull(str);
        try {
            int len = str.length();
            if (len % 4 != 0) {
                String sMsg = "String's length (" + len + ") is not a multiple of 4";
                throw new InvalidWeb64Exception(sMsg);
            }
            int rsize = (len / 4 + 1) * 3;
            baBuffer = new byte[rsize];
            for (int i = 0; i < len; ++i) {
                int c = web64DecodeTable[(byte)str.charAt(i++)];
                int c1 = web64DecodeTable[(byte)str.charAt(i++)];
                c = c << 2 & 0xFC | c1 >> 4 & 3;
                baBuffer[nIdxOut++] = (byte)c;
                if (str.charAt(i) != '_') {
                    c = web64DecodeTable[(byte)str.charAt(i++)];
                    c1 = c1 << 4 & 0xF0 | c >> 2 & 0xF;
                    baBuffer[nIdxOut++] = (byte)c1;
                    if (str.charAt(i) != '_') {
                        c1 = web64DecodeTable[(byte)str.charAt(i)];
                        c = c << 6 & 0xC0 | c1 & 0x3F;
                        baBuffer[nIdxOut++] = (byte)c;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            String sMsg = "Unable to decode string '" + CCLStringUtils.trim(str, 100) + "'";
            throw new InvalidWeb64Exception(e, sMsg);
        }
        baRet = new byte[nIdxOut];
        System.arraycopy(baBuffer, 0, baRet, 0, nIdxOut);
        return baRet;
    }

    public static String decodeToUTF8String(String str) throws InvalidWeb64Exception {
        String sRet = null;
        byte[] ba = null;
        CCLCheck.nonNull(str);
        try {
            ba = CCLWeb64.decode(str);
            sRet = new String(ba, "utf-8");
        }
        catch (Exception ex) {
            throw new InvalidWeb64Exception(ex, "Unable to decode string to UTF-8 string");
        }
        return sRet;
    }

    public static String compressAndEncode(String value) {
        try {
            byte[] b = value.getBytes("UTF-8");
            ByteArrayOutputStream bos = new ByteArrayOutputStream(value.length());
            GZIPOutputStream gzos = new GZIPOutputStream(bos);
            gzos.write(b);
            gzos.close();
            b = bos.toByteArray();
            return CCLWeb64.encode(b);
        }
        catch (Exception e) {
            return value;
        }
    }

    public static String decodeAndDecompress(String value) {
        try {
            byte[] b = CCLWeb64.decode(value);
            ByteArrayInputStream bis = new ByteArrayInputStream(b);
            GZIPInputStream gzis = new GZIPInputStream(bis);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(b.length);
            int nByteRead = 0;
            byte[] buf = new byte[8092];
            while ((nByteRead = gzis.read(buf, 0, 8092)) != -1) {
                bos.write(buf, 0, nByteRead);
            }
            bos.close();
            gzis.close();
            return bos.toString("UTF-8");
        }
        catch (Exception e) {
            return value;
        }
    }

    public static class InvalidWeb64Exception
    extends CCLException {
        public InvalidWeb64Exception(String sMsg) {
            super(sMsg);
        }

        public InvalidWeb64Exception(Throwable th, String sMsg) {
            super(th, sMsg);
        }
    }
}

