/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.ccl4j.stax.utils;

import com.ibm.cognos.ccl4j.stax.stream.XMLStreamFactory;
import com.ibm.cognos.ccl4j.stax.utils.StaxElement;
import com.ibm.cognos.ccl4j.stax.utils.StaxUtils;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public abstract class StaxBase
implements StaxElement {
    protected static final String SOAP_NAMESPACE_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    protected static final String SOAPENC_NAMESPACE_URI = "http://schemas.xmlsoap.org/soap/encoding/";
    protected static final String SOAPENC_NAMESPACE_PREFIX = "SOAP-ENC";
    protected static final String SOAP_ENV = "SOAP-ENV";
    protected static final String BUS_NAMESPACE_PREFIX = "bus";
    protected static final String BUS_NAMESPACE_URI = "http://developer.cognos.com/schemas/bibus/3/";
    protected static final String XSI_NAMESPACE_PREFIX = "xsi";
    protected static final String XSI_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    protected static final String XSI_NIL_NAME = "nil";
    protected static final String XSD_NAMESPACE_PREFIX = "xsd";
    protected static final String XSD_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema";
    protected static final String BASE64_BINARY = "base64Binary";
    protected static final String STRING = "string";
    protected static final String INT = "int";
    protected static final String INTEGER = "integer";
    protected static final String BOOLEAN = "boolean";
    protected static final String ITEM = "item";
    protected static final String TYPE = "type";
    protected static final String ARRAY = "Array";
    protected static final String ARRAY_TYPE = "arrayType";
    protected static final String NAME = "name";
    protected static final String VALUE = "value";
    public static final int DEFAULT_ARRAY_SIZE = 20;
    public static final int NOT_FOUND = -1;

    public static void writeStartBusElement(String name, boolean writeNamespace, XMLStreamWriter xsw) throws XMLStreamException {
        StaxBase.writeStartBusElement(name, null, writeNamespace, xsw);
    }

    public static void writeStartBusElement(String name, String type, boolean writeNamespace, XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement(name);
        if (writeNamespace) {
            StaxBase.setNamespaces(xsw);
        }
        if (type != null) {
            xsw.writeAttribute(XSI_NAMESPACE_PREFIX, XSI_NAMESPACE_URI, TYPE, "bus:" + type);
        }
    }

    public static void writeStartServiceElement(String name, String prefix, String uri, XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement(prefix, name, uri);
        StaxBase.setNamespaces(xsw);
    }

    public static void writeStartElement(String name, String type, XMLStreamWriter xsw) throws XMLStreamException {
        StaxBase.writeStartElement(name, BUS_NAMESPACE_PREFIX, type, xsw);
        StaxBase.setNamespaces(xsw);
    }

    public static void writeStartElement(String name, String typeNSPrefix, String type, XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement(name);
        if (type != null) {
            xsw.writeAttribute(XSI_NAMESPACE_PREFIX, XSI_NAMESPACE_URI, TYPE, typeNSPrefix + ":" + type);
        }
    }

    private static void setNamespaces(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeNamespace(XSD_NAMESPACE_PREFIX, XSD_NAMESPACE_URI);
        xsw.writeNamespace(XSI_NAMESPACE_PREFIX, XSI_NAMESPACE_URI);
        xsw.writeNamespace(SOAPENC_NAMESPACE_PREFIX, SOAPENC_NAMESPACE_URI);
    }

    public static void writeStartArrayElement(String name, String type, int length, boolean writeNamespace, XMLStreamWriter xsw) throws XMLStreamException {
        StaxBase.writeStartArrayElement(name, BUS_NAMESPACE_PREFIX, type, length, writeNamespace, xsw);
    }

    public static void writeStartArrayElement(String name, String typeNSPrefix, String type, int length, boolean writeNamespace, XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement(name);
        if (writeNamespace) {
            StaxBase.setNamespaces(xsw);
        }
        xsw.writeAttribute(XSI_NAMESPACE_PREFIX, XSI_NAMESPACE_URI, TYPE, "SOAP-ENC:Array");
        xsw.writeAttribute(SOAPENC_NAMESPACE_PREFIX, SOAPENC_NAMESPACE_URI, ARRAY_TYPE, typeNSPrefix + ":" + type + "[" + length + "]");
    }

    public static void writeStringElement(String localName, String text, XMLStreamWriter xsw) throws XMLStreamException {
        StaxBase.writeElement(localName, text, STRING, xsw);
    }

    public static void writeBase64BinaryElement(String localName, String text, XMLStreamWriter xsw) throws XMLStreamException {
        StaxBase.writeElement(localName, text, BASE64_BINARY, xsw);
    }

    public static void writeIntElement(String localName, Integer value, XMLStreamWriter xsw) throws XMLStreamException {
        StaxBase.writeElement(localName, value, INT, xsw);
    }

    public static void writeLongElement(String localName, Long value, XMLStreamWriter xsw) throws XMLStreamException {
        StaxBase.writeElement(localName, value, INT, xsw);
    }

    public static void writeBooleanElement(String localName, Boolean value, XMLStreamWriter xsw) throws XMLStreamException {
        StaxBase.writeElement(localName, value, BOOLEAN, xsw);
    }

    public static void writeBusElement(String localName, String text, String type, XMLStreamWriter xsw) throws XMLStreamException {
        StaxBase.writeElement(localName, text, type, BUS_NAMESPACE_PREFIX, xsw);
    }

    public static void writeElement(String localName, Object value, XMLStreamWriter xsw) throws XMLStreamException {
        StaxBase.writeElement(localName, value, null, xsw);
    }

    public static void writeElement(String localName, Object value, String type, XMLStreamWriter xsw) throws XMLStreamException {
        if (value != null) {
            StaxBase.writeElement(localName, value.toString(), type, XSD_NAMESPACE_PREFIX, xsw);
        }
    }

    public static void writeElement(String localName, String text, String type, String typeNSPrefix, XMLStreamWriter xsw) throws XMLStreamException {
        if (text != null) {
            StaxBase.writeStartElement(localName, typeNSPrefix, type, xsw);
            xsw.writeCharacters(text);
            xsw.writeEndElement();
        }
    }

    public static void writeChildXML(StaxElement element, XMLStreamWriter xsw) throws XMLStreamException {
        if (element.isPresent()) {
            element.writeXML(xsw, false);
        }
    }

    public static Boolean parseBoolean(XMLStreamReader xsr) throws XMLStreamException {
        return Boolean.valueOf(xsr.getElementText());
    }

    public static Boolean parseOptionalBoolean(XMLStreamReader xsr) throws XMLStreamException {
        String text = xsr.getElementText();
        if (text != null) {
            return Boolean.valueOf(text);
        }
        return null;
    }

    public static int parseInt(XMLStreamReader xsr) throws XMLStreamException {
        return Integer.parseInt(xsr.getElementText());
    }

    public static Integer parseInteger(XMLStreamReader xsr) throws XMLStreamException {
        return Integer.parseInt(xsr.getElementText());
    }

    public static Long parseLong(XMLStreamReader xsr) throws XMLStreamException {
        return Long.parseLong(xsr.getElementText());
    }

    public static String toString(StaxElement staxElement) throws XMLStreamException {
        return StaxBase.toString(staxElement, true);
    }

    public static String toString(StaxElement staxElement, boolean writeNamespace) throws XMLStreamException {
        StringWriter writer = new StringWriter();
        XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(writer);
        staxElement.writeXML(xsw, writeNamespace);
        xsw.flush();
        return writer.getBuffer().toString();
    }

    public static int parseArraySize(XMLStreamReader xsr) {
        String arrayType = xsr.getAttributeValue(SOAPENC_NAMESPACE_URI, ARRAY_TYPE);
        return arrayType != null ? StaxBase.parseArraySize(arrayType) : 0;
    }

    public static int parseArraySize(String arrayType) {
        int end;
        int start = arrayType.indexOf(91);
        if (start != -1 && (end = arrayType.indexOf(93, start)) != -1 && end - start > 1) {
            return Integer.parseInt(arrayType.substring(start + 1, end));
        }
        return 20;
    }

    @Override
    public void parse(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        while (StaxUtils.moveToNextElementWithinParent(entryName, xsr)) {
            if (!this.isNotNil(xsr)) continue;
            this.parseElement(xsr, xsr.getLocalName());
        }
    }

    protected abstract void parseElement(XMLStreamReader var1, String var2) throws XMLStreamException;

    @Override
    public void writeXML(XMLStreamWriter xsw) throws XMLStreamException {
        this.writeXML(xsw, true);
    }

    @Override
    public boolean isEmpty() {
        return !this.isPresent();
    }

    @Override
    public String asXML() throws XMLStreamException {
        return StaxBase.toString(this);
    }

    protected boolean isNotNil(XMLStreamReader xsr) {
        return !this.isNil(xsr);
    }

    private boolean isNil(XMLStreamReader xsr) {
        String xsiNil = xsr.getAttributeValue(XSI_NAMESPACE_URI, XSI_NIL_NAME);
        return Boolean.parseBoolean(xsiNil);
    }
}

