/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.ccl4j.stax.utils;

import com.ibm.cognos.ccl4j.stax.stream.PathIterator;
import com.ibm.cognos.ccl4j.stax.stream.XMLStreamFactory;
import java.io.StringWriter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxUtils {
    public static boolean moveToElement(String target, XMLStreamReader reader) throws XMLStreamException {
        int event = reader.next();
        while (event != 8) {
            if (event == 1) {
                StaxUtils.detectReferences(reader);
                String localName = reader.getLocalName();
                if (localName.equals(target)) {
                    return true;
                }
            }
            event = reader.next();
        }
        return false;
    }

    public static int moveToAnyElement(String[] target, XMLStreamReader reader) throws XMLStreamException {
        int event = reader.next();
        while (event != 8) {
            if (event == 1) {
                StaxUtils.detectReferences(reader);
                String localName = reader.getLocalName();
                for (int i = 0; i < target.length; ++i) {
                    if (!localName.equals(target[i])) continue;
                    return i;
                }
            }
            event = reader.next();
        }
        return -1;
    }

    public static boolean iterateChildrenElement(String target, XMLStreamReader reader) throws XMLStreamException {
        int level = 0;
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    StaxUtils.detectReferences(reader);
                    String localName = reader.getLocalName();
                    if (localName.equals(target)) {
                        return true;
                    }
                    ++level;
                    break;
                }
                case 2: {
                    if (--level >= 0) break;
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean iterateChildrenElement(String target, String attributeName, String attributeValue, String namespaceURI, XMLStreamReader reader) throws XMLStreamException {
        int level = 0;
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    StaxUtils.detectReferences(reader);
                    String localName = reader.getLocalName();
                    if (target.equals(localName) && attributeValue.equals(reader.getAttributeValue(namespaceURI, attributeName))) {
                        return true;
                    }
                    ++level;
                    break;
                }
                case 2: {
                    if (--level >= 0) break;
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean moveToEndElement(String target, XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            if (2 != reader.next() || !target.equals(reader.getLocalName())) continue;
            return true;
        }
        return false;
    }

    public static boolean moveToNextSibling(XMLStreamReader reader) throws XMLStreamException {
        int nesting = 1;
        while (true) {
            int type = reader.next();
            StaxUtils.detectReferences(reader);
            if (type == 1) {
                ++nesting;
                continue;
            }
            if (type == 2 && --nesting == 0) break;
        }
        return true;
    }

    public static void writeTextElement(XMLStreamWriter writer, String localName, String text) throws XMLStreamException {
        if (text != null) {
            writer.writeStartElement(localName);
            writer.writeCharacters(text);
            writer.writeEndElement();
        } else {
            writer.writeEmptyElement(localName);
        }
    }

    public static void writeTextElement(XMLStreamWriter writer, String namespaceURI, String localName, String text) throws XMLStreamException {
        if (text != null) {
            writer.writeStartElement(namespaceURI, localName);
            writer.writeCharacters(text);
            writer.writeEndElement();
        } else {
            writer.writeEmptyElement(namespaceURI, localName);
        }
    }

    public static void copyCurrentElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        int level = 0;
        int event = reader.getEventType();
        while (true) {
            switch (event) {
                case 1: {
                    String prefix = reader.getPrefix();
                    String namespace = reader.getNamespaceURI();
                    String localName = reader.getLocalName();
                    if (prefix == null || namespace == null) {
                        writer.writeStartElement(localName);
                    } else {
                        writer.writeStartElement(prefix, localName, namespace);
                    }
                    int namspaceCount = reader.getNamespaceCount();
                    for (int i = 0; i < namspaceCount; ++i) {
                        String nsPrefix = reader.getNamespacePrefix(i);
                        String nsURI = reader.getNamespaceURI(i);
                        if (nsPrefix != null) {
                            writer.setPrefix(nsPrefix, nsURI);
                            writer.writeNamespace(nsPrefix, nsURI);
                            continue;
                        }
                        writer.writeDefaultNamespace(nsURI);
                    }
                    if (prefix != null && namespace != null && writer.getNamespaceContext().getNamespaceURI(prefix) == null) {
                        writer.setPrefix(prefix, namespace);
                        writer.writeNamespace(prefix, namespace);
                    }
                    int attrCount = reader.getAttributeCount();
                    for (int i = 0; i < attrCount; ++i) {
                        String attPrefix = reader.getAttributePrefix(i);
                        String attNamespace = reader.getAttributeNamespace(i);
                        if (attPrefix != null && writer.getNamespaceContext().getNamespaceURI(attPrefix) == null && !"xml".equals(attPrefix)) {
                            writer.setPrefix(attPrefix, attNamespace);
                            writer.writeNamespace(attPrefix, attNamespace);
                        }
                        String attributeLocalName = reader.getAttributeLocalName(i);
                        String attributeValue = reader.getAttributeValue(i);
                        writer.writeAttribute(attPrefix, attNamespace, attributeLocalName, attributeValue);
                    }
                    ++level;
                    break;
                }
                case 2: {
                    writer.writeEndElement();
                    if (--level != 0) break;
                    writer.flush();
                    return;
                }
                case 4: {
                    String characters = reader.getText();
                    writer.writeCharacters(characters);
                    break;
                }
                case 12: {
                    String cdata = reader.getText();
                    writer.writeCData(cdata);
                }
            }
            if (!reader.hasNext()) break;
            event = reader.next();
        }
        writer.flush();
    }

    public static void copyChildren(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    StaxUtils.copyCurrentElement(reader, writer);
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
    }

    public static boolean moveToNextElement(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            int event = reader.next();
            if (event != 1) continue;
            StaxUtils.detectReferences(reader);
            return true;
        }
        return false;
    }

    public static boolean moveToNextElementWithinParent(String parent, XMLStreamReader reader) throws XMLStreamException {
        if (reader.isStartElement()) {
            StaxUtils.detectReferences(reader);
        }
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    StaxUtils.detectReferences(reader);
                    return true;
                }
                case 2: {
                    String localName = reader.getLocalName();
                    if (!localName.equals(parent)) break;
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean moveToElementWithPath(String path, XMLStreamReader reader) throws XMLStreamException {
        PathIterator it = new PathIterator(reader, new String[]{path});
        return it.moveToNextPath() != -1;
    }

    public static int moveToElementWithPath(String[] pathArray, XMLStreamReader reader) throws XMLStreamException {
        PathIterator it = new PathIterator(reader, pathArray);
        return it.moveToNextPath();
    }

    public static void toString(XMLStreamReader reader, StringBuffer buffer) throws XMLStreamException {
        StringWriter writer = new StringWriter();
        XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(writer);
        StaxUtils.copyCurrentElement(reader, xsw);
        buffer.append(writer.getBuffer());
    }

    public static void writeQNameText(XMLStreamWriter writer, QName value) throws XMLStreamException {
        String text;
        String prefix = value.getPrefix();
        if (null == prefix || "".equals(prefix)) {
            text = value.getLocalPart();
        } else {
            String ns = StaxUtils.patchLostNamespace(value.getNamespaceURI(), prefix);
            writer.writeNamespace(prefix, ns);
            text = prefix + ":" + value.getLocalPart();
        }
        writer.writeCharacters(text);
    }

    public static QName toQName(String text, NamespaceContext namespaceContext) {
        if (null == text) {
            return null;
        }
        int sep = text.indexOf(58);
        String prefix = sep == -1 ? "" : text.substring(0, sep);
        String localPart = sep == -1 ? text : text.substring(sep + 1);
        String ns = StaxUtils.patchLostNamespace(namespaceContext.getNamespaceURI(prefix), prefix);
        if (ns == null || "".equals(ns)) {
            return new QName(localPart);
        }
        return new QName(ns, localPart, prefix);
    }

    private static String patchLostNamespace(String namespace, String prefix) {
        String ns = namespace;
        if (!"".equals(prefix) && (null == ns || "".equals(ns))) {
            ns = "xsd".equals(prefix) || "xs".equals(prefix) ? "http://www.w3.org/2001/XMLSchema" : ("fragext".equals(prefix) ? "http://developer.cognos.com/fragments/extensions/1/" : ("cmobj".equals(prefix) ? "http://developer.cognos.com/fragments/extensions/cm/1/" : ""));
        }
        return ns;
    }

    public static boolean moveToElementWithinParent(String target, String parent, XMLStreamReader reader) throws XMLStreamException {
        int event = reader.next();
        while (event != 8) {
            if (event == 1 && reader.getLocalName().equals(target)) {
                StaxUtils.detectReferences(reader);
                return true;
            }
            if (event == 2 && reader.getLocalName().equals(parent)) {
                return false;
            }
            event = reader.next();
        }
        return false;
    }

    public static String getElementText(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            if (reader.next() != 4) continue;
            return reader.getText();
        }
        return null;
    }

    public static void detectReferences(XMLStreamReader reader) throws XMLStreamException {
        String HREF_ATTRIBUTE = "href";
        if (reader.isStartElement()) {
            int attributeCount = reader.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                QName attributeName = reader.getAttributeName(i);
                String attributeLocalName = attributeName.getLocalPart();
                if (!attributeLocalName.equalsIgnoreCase("href") || attributeName.getPrefix().length() != 0) continue;
                XMLStreamException referenceException = new XMLStreamException();
                throw referenceException;
            }
        }
    }
}

