/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.IOException;
import java.io.Reader;
import org.apache.commons.csv.FastCharBuffer;

public class FastBufferedReader
extends Reader {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final Reader mSource;
    private final StringBuilder mLineBuilder = new StringBuilder(80);
    private FastCharBuffer mBuffer;
    private boolean mClosed = false;
    private boolean mEndOfStream = false;
    private boolean mMarked = false;
    private long mByteOffset = 0L;
    private long mMarkByteOffset = -1L;

    public FastBufferedReader(Reader in, int sz) {
        super((Object)in);
        this.mSource = in;
        this.mBuffer = FastCharBuffer.allocate(sz);
        this.mBuffer.flip();
    }

    public FastBufferedReader(Reader in) {
        this(in, 8192);
    }

    private void checkIfClosed() throws IOException {
        if (this.mClosed) {
            throw new IOException("Stream closed");
        }
    }

    private boolean fill() throws IOException {
        int oldPos = this.mBuffer.position();
        int oldLimit = this.mBuffer.limit();
        if (oldLimit == this.mBuffer.capacity()) {
            this.mMarked = false;
            this.mMarkByteOffset = -1L;
        }
        if (!this.mEndOfStream) {
            if (this.mMarked) {
                this.mBuffer.position(oldLimit);
                this.mBuffer.limit(this.mBuffer.capacity());
                int len = this.mBuffer.write(this.mSource);
                if (len < 0) {
                    this.mBuffer.position(oldPos);
                    this.mBuffer.limit(oldLimit);
                    this.mEndOfStream = true;
                } else {
                    this.mBuffer.limit(this.mBuffer.position());
                    this.mBuffer.position(oldPos);
                }
            } else {
                this.mBuffer.compact();
                int len = this.mBuffer.write(this.mSource);
                if (len < 0) {
                    this.mBuffer.position(oldPos);
                    this.mBuffer.limit(oldLimit);
                    this.mEndOfStream = true;
                } else {
                    this.mBuffer.flip();
                }
            }
        }
        return this.mBuffer.hasRemaining();
    }

    public int read() throws IOException {
        this.checkIfClosed();
        if (!this.mBuffer.hasRemaining() && !this.fill()) {
            return -1;
        }
        ++this.mByteOffset;
        return this.mBuffer.get();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        this.checkIfClosed();
        if (!this.mBuffer.hasRemaining() && !this.fill()) {
            return -1;
        }
        len = Math.min(len, this.mBuffer.remaining());
        this.mBuffer.get(cbuf, off, len);
        this.mByteOffset += (long)len;
        return len;
    }

    public String readLine() throws IOException {
        this.checkIfClosed();
        this.mLineBuilder.setLength(0);
        boolean foundEOL = false;
        while (!foundEOL && (this.mBuffer.hasRemaining() || this.fill())) {
            int eolPos = this.mBuffer.find('\n', '\r');
            if (-1 == eolPos) {
                this.mByteOffset += (long)this.mBuffer.read(this.mLineBuilder);
                continue;
            }
            foundEOL = true;
            int len = eolPos - this.mBuffer.position();
            this.mByteOffset += (long)this.mBuffer.read(this.mLineBuilder, len);
            this.mBuffer.advance(1);
            ++this.mByteOffset;
            char chr = this.mBuffer.get(eolPos);
            if (chr != '\r' || !this.mBuffer.hasRemaining() || this.mBuffer.get(eolPos + 1) != '\n') continue;
            this.mBuffer.advance(1);
            ++this.mByteOffset;
        }
        if (this.mLineBuilder.length() == 0 && !foundEOL) {
            return null;
        }
        return this.mLineBuilder.toString();
    }

    public long skip(long n) throws IOException {
        this.checkIfClosed();
        if (n < 0L) {
            throw new IllegalArgumentException("n < 0");
        }
        long skipped = 0L;
        while (n > 0L && (this.mBuffer.hasRemaining() || this.fill())) {
            int jump = (int)Math.min(n, (long)this.mBuffer.remaining());
            this.mBuffer.advance(jump);
            n -= (long)jump;
            skipped += (long)jump;
        }
        this.mByteOffset += skipped;
        return skipped;
    }

    public boolean ready() throws IOException {
        this.checkIfClosed();
        return !this.mEndOfStream && (this.mBuffer.hasRemaining() || this.mSource.ready());
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) throws IOException {
        this.checkIfClosed();
        this.mBuffer.compact();
        this.mBuffer.flip();
        if (readAheadLimit > this.mBuffer.capacity()) {
            FastCharBuffer newBuffer = FastCharBuffer.allocate(readAheadLimit);
            newBuffer.put(this.mBuffer);
            newBuffer.flip();
            this.mBuffer = newBuffer;
        }
        this.mMarked = true;
        this.mMarkByteOffset = this.mByteOffset;
    }

    public void reset() throws IOException {
        this.checkIfClosed();
        if (!this.mMarked) {
            throw new IOException("Mark invalid");
        }
        this.mMarked = false;
        this.mBuffer.position(0);
        this.mByteOffset = this.mMarkByteOffset;
        this.mMarkByteOffset = -1L;
    }

    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        this.mSource.close();
    }

    public long offset() {
        return this.mByteOffset;
    }
}

