/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.IOException;
import java.io.Reader;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.CharBuffer;

public final class FastCharBuffer
implements Appendable,
CharSequence,
Readable {
    private final char[] mChars;
    private int mPos;
    private int mLimit;

    public static FastCharBuffer allocate(int sz) {
        return new FastCharBuffer(new char[sz]);
    }

    private FastCharBuffer(char[] chars) {
        this.mChars = chars;
        this.mPos = 0;
        this.mLimit = this.mChars.length;
    }

    public int capacity() {
        return this.mChars.length;
    }

    public int position() {
        return this.mPos;
    }

    public void position(int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("pos < 0");
        }
        if (pos > this.mLimit) {
            throw new IllegalArgumentException("pos > limit");
        }
        this.mPos = pos;
    }

    public int limit() {
        return this.mLimit;
    }

    public void limit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit < 0");
        }
        if (limit > this.mChars.length) {
            throw new IllegalAccessError("limit > capacity");
        }
        this.mLimit = limit;
        if (this.mPos > this.mLimit) {
            this.mPos = this.mLimit;
        }
    }

    public void clear() {
        this.mPos = 0;
        this.mLimit = this.mChars.length;
    }

    public void flip() {
        this.mLimit = this.mPos;
        this.mPos = 0;
    }

    public void rewind() {
        this.mPos = 0;
    }

    public void compact() {
        int n = this.mLimit - this.mPos;
        System.arraycopy(this.mChars, this.mPos, this.mChars, 0, n);
        this.mPos = n;
        this.mLimit = this.mChars.length;
    }

    public int remaining() {
        return this.mLimit - this.mPos;
    }

    public boolean hasRemaining() {
        return this.mPos < this.mLimit;
    }

    public char get() {
        if (this.mPos >= this.mLimit) {
            throw new BufferUnderflowException();
        }
        return this.mChars[this.mPos++];
    }

    public void get(char[] chars) {
        this.get(chars, 0, chars.length);
    }

    public void get(char[] chars, int offset, int len) {
        if (len > this.mLimit - this.mPos) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.mChars, this.mPos, chars, offset, len);
        this.mPos += len;
    }

    public char get(int pos) {
        return this.mChars[pos];
    }

    public void put(char chr) {
        if (this.mPos >= this.mLimit) {
            throw new BufferOverflowException();
        }
        this.mChars[this.mPos++] = chr;
    }

    public void put(char[] chars) {
        this.put(chars, 0, chars.length);
    }

    public void put(char[] chars, int offset, int len) {
        if (len > this.mLimit - this.mPos) {
            throw new BufferOverflowException();
        }
        System.arraycopy(chars, offset, this.mChars, this.mPos, len);
        this.mPos += len;
    }

    public void put(int pos, char chr) {
        this.mChars[pos] = chr;
    }

    public void put(FastCharBuffer fcb) {
        int n = fcb.mLimit - fcb.mPos;
        if (n > this.mLimit - this.mPos) {
            throw new BufferOverflowException();
        }
        System.arraycopy(fcb.mChars, fcb.mPos, this.mChars, this.mPos, n);
        this.mPos += n;
        fcb.mPos += n;
    }

    public FastCharBuffer append(char c) {
        this.put(c);
        return this;
    }

    public FastCharBuffer append(CharSequence csq) {
        return this.append(csq, 0, csq.length());
    }

    public FastCharBuffer append(CharSequence csq, int start, int end) {
        int len = end - start;
        if (len > this.mLimit - this.mPos) {
            throw new BufferOverflowException();
        }
        for (int i = start; i < start + len; ++i) {
            this.mChars[this.mPos++] = csq.charAt(i);
        }
        return this;
    }

    public char charAt(int pos) {
        return this.mChars[pos];
    }

    public int length() {
        return this.mLimit - this.mPos;
    }

    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public int read(CharBuffer cb) throws IOException {
        if (this.mPos >= this.mLimit) {
            return -1;
        }
        int n = Math.min(this.mLimit - this.mPos, cb.remaining());
        char[] chars = new char[n];
        this.get(chars);
        cb.put(chars);
        return n;
    }

    public int read(StringBuilder ap) {
        if (this.mPos >= this.mLimit) {
            return -1;
        }
        int n = this.mLimit - this.mPos;
        char[] chars = new char[n];
        System.arraycopy(this.mChars, this.mPos, chars, 0, n);
        this.mPos += n;
        ap.append(chars);
        return n;
    }

    public int read(StringBuilder ap, int len) {
        if (this.mPos >= this.mLimit) {
            return -1;
        }
        int n = Math.min(len, this.mLimit - this.mPos);
        char[] chars = new char[n];
        System.arraycopy(this.mChars, this.mPos, chars, 0, n);
        this.mPos += n;
        ap.append(chars);
        return n;
    }

    public int read(FastCharBuffer fcb) {
        if (this.mPos >= this.mLimit) {
            return -1;
        }
        int n = Math.min(this.mLimit - this.mPos, fcb.mLimit - fcb.mPos);
        System.arraycopy(this.mChars, this.mPos, fcb.mChars, fcb.mPos, n);
        this.mPos += n;
        fcb.mPos += n;
        return n;
    }

    public int write(Reader reader) throws IOException {
        char[] chars = new char[this.mLimit - this.mPos];
        int n = reader.read(chars);
        if (n == -1) {
            return -1;
        }
        this.put(chars, 0, n);
        return n;
    }

    public void advance(int distance) {
        if (distance < 0) {
            throw new IllegalArgumentException("distance < 0");
        }
        if (distance > this.mLimit - this.mPos) {
            throw new BufferOverflowException();
        }
        this.mPos += distance;
    }

    public int find(char chr) {
        for (int i = this.mPos; i < this.mLimit; ++i) {
            if (chr != this.mChars[i]) continue;
            return i;
        }
        return -1;
    }

    public int find(char chr1, char chr2) {
        for (int i = this.mPos; i < this.mLimit; ++i) {
            if (chr1 == this.mChars[i]) {
                return i;
            }
            if (chr2 != this.mChars[i]) continue;
            return i;
        }
        return -1;
    }
}

