/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.athena.qls.bi.cm;

import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.AnyTypeProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAF;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.CAMSettings;
import com.cognos.developer.schemas.bibus._3.ContentManagerCacheService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerCacheService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.CookieVar;
import com.cognos.developer.schemas.bibus._3.DataSourceCredential;
import com.cognos.developer.schemas.bibus._3.DispatcherTransportVar;
import com.cognos.developer.schemas.bibus._3.EnvironmentVar;
import com.cognos.developer.schemas.bibus._3.FormFieldVar;
import com.cognos.developer.schemas.bibus._3.FormatEnum;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SetCookieVar;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.developer.schemas.bibus._3.UserCapabilityCache;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.util.base64;
import com.ibm.cognos.athena.qls.bi.cm.ObjectPool;
import com.ibm.cognos.athena.qls.bi.exception.QLSBIRuntimeException;
import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.commons.codec.binary.Base64;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DOMReader;

public abstract class BaseCMCommand {
    private static final String ELEMENT_VALUE = "value";
    private static final String ELEMENT_NAME = "name";
    private static final String PART_NAME = "biBusHeader";
    private static final String NAMESPACE = "http://developer.cognos.com/schemas/bibus/3/";
    private static URL gDispatcherURL = null;
    private static ContentManagerService_ServiceLocator gCMServiceLocator = new ContentManagerService_ServiceLocator();
    private static ObjectPool<ContentManagerService_PortType> cmServicePool;
    private static final String CREDENTIALS_STR = "<credential><username>%s</username><password>%s</password></credential>";
    private static ContentManagerCacheService_ServiceLocator gCMCacheServiceLocator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static URL getDispatcherURL() throws MalformedURLException, CCLConfigurationException {
        if (gDispatcherURL == null) {
            ContentManagerService_ServiceLocator contentManagerService_ServiceLocator = gCMServiceLocator;
            synchronized (contentManagerService_ServiceLocator) {
                if (gDispatcherURL != null) {
                    return gDispatcherURL;
                }
                ICCLConfiguration config = CCLConfigurationFactory.getInstance();
                config.init();
                String value = config.getValue("internalDispatcher", false);
                gDispatcherURL = new URL(value);
            }
        }
        return gDispatcherURL;
    }

    protected static ContentManagerService_PortType getContentManagerServicePort(BiBusHeader header) throws MalformedURLException, ServiceException, CCLConfigurationException {
        ContentManagerService_PortType port = CMServicePoolHolder.cmServicePool.borrow();
        if (port == null) {
            port = gCMServiceLocator.getcontentManagerService(BaseCMCommand.getDispatcherURL());
        }
        ((Stub)port).setHeader(NAMESPACE, PART_NAME, (Object)header);
        ((Stub)port)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
        return port;
    }

    protected static void returnContentManagerServicePort(ContentManagerService_PortType port) {
        CMServicePoolHolder.cmServicePool.returnTo(port);
    }

    public static ContentManagerCacheService_PortType getContentManagerCacheServicePort(BiBusHeader header) throws MalformedURLException, ServiceException, CCLConfigurationException {
        ContentManagerCacheService_PortType port = gCMCacheServiceLocator.getcontentManagerCacheService(BaseCMCommand.getDispatcherURL());
        ((Stub)port).setHeader(NAMESPACE, PART_NAME, (Object)header);
        ((Stub)port)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
        return port;
    }

    public static BiBusHeader buildBiBusHeaderFrom(BIBusEnvelope clientEnvelope) {
        BiBusHeader header = new BiBusHeader();
        try {
            BaseCMCommand.copyCAMToService(clientEnvelope, header);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        BaseCMCommand.copyCAFToService(clientEnvelope, header);
        BaseCMCommand.copyCookiesToService(clientEnvelope, header);
        BaseCMCommand.copySetCookiesToService(clientEnvelope, header);
        BaseCMCommand.copyPrefsToService(clientEnvelope, header);
        BaseCMCommand.copyEnvironmentVarsToService(clientEnvelope, header);
        BaseCMCommand.copyFormFieldVarsToService(clientEnvelope, header);
        BaseCMCommand.copyUserCapabilitiesCache(clientEnvelope, header);
        BaseCMCommand.copyDispatcherTransportVarsToService(clientEnvelope, header);
        return header;
    }

    private static void copyCAFToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        CAF caf = bibus.getCAF();
        if (caf == null) {
            caf = new CAF();
            bibus.setCAF(caf);
        }
        String secureState = clientEnvelope.getCAFSecureState();
        caf.setSecureState(secureState);
    }

    private static void copyCAMToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) throws UnsupportedEncodingException {
        Element settings;
        Node userSessionID;
        Node camCredentialPath;
        Node securityBlob;
        Element isAnnoymous;
        Element ipfLogEnabled;
        Element generation;
        String[] arrStringParts;
        byte[] arrPassportBytes;
        String strCAMPassport;
        CAMPassport cPassport;
        CAM cSecurity = bibus.getCAM();
        if (cSecurity == null) {
            cSecurity = new CAM();
            bibus.setCAM(cSecurity);
        }
        if (null == (cPassport = cSecurity.getCAMPassport())) {
            cPassport = new CAMPassport();
        }
        if ((strCAMPassport = clientEnvelope.getPassportID()) != null && Base64.isArrayByteBase64((byte[])(arrPassportBytes = strCAMPassport.getBytes("UTF-8"))) && (arrStringParts = (strCAMPassport = new String(CryptoWrapper.decodeBase64((byte[])strCAMPassport.getBytes("UTF-8")))).split(";")) != null && arrStringParts.length > 1) {
            strCAMPassport = arrStringParts[1];
        }
        cPassport.setId(strCAMPassport);
        Element canCallLogon = (Element)clientEnvelope.getCAM().selectSingleNode("./CAMPassport/canCallLogon");
        if (canCallLogon != null) {
            boolean canCall = Boolean.parseBoolean(canCallLogon.getText());
            cPassport.setCanCallLogon(canCall);
        }
        if ((generation = (Element)clientEnvelope.getCAM().selectSingleNode("./CAMPassport/generation")) != null) {
            try {
                cPassport.setGeneration(Integer.parseInt(generation.getText()));
            }
            catch (NumberFormatException nf) {
                // empty catch block
            }
        }
        if ((ipfLogEnabled = (Element)clientEnvelope.getCAM().selectSingleNode("./CAMPassport/ipfLogEnabled")) != null) {
            cPassport.setLogEnabled(Boolean.parseBoolean(ipfLogEnabled.getText()));
        }
        if ((isAnnoymous = (Element)clientEnvelope.getCAM().selectSingleNode("./CAMPassport/isAnonymous")) != null) {
            cPassport.setIsAnonymous(Boolean.parseBoolean(isAnnoymous.getText()));
        }
        cSecurity.setCAMPassport(cPassport);
        if (cSecurity.getException() != null) {
            cSecurity.setException(null);
        }
        cSecurity.setAction(clientEnvelope.getCAMAction());
        Node authencityToken = clientEnvelope.getCAM().selectSingleNode("./authenticityToken");
        if (BaseCMCommand.hasTextChild(authencityToken)) {
            byte[] data = base64.decode((int)0, (String)authencityToken.getText());
            cSecurity.setAuthenticityToken(data);
        }
        if (BaseCMCommand.hasTextChild(securityBlob = clientEnvelope.getCAM().selectSingleNode("./securityBlob"))) {
            byte[] data = base64.decode((int)0, (String)securityBlob.getText());
            cSecurity.setSecurityBlob(data);
        }
        if (BaseCMCommand.hasTextChild(camCredentialPath = clientEnvelope.getCAM().selectSingleNode("./CAMCredentialPath"))) {
            cSecurity.setCAMCredentialPath(camCredentialPath.getText());
        }
        if (BaseCMCommand.hasTextChild(userSessionID = clientEnvelope.getCAM().selectSingleNode("./userSessionID"))) {
            byte[] data = base64.decode((int)0, (String)userSessionID.getText());
            cSecurity.setUserSessionID(data);
        }
        if ((settings = (Element)clientEnvelope.getCAM().selectSingleNode("./settings")) != null) {
            Element annoymousAllowed = (Element)settings.selectSingleNode("./anonymousAllowed");
            Element namespacesConfigured = (Element)settings.selectSingleNode("./namespacesConfigured");
            CAMSettings camSettings = new CAMSettings();
            if (annoymousAllowed != null) {
                camSettings.setAnonymousAllowed(Boolean.parseBoolean(annoymousAllowed.getText()));
            }
            if (namespacesConfigured != null) {
                camSettings.setNamespacesConfigured(Boolean.parseBoolean(namespacesConfigured.getText()));
            }
            cSecurity.setSettings(camSettings);
        }
    }

    private static void copyCookiesToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmCookieVars = clientEnvelope.getCookieVars();
        if (elmCookieVars == null) {
            return;
        }
        List listCookieVars = elmCookieVars.elements();
        if (listCookieVars == null || listCookieVars.size() == 0) {
            return;
        }
        CookieVar[] cVars = new CookieVar[listCookieVars.size()];
        for (int idx = 0; idx < listCookieVars.size(); ++idx) {
            Element eCookieNode = (Element)listCookieVars.get(idx);
            CookieVar cCookie = new CookieVar();
            Element eCookieName = eCookieNode.element(ELEMENT_NAME);
            Element eCookieValue = eCookieNode.element(ELEMENT_VALUE);
            if (BaseCMCommand.hasTextChild((Node)eCookieName)) {
                cCookie.setName(eCookieName.getTextTrim());
            }
            if (BaseCMCommand.hasTextChild((Node)eCookieValue)) {
                cCookie.setValue(eCookieValue.getTextTrim());
            }
            cVars[idx] = cCookie;
        }
        if (bibus.getHdrSession() == null) {
            bibus.setHdrSession(new HdrSession());
        }
        bibus.getHdrSession().setCookieVars(cVars);
    }

    private static void copyDispatcherTransportVarsToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmDispVars = clientEnvelope.getDispatcherTransportVars();
        if (elmDispVars == null) {
            return;
        }
        List listDispVars = elmDispVars.elements();
        if (listDispVars == null || listDispVars.size() == 0) {
            return;
        }
        DispatcherTransportVar[] cVars = new DispatcherTransportVar[listDispVars.size()];
        for (int idx = 0; idx < listDispVars.size(); ++idx) {
            Element eFormFieldVarNode = (Element)listDispVars.get(idx);
            DispatcherTransportVar dispVar = new DispatcherTransportVar();
            Element eFormFieldVarName = eFormFieldVarNode.element(ELEMENT_NAME);
            Element eFormFieldVarValue = eFormFieldVarNode.element(ELEMENT_VALUE);
            if (BaseCMCommand.hasTextChild((Node)eFormFieldVarName)) {
                dispVar.setName(eFormFieldVarName.getTextTrim());
            }
            if (BaseCMCommand.hasTextChild((Node)eFormFieldVarValue)) {
                dispVar.setValue(eFormFieldVarValue.getTextTrim());
            }
            cVars[idx] = dispVar;
        }
        bibus.setDispatcherTransportVars(cVars);
    }

    private static void copyEnvironmentVarsToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmEnvVars = clientEnvelope.getEnvironmentVars();
        if (elmEnvVars == null) {
            return;
        }
        List listEnvVars = elmEnvVars.elements();
        if (listEnvVars == null || listEnvVars.size() == 0) {
            return;
        }
        EnvironmentVar[] cVars = new EnvironmentVar[listEnvVars.size()];
        for (int idx = 0; idx < listEnvVars.size(); ++idx) {
            Element eEnvVarNode = (Element)listEnvVars.get(idx);
            EnvironmentVar envVar = new EnvironmentVar();
            Element eEnvVarName = eEnvVarNode.element(ELEMENT_NAME);
            Element eEnvVarValue = eEnvVarNode.element(ELEMENT_VALUE);
            if (BaseCMCommand.hasTextChild((Node)eEnvVarName)) {
                envVar.setName(eEnvVarName.getTextTrim());
            }
            if (BaseCMCommand.hasTextChild((Node)eEnvVarValue)) {
                envVar.setValue(eEnvVarValue.getTextTrim());
            }
            cVars[idx] = envVar;
        }
        if (bibus.getHdrSession() == null) {
            bibus.setHdrSession(new HdrSession());
        }
        bibus.getHdrSession().setEnvironmentVars(cVars);
    }

    private static void copyFormFieldVarsToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmFormFieldVars = clientEnvelope.getFormFieldVars();
        if (elmFormFieldVars == null) {
            return;
        }
        List listFormFieldVars = elmFormFieldVars.elements();
        if (listFormFieldVars == null || listFormFieldVars.size() == 0) {
            return;
        }
        FormFieldVar[] cVars = new FormFieldVar[listFormFieldVars.size()];
        for (int idx = 0; idx < listFormFieldVars.size(); ++idx) {
            Element eFormFieldVarNode = (Element)listFormFieldVars.get(idx);
            FormFieldVar formFieldVar = new FormFieldVar();
            Element eFormFieldVarName = eFormFieldVarNode.element(ELEMENT_NAME);
            Element eFormFieldVarValue = eFormFieldVarNode.element(ELEMENT_VALUE);
            if (BaseCMCommand.hasTextChild((Node)eFormFieldVarName)) {
                formFieldVar.setName(eFormFieldVarName.getTextTrim());
            }
            if (BaseCMCommand.hasTextChild((Node)eFormFieldVarValue)) {
                formFieldVar.setValue(eFormFieldVarValue.getTextTrim());
            }
            formFieldVar.setFormat(FormatEnum.not_encrypted);
            cVars[idx] = formFieldVar;
        }
        if (bibus.getHdrSession() == null) {
            bibus.setHdrSession(new HdrSession());
        }
        bibus.getHdrSession().setFormFieldVars(cVars);
    }

    private static void copyPrefsToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmUserPrefs = clientEnvelope.getUserPreferenceVars();
        if (elmUserPrefs == null) {
            return;
        }
        List listUserPrefs = elmUserPrefs.elements();
        if (listUserPrefs == null || listUserPrefs.size() == 0) {
            return;
        }
        UserPreferenceVar[] uPrefs = new UserPreferenceVar[listUserPrefs.size()];
        for (int idx = 0; idx < listUserPrefs.size(); ++idx) {
            Element eNode = (Element)listUserPrefs.get(idx);
            UserPreferenceVar uVar = new UserPreferenceVar();
            Element eName = eNode.element(ELEMENT_NAME);
            Element eValue = eNode.element(ELEMENT_VALUE);
            if (BaseCMCommand.hasTextChild((Node)eName)) {
                uVar.setName(eName.getText());
            }
            if (BaseCMCommand.hasTextChild((Node)eValue)) {
                uVar.setValue(eValue.getText());
            }
            uPrefs[idx] = uVar;
        }
        bibus.setUserPreferenceVars(uPrefs);
    }

    private static void copySetCookiesToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmSetCookieVars = clientEnvelope.getSetCookieVars();
        if (elmSetCookieVars == null) {
            return;
        }
        List listSetCookieVars = elmSetCookieVars.elements();
        if (listSetCookieVars == null || listSetCookieVars.size() == 0) {
            return;
        }
        SetCookieVar[] cVars = new SetCookieVar[listSetCookieVars.size()];
        for (int idx = 0; idx < listSetCookieVars.size(); ++idx) {
            Element eCookieNode = (Element)listSetCookieVars.get(idx);
            SetCookieVar cCookie = new SetCookieVar();
            Element eCookieName = eCookieNode.element(ELEMENT_NAME);
            Element eCookieValue = eCookieNode.element(ELEMENT_VALUE);
            if (BaseCMCommand.hasTextChild((Node)eCookieName)) {
                cCookie.setName(eCookieName.getTextTrim());
            }
            if (BaseCMCommand.hasTextChild((Node)eCookieValue)) {
                cCookie.setValue(eCookieValue.getTextTrim());
            }
            cVars[idx] = cCookie;
        }
        if (bibus.getHdrSession() == null) {
            bibus.setHdrSession(new HdrSession());
        }
        bibus.getHdrSession().setSetCookieVars(cVars);
    }

    private static void copyUserCapabilitiesCache(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmUserCapabilitiesCache = clientEnvelope.getUserCapabilitiesCache();
        if (elmUserCapabilitiesCache == null) {
            return;
        }
        Element elmCapabilities = (Element)elmUserCapabilitiesCache.selectSingleNode("userCapabilities");
        if (elmCapabilities == null) {
            return;
        }
        Element elmSignature = elmUserCapabilitiesCache.element("signature");
        if (!BaseCMCommand.hasTextChild((Node)elmSignature)) {
            return;
        }
        List listCapabilities = elmCapabilities.elements();
        if (listCapabilities == null || listCapabilities.size() == 0) {
            return;
        }
        UserCapabilityEnum[] eCapabilities = new UserCapabilityEnum[listCapabilities.size()];
        for (int idx = 0; idx < listCapabilities.size(); ++idx) {
            Node anItem = (Node)listCapabilities.get(idx);
            if (!BaseCMCommand.hasTextChild(anItem)) continue;
            eCapabilities[idx] = UserCapabilityEnum.fromValue((String)((Element)anItem).getTextTrim());
        }
        UserCapabilityCache myCache = new UserCapabilityCache();
        myCache.setUserCapabilities(eCapabilities);
        byte[] decodedValue = base64.decode((int)0, (String)elmSignature.getText());
        myCache.setSignature(decodedValue);
        bibus.setUserCapabilityCache(myCache);
    }

    private static boolean hasTextChild(Node aNode) {
        if (aNode == null || aNode.getNodeType() != 1) {
            return false;
        }
        String txt = aNode.getText();
        return txt != null && txt.length() > 0;
    }

    protected static final BiBusHeader getBiBusHeader(Stub aStub) throws Exception {
        SOAPHeaderElement she = aStub.getResponseHeader(NAMESPACE, PART_NAME);
        if (she == null) {
            she = aStub.getHeader(NAMESPACE, PART_NAME);
        }
        BiBusHeader header = (BiBusHeader)she.getObjectValue(BiBusHeader.class);
        return header;
    }

    protected static final BIBusEnvelope getBIBusEnvelope(Stub aStub) throws Exception {
        SOAPHeaderElement she = aStub.getResponseHeader(NAMESPACE, PART_NAME);
        if (she == null) {
            she = aStub.getHeader(NAMESPACE, PART_NAME);
        }
        BIBusEnvelope envelope = new BIBusEnvelope();
        envelope.setBIBusHeader(BaseCMCommand.convert(she.getAsDocument()));
        return envelope;
    }

    public static Element convert(org.w3c.dom.Document doc) throws ParserConfigurationException {
        DOMReader reader = new DOMReader();
        Document doc2 = reader.read(doc);
        return doc2.getRootElement();
    }

    public static void createPersonalDatasourceSignon(String datasource, String connection, String userName, String password, BiBusHeader bibusHeader) {
        ContentManagerService_PortType port = null;
        try {
            port = BaseCMCommand.getContentManagerServicePort(bibusHeader);
        }
        catch (MalformedURLException e) {
            throw QLSBIRuntimeException.wrap(e);
        }
        catch (ServiceException e) {
            throw QLSBIRuntimeException.wrap(e);
        }
        catch (CCLConfigurationException e) {
            throw QLSBIRuntimeException.wrap(e);
        }
        try {
            DataSourceCredential dataSourceCredentials = new DataSourceCredential();
            TokenProp datasourceCredentialsName = new TokenProp();
            datasourceCredentialsName.setValue(datasource + connection);
            dataSourceCredentials.setDefaultName(datasourceCredentialsName);
            StringProp datasourceName = new StringProp();
            datasourceName.setValue(datasource);
            dataSourceCredentials.setDataSourceName(datasourceName);
            StringProp datasourceConnectionName = new StringProp();
            datasourceConnectionName.setValue(connection);
            dataSourceCredentials.setDataSourceConnectionName(datasourceConnectionName);
            String credentialsString = String.format(CREDENTIALS_STR, userName, password);
            AnyTypeProp credentialsProp = new AnyTypeProp();
            credentialsProp.setValue(credentialsString);
            dataSourceCredentials.setCredentials(credentialsProp);
            AddOptions addOptions = new AddOptions();
            addOptions.setUpdateAction(UpdateActionEnum.replace);
            String camId = BaseCMCommand.getUserCAMID(port);
            port.add(new SearchPathSingleObject(camId), new BaseClass[]{dataSourceCredentials}, addOptions);
        }
        catch (RemoteException e) {
            throw QLSBIRuntimeException.wrap(e);
        }
        finally {
            BaseCMCommand.returnContentManagerServicePort(port);
        }
    }

    private static String getUserCAMID(ContentManagerService_PortType port) throws RemoteException {
        PropEnum[] props = new PropEnum[]{PropEnum.searchPath};
        BaseClass[] bc = null;
        String searchPath = "~";
        SearchPathMultipleObject spMulti = new SearchPathMultipleObject();
        spMulti.set_value(searchPath);
        bc = port.query(spMulti, props, new Sort[0], new QueryOptions());
        if (bc == null) {
            throw new QLSBIRuntimeException(CoreMessageKeys.GEN_FoundInternalError);
        }
        if (bc.length != 1) {
            throw new QLSBIRuntimeException(CoreMessageKeys.GEN_FoundInternalError);
        }
        Account account = (Account)bc[0];
        return account.getSearchPath().getValue().toString();
    }

    static {
        gCMCacheServiceLocator = new ContentManagerCacheService_ServiceLocator();
    }

    private static class CMServicePoolHolder {
        static ObjectPool<ContentManagerService_PortType> cmServicePool = new ObjectPool(20);

        private CMServicePoolHolder() {
        }
    }
}

