/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.athena.qls.bi.cm;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.athena.qls.bi.cm.CMConnection;
import com.ibm.cognos.athena.qls.bi.cm.CMDataSourceViaCMCService;
import com.ibm.cognos.athena.qls.bi.cm.CMObject;
import com.ibm.cognos.athena.qls.bi.cm.CMSignon;
import com.ibm.cognos.athena.qls.bi.exception.QLSBIRuntimeException;
import com.ibm.cognos.athena.qls.bi.exception.RecoverableAxisFault;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.util.collection.MapCast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.Flat3Map;

public class CMDataSource {
    protected static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls_bi");
    protected static final String DISABLED = "disabled";
    protected static final String CAM_AUTH_NEGOTIATE = "camAuthNegotiate";
    protected final String dsName;
    protected Map<String, CMConnection> connections = null;
    protected CMObject dataSource = null;
    protected String base64EncodedSecurityBlob = null;
    private BIBusEnvelope biBusEnvelope;
    private long nanoTimeStamp;

    public static CMDataSource create(String name, BiBusHeader header) throws RecoverableAxisFault {
        return CMDataSourceViaCMCService.createDS(name, header);
    }

    protected CMDataSource(String name) {
        this.dsName = name;
        this.biBusEnvelope = null;
        this.nanoTimeStamp = System.nanoTime();
    }

    public String getName() {
        return this.dsName;
    }

    public CMObject getDataSource() {
        return this.dataSource;
    }

    public boolean exist() {
        return this.dataSource != null;
    }

    public Collection<CMConnection> getConnections() throws QLSBIRuntimeException {
        return this.connections.values();
    }

    public CMConnection getConnection(String connectionName) throws QLSBIRuntimeException {
        return this.connections.get(connectionName);
    }

    public String toString() {
        return super.toString() + ":Connections=" + this.connections;
    }

    protected void addSignonsAsChildrenOfConnection(List<CMSignon> dataSourceSignons, List<CMSignon> dataSourceCredentials) {
        CMConnectionWithCredentials cmConnWithCred;
        String connName;
        Map connectionWithCredentials = MapCast.uncheckedCast((Map)new Flat3Map());
        for (CMSignon signon : dataSourceSignons) {
            connName = signon.getConnectionName();
            cmConnWithCred = (CMConnectionWithCredentials)connectionWithCredentials.get(connName);
            if (cmConnWithCred == null) {
                cmConnWithCred = new CMConnectionWithCredentials(this.connections.get(connName));
                connectionWithCredentials.put(connName, cmConnWithCred);
            }
            cmConnWithCred.signons.add(signon);
        }
        for (CMSignon credentials : dataSourceCredentials) {
            connName = credentials.getConnectionName();
            cmConnWithCred = (CMConnectionWithCredentials)connectionWithCredentials.get(connName);
            if (cmConnWithCred == null) {
                cmConnWithCred = new CMConnectionWithCredentials(this.connections.get(connName));
                connectionWithCredentials.put(connName, cmConnWithCred);
            }
            cmConnWithCred.credentials.add(credentials);
        }
        boolean isDebugEnabled = logger.isDebugEnabled();
        for (CMConnectionWithCredentials cmConnWithCredentials : connectionWithCredentials.values()) {
            List<CMSignon> signons;
            if (!cmConnWithCredentials.signons.isEmpty()) {
                signons = cmConnWithCredentials.signons;
                if (isDebugEnabled) {
                    logger.debug("Use dataSourceSignon as signon ", this.getClass().getName() + "::addSignonsAsChildrenOfConnection()");
                }
            } else {
                signons = cmConnWithCredentials.credentials;
                if (isDebugEnabled) {
                    logger.debug("Use dataSourceCredentials as signon ", this.getClass().getName() + "::addSignonsAsChildrenOfConnection()");
                }
            }
            for (CMSignon signon : signons) {
                CMConnection connection = cmConnWithCredentials.connection;
                if (connection == null) continue;
                connection.addSignon(signon);
                if (!isDebugEnabled) continue;
                logger.debug(String.format("Add signon %s to connection " + connection.getDefaultName(), signon.toString()), this.getClass().getName() + "::addSignonsAsChildrenOfConnection()");
            }
        }
    }

    public String getDataSourceType() {
        return (String)this.dataSource.getProperty("type");
    }

    public BIBusEnvelope getBIBusEnvelope() {
        return this.biBusEnvelope;
    }

    public void setBIBusEnvelope(BIBusEnvelope biBusEnvelope) {
        this.biBusEnvelope = biBusEnvelope;
    }

    public long getNanoTimeStamp() {
        return this.nanoTimeStamp;
    }

    public void setNanoTimeStamp(long nanoTimeStamp) {
        this.nanoTimeStamp = nanoTimeStamp;
    }

    private static class CMConnectionWithCredentials {
        final List<CMSignon> credentials = new ArrayList<CMSignon>();
        final List<CMSignon> signons = new ArrayList<CMSignon>();
        final CMConnection connection;

        public CMConnectionWithCredentials(CMConnection conn) {
            this.connection = conn;
        }
    }
}

