/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.athena.qls.bi.cm;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.DataSourceCredential;
import com.cognos.developer.schemas.bibus._3.DataSourceSignon;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.ibm.cognos.athena.qls.bi.cm.CMObject;
import com.ibm.cognos.athena.qls.bi.cm.CMQuery;
import org.dom4j.Element;

public class CMSignon
extends CMObject {
    public static final String SIGNON_INFO = "dataSourceSignon";
    protected static final String CREDENTIALS_PROPERTY = "credentials";
    private volatile String connectionName = null;

    public CMSignon(Element itemElement) {
        super(itemElement);
    }

    public CMSignon(DataSourceSignon dsSignon) {
        super((BaseClass)dsSignon);
        if (dsSignon.getCredentials().getValue() != null) {
            this.addProperty(PropEnum.credentials.toString(), dsSignon.getCredentials().getValue());
        }
    }

    public CMSignon(DataSourceCredential dsCredential) {
        super((BaseClass)dsCredential);
        if (dsCredential.getCredentials().getValue() != null) {
            this.addProperty(PropEnum.credentials.toString(), dsCredential.getCredentials().getValue());
        }
        this.setDataSourceConnectionName(dsCredential);
    }

    public String getCredential() {
        return this.getStringProperty(CREDENTIALS_PROPERTY);
    }

    public String getConnectionName() {
        if (this.connectionName == null) {
            this.connectionName = this.getDataSourceConnectionName();
            if (this.connectionName != null) {
                return this.connectionName;
            }
            String searchPath = this.getSearchPath();
            if (searchPath != null) {
                this.connectionName = CMQuery.getSearchPathPropName(searchPath, "dataSourceConnection");
            }
        }
        return this.connectionName;
    }

    protected void setDataSourceConnectionName(DataSourceCredential dsCredential) {
        StringProp nameProp = dsCredential.getDataSourceConnectionName();
        if (null != nameProp) {
            this.setDataSourceConnectionName(nameProp.getValue());
        }
    }

    protected void setDataSourceConnectionName(String dataSourceConnectionName) {
        this.connectionName = dataSourceConnectionName;
        if (null != this.connectionName) {
            this.addProperty("dataSourceConnectionName", this.connectionName);
        }
    }
}

