/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.athena.qls.bi.cm;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ObjectPool<T> {
    private final int size;
    private final Queue<T> availableRecords;
    private final Queue<T> borrowedRecords;

    public ObjectPool() {
        this(0);
    }

    public ObjectPool(int maxSize) {
        this.size = maxSize;
        this.availableRecords = new ConcurrentLinkedQueue<T>();
        this.borrowedRecords = new ConcurrentLinkedQueue<T>();
    }

    public T borrow() {
        if (this.availableRecords.size() == 0) {
            return null;
        }
        T record = this.availableRecords.remove();
        this.borrowedRecords.add(record);
        return record;
    }

    public void add(T record) {
        this.returnTo(record);
    }

    public void returnTo(T record) {
        if (record != null) {
            this.borrowedRecords.remove(record);
            if (this.size == 0 || this.availableRecords.size() < this.size) {
                this.availableRecords.add(record);
            }
        }
    }

    public List<T> release() {
        ArrayList<T> ans = new ArrayList<T>();
        ans.addAll(this.availableRecords);
        ans.addAll(this.borrowedRecords);
        this.availableRecords.clear();
        this.borrowedRecords.clear();
        return ans;
    }

    public int size() {
        return this.availableRecords.size();
    }

    public int borrowedSize() {
        return this.borrowedRecords.size();
    }
}

