/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.athena.qls.bi.util;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.xml.SAXReaderPool;
import com.ibm.cognos.athena.qls.bi.cm.CMQuery;
import com.ibm.cognos.athena.qls.bi.exception.QLSBIRuntimeException;
import com.ibm.cognos.athena.qls.bi.exception.XQESOAPFaultException;
import com.ibm.cognos.aurora.api.AuroraConfiguration;
import com.ibm.cognos.aurora.api.QLSAPI;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.smd.ISmartMetadata;
import com.ibm.cognos.aurora.api.smd.SMDAPI;
import java.util.Properties;
import org.dom4j.Element;

public final class EnvironmentUtil {
    public static final String NAMESPACE_PREFIX_SOAP_ENV = "SOAP-ENV";
    public static final String SOAP_HEADER = "Header";
    public static final String SOAP_BODY = "Body";
    private static BIBusEnvelope junitBiBusEnvelope = null;
    private static String junitBiBusConversationContextID = null;

    private EnvironmentUtil() {
    }

    private static final String getCCLProperty(String propertyName) {
        ICCLConfiguration configuration = CCLConfigurationFactory.getInstance();
        try {
            configuration.init();
            Element valueElement = configuration.getValueElement(propertyName, true);
            Element itemElement = valueElement.element("item");
            if (itemElement == null) {
                return valueElement.getText();
            }
            return itemElement.getText();
        }
        catch (CCLConfigurationException e) {
            throw QLSBIRuntimeException.wrap(e);
        }
    }

    public static final String getTestContentManagerURL() {
        return EnvironmentUtil.getCCLProperty("contentManagers");
    }

    public static final String getTestDispatcherURL() {
        return EnvironmentUtil.getCCLProperty("externalDispatcher");
    }

    public static BIBusEnvelope getOrCreateBiBusHeader() {
        if (junitBiBusEnvelope != null) {
            return junitBiBusEnvelope;
        }
        CMQuery queryCommand = new CMQuery("/");
        try {
            BIBusEnvelope queryEnvelope = new BIBusEnvelope();
            queryEnvelope.setCAMaction("logon");
            queryCommand.setRequestEnvelope(queryEnvelope);
            queryCommand.execute();
            BIBusEnvelope responseEnvelope = queryCommand.getResponseEnvelope();
            junitBiBusConversationContextID = responseEnvelope.getRequestContext();
            responseEnvelope.setConversationContextID(junitBiBusConversationContextID);
            responseEnvelope.setConversationContextNodeID("TestEnvironment.getOrCreateBiBusHeader()FakeNodeId");
            responseEnvelope.setConversationContextProcessID(1234);
            junitBiBusEnvelope = responseEnvelope;
        }
        catch (SoapFaultException sfe) {
            BIBusEnvelope faultEnvelope = queryCommand.getResponseEnvelope();
            throw new XQESOAPFaultException(faultEnvelope);
        }
        catch (Exception ex) {
            junitBiBusEnvelope = new BIBusEnvelope();
        }
        return junitBiBusEnvelope;
    }

    public static String getOrCreateBiBusConversationContextID() {
        EnvironmentUtil.getOrCreateBiBusHeader();
        return junitBiBusConversationContextID;
    }

    public static Properties getAuroraConfiguration() throws Exception {
        return AuroraConfiguration.getProperties();
    }

    public static IQueryLogicalStorage initializeQLS() throws Exception {
        Properties props = AuroraConfiguration.getProperties();
        return QLSAPI.getInstance((Properties)props);
    }

    public static ISmartMetadata initializeSMD() throws Exception {
        Properties props = AuroraConfiguration.getProperties();
        return SMDAPI.getInstance((Properties)props);
    }

    static {
        SAXReaderPool.prepare((boolean)true, (int)10);
    }
}

